/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.network;

import android.content.Context;
import com.tradplus.ads.base.bean.TPPrivacyInfo;
import com.tradplus.ads.base.common.TPURLManager;
import com.tradplus.ads.base.config.response.BiddingResponse;
import com.tradplus.ads.base.network.BaseHttpRequest;
import com.tradplus.ads.base.network.TPAdUrlGenerator;
import com.tradplus.ads.base.network.TPHttpBuilder;
import com.tradplus.ads.base.network.TPHttpGetRequest;
import com.tradplus.ads.base.network.TPHttpPostRequest;
import com.tradplus.ads.base.network.TPOpenResponse;
import com.tradplus.ads.base.network.TPUrlGenerator;
import com.tradplus.ads.base.network.response.CPAdResponse;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.serialization.JSON;

public class TPRequestManager {
    private static boolean isHttpEncrypt = false;
    private static TPRequestManager instance;

    public static TPRequestManager getInstance() {
        if (instance == null) {
            instance = new TPRequestManager();
        }
        return instance;
    }

    public void requestOpen(Context object, BaseHttpRequest.OnHttpLoaderListener onHttpLoaderListener) {
        object = new TPUrlGenerator((Context)object);
        ((TPUrlGenerator)object).generateOpen();
        if (isHttpEncrypt) {
            object = new TPHttpPostRequest(TPURLManager.getInstance().getOpenUrl(), JSON.toJSONString(((TPAdUrlGenerator)object).getParamMap()), "http_timeout_event", isHttpEncrypt);
            ((TPHttpBuilder)object).setParseClass(TPOpenResponse.class);
            ((BaseHttpRequest)object).request(onHttpLoaderListener);
            return;
        }
        object = new TPHttpGetRequest(TPURLManager.getInstance().getOpenUrl(), ((TPAdUrlGenerator)object).getParamData(), "http_timeout_event", isHttpEncrypt);
        ((TPHttpBuilder)object).setParseClass(TPOpenResponse.class);
        ((BaseHttpRequest)object).request(onHttpLoaderListener);
    }

    public void requestConf(Context object, String string, long l, String string2, BaseHttpRequest.OnHttpLoaderListener onHttpLoaderListener) {
        object = new TPUrlGenerator((Context)object);
        ((TPAdUrlGenerator)object).withAdUnitId(string).withKeywords("").withRespTime(l).withRespUid(string2);
        ((TPUrlGenerator)object).generateConfig();
        if (isHttpEncrypt) {
            object = new TPHttpPostRequest(TPURLManager.getInstance().getConfigURL(), JSON.toJSONString(((TPAdUrlGenerator)object).getParamMap()), "http_timeout_conf", isHttpEncrypt);
            ((TPHttpBuilder)object).setParseClass(ConfigResponse.class);
            ((BaseHttpRequest)object).request(onHttpLoaderListener);
            return;
        }
        object = new TPHttpGetRequest(TPURLManager.getInstance().getConfigURL(), ((TPAdUrlGenerator)object).getParamData(), "http_timeout_conf", isHttpEncrypt);
        ((TPHttpBuilder)object).setParseClass(ConfigResponse.class);
        ((BaseHttpRequest)object).request(onHttpLoaderListener);
    }

    public void requestCrossConfig(Context object, String string, String string2, int n, BaseHttpRequest.OnHttpLoaderListener onHttpLoaderListener) {
        object = new TPUrlGenerator((Context)object);
        ((TPAdUrlGenerator)object).withAdCampaignIdId(string).withAdOrientation(n).withAdType(string2);
        ((TPUrlGenerator)object).generateCrossConfig();
        if (isHttpEncrypt) {
            object = new TPHttpPostRequest(TPURLManager.getInstance().getCrossProURL(), JSON.toJSONString(((TPAdUrlGenerator)object).getParamMap()), "http_timeout_crosspromotion", isHttpEncrypt);
            ((TPHttpBuilder)object).setParseClass(CPAdResponse.class);
            ((BaseHttpRequest)object).request(onHttpLoaderListener);
            return;
        }
        object = new TPHttpGetRequest(TPURLManager.getInstance().getCrossProURL(), ((TPAdUrlGenerator)object).getParamData(), "http_timeout_crosspromotion", isHttpEncrypt);
        ((TPHttpBuilder)object).setParseClass(CPAdResponse.class);
        ((BaseHttpRequest)object).request(onHttpLoaderListener);
    }

    public void requestPrivacy(Context object, BaseHttpRequest.OnHttpLoaderListener onHttpLoaderListener) {
        object = new TPUrlGenerator((Context)object);
        ((TPUrlGenerator)object).generatePrivacy();
        if (isHttpEncrypt) {
            object = new TPHttpPostRequest(TPURLManager.getInstance().getPrivacyHost(), JSON.toJSONString(((TPAdUrlGenerator)object).getParamMap()), "http_timeout_event", isHttpEncrypt);
            ((TPHttpBuilder)object).setParseClass(TPPrivacyInfo.class);
            ((BaseHttpRequest)object).request(onHttpLoaderListener);
            return;
        }
        object = new TPHttpGetRequest(TPURLManager.getInstance().getPrivacyHost(), ((TPAdUrlGenerator)object).getParamData(), "http_timeout_event", isHttpEncrypt);
        ((TPHttpBuilder)object).setParseClass(TPPrivacyInfo.class);
        ((BaseHttpRequest)object).request(onHttpLoaderListener);
    }

    public void requestVisual(Context object, String string, String string2, BaseHttpRequest.OnHttpLoaderListener onHttpLoaderListener) {
        object = new TPUrlGenerator((Context)object);
        ((TPUrlGenerator)object).generateTools(string2);
        if (isHttpEncrypt) {
            new TPHttpPostRequest(string, JSON.toJSONString(((TPAdUrlGenerator)object).getParamMap()), "http_timeout_event", isHttpEncrypt).request(onHttpLoaderListener);
            return;
        }
        new TPHttpGetRequest(string, ((TPAdUrlGenerator)object).getParamData(), "http_timeout_event", isHttpEncrypt).request(onHttpLoaderListener);
    }

    public void requestBidding(String object, int n, BaseHttpRequest.OnHttpLoaderListener onHttpLoaderListener) {
        object = new TPHttpPostRequest(TPURLManager.getInstance().getBiddingPostUrl(), (String)object, "", isHttpEncrypt);
        ((TPHttpBuilder)object).setConnectTimeout(n);
        ((TPHttpBuilder)object).setParseClass(BiddingResponse.class);
        ((BaseHttpRequest)object).request(onHttpLoaderListener);
    }

    public void requestPushMessage(String string, String string2, BaseHttpRequest.OnHttpLoaderListener onHttpLoaderListener) {
        new TPHttpPostRequest(string, string2, "http_timeout_event", TPRequestManager.isIsHttpEncrypt()).request(onHttpLoaderListener);
    }

    public void requestCallback(String string, TPUrlGenerator tPUrlGenerator, BaseHttpRequest.OnHttpLoaderListener onHttpLoaderListener) {
        if (isHttpEncrypt) {
            new TPHttpPostRequest(string, JSON.toJSONString(tPUrlGenerator.getParamMap()), "http_timeout_event", isHttpEncrypt).request(onHttpLoaderListener);
            return;
        }
        new TPHttpGetRequest(string, tPUrlGenerator.getParamData(), "http_timeout_event", isHttpEncrypt).request(onHttpLoaderListener);
    }

    public void requestNormalGet(String string, String string2, BaseHttpRequest.OnHttpLoaderListener onHttpLoaderListener) {
        new TPHttpGetRequest(string, string2, false).request(onHttpLoaderListener);
    }

    public static boolean isIsHttpEncrypt() {
        return isHttpEncrypt;
    }

    public static void setIsHttpEncrypt(boolean bl) {
        isHttpEncrypt = bl;
    }
}

