/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.network.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.network.util.ImageLruCache;
import com.tradplus.ads.base.network.util.ImageUrlLoader;
import com.tradplus.ads.base.network.util.ResourceDiskCacheManager;
import com.tradplus.ads.base.network.util.ResourceDownloadBaseUrlLoader;
import com.tradplus.ads.base.network.util.ResourceEntry;
import com.tradplus.ads.common.util.BitmapUtil;
import com.tradplus.ads.common.util.FileUtil;
import com.tradplus.ads.common.util.LogUtil;
import java.io.FileInputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractSequentialList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class ImageLoader {
    private static final String TAG = "ImageLoader";
    private static final int MESSAGE_WHAT_SUCCESS = 1;
    private static final int MESSAGE_WHAT_FAILED = 2;
    private static final String MESSAGE_DATA_URL = "image_key";
    private static final String MESSAGE_DATA_DESC = "image_message";
    private static ImageLoader mInstance;
    private ImageLruCache<String, WeakReference<Bitmap>> mMemoryCache;
    private final Object mDiskCacheLock = new Object();
    Context mContext;
    private LinkedHashMap<String, List<ImageLoaderListener>> mListenerMap = new LinkedHashMap();
    private Handler handler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message object) {
            if (object.what == 1) {
                String string = object.getData().getString(ImageLoader.MESSAGE_DATA_URL);
                object = ImageLoader.this.getBitmapFromMemCache(string);
                Object object2 = (LinkedList)ImageLoader.this.mListenerMap.get(string);
                if (object2 != null) {
                    object2 = ((AbstractSequentialList)object2).iterator();
                    while (object2.hasNext()) {
                        ImageLoaderListener imageLoaderListener = (ImageLoaderListener)object2.next();
                        if (imageLoaderListener == null) continue;
                        if (object != null) {
                            imageLoaderListener.onSuccess(string, (Bitmap)object);
                            continue;
                        }
                        imageLoaderListener.onFail(string, "Bitmap load fail");
                    }
                }
                ImageLoader.this.mListenerMap.remove(string);
                return;
            }
            if (object.what == 2) {
                String string = object.getData().getString(ImageLoader.MESSAGE_DATA_URL);
                object = object.getData().getString(ImageLoader.MESSAGE_DATA_DESC);
                Object object3 = (LinkedList)ImageLoader.this.mListenerMap.get(string);
                if (object3 != null) {
                    object3 = ((AbstractSequentialList)object3).iterator();
                    while (object3.hasNext()) {
                        ImageLoaderListener imageLoaderListener = (ImageLoaderListener)object3.next();
                        if (imageLoaderListener == null) continue;
                        imageLoaderListener.onFail(string, (String)object);
                    }
                }
                ImageLoader.this.mListenerMap.remove(string);
            }
        }
    };

    public void addBitmapToMemoryCache(String string, Bitmap bitmap) {
        if (this.getBitmapFromMemCache(string) == null && bitmap != null) {
            this.mMemoryCache.put(string, new WeakReference<Bitmap>(bitmap));
        }
    }

    public Bitmap getBitmapFromMemCache(String object) {
        if ((object = this.mMemoryCache.get((String)object)) != null) {
            return (Bitmap)((Reference)object).get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bitmap getBitmapFromDiskCache(ResourceEntry object, int n, int n2) {
        if (object == null) return null;
        if (TextUtils.isEmpty((CharSequence)((ResourceEntry)object).resourceUrl)) {
            return null;
        }
        String string = FileUtil.hashKeyForDisk(((ResourceEntry)object).resourceUrl);
        Bitmap bitmap = null;
        Object object2 = this.mDiskCacheLock;
        synchronized (object2) {
            block13: {
                object = ResourceDiskCacheManager.getInstance(this.mContext).getFileInputStream(((ResourceEntry)object).resourceType, string);
                if (object == null) {
                    return null;
                }
                try {
                    void var3_4;
                    void var2_2;
                    bitmap = BitmapUtil.getBitmap(((FileInputStream)object).getFD(), (int)var2_2, (int)var3_4);
                }
                catch (Throwable throwable) {
                    try {
                        if (object == null) return bitmap;
                        ((FileInputStream)object).close();
                    }
                    catch (Exception exception) {}
                    break block13;
                }
                catch (Throwable throwable) {
                    n = throwable;
                    try {
                        if (object == null) throw n;
                        ((FileInputStream)object).close();
                        throw n;
                    }
                    catch (Exception exception) {}
                    throw n;
                }
                try {
                    if (object == null) return bitmap;
                    ((FileInputStream)object).close();
                }
                catch (Exception exception) {}
            }
            return bitmap;
        }
    }

    private ImageLoader(Context context) {
        this.mContext = context.getApplicationContext();
        int n = (int)Runtime.getRuntime().maxMemory() / 5;
        LogUtil.ownShow("ImageLoad init cache size: " + n + "B");
        this.mMemoryCache = new ImageLruCache<String, WeakReference<Bitmap>>(n){

            @Override
            protected int sizeOf(String string, WeakReference<Bitmap> weakReference) {
                string = weakReference != null ? (Bitmap)weakReference.get() : null;
                int n = string != null ? string.getRowBytes() * string.getHeight() : 0;
                LogUtil.ownShow("sizeOf: Bitmap size:" + n + "B.");
                return n;
            }

            @Override
            protected void entryRemoved(boolean bl, String string, WeakReference<Bitmap> weakReference, WeakReference<Bitmap> weakReference2) {
                super.entryRemoved(bl, string, weakReference, weakReference2);
                try {
                    Bitmap bitmap = weakReference != null ? (Bitmap)weakReference.get() : null;
                    if (bitmap == null) {
                        LogUtil.ownShow("entryRemoved: Bitmap has been release.");
                    }
                    if (weakReference != null && !weakReference.equals(weakReference2) && bitmap != null && !bitmap.isRecycled()) {
                        bitmap.recycle();
                        LogUtil.ownShow("entryRemoved: Bitmap recycle.");
                    }
                    return;
                }
                catch (Exception exception) {
                    if (TPDataManager.getInstance().isDebugMode()) {
                        exception.printStackTrace();
                    }
                    return;
                }
            }
        };
    }

    public static ImageLoader getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new ImageLoader(context);
        }
        return mInstance;
    }

    public void load(ResourceEntry resourceEntry, ImageLoaderListener imageLoaderListener) {
        this.load(resourceEntry, -1, -1, imageLoaderListener);
    }

    public void load(ResourceEntry resourceEntry, int n, int n2, ImageLoaderListener imageLoaderListener) {
        if (resourceEntry == null || TextUtils.isEmpty((CharSequence)resourceEntry.resourceUrl)) {
            if (imageLoaderListener != null) {
                imageLoaderListener.onFail("", "No url info.");
            }
            return;
        }
        Bitmap bitmap = this.getBitmapFromMemCache(resourceEntry.resourceUrl);
        if (bitmap != null) {
            imageLoaderListener.onSuccess(resourceEntry.resourceUrl, bitmap);
            return;
        }
        bitmap = this.getBitmapFromDiskCache(resourceEntry, n, n2);
        if (bitmap != null) {
            imageLoaderListener.onSuccess(resourceEntry.resourceUrl, bitmap);
            return;
        }
        this.loadFormUrl(resourceEntry, n, n2, imageLoaderListener);
    }

    private void loadFormUrl(ResourceEntry object, final int n, final int n2, ImageLoaderListener imageLoaderListener) {
        if (!this.mListenerMap.containsKey(((ResourceEntry)object).resourceUrl)) {
            LinkedList<ImageLoaderListener> linkedList = new LinkedList<ImageLoaderListener>();
            linkedList.add(imageLoaderListener);
            this.mListenerMap.put(((ResourceEntry)object).resourceUrl, linkedList);
            object = new ImageUrlLoader((ResourceEntry)object);
            ((ImageUrlLoader)object).setListener(new ImageUrlLoader.HttpLoadListener(){

                @Override
                public void onLoadSuccess(ResourceEntry resourceEntry) {
                    LogUtil.ownShow("Load Success:" + resourceEntry.resourceUrl);
                    Message message = ImageLoader.this.handler.obtainMessage();
                    ImageLoader.this.handler.obtainMessage().what = 1;
                    Bundle bundle = new Bundle();
                    bundle.putString(ImageLoader.MESSAGE_DATA_URL, resourceEntry.resourceUrl);
                    message.setData(bundle);
                    bundle = ImageLoader.this.getBitmapFromDiskCache(resourceEntry, n, n2);
                    if (bundle != null) {
                        ImageLoader.this.addBitmapToMemoryCache(resourceEntry.resourceUrl, (Bitmap)bundle);
                    }
                    ImageLoader.this.handler.sendMessage(message);
                }

                @Override
                public void onLoadFail(ResourceEntry resourceEntry, String string) {
                    string = ImageLoader.this.handler.obtainMessage();
                    ImageLoader.this.handler.obtainMessage().what = 2;
                    Bundle bundle = new Bundle();
                    bundle.putString(ImageLoader.MESSAGE_DATA_URL, resourceEntry.resourceUrl);
                    string.setData(bundle);
                    ImageLoader.this.handler.sendMessage((Message)string);
                }
            });
            ((ResourceDownloadBaseUrlLoader)object).start();
            return;
        }
        LinkedList linkedList = (LinkedList)this.mListenerMap.get(((ResourceEntry)object).resourceUrl);
        if (linkedList != null && !linkedList.contains(imageLoaderListener)) {
            linkedList.add(imageLoaderListener);
        }
    }

    public void recycle() {
        try {
            if (this.mMemoryCache != null) {
                this.mMemoryCache.evictAll();
            }
            if (this.mListenerMap != null) {
                this.mListenerMap.clear();
            }
            return;
        }
        catch (Exception exception) {
            if (TPDataManager.getInstance().isDebugMode()) {
                exception.printStackTrace();
            }
            return;
        }
    }

    public static interface ImageLoaderListener {
        public void onSuccess(String var1, Bitmap var2);

        public void onFail(String var1, String var2);
    }
}

