/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.network.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class ImageLruCache<K, V> {
    private final LinkedHashMap<K, V> map;
    private int size;
    private int maxSize;
    private int putCount;
    private int createCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;

    public ImageLruCache(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.maxSize = n;
        this.map = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        ImageLruCache imageLruCache = this;
        synchronized (imageLruCache) {
            this.maxSize = n;
        }
        this.trimToSize(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K k) {
        Object object;
        if (k == null) {
            throw new NullPointerException("key == null");
        }
        ImageLruCache<K, V> imageLruCache = this;
        synchronized (imageLruCache) {
            object = this.map.get(k);
            if (object != null) {
                ++this.hitCount;
                return object;
            }
            ++this.missCount;
        }
        imageLruCache = this.create(k);
        if (imageLruCache == null) {
            return null;
        }
        ImageLruCache imageLruCache2 = this;
        synchronized (imageLruCache2) {
            ++this.createCount;
            object = this.map.put(k, imageLruCache);
            if (object != null) {
                this.map.put(k, object);
            } else {
                this.size += this.safeSizeOf(k, imageLruCache);
            }
        }
        if (object != null) {
            this.entryRemoved(false, k, imageLruCache, object);
            return object;
        }
        ImageLruCache imageLruCache3 = this;
        imageLruCache3.trimToSize(imageLruCache3.maxSize);
        return (V)imageLruCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K k, V v) {
        V v2;
        if (k == null || v == null) {
            throw new NullPointerException("key == null || value == null");
        }
        ImageLruCache imageLruCache = this;
        synchronized (imageLruCache) {
            ++this.putCount;
            this.size += this.safeSizeOf(k, v);
            v2 = this.map.put(k, v);
        }
        if (v2 != null) {
            this.entryRemoved(false, k, v2, v);
        }
        ImageLruCache imageLruCache2 = this;
        imageLruCache2.trimToSize(imageLruCache2.maxSize);
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimToSize(int n) {
        while (true) {
            K k;
            Map.Entry<K, V> entry;
            ImageLruCache imageLruCache = this;
            synchronized (imageLruCache) {
                if (this.size < 0 || this.map.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= n) {
                    return;
                }
                entry = this.map.entrySet().size() > 0 ? this.map.entrySet().iterator().next() : null;
                if (entry == null) {
                    return;
                }
                k = entry.getKey();
                entry = entry.getValue();
                this.map.remove(k);
                this.size -= this.safeSizeOf(k, entry);
                ++this.evictionCount;
            }
            this.entryRemoved(true, k, entry, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V remove(K k) {
        Object v;
        if (k == null) {
            throw new NullPointerException("key == null");
        }
        ImageLruCache imageLruCache = this;
        synchronized (imageLruCache) {
            v = this.map.remove(k);
            if (v != null) {
                this.size -= this.safeSizeOf(k, v);
            }
        }
        if (v != null) {
            this.entryRemoved(false, k, v, null);
        }
        return v;
    }

    protected void entryRemoved(boolean bl, K k, V v, V v2) {
    }

    protected V create(K k) {
        return null;
    }

    private int safeSizeOf(K k, V v) {
        int n = this.sizeOf(k, v);
        if (n < 0) {
            throw new IllegalStateException("Negative size: " + k + "=" + v);
        }
        return n;
    }

    protected int sizeOf(K k, V v) {
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized int maxSize() {
        return this.maxSize;
    }

    public final synchronized int hitCount() {
        return this.hitCount;
    }

    public final synchronized int missCount() {
        return this.missCount;
    }

    public final synchronized int createCount() {
        return this.createCount;
    }

    public final synchronized int putCount() {
        return this.putCount;
    }

    public final synchronized int evictionCount() {
        return this.evictionCount;
    }

    public final synchronized Map<K, V> snapshot() {
        return new LinkedHashMap<K, V>(this.map);
    }

    public final synchronized String toString() {
        int n = this.hitCount + this.missCount;
        n = n != 0 ? 100 * this.hitCount / n : 0;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.maxSize, this.hitCount, this.missCount, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedHashMap<K, V> linkedHashMap = this.map;
        synchronized (linkedHashMap) {
            while (true) {
                K k;
                Map.Entry<K, V> entry;
                ImageLruCache imageLruCache = this;
                synchronized (imageLruCache) {
                    if (this.size < 0 || this.map.isEmpty() && this.size != 0) {
                        throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                    }
                    if (this.size == 0) {
                        break;
                    }
                    entry = this.map.entrySet().size() > 0 ? this.map.entrySet().iterator().next() : null;
                    if (entry == null) {
                        break;
                    }
                    k = entry.getKey();
                    entry = entry.getValue();
                    this.map.remove(k);
                    this.size -= this.safeSizeOf(k, entry);
                    ++this.evictionCount;
                }
                this.entryRemoved(true, k, entry, null);
            }
            this.map.clear();
            return;
        }
    }
}

