/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.network.util;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tradplus.ads.base.Const;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.common.DiskLruCache;
import com.tradplus.ads.common.util.FileUtil;
import com.tradplus.ads.common.util.LogUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceDiskCacheManager {
    private final String TAG = this.getClass().getSimpleName();
    private static final String INTERNAL_DIR = Const.RESOURCE_HEAD + "_internal_resouce";
    private static final String CUSTOM_DIR = Const.RESOURCE_HEAD + "_custom_resouce";
    private static ResourceDiskCacheManager sIntance;
    private Context mContext;
    private File mSaveFileDirection;
    ConcurrentHashMap<Integer, DiskLruCache> mFileTypeDiskLruCacheMap = new ConcurrentHashMap();

    private ResourceDiskCacheManager(Context context) {
        this.mContext = context.getApplicationContext();
        this.mSaveFileDirection = FileUtil.getFileSaveFile(this.mContext);
    }

    public static synchronized ResourceDiskCacheManager getInstance(Context context) {
        if (sIntance == null) {
            sIntance = new ResourceDiskCacheManager(context);
        }
        return sIntance;
    }

    /*
     * Loose catch block
     */
    public boolean saveNetworkInputStreamToFile(int n, String object, InputStream inputStream) {
        boolean bl;
        block28: {
            DiskLruCache diskLruCache;
            Object object2;
            block27: {
                if (object == null || inputStream == null) {
                    return false;
                }
                object2 = this.getSaveDirectory(n);
                if (TextUtils.isEmpty((CharSequence)object2)) {
                    return false;
                }
                if (!((File)(object2 = new File((String)object2))).exists()) {
                    ((File)object2).mkdirs();
                }
                bl = false;
                diskLruCache = this.mFileTypeDiskLruCacheMap.get(n);
                if (diskLruCache == null) {
                    try {
                        diskLruCache = DiskLruCache.open((File)object2, 1, 1, this.getCacheMaxSize(n));
                        this.mFileTypeDiskLruCacheMap.put(n, diskLruCache);
                    }
                    catch (Throwable throwable) {
                        if (!TPDataManager.getInstance().isDebugMode()) break block27;
                        Log.e((String)this.TAG, (String)"Create DiskCache error.");
                        throwable.printStackTrace();
                    }
                }
            }
            if (diskLruCache != null) {
                OutputStream outputStream = null;
                object2 = null;
                DiskLruCache.Snapshot snapshot = diskLruCache.get((String)object);
                if (snapshot == null) {
                    object2 = diskLruCache.edit((String)object);
                    if (object2 != null) {
                        int n2;
                        outputStream = ((DiskLruCache.Editor)object2).newOutputStream(0);
                        object = new byte[2048];
                        while ((n2 = inputStream.read((byte[])object)) != -1) {
                            outputStream.write((byte[])object, 0, n2);
                        }
                        ((DiskLruCache.Editor)object2).commit();
                        outputStream.close();
                    }
                } else {
                    snapshot.getInputStream(0).close();
                }
                LogUtil.ownShow("download end = ");
                bl = true;
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    break block28;
                }
                catch (IOException iOException) {}
                break block28;
                catch (Exception exception) {
                    try {
                        LogUtil.ownShow("writeToDiskLruCache - ".concat(String.valueOf(exception)));
                        try {
                            if (object2 != null) {
                                ((DiskLruCache.Editor)object2).abort();
                            }
                        }
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (outputStream != null) {
                                outputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return bl;
    }

    public FileInputStream getFileInputStream(int n, String string) {
        DiskLruCache diskLruCache;
        block8: {
            Object object = this.getSaveDirectory(n);
            if (TextUtils.isEmpty((CharSequence)object)) {
                return null;
            }
            if (!((File)(object = new File((String)object))).exists()) {
                ((File)object).mkdirs();
            }
            if ((diskLruCache = this.mFileTypeDiskLruCacheMap.get(n)) == null) {
                try {
                    diskLruCache = DiskLruCache.open((File)object, 1, 1, this.getCacheMaxSize(n));
                    this.mFileTypeDiskLruCacheMap.put(n, diskLruCache);
                }
                catch (Throwable throwable) {
                    if (!TPDataManager.getInstance().isDebugMode()) break block8;
                    Log.e((String)this.TAG, (String)"Create DiskCache error.");
                    throwable.printStackTrace();
                }
            }
        }
        try {
            Closeable closeable;
            if (diskLruCache != null && (closeable = diskLruCache.get(string)) != null && (closeable = closeable.getInputStream(0)) != null) {
                return (FileInputStream)closeable;
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String getSaveDirectory(int n) {
        String string = CUSTOM_DIR;
        switch (n) {
            case 1: {
                string = INTERNAL_DIR;
            }
        }
        return new File(this.mSaveFileDirection, string).getAbsolutePath();
    }

    private long getCacheMaxSize(int n) {
        switch (n) {
            case 1: {
                return 0x6400000L;
            }
        }
        return 0x6400000L;
    }

    public boolean isExistFile(int n, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return new File(this.getSaveDirectory(n) + File.separator + string + ".0").exists();
    }
}

