/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.network.util;

import android.content.Context;
import android.util.Log;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.config.TradPlusConfigUtils;
import com.tradplus.ads.base.event.TPPushCenter;
import com.tradplus.ads.base.network.BaseHttpRequest;
import com.tradplus.ads.base.network.OnConfigListener;
import com.tradplus.ads.base.network.TPRequestManager;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.pushcenter.event.request.SimplifyEvent;
import com.tradplus.ads.pushcenter.reqeust.AdconfRequest;
import com.tradplus.ads.pushcenter.utils.PushMessageUtils;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.ads.pushcenter.utils.SendMessageUtil;
import java.util.ArrayList;

public class TradPlusConfigLoadUtils {
    private String unitId;
    private Context context;
    private AdconfRequest adconfRequest;
    private AdconfRequest adconfStillLoadRequest;
    private SimplifyEvent adconfSimplifyLoadRequest;
    private SimplifyEvent adconfSimplifyStillLoadRequest;
    private OnConfigListener onConfigListener;
    private String respUid = "";
    private long respTime;
    private long startTime;

    public TradPlusConfigLoadUtils(Context context, String string, String string2, long l) {
        this.unitId = string;
        this.context = context;
        this.respUid = string2;
        this.respTime = l;
        this.startTime = System.currentTimeMillis();
    }

    private void initData(boolean bl) {
        SendMessageUtil.getInstance().sendLoadAdconfStart(this.context, this.unitId, bl);
        this.adconfRequest = new AdconfRequest(this.context, PushMessageUtils.PushStatus.EV_PRE_LOAD_ADCONF.getValue());
        this.adconfSimplifyLoadRequest = new SimplifyEvent(PushMessageUtils.PushStatus.EV_PRE_LOAD_ADCONF.getValue());
    }

    public void load(final boolean bl) {
        this.initData(bl);
        TPTaskManager.getInstance().runDyCorePool(new Runnable(){

            @Override
            public void run() {
                TPDataManager.getInstance().getGaidM();
                TradPlusConfigLoadUtils.this.loadConfig(bl);
            }
        });
    }

    public void loadConfig(final boolean bl) {
        ConfigResponse configResponse = TradPlusConfigUtils.getInstance().getConfigByUnitId(this.unitId);
        if (configResponse == null || configResponse.getIs_nothing() == 1) {
            LogUtil.ownShow("config request unitid = " + this.unitId, "TradPlus");
            TPRequestManager.getInstance().requestConf(this.context, this.unitId, this.respTime, this.respUid, new BaseHttpRequest.OnHttpLoaderListener<ConfigResponse>(){

                @Override
                public void loadSuccess(ConfigResponse configResponse) {
                    if (configResponse != null) {
                        TradPlusConfigLoadUtils.this.removeNothingWaterfall(configResponse);
                        TPDataManager.getInstance().putSegmentIds(TradPlusConfigLoadUtils.this.unitId, configResponse.getBucket_id(), configResponse.getSegment_id());
                        TradPlusConfigLoadUtils.this.adconfRequest.setLuid(TradPlusConfigLoadUtils.this.unitId);
                        TradPlusConfigLoadUtils.this.adconfRequest.setRt("" + RequestUtils.getInstance().countRuntime(TradPlusConfigLoadUtils.this.startTime));
                        TradPlusConfigLoadUtils.this.adconfRequest.setEc(configResponse.getIs_nothing() == 1 ? "12" : "1");
                        TradPlusConfigLoadUtils.this.adconfRequest.setCf("1");
                        TradPlusConfigLoadUtils.this.adconfSimplifyLoadRequest.setLuid(TradPlusConfigLoadUtils.this.unitId);
                        TradPlusConfigLoadUtils.this.adconfSimplifyLoadRequest.setLt("" + RequestUtils.getInstance().countRuntime(TradPlusConfigLoadUtils.this.adconfRequest.getCreateTime()));
                        TradPlusConfigLoadUtils.this.adconfSimplifyLoadRequest.setEc(configResponse.getIs_nothing() == 1 ? "12" : "1");
                        if (configResponse.getCode() != null) {
                            if (!configResponse.getCode().equals("0")) {
                                CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.APPID_MATCH_ADUNITAD, "unitId:" + TradPlusConfigLoadUtils.this.unitId);
                            }
                            TradPlusConfigLoadUtils.this.adconfRequest.setSc(configResponse.getCode());
                        }
                        if (bl) {
                            TPPushCenter.getInstance().saveEvent(TradPlusConfigLoadUtils.this.adconfRequest);
                            TPPushCenter.getInstance().saveEvent(TradPlusConfigLoadUtils.this.adconfSimplifyLoadRequest);
                        }
                        configResponse.setCreateTime(System.currentTimeMillis());
                        TradPlusConfigUtils.getInstance().setConfigByUnitId(TradPlusConfigLoadUtils.this.context, TradPlusConfigLoadUtils.this.unitId, configResponse);
                    } else {
                        TradPlusConfigLoadUtils.this.adconfRequest.setLuid(TradPlusConfigLoadUtils.this.unitId);
                        TradPlusConfigLoadUtils.this.adconfRequest.setRt("" + RequestUtils.getInstance().countRuntime(TradPlusConfigLoadUtils.this.adconfRequest.getCreateTime()));
                        TradPlusConfigLoadUtils.this.adconfRequest.setEc("10");
                        TradPlusConfigLoadUtils.this.adconfRequest.setCf("1");
                        TradPlusConfigLoadUtils.this.adconfSimplifyLoadRequest.setLuid(TradPlusConfigLoadUtils.this.unitId);
                        TradPlusConfigLoadUtils.this.adconfSimplifyLoadRequest.setLt("" + RequestUtils.getInstance().countRuntime(TradPlusConfigLoadUtils.this.adconfRequest.getCreateTime()));
                        TradPlusConfigLoadUtils.this.adconfSimplifyLoadRequest.setEc("10");
                        TPPushCenter.getInstance().saveEvent(TradPlusConfigLoadUtils.this.adconfRequest);
                        TPPushCenter.getInstance().saveEvent(TradPlusConfigLoadUtils.this.adconfSimplifyLoadRequest);
                    }
                    if (TradPlusConfigLoadUtils.this.onConfigListener != null) {
                        TradPlusConfigLoadUtils.this.onConfigListener.onSuccess(configResponse);
                    }
                }

                @Override
                public void loadError(int n, String string) {
                    Log.e((String)"TradPlus", (String)"Response is Failed,error:".concat(String.valueOf(string)));
                    TradPlusConfigLoadUtils.this.adconfRequest.setLuid(TradPlusConfigLoadUtils.this.unitId);
                    TradPlusConfigLoadUtils.this.adconfRequest.setRt("" + RequestUtils.getInstance().countRuntime(TradPlusConfigLoadUtils.this.adconfRequest.getCreateTime()));
                    TradPlusConfigLoadUtils.this.adconfRequest.setCf("1");
                    TradPlusConfigLoadUtils.this.adconfSimplifyLoadRequest.setLuid(TradPlusConfigLoadUtils.this.unitId);
                    TradPlusConfigLoadUtils.this.adconfSimplifyLoadRequest.setLt("" + RequestUtils.getInstance().countRuntime(TradPlusConfigLoadUtils.this.adconfRequest.getCreateTime()));
                    TradPlusConfigLoadUtils.this.adconfRequest.setEc(TPError.parseErrorCode(n));
                    TradPlusConfigLoadUtils.this.adconfSimplifyLoadRequest.setEc(TPError.parseErrorCode(n));
                    if (bl) {
                        TPPushCenter.getInstance().saveEvent(TradPlusConfigLoadUtils.this.adconfRequest);
                        TPPushCenter.getInstance().saveEvent(TradPlusConfigLoadUtils.this.adconfSimplifyLoadRequest);
                    }
                    if (TradPlusConfigLoadUtils.this.onConfigListener != null) {
                        TradPlusConfigLoadUtils.this.onConfigListener.onFailed(n, string);
                    }
                }

                @Override
                public void loadCanceled() {
                }
            });
            return;
        }
        LogUtil.ownShow("config local unitid = " + this.unitId, "TradPlus");
        TPDataManager.getInstance().putSegmentIds(this.unitId, configResponse.getBucket_id(), configResponse.getSegment_id());
        this.adconfRequest.setLuid(this.unitId);
        this.adconfRequest.setRt("" + RequestUtils.getInstance().countRuntime(this.adconfRequest.getCreateTime()));
        this.adconfRequest.setEc("1");
        this.adconfRequest.setCf("2");
        this.adconfSimplifyLoadRequest.setLuid(this.unitId);
        this.adconfSimplifyLoadRequest.setLt("" + RequestUtils.getInstance().countRuntime(this.adconfRequest.getCreateTime()));
        this.adconfSimplifyLoadRequest.setEc("1");
        TPPushCenter.getInstance().saveEvent(this.adconfRequest);
        TPPushCenter.getInstance().saveEvent(this.adconfSimplifyLoadRequest);
        if (this.onConfigListener != null) {
            this.onConfigListener.onSuccess(configResponse);
        }
    }

    public void stillLoadConfig() {
        SendMessageUtil.getInstance().sendLoadAdconfStart(this.context, this.unitId, true);
        this.adconfStillLoadRequest = new AdconfRequest(this.context, PushMessageUtils.PushStatus.EV_PRE_LOAD_ADCONF.getValue());
        this.adconfSimplifyStillLoadRequest = new SimplifyEvent(PushMessageUtils.PushStatus.EV_PRE_LOAD_ADCONF.getValue());
        TPRequestManager.getInstance().requestConf(this.context, this.unitId, this.respTime, this.respUid, new BaseHttpRequest.OnHttpLoaderListener<ConfigResponse>(){

            @Override
            public void loadSuccess(ConfigResponse configResponse) {
                if (configResponse != null) {
                    TPDataManager tPDataManager = TPDataManager.getInstance();
                    if (!configResponse.getCode().equals("201")) {
                        configResponse.setCreateTime(System.currentTimeMillis());
                        TradPlusConfigLoadUtils.this.removeNothingWaterfall(configResponse);
                        TradPlusConfigUtils.getInstance().setConfigByUnitId(TradPlusConfigLoadUtils.this.context, TradPlusConfigLoadUtils.this.unitId, configResponse);
                        TradPlusConfigLoadUtils.this.adconfStillLoadRequest.setLuid(TradPlusConfigLoadUtils.this.unitId);
                        TradPlusConfigLoadUtils.this.adconfStillLoadRequest.setRt("" + RequestUtils.getInstance().countRuntime(TradPlusConfigLoadUtils.this.startTime));
                        TradPlusConfigLoadUtils.this.adconfStillLoadRequest.setEc(configResponse.getIs_nothing() == 1 ? "12" : "1");
                        TradPlusConfigLoadUtils.this.adconfStillLoadRequest.setCf("1");
                        TradPlusConfigLoadUtils.this.adconfSimplifyStillLoadRequest.setLuid(TradPlusConfigLoadUtils.this.unitId);
                        TradPlusConfigLoadUtils.this.adconfSimplifyStillLoadRequest.setLt("" + RequestUtils.getInstance().countRuntime(TradPlusConfigLoadUtils.this.startTime));
                        TradPlusConfigLoadUtils.this.adconfSimplifyStillLoadRequest.setEc(configResponse.getIs_nothing() == 1 ? "12" : "1");
                        if (!configResponse.getCode().equals("0")) {
                            CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.APPID_MATCH_ADUNITAD);
                        }
                        TradPlusConfigLoadUtils.this.adconfStillLoadRequest.setSc(configResponse.getCode());
                        TPPushCenter.getInstance().saveEvent(TradPlusConfigLoadUtils.this.adconfStillLoadRequest);
                        TPPushCenter.getInstance().saveEvent(TradPlusConfigLoadUtils.this.adconfSimplifyStillLoadRequest);
                        tPDataManager.putSegmentIds(TradPlusConfigLoadUtils.this.unitId, configResponse.getBucket_id(), configResponse.getSegment_id());
                        if (TradPlusConfigLoadUtils.this.onConfigListener != null) {
                            TradPlusConfigLoadUtils.this.onConfigListener.onSuccess(configResponse);
                            return;
                        }
                    } else {
                        configResponse = TradPlusConfigUtils.getInstance().getConfigByUnitId(TradPlusConfigLoadUtils.this.unitId);
                        if (configResponse != null) {
                            TradPlusConfigLoadUtils.this.adconfStillLoadRequest.setLuid(TradPlusConfigLoadUtils.this.unitId);
                            TradPlusConfigLoadUtils.this.adconfStillLoadRequest.setRt("" + RequestUtils.getInstance().countRuntime(TradPlusConfigLoadUtils.this.startTime));
                            TradPlusConfigLoadUtils.this.adconfStillLoadRequest.setEc(configResponse.getIs_nothing() == 1 ? "12" : "1");
                            TradPlusConfigLoadUtils.this.adconfStillLoadRequest.setCf("1");
                            TradPlusConfigLoadUtils.this.adconfSimplifyStillLoadRequest.setLuid(TradPlusConfigLoadUtils.this.unitId);
                            TradPlusConfigLoadUtils.this.adconfSimplifyStillLoadRequest.setLt("" + RequestUtils.getInstance().countRuntime(TradPlusConfigLoadUtils.this.startTime));
                            TradPlusConfigLoadUtils.this.adconfSimplifyStillLoadRequest.setEc(configResponse.getIs_nothing() == 1 ? "12" : "1");
                            configResponse.setCreateTime(System.currentTimeMillis());
                            TradPlusConfigUtils.getInstance().setConfigByUnitId(TradPlusConfigLoadUtils.this.context, TradPlusConfigLoadUtils.this.unitId, configResponse);
                            tPDataManager.putSegmentIds(TradPlusConfigLoadUtils.this.unitId, configResponse.getBucket_id(), configResponse.getSegment_id());
                            TPPushCenter.getInstance().saveEvent(TradPlusConfigLoadUtils.this.adconfStillLoadRequest);
                            TPPushCenter.getInstance().saveEvent(TradPlusConfigLoadUtils.this.adconfSimplifyStillLoadRequest);
                            if (TradPlusConfigLoadUtils.this.onConfigListener != null) {
                                TradPlusConfigLoadUtils.this.onConfigListener.onSuccess(configResponse);
                                return;
                            }
                        } else {
                            TradPlusConfigLoadUtils.this.adconfStillLoadRequest.setLuid(TradPlusConfigLoadUtils.this.unitId);
                            TradPlusConfigLoadUtils.this.adconfStillLoadRequest.setRt("" + RequestUtils.getInstance().countRuntime(TradPlusConfigLoadUtils.this.startTime));
                            TradPlusConfigLoadUtils.this.adconfStillLoadRequest.setEc("10");
                            TradPlusConfigLoadUtils.this.adconfStillLoadRequest.setCf("1");
                            TradPlusConfigLoadUtils.this.adconfSimplifyStillLoadRequest.setLuid(TradPlusConfigLoadUtils.this.unitId);
                            TradPlusConfigLoadUtils.this.adconfSimplifyStillLoadRequest.setLt("" + RequestUtils.getInstance().countRuntime(TradPlusConfigLoadUtils.this.startTime));
                            TradPlusConfigLoadUtils.this.adconfSimplifyStillLoadRequest.setEc("10");
                            TPPushCenter.getInstance().saveEvent(TradPlusConfigLoadUtils.this.adconfStillLoadRequest);
                            TPPushCenter.getInstance().saveEvent(TradPlusConfigLoadUtils.this.adconfSimplifyStillLoadRequest);
                        }
                    }
                    return;
                }
                if (TradPlusConfigLoadUtils.this.onConfigListener != null) {
                    TradPlusConfigLoadUtils.this.onConfigListener.onFailed(10, "response is null");
                }
            }

            @Override
            public void loadError(int n, String string) {
                TradPlusConfigLoadUtils.this.adconfStillLoadRequest.setLuid(TradPlusConfigLoadUtils.this.unitId);
                TradPlusConfigLoadUtils.this.adconfStillLoadRequest.setRt("" + RequestUtils.getInstance().countRuntime(TradPlusConfigLoadUtils.this.startTime));
                TradPlusConfigLoadUtils.this.adconfStillLoadRequest.setCf("1");
                TradPlusConfigLoadUtils.this.adconfSimplifyStillLoadRequest.setLuid(TradPlusConfigLoadUtils.this.unitId);
                TradPlusConfigLoadUtils.this.adconfSimplifyStillLoadRequest.setLt("" + RequestUtils.getInstance().countRuntime(TradPlusConfigLoadUtils.this.startTime));
                TradPlusConfigLoadUtils.this.adconfStillLoadRequest.setEc(TPError.parseErrorCode(n));
                TradPlusConfigLoadUtils.this.adconfSimplifyStillLoadRequest.setEc(TPError.parseErrorCode(n));
                TPPushCenter.getInstance().saveEvent(TradPlusConfigLoadUtils.this.adconfStillLoadRequest);
                TPPushCenter.getInstance().saveEvent(TradPlusConfigLoadUtils.this.adconfSimplifyStillLoadRequest);
                if (TradPlusConfigLoadUtils.this.onConfigListener != null) {
                    TradPlusConfigLoadUtils.this.onConfigListener.onFailed(n, string);
                }
            }

            @Override
            public void loadCanceled() {
            }
        });
    }

    public static boolean isConfigExpires(long l, long l2) {
        return System.currentTimeMillis() - l >= (TPDataManager.getInstance().isDebugMode() ? 120L : l2) * 1000L;
    }

    public void setOnConfigListener(OnConfigListener onConfigListener) {
        this.onConfigListener = onConfigListener;
    }

    public void removeNothingWaterfall(ConfigResponse object) {
        if (object == null) {
            return;
        }
        try {
            object = ((ConfigResponse)object).getWaterfall();
            if (object == null) {
                return;
            }
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                if (!"nothing".equals(((ConfigResponse.WaterfallBean)object.next()).getName())) continue;
                object.remove();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

