/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Environment;
import android.os.Process;
import android.text.TextUtils;
import com.tradplus.ads.base.util.TradPlusDataConstants;
import com.tradplus.ads.common.util.LogUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONArray;
import org.json.JSONObject;

@Deprecated
public class ACache {
    public static final int TIME_HOUR = 3600;
    public static final int TIME_DAY = 86400;
    private static final int MAX_SIZE = 50000000;
    private static final int MAX_COUNT = Integer.MAX_VALUE;
    private static Map<String, ACache> mInstanceMap = new HashMap<String, ACache>();
    private ACacheManager mCache;
    private static final String cacheFileDir = "TradPlusCache";
    private static final String cacheCrossProFileDir = "CrossProCache";
    private static final String cacheAdxFileDir = "AdxCache";
    private static final String cacheTrackFileDir = "TrackCache";
    private static final String cacheConfigDir = "ConfigCache";

    public static ACache get(Context context, int n) {
        if (context == null) {
            return null;
        }
        if (n == TradPlusDataConstants.CACHETRADPLUSTYPE) {
            return ACache.get(new File(context.getCacheDir(), cacheFileDir), 50000000L, Integer.MAX_VALUE);
        }
        if (n == TradPlusDataConstants.CACHETYPE) {
            return ACache.get(new File(context.getCacheDir(), cacheCrossProFileDir), 50000000L, Integer.MAX_VALUE);
        }
        if (n == TradPlusDataConstants.CACHEADXTYPE) {
            return ACache.get(new File(context.getCacheDir(), cacheAdxFileDir), 50000000L, Integer.MAX_VALUE);
        }
        if (n == TradPlusDataConstants.TRACKTYPE) {
            return ACache.get(new File(context.getCacheDir(), cacheTrackFileDir), 50000000L, Integer.MAX_VALUE);
        }
        if (n == TradPlusDataConstants.CACHETRADPLUSCONFIGTYPE) {
            return ACache.get(new File(context.getCacheDir(), cacheConfigDir), 50000000L, Integer.MAX_VALUE);
        }
        return null;
    }

    public static ACache get(File file) {
        return ACache.get(file, 50000000L, Integer.MAX_VALUE);
    }

    public static ACache get(Context context, long l, int n) {
        if (context == null) {
            return null;
        }
        return ACache.get(new File(context.getCacheDir(), cacheFileDir), l, n);
    }

    public static ACache get(File file, long l, int n) {
        ACache aCache = mInstanceMap.get(file.getAbsoluteFile() + ACache.myPid());
        if (aCache == null) {
            aCache = new ACache(file, l, n);
            mInstanceMap.put(file.getAbsolutePath() + ACache.myPid(), aCache);
        }
        return aCache;
    }

    private static String myPid() {
        return "_" + Process.myPid();
    }

    private ACache(File file, long l, int n) {
        if (!file.exists() && !file.mkdirs()) {
            LogUtil.ownShow("create acache file failed.");
            return;
        }
        this.mCache = new ACacheManager(file, l, n);
    }

    private static File getEnvironmentCacheDir(Context object, String string) {
        object = object.getExternalFilesDir(string);
        try {
            LogUtil.ownShow("%%%11111111111111111111111" + ((File)object).createNewFile());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (!((File)object).exists() && !((File)object).mkdirs()) {
            return null;
        }
        return object;
    }

    private static File getEnvironmentStorageDir(Context object, String string) {
        object = Environment.getExternalStoragePublicDirectory((String)string);
        if (!((File)object).exists() && !((File)object).mkdirs()) {
            return null;
        }
        return object;
    }

    /*
     * Loose catch block
     */
    public void put(String object, String string) {
        if (this.mCache == null) {
            return;
        }
        object = this.mCache.newFile((String)object);
        if (string == null) {
            string = "";
        }
        BufferedWriter bufferedWriter = null;
        bufferedWriter = new BufferedWriter(new FileWriter((File)object), 1024);
        bufferedWriter.write(string);
        try {
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.mCache.put((File)object);
        return;
        catch (IOException iOException) {
            block13: {
                try {
                    iOException.printStackTrace();
                    if (bufferedWriter == null) break block13;
                }
                catch (Throwable throwable) {
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.flush();
                            bufferedWriter.close();
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                        }
                    }
                    this.mCache.put((File)object);
                    throw throwable;
                }
                try {
                    bufferedWriter.flush();
                    bufferedWriter.close();
                }
                catch (IOException iOException3) {
                    iOException3.printStackTrace();
                }
            }
            this.mCache.put((File)object);
            return;
        }
    }

    public void put(String string, String string2, int n) {
        this.put(string, Utils.newStringWithDateInfo(n, string2));
    }

    /*
     * Loose catch block
     */
    public String getAsString(String string) {
        BufferedReader bufferedReader;
        block16: {
            String string2;
            if (this.mCache == null) {
                return "";
            }
            Object object = this.mCache.get(string);
            if (!((File)object).exists()) {
                return null;
            }
            bufferedReader = null;
            bufferedReader = new BufferedReader(new FileReader((File)object));
            object = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                object = (String)object + string2;
            }
            if (Utils.isDue((String)object)) break block16;
            string = Utils.clearDateInfo((String)object);
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return string;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.remove(string);
        return null;
        catch (IOException iOException) {
            block17: {
                try {
                    iOException.printStackTrace();
                    if (bufferedReader == null) break block17;
                }
                catch (Throwable throwable) {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException2) {
                            iOException2.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException3) {
                    iOException3.printStackTrace();
                }
            }
            return null;
        }
    }

    public void put(String string, JSONObject jSONObject) {
        this.put(string, jSONObject.toString());
    }

    public void put(String string, JSONObject jSONObject, int n) {
        this.put(string, jSONObject.toString(), n);
    }

    public JSONObject getAsJSONObject(String string) {
        string = this.getAsString(string);
        try {
            return new JSONObject(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void put(String string, JSONArray jSONArray) {
        this.put(string, jSONArray.toString());
    }

    public void put(String string, JSONArray jSONArray, int n) {
        this.put(string, jSONArray.toString(), n);
    }

    public JSONArray getAsJSONArray(String string) {
        if (TextUtils.isEmpty((CharSequence)(string = this.getAsString(string)))) {
            return null;
        }
        try {
            return new JSONArray(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public void put(String object, byte[] byArray) {
        if (this.mCache == null) {
            return;
        }
        object = this.mCache.newFile((String)object);
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream((File)object);
        fileOutputStream.write(byArray);
        try {
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.mCache.put((File)object);
        return;
        catch (Exception exception) {
            block12: {
                try {
                    exception.printStackTrace();
                    if (fileOutputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.flush();
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    this.mCache.put((File)object);
                    throw throwable;
                }
                try {
                    fileOutputStream.flush();
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.mCache.put((File)object);
            return;
        }
    }

    public void put(String string, byte[] byArray, int n) {
        this.put(string, Utils.newByteArrayWithDateInfo(n, byArray));
    }

    /*
     * Loose catch block
     */
    public byte[] getAsBinary(String object) {
        RandomAccessFile randomAccessFile;
        block16: {
            Object object2;
            block15: {
                if (this.mCache == null) {
                    return null;
                }
                randomAccessFile = null;
                object2 = this.mCache.get((String)object);
                if (((File)object2).exists()) break block15;
                return null;
            }
            randomAccessFile = new RandomAccessFile((File)object2, "r");
            object2 = new byte[(int)randomAccessFile.length()];
            randomAccessFile.read((byte[])object2);
            if (Utils.isDue((byte[])object2)) break block16;
            object = Utils.clearDateInfo((byte[])object2);
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return object;
        }
        try {
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.remove((String)object);
        return null;
        catch (Exception exception) {
            block17: {
                try {
                    exception.printStackTrace();
                    if (randomAccessFile == null) break block17;
                }
                catch (Throwable throwable) {
                    if (randomAccessFile != null) {
                        try {
                            randomAccessFile.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return null;
        }
    }

    public void put(String string, Serializable serializable) {
        this.put(string, serializable, -1);
    }

    /*
     * Loose catch block
     */
    public void put(String string, Serializable object, int n) {
        ObjectOutputStream objectOutputStream;
        block11: {
            objectOutputStream = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            object = byteArrayOutputStream.toByteArray();
            if (n != -1) {
                this.put(string, (byte[])object, n);
                break block11;
            }
            this.put(string, (byte[])object);
        }
        try {
            objectOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                objectOutputStream.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    /*
     * Loose catch block
     */
    public Object getAsObject(String object) {
        byte[] byArray = this.getAsBinary((String)object);
        object = byArray;
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = null;
            ObjectInputStream objectInputStream = null;
            byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
            try {
                byteArrayInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                objectInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return object;
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        if (byteArrayInputStream != null) {
                            byteArrayInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    if (byteArrayInputStream != null) {
                        byteArrayInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                try {
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return null;
            }
        }
        return null;
    }

    public void put(String string, Bitmap bitmap) {
        this.put(string, Utils.Bitmap2Bytes(bitmap));
    }

    public void put(String string, Bitmap bitmap, int n) {
        this.put(string, Utils.Bitmap2Bytes(bitmap), n);
    }

    public Bitmap getAsBitmap(String string) {
        if (this.getAsBinary(string) == null) {
            return null;
        }
        return Utils.Bytes2Bimap(this.getAsBinary(string));
    }

    public void put(String string, Drawable drawable) {
        this.put(string, Utils.drawable2Bitmap(drawable));
    }

    public void put(String string, Drawable drawable, int n) {
        this.put(string, Utils.drawable2Bitmap(drawable), n);
    }

    public Drawable getAsDrawable(String string) {
        if (this.getAsBinary(string) == null) {
            return null;
        }
        return Utils.bitmap2Drawable(Utils.Bytes2Bimap(this.getAsBinary(string)));
    }

    public File file(String object) {
        if (this.mCache == null) {
            return null;
        }
        if (((File)(object = this.mCache.newFile((String)object))).exists()) {
            return object;
        }
        return null;
    }

    public boolean hasCache(String string) {
        if (this.mCache == null) {
            return false;
        }
        return this.mCache.hasCache(string);
    }

    public boolean remove(String string) {
        if (this.mCache == null) {
            return false;
        }
        return this.mCache.remove(string);
    }

    public void clear() {
        if (this.mCache == null) {
            return;
        }
        this.mCache.clear();
    }

    static class Utils {
        private static final char mSeparator = ' ';

        private Utils() {
        }

        private static boolean isDue(String string) {
            return Utils.isDue(string.getBytes());
        }

        private static boolean isDue(byte[] objectArray) {
            String[] stringArray = Utils.getDateInfoFromDate(objectArray);
            objectArray = stringArray;
            if (stringArray != null && objectArray.length == 2) {
                Object object = objectArray[0];
                while (object.startsWith("0")) {
                    object = object.substring(1, object.length());
                }
                long l = Long.valueOf((String)object);
                long l2 = Long.valueOf((String)objectArray[1]);
                if (System.currentTimeMillis() > l + l2 * 1000L) {
                    return true;
                }
            }
            return false;
        }

        private static String newStringWithDateInfo(int n, String string) {
            return Utils.createDateInfo(n) + string;
        }

        private static byte[] newByteArrayWithDateInfo(int n, byte[] byArray) {
            byte[] byArray2 = Utils.createDateInfo(n).getBytes();
            byte[] byArray3 = new byte[byArray2.length + byArray.length];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
            return byArray3;
        }

        private static String clearDateInfo(String string) {
            if (string != null && Utils.hasDateInfo(string.getBytes())) {
                String string2 = string;
                string = string2.substring(string2.indexOf(32) + 1, string.length());
            }
            return string;
        }

        private static byte[] clearDateInfo(byte[] byArray) {
            if (Utils.hasDateInfo(byArray)) {
                return Utils.copyOfRange(byArray, Utils.indexOf(byArray, ' ') + 1, byArray.length);
            }
            return byArray;
        }

        private static boolean hasDateInfo(byte[] byArray) {
            return byArray != null && byArray.length > 15 && byArray[13] == 45 && Utils.indexOf(byArray, ' ') > 14;
        }

        private static String[] getDateInfoFromDate(byte[] object) {
            if (Utils.hasDateInfo(object)) {
                String string = new String(Utils.copyOfRange(object, 0, 13));
                object = new String(Utils.copyOfRange(object, 14, Utils.indexOf(object, ' ')));
                return new String[]{string, object};
            }
            return null;
        }

        private static int indexOf(byte[] byArray, char c) {
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] != c) continue;
                return i;
            }
            return -1;
        }

        private static byte[] copyOfRange(byte[] byArray, int n, int n2) {
            int n3 = n2 - n;
            if (n3 < 0) {
                throw new IllegalArgumentException(n + " > " + n2);
            }
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n, byArray2, 0, Math.min(byArray.length - n, n3));
            return byArray2;
        }

        private static String createDateInfo(int n) {
            String string = "" + System.currentTimeMillis();
            while (string.length() < 13) {
                string = "0".concat(String.valueOf(string));
            }
            return string + "-" + n + ' ';
        }

        private static byte[] Bitmap2Bytes(Bitmap bitmap) {
            if (bitmap == null) {
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }

        private static Bitmap Bytes2Bimap(byte[] byArray) {
            if (byArray.length == 0) {
                return null;
            }
            return BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
        }

        private static Bitmap drawable2Bitmap(Drawable drawable) {
            if (drawable == null) {
                return null;
            }
            int n = drawable.getIntrinsicWidth();
            int n2 = drawable.getIntrinsicHeight();
            Bitmap.Config config = drawable.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
            config = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)config);
            Canvas canvas = new Canvas((Bitmap)config);
            drawable.setBounds(0, 0, n, n2);
            drawable.draw(canvas);
            return config;
        }

        private static Drawable bitmap2Drawable(Bitmap bitmap) {
            if (bitmap == null) {
                return null;
            }
            return new BitmapDrawable(bitmap);
        }
    }

    public class ACacheManager {
        private final AtomicLong cacheSize;
        private final AtomicInteger cacheCount;
        private final long sizeLimit;
        private final int countLimit;
        private final Map<File, Long> lastUsageDates = Collections.synchronizedMap(new HashMap());
        protected File cacheDir;

        private ACacheManager(File file, long l, int n) {
            this.cacheDir = file;
            this.sizeLimit = l;
            this.countLimit = n;
            this.cacheSize = new AtomicLong();
            this.cacheCount = new AtomicInteger();
            this.calculateCacheSizeAndCacheCount();
        }

        private void calculateCacheSizeAndCacheCount() {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    int n = 0;
                    int n2 = 0;
                    File[] fileArray = ACacheManager.this.cacheDir.listFiles();
                    if (fileArray != null) {
                        for (File file : fileArray) {
                            n = (int)((long)n + ACacheManager.this.calculateSize(file));
                            ++n2;
                            File file2 = file;
                            ACacheManager.this.lastUsageDates.put(file2, file2.lastModified());
                        }
                        ACacheManager.this.cacheSize.set(n);
                        ACacheManager.this.cacheCount.set(n2);
                    }
                }
            }).start();
        }

        private void put(File file) {
            long l;
            int n = this.cacheCount.get();
            while (n + 1 > this.countLimit) {
                l = this.removeNext();
                this.cacheSize.addAndGet(-l);
                n = this.cacheCount.addAndGet(-1);
            }
            this.cacheCount.addAndGet(1);
            l = this.calculateSize(file);
            long l2 = this.cacheSize.get();
            while (l2 + l > this.sizeLimit) {
                long l3 = this.removeNext();
                l2 = this.cacheSize.addAndGet(-l3);
            }
            this.cacheSize.addAndGet(l);
            Long l4 = System.currentTimeMillis();
            file.setLastModified(l4);
            this.lastUsageDates.put(file, l4);
        }

        private File get(String object) {
            object = this.newFile((String)object);
            Long l = System.currentTimeMillis();
            ((File)object).setLastModified(l);
            this.lastUsageDates.put((File)object, l);
            return object;
        }

        private File newFile(String string) {
            return new File(this.cacheDir, "" + string.hashCode());
        }

        private boolean remove(String string) {
            return this.get(string).delete();
        }

        private boolean hasCache(String string) {
            return this.newFile(string).exists();
        }

        private void clear() {
            this.lastUsageDates.clear();
            this.cacheSize.set(0L);
            File[] fileArray = this.cacheDir.listFiles();
            if (fileArray != null) {
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    fileArray[i].delete();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long removeNext() {
            if (this.lastUsageDates.isEmpty()) {
                return 0L;
            }
            Long l = null;
            File file = null;
            Object object = this.lastUsageDates.entrySet();
            Map<File, Long> map = this.lastUsageDates;
            synchronized (map) {
                Iterator<Map.Entry<File, Long>> iterator = object.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (file == null) {
                        file = (File)object.getKey();
                        l = (Long)object.getValue();
                        continue;
                    }
                    Long l2 = (Long)object.getValue();
                    if (l2 >= l) continue;
                    l = l2;
                    file = (File)object.getKey();
                }
            }
            long l3 = this.calculateSize(file);
            if (file.delete()) {
                this.lastUsageDates.remove(file);
            }
            return l3;
        }

        private long calculateSize(File file) {
            return file.length();
        }
    }
}

