/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.util;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import com.tradplus.ads.base.util.OaidListener;
import com.tradplus.ads.base.util.OpenDeviceIdentifierService;
import com.tradplus.ads.base.util.oaid.AsusOaid;
import com.tradplus.ads.base.util.oaid.HWOaidAidlUtil;
import com.tradplus.ads.base.util.oaid.MeizuOaid;
import com.tradplus.ads.base.util.oaid.NubiaOaid;
import com.tradplus.ads.base.util.oaid.OaidCallback;
import com.tradplus.ads.base.util.oaid.OppoOaid;
import com.tradplus.ads.base.util.oaid.SamsungOaid;
import com.tradplus.ads.base.util.oaid.VivoOaid;
import com.tradplus.ads.base.util.oaid.ZuiOaid;
import com.tradplus.ads.common.util.LogUtil;
import java.lang.reflect.Method;
import java.util.Arrays;

public class OaidUtil {
    private static final String TAG = "OaidAidlUtil";
    private static final String SERVICE_PACKAGE_NAME = "com.huawei.hwid";
    private static final String SERVICE_ACTION = "com.uodis.opendevice.OPENIDS_SERVICE";
    private Context mContext;
    private ServiceConnection mServiceConnection;
    private OpenDeviceIdentifierService mService;
    private OaidListener mCallback;

    public OaidUtil(Context context) {
        this.mContext = context;
    }

    private boolean bindService() {
        LogUtil.ownShow(TAG, "bindService");
        if (this.mContext == null) {
            LogUtil.ownShow(TAG, "context is null");
            return false;
        }
        this.mServiceConnection = new IdentifierServiceConnection();
        Intent intent = new Intent(SERVICE_ACTION);
        intent.setPackage(SERVICE_PACKAGE_NAME);
        boolean bl = this.mContext.bindService(intent, this.mServiceConnection, 1);
        LogUtil.ownShow(TAG, "bindService result: ".concat(String.valueOf(bl)));
        return bl;
    }

    private void unbindService() {
        LogUtil.ownShow(TAG, "unbindService");
        if (this.mContext == null) {
            LogUtil.ownShow(TAG, "context is null");
            return;
        }
        if (this.mServiceConnection != null) {
            this.mContext.unbindService(this.mServiceConnection);
            this.mService = null;
            this.mContext = null;
            this.mCallback = null;
        }
    }

    public void getOaid(OaidListener oaidListener) {
        if (oaidListener == null) {
            LogUtil.ownShow(TAG, "callback is null");
            return;
        }
        this.mCallback = oaidListener;
        this.bindService();
    }

    public static void initOaidServerAndGetOaid(Context context, OaidCallback oaidCallback) {
        String string = "";
        try {
            string = OaidUtil.initSystemServerOaid(context);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                if (oaidCallback != null) {
                    oaidCallback.onSuccuss(string, false);
                }
                return;
            }
            String string2 = Build.MANUFACTURER;
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                string2 = string2.toUpperCase();
                if (Arrays.asList("ASUS", "HUAWEI", "OPPO", "ONEPLUS", "ZTE", "FERRMEOS", "SSUI", "SAMSUNG", "MEIZU", "MOTOLORA", "LENOVO").contains(string2)) {
                    OaidUtil.getOaidByBackground(context, string2, oaidCallback);
                } else if ("VIVO".equals(string2)) {
                    string = new VivoOaid(context).getOaid();
                } else if ("NUBIA".equals(string2)) {
                    string = new NubiaOaid(context).getOaid();
                }
            }
        }
        catch (Throwable throwable) {}
        if (!TextUtils.isEmpty((CharSequence)string) && oaidCallback != null) {
            oaidCallback.onSuccuss(string, false);
        }
    }

    private static void getOaidByBackground(final Context context, final String string, final OaidCallback oaidCallback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                OaidCallback oaidCallback2 = new OaidCallback(){

                    @Override
                    public void onSuccuss(String string, boolean bl) {
                        if (oaidCallback != null) {
                            oaidCallback.onSuccuss(string, bl);
                        }
                    }

                    @Override
                    public void onFail(String string) {
                        oaidCallback.onFail("no oaid");
                    }
                };
                try {
                    switch (string) {
                        case "ASUS": {
                            new AsusOaid(context).getOaid(oaidCallback2);
                            return;
                        }
                        case "OPPO": 
                        case "ONEPLUS": {
                            new OppoOaid(context).getOaid(oaidCallback2);
                            return;
                        }
                        case "HUAWEI": {
                            new HWOaidAidlUtil(context).getOaid(oaidCallback2);
                            return;
                        }
                        case "SAMSUNG": {
                            new SamsungOaid(context).getOaid(oaidCallback2);
                            return;
                        }
                        case "LENOVO": 
                        case "MOTOLORA": {
                            new ZuiOaid(context).getOaid(oaidCallback2);
                            return;
                        }
                        case "MEIZU": {
                            new MeizuOaid(context).getOaid(oaidCallback2);
                            return;
                        }
                    }
                    oaidCallback.onFail("no oaid");
                    return;
                }
                catch (Throwable throwable) {
                    if (oaidCallback != null) {
                        oaidCallback.onFail(throwable.getMessage());
                    }
                    return;
                }
            }
        }).start();
    }

    private static String initSystemServerOaid(Context context) {
        try {
            return new IdProvider((Context)context).b;
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    @SuppressLint(value={"PrivateApi"})
    static final class IdProvider {
        private static Object e;
        private static Class<?> f;
        private static Method g;
        private static Method h;
        private static Method i;
        private static Method j;
        final String a;
        final String b;
        final String c;
        final String d;

        IdProvider(Context context) {
            this.a = IdProvider.a(context, g);
            this.b = IdProvider.a(context, h);
            this.c = IdProvider.a(context, i);
            this.d = IdProvider.a(context, j);
        }

        static boolean a() {
            return f != null && e != null;
        }

        private static String a(Context object, Method method) {
            if (e != null && method != null) {
                try {
                    object = method.invoke(e, object);
                    if (object != null) {
                        return (String)object;
                    }
                }
                catch (Throwable throwable) {}
            }
            return null;
        }

        static {
            g = null;
            h = null;
            i = null;
            j = null;
            try {
                f = Class.forName("com.android.id.impl.IdProviderImpl");
                e = f.newInstance();
                g = f.getMethod("getUDID", Context.class);
                h = f.getMethod("getOAID", Context.class);
                i = f.getMethod("getVAID", Context.class);
                j = f.getMethod("getAAID", Context.class);
            }
            catch (Throwable throwable) {}
        }
    }

    final class IdentifierServiceConnection
    implements ServiceConnection {
        private IdentifierServiceConnection() {
        }

        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            LogUtil.ownShow(OaidUtil.TAG, "onServiceConnected");
            OaidUtil.this.mService = OpenDeviceIdentifierService.Stub.asInterface(iBinder);
            if (null != OaidUtil.this.mService) {
                try {
                    if (null != OaidUtil.this.mCallback) {
                        OaidUtil.this.mCallback.onSuccuss(OaidUtil.this.mService.getOaid(), OaidUtil.this.mService.isOaidTrackLimited());
                    }
                    return;
                }
                catch (RemoteException remoteException) {
                    LogUtil.ownShow(OaidUtil.TAG, "getChannelInfo RemoteException");
                    if (null != OaidUtil.this.mCallback) {
                        OaidUtil.this.mCallback.onFail(remoteException.getMessage());
                    }
                    return;
                }
                catch (Exception exception) {
                    LogUtil.ownShow(OaidUtil.TAG, "getChannelInfo Excepition");
                    if (null != OaidUtil.this.mCallback) {
                        OaidUtil.this.mCallback.onFail(exception.getMessage());
                    }
                    return;
                }
                finally {
                    OaidUtil.this.unbindService();
                }
            }
        }

        public final void onServiceDisconnected(ComponentName componentName) {
            LogUtil.ownShow(OaidUtil.TAG, "onServiceDisconnected");
            OaidUtil.this.mService = null;
        }
    }
}

