/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.util;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.common.TPSensorManager;
import com.tradplus.ads.base.common.TPUseTimeManager;
import com.tradplus.ads.base.network.NetworkChangeManager;
import com.tradplus.ads.common.util.LogUtil;
import java.util.ArrayList;
import java.util.List;

public class TPContextUtils {
    private List<Activity> activities;
    private boolean isApplicationContext;
    private static TPContextUtils instance;
    private Context mApplicationContext;
    private boolean isRefreshActivity = false;

    public static TPContextUtils getInstance(Context context) {
        if (instance == null) {
            instance = new TPContextUtils(context);
        }
        return instance;
    }

    public TPContextUtils(Context context) {
        this.init(context);
    }

    private void init(Context context) {
        this.mApplicationContext = context.getApplicationContext();
        this.startTopActivity(context);
    }

    private void startTopActivity(Context context) {
        this.activities = new ArrayList<Activity>();
        if (context instanceof Activity) {
            this.activities.add((Activity)context);
        }
        if (this.mApplicationContext instanceof Application) {
            this.isApplicationContext = true;
            ((Application)this.mApplicationContext).registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(Activity activity, Bundle bundle) {
                    if (!TPContextUtils.this.activities.contains(activity)) {
                        TPContextUtils.this.activities.add(activity);
                    }
                    if (TPSensorManager.getInstance().isRegister()) {
                        TPSensorManager.getInstance().setShowAdActivity(activity);
                    }
                    LogUtil.ownShow("onActivityCreated activity size = " + TPContextUtils.this.activities.size());
                }

                public void onActivityStarted(Activity activity) {
                }

                public void onActivityResumed(Activity activity) {
                    if (TPContextUtils.this.isRefreshActivity) {
                        GlobalTradPlus.getInstance().refreshContext((Context)activity);
                    }
                    TPUseTimeManager.getInstance().onResume();
                }

                public void onActivityPaused(Activity activity) {
                    TPUseTimeManager.getInstance().onPause();
                }

                public void onActivityStopped(Activity activity) {
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
                }

                public void onActivityDestroyed(Activity activity) {
                    TPContextUtils.this.activities.remove(activity);
                    LogUtil.ownShow("destroyed activity size = " + TPContextUtils.this.activities.size());
                    if (TPContextUtils.this.activities.size() == 0) {
                        NetworkChangeManager.getInstance().stopConnectivityNetwork(TPContextUtils.this.mApplicationContext);
                    }
                    if (TPSensorManager.getInstance().isRegister()) {
                        TPSensorManager.getInstance().unregisterSensor();
                    }
                }
            });
        }
    }

    public Context compareContext(Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof Activity) {
            return context;
        }
        if (this.activities != null && this.activities.size() > 0) {
            return (Context)this.activities.get(0);
        }
        return null;
    }

    public boolean isApplicationContext() {
        return this.isApplicationContext;
    }

    public void setApplicationContext(boolean bl) {
        this.isApplicationContext = bl;
    }

    public boolean compareContextWithApplication(Context context) {
        return context instanceof Application;
    }

    public void setRefreshActivity(boolean bl) {
        this.isRefreshActivity = bl;
    }
}

