/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlUtils {
    private XmlUtils() {
    }

    public static Node getFirstMatchingChildNode(Node node, String string) {
        return XmlUtils.getFirstMatchingChildNode(node, string, null, null);
    }

    public static Node getFirstMatchingChildNode(Node object, String string, String string2, List<String> list) {
        if (object == null || string == null) {
            return null;
        }
        if ((object = XmlUtils.getMatchingChildNodes((Node)object, string, string2, list)) != null && !object.isEmpty()) {
            return (Node)object.get(0);
        }
        return null;
    }

    public static List<Node> getMatchingChildNodes(Node node, String string) {
        return XmlUtils.getMatchingChildNodes(node, string, null, null);
    }

    public static List<Node> getMatchingChildNodes(Node object, String string, String string2, List<String> list) {
        if (object == null || string == null) {
            return null;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        object = object.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node = object.item(i);
            if (!node.getNodeName().equals(string) || !XmlUtils.nodeMatchesAttributeFilter(node, string2, list)) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public static boolean nodeMatchesAttributeFilter(Node object, String string, List<String> list) {
        if (string == null || list == null) {
            return true;
        }
        return (object = object.getAttributes()) != null && (object = object.getNamedItem(string)) != null && list.contains(object.getNodeValue());
    }

    public static String getNodeValue(Node node) {
        if (node != null && node.getFirstChild() != null && node.getFirstChild().getNodeValue() != null) {
            return node.getFirstChild().getNodeValue().trim();
        }
        return null;
    }

    public static Integer getAttributeValueAsInt(Node node, String string) {
        if (node == null || string == null) {
            return null;
        }
        try {
            return Integer.parseInt(XmlUtils.getAttributeValue(node, string));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static String getAttributeValue(Node node, String string) {
        if (node == null || string == null) {
            return null;
        }
        if ((node = node.getAttributes().getNamedItem(string)) != null) {
            return node.getNodeValue();
        }
        return null;
    }

    public static <T> List<T> getListFromDocument(Document object, String string, String string2, String string3, NodeProcessor<T> nodeProcessor) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (object == null) {
            return arrayList;
        }
        if ((object = object.getElementsByTagName(string)) == null) {
            return arrayList;
        }
        string = string3 == null ? null : Arrays.asList(string3);
        for (int i = 0; i < object.getLength(); ++i) {
            Node node = object.item(i);
            if (node == null || !XmlUtils.nodeMatchesAttributeFilter(node, string2, (List<String>)((Object)string)) || (node = nodeProcessor.process(node)) == null) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    public static <T> T getFirstMatchFromDocument(Document object, String string, String string2, String string3, NodeProcessor<T> nodeProcessor) {
        if (object == null) {
            return null;
        }
        if ((object = object.getElementsByTagName(string)) == null) {
            return null;
        }
        string = string3 == null ? null : Arrays.asList(string3);
        for (int i = 0; i < object.getLength(); ++i) {
            Node node = object.item(i);
            if (node == null || !XmlUtils.nodeMatchesAttributeFilter(node, string2, (List<String>)((Object)string)) || (node = nodeProcessor.process(node)) == null) continue;
            return (T)node;
        }
        return null;
    }

    public static String getFirstMatchingStringData(Document document, String string) {
        return XmlUtils.getFirstMatchingStringData(document, string, null, null);
    }

    public static String getFirstMatchingStringData(Document document, String string, String string2, String string3) {
        return XmlUtils.getFirstMatchFromDocument(document, string, string2, string3, new NodeProcessor<String>(){

            @Override
            public String process(Node node) {
                return XmlUtils.getNodeValue(node);
            }
        });
    }

    public static List<String> getStringDataAsList(Document document, String string) {
        return XmlUtils.getStringDataAsList(document, string, null, null);
    }

    public static List<String> getStringDataAsList(Document document, String string, String string2, String string3) {
        return XmlUtils.getListFromDocument(document, string, string2, string3, new NodeProcessor<String>(){

            @Override
            public String process(Node node) {
                return XmlUtils.getNodeValue(node);
            }
        });
    }

    public static List<Node> getNodesWithElementAndAttribute(Document document, String string, String string2, String string3) {
        return XmlUtils.getListFromDocument(document, string, string2, string3, new NodeProcessor<Node>(){

            @Override
            public Node process(Node node) {
                return node;
            }
        });
    }

    public static interface NodeProcessor<T> {
        public T process(Node var1);
    }
}

