/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.util.oaid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.tradplus.ads.base.util.oaid.HWIdentifierService;
import com.tradplus.ads.base.util.oaid.OaidCallback;

public class HWOaidAidlUtil {
    private static final String TAG = "OaidAidlUtil";
    private static final String SERVICE_PACKAGE_NAME = "com.huawei.hwid";
    private static final String SERVICE_ACTION = "com.uodis.opendevice.OPENIDS_SERVICE";
    private Context mContext;
    private ServiceConnection mServiceConnection;
    private HWIdentifierService mService;
    private OaidCallback mCallback;

    public HWOaidAidlUtil(Context context) {
        this.mContext = context;
    }

    private boolean bindService() {
        Log.d((String)TAG, (String)"bindService");
        if (this.mContext == null) {
            Log.e((String)TAG, (String)"context is null");
            return false;
        }
        this.mServiceConnection = new IdentifierServiceConnection();
        Intent intent = new Intent(SERVICE_ACTION);
        intent.setPackage(SERVICE_PACKAGE_NAME);
        boolean bl = this.mContext.bindService(intent, this.mServiceConnection, 1);
        Log.i((String)TAG, (String)"bindService result: ".concat(String.valueOf(bl)));
        return bl;
    }

    private void unbindService() {
        Log.i((String)TAG, (String)"unbindService");
        if (this.mContext == null) {
            Log.e((String)TAG, (String)"context is null");
            return;
        }
        if (this.mServiceConnection != null) {
            this.mContext.unbindService(this.mServiceConnection);
            this.mService = null;
            this.mContext = null;
            this.mCallback = null;
        }
    }

    public void getOaid(OaidCallback oaidCallback) {
        if (oaidCallback == null) {
            Log.e((String)TAG, (String)"callback is null");
            return;
        }
        this.mCallback = oaidCallback;
        this.bindService();
    }

    final class IdentifierServiceConnection
    implements ServiceConnection {
        private IdentifierServiceConnection() {
        }

        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            Log.i((String)HWOaidAidlUtil.TAG, (String)"onServiceConnected");
            HWOaidAidlUtil.this.mService = HWIdentifierService.Stub.asInterface(iBinder);
            if (null != HWOaidAidlUtil.this.mService) {
                try {
                    if (null != HWOaidAidlUtil.this.mCallback) {
                        HWOaidAidlUtil.this.mCallback.onSuccuss(HWOaidAidlUtil.this.mService.getOaid(), HWOaidAidlUtil.this.mService.isOaidTrackLimited());
                    }
                    return;
                }
                catch (RemoteException remoteException) {
                    Log.e((String)HWOaidAidlUtil.TAG, (String)"getChannelInfo RemoteException");
                    if (null != HWOaidAidlUtil.this.mCallback) {
                        HWOaidAidlUtil.this.mCallback.onFail(remoteException.getMessage());
                    }
                    return;
                }
                catch (Exception exception) {
                    Log.e((String)HWOaidAidlUtil.TAG, (String)"getChannelInfo Excepition");
                    if (null != HWOaidAidlUtil.this.mCallback) {
                        HWOaidAidlUtil.this.mCallback.onFail(exception.getMessage());
                    }
                    return;
                }
                finally {
                    HWOaidAidlUtil.this.unbindService();
                }
            }
        }

        public final void onServiceDisconnected(ComponentName componentName) {
            Log.i((String)HWOaidAidlUtil.TAG, (String)"onServiceDisconnected");
            HWOaidAidlUtil.this.mService = null;
        }
    }
}

