/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.util.oaid;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.Signature;
import android.os.IBinder;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import com.tradplus.ads.base.util.oaid.OaidCallback;
import com.tradplus.ads.base.util.oaid.OppoOaidInterface;
import java.security.MessageDigest;

public final class OppoOaid {
    private Context context;
    OppoOaidInterface oppoOaidInterface;
    ServiceConnection c = new ServiceConnection(){

        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            OppoOaid.this.oppoOaidInterface = OppoOaidInterface.OppoOaidBinder.getOppoOaidInterface(iBinder);
        }

        public final void onServiceDisconnected(ComponentName componentName) {
            OppoOaid.this.oppoOaidInterface = null;
        }
    };

    public OppoOaid(Context context) {
        this.context = context;
    }

    public final String getOaid(OaidCallback oaidCallback) {
        String string = "";
        if (Looper.myLooper() == Looper.getMainLooper()) {
            return "";
        }
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.heytap.openid", "com.heytap.openid.IdentifyService"));
        intent.setAction("action.com.heytap.openid.OPEN_ID_SERVICE");
        if (this.context.bindService(intent, this.c, 1)) {
            try {
                SystemClock.sleep((long)3000L);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (this.oppoOaidInterface != null) {
                string = this.getOaid("OUID");
                if (oaidCallback != null) {
                    oaidCallback.onSuccuss(string, false);
                }
            }
        }
        if (TextUtils.isEmpty((CharSequence)string) && oaidCallback != null) {
            oaidCallback.onFail("Empty");
        }
        return string;
    }

    private String getOaid(String string) {
        Object[] objectArray;
        String string2 = null;
        String string3 = this.context.getPackageName();
        try {
            objectArray = this.context.getPackageManager().getPackageInfo((String)string3, (int)64).signatures;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            objectArray = null;
        }
        if (objectArray != null && objectArray.length > 0) {
            objectArray = objectArray[0].toByteArray();
            try {
                Object object = MessageDigest.getInstance("SHA1");
                if (object != null) {
                    objectArray = ((MessageDigest)object).digest((byte[])objectArray);
                    object = new StringBuilder();
                    Object[] objectArray2 = objectArray;
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        Signature signature = objectArray2[i];
                        ((StringBuilder)object).append(Integer.toHexString(signature & 0xFF | 0x100).substring(1, 3));
                    }
                    string2 = ((StringBuilder)object).toString();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return ((OppoOaidInterface.OppoOaidBinder.OppoOaidInterfaceImpl)this.oppoOaidInterface).getOaid(string3, string2, string);
    }
}

