/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;

public class AdvertisingIdClient {
    public static AdInfo getAdvertisingIdInfo(Context context) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalStateException("Cannot be called from the main thread");
        }
        context.getPackageManager().getPackageInfo("com.android.vending", 0);
        AdvertisingConnection advertisingConnection = new AdvertisingConnection();
        Object object = new Intent("com.google.android.gms.ads.identifier.service.START");
        object.setPackage("com.google.android.gms");
        if (context.bindService((Intent)object, (ServiceConnection)advertisingConnection, 1)) {
            try {
                object = new AdvertisingInterface(advertisingConnection.getBinder());
                object = new AdInfo(((AdvertisingInterface)object).getId(), ((AdvertisingInterface)object).isLimitAdTrackingEnabled(true));
                return object;
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                context.unbindService((ServiceConnection)advertisingConnection);
            }
        }
        throw new IOException("Google Play connection failed");
    }

    static final class AdvertisingInterface
    implements IInterface {
        private IBinder binder;

        public AdvertisingInterface(IBinder iBinder) {
            this.binder = iBinder;
        }

        public final IBinder asBinder() {
            return this.binder;
        }

        public final String getId() {
            String string;
            Parcel parcel = Parcel.obtain();
            Parcel parcel2 = Parcel.obtain();
            try {
                parcel.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.binder.transact(1, parcel, parcel2, 0);
                parcel2.readException();
                string = parcel2.readString();
            }
            finally {
                parcel2.recycle();
                parcel.recycle();
            }
            return string;
        }

        public final boolean isLimitAdTrackingEnabled(boolean bl) {
            Parcel parcel = Parcel.obtain();
            Parcel parcel2 = Parcel.obtain();
            try {
                parcel.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                parcel.writeInt(bl ? 1 : 0);
                this.binder.transact(2, parcel, parcel2, 0);
                parcel2.readException();
                bl = 0 != parcel2.readInt();
            }
            finally {
                parcel2.recycle();
                parcel.recycle();
            }
            return bl;
        }
    }

    static final class AdvertisingConnection
    implements ServiceConnection {
        boolean retrieved = false;
        private final LinkedBlockingQueue<IBinder> queue = new LinkedBlockingQueue(1);

        private AdvertisingConnection() {
        }

        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            try {
                this.queue.put(iBinder);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public final void onServiceDisconnected(ComponentName componentName) {
        }

        public final IBinder getBinder() {
            if (this.retrieved) {
                throw new IllegalStateException();
            }
            this.retrieved = true;
            return this.queue.take();
        }
    }

    public static final class AdInfo {
        private final String advertisingId;
        private final boolean limitAdTrackingEnabled;

        AdInfo(String string, boolean bl) {
            this.advertisingId = string;
            this.limitAdTrackingEnabled = bl;
        }

        public final String getId() {
            return this.advertisingId;
        }

        public final boolean isLimitAdTrackingEnabled() {
            return this.limitAdTrackingEnabled;
        }
    }
}

