/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.os.AsyncTask;
import com.tradplus.ads.common.DiskLruCache;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.common.util.CMData;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.Streams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CacheService {
    static final String UNIQUE_CACHE_NAME = "flute-cache";
    private static final int APP_VERSION = 1;
    private static final int VALUE_COUNT = 1;
    private static final int DISK_CACHE_INDEX = 0;
    private static DiskLruCache sDiskLruCache;

    public static boolean initializeDiskCache(Context object) {
        if (object == null) {
            return false;
        }
        if (sDiskLruCache == null) {
            if ((object = CacheService.getDiskCacheDirectory(object)) == null) {
                return false;
            }
            long l = DeviceUtils.diskCacheSizeBytes((File)object);
            try {
                sDiskLruCache = DiskLruCache.open((File)object, 1, 1, l);
            }
            catch (IOException iOException) {
                LogUtil.show("Unable to create DiskLruCache", iOException);
                return false;
            }
        }
        return true;
    }

    public static void initialize(Context context) {
        CacheService.initializeDiskCache(context);
    }

    public static String createValidDiskCacheKey(String string) {
        return CMData.getS256(string);
    }

    public static File getDiskCacheDirectory(Context object) {
        if ((object = object.getCacheDir()) == null) {
            return null;
        }
        object = ((File)object).getPath();
        return new File((String)object + File.separator + UNIQUE_CACHE_NAME);
    }

    public static boolean containsKeyDiskCache(String string) {
        if (sDiskLruCache == null) {
            return false;
        }
        try {
            return sDiskLruCache.get(CacheService.createValidDiskCacheKey(string)) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getFilePathDiskCache(String string) {
        if (sDiskLruCache == null) {
            return null;
        }
        return sDiskLruCache.getDirectory() + File.separator + CacheService.createValidDiskCacheKey(string) + ".0";
    }

    public static byte[] getFromDiskCache(String object) {
        byte[] byArray;
        block12: {
            if (sDiskLruCache == null) {
                return null;
            }
            byArray = null;
            try (DiskLruCache.Snapshot snapshot = null;){
                snapshot = sDiskLruCache.get(CacheService.createValidDiskCacheKey((String)object));
                if (snapshot == null) {
                    return null;
                }
                object = snapshot.getInputStream(0);
                if (object == null) break block12;
                byArray = new byte[(int)snapshot.getLength(0)];
                object = new BufferedInputStream((InputStream)object);
                try {
                    Streams.readStream((InputStream)object, byArray);
                }
                finally {
                    Streams.closeStream((Closeable)object);
                }
            }
        }
        return byArray;
    }

    public static void getFromDiskCacheAsync(String string, DiskLruCacheGetListener diskLruCacheGetListener) {
        new DiskLruCacheGetTask(string, diskLruCacheGetListener).execute(new Void[0]);
    }

    public static boolean putToDiskCache(String string, byte[] byArray) {
        return CacheService.putToDiskCache(string, new ByteArrayInputStream(byArray));
    }

    public static boolean putToDiskCache(String object, InputStream inputStream) {
        if (sDiskLruCache == null) {
            return false;
        }
        DiskLruCache.Editor editor = null;
        try {
            editor = sDiskLruCache.edit(CacheService.createValidDiskCacheKey((String)object));
            if (editor == null) {
                return false;
            }
            object = new BufferedOutputStream(editor.newOutputStream(0));
            Streams.copyContent(inputStream, (OutputStream)object);
            ((OutputStream)object).flush();
            ((OutputStream)object).close();
            sDiskLruCache.flush();
            editor.commit();
        }
        catch (Exception exception) {
            LogUtil.show("Unable to put to DiskLruCache", exception);
            try {
                if (editor != null) {
                    editor.abort();
                }
            }
            catch (IOException iOException) {}
            return false;
        }
        return true;
    }

    public static void putToDiskCacheAsync(String string, byte[] byArray) {
        new DiskLruCachePutTask(string, byArray).execute(new Void[0]);
    }

    @Deprecated
    @VisibleForTesting
    public static void clearAndNullCaches() {
        if (sDiskLruCache != null) {
            try {
                sDiskLruCache.delete();
                sDiskLruCache = null;
                return;
            }
            catch (IOException iOException) {
                sDiskLruCache = null;
            }
        }
    }

    @Deprecated
    @VisibleForTesting
    public static DiskLruCache getDiskLruCache() {
        return sDiskLruCache;
    }

    static class DiskLruCachePutTask
    extends AsyncTask<Void, Void, Void> {
        private final String mKey;
        private final byte[] mContent;

        DiskLruCachePutTask(String string, byte[] byArray) {
            this.mKey = string;
            this.mContent = byArray;
        }

        protected Void doInBackground(Void ... voidArray) {
            CacheService.putToDiskCache(this.mKey, this.mContent);
            return null;
        }
    }

    static class DiskLruCacheGetTask
    extends AsyncTask<Void, Void, byte[]> {
        private final DiskLruCacheGetListener mDiskLruCacheGetListener;
        private final String mKey;

        DiskLruCacheGetTask(String string, DiskLruCacheGetListener diskLruCacheGetListener) {
            this.mDiskLruCacheGetListener = diskLruCacheGetListener;
            this.mKey = string;
        }

        protected byte[] doInBackground(Void ... voidArray) {
            return CacheService.getFromDiskCache(this.mKey);
        }

        protected void onPostExecute(byte[] byArray) {
            if (this.isCancelled()) {
                this.onCancelled();
                return;
            }
            if (this.mDiskLruCacheGetListener != null) {
                this.mDiskLruCacheGetListener.onComplete(this.mKey, byArray);
            }
        }

        protected void onCancelled() {
            if (this.mDiskLruCacheGetListener != null) {
                this.mDiskLruCacheGetListener.onComplete(this.mKey, null);
            }
        }
    }

    public static interface DiskLruCacheGetListener {
        public void onComplete(String var1, byte[] var2);
    }
}

