/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import com.tradplus.ads.common.DiskLruCacheStrictLineReader;
import com.tradplus.ads.common.DiskLruCacheUtil;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public final class DiskLruCache
implements Closeable {
    static final String JOURNAL_FILE = "journal";
    static final String JOURNAL_FILE_TEMP = "journal.tmp";
    static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    static final String MAGIC = "libcore.io.DiskLruCache";
    static final String VERSION_1 = "1";
    static final long ANY_SEQUENCE_NUMBER = -1L;
    static final Pattern LEGAL_KEY_PATTERN = Pattern.compile("[a-z0-9_-]{1,64}");
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    private static final String REMOVE = "REMOVE";
    private static final String READ = "READ";
    private final File directory;
    private final File journalFile;
    private final File journalFileTmp;
    private final File journalFileBackup;
    private final int appVersion;
    private long maxSize;
    private final int valueCount;
    private long size = 0L;
    private Writer journalWriter;
    private final LinkedHashMap<String, Entry> lruEntries = new LinkedHashMap(0, 0.75f, true);
    private int redundantOpCount;
    private long nextSequenceNumber = 0L;
    final ThreadPoolExecutor executorService = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    private final Callable<Void> cleanupCallable = new Callable<Void>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (DiskLruCache.this.journalWriter == null) {
                    return null;
                }
                DiskLruCache.this.trimToSize();
                if (DiskLruCache.this.journalRebuildRequired()) {
                    DiskLruCache.this.rebuildJournal();
                    DiskLruCache.this.redundantOpCount = 0;
                }
            }
            return null;
        }
    };
    private static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int n) {
        }
    };

    private DiskLruCache(File file, int n, int n2, long l) {
        this.directory = file;
        this.appVersion = n;
        this.journalFile = new File(file, JOURNAL_FILE);
        this.journalFileTmp = new File(file, JOURNAL_FILE_TEMP);
        this.journalFileBackup = new File(file, JOURNAL_FILE_BACKUP);
        this.valueCount = n2;
        this.maxSize = l;
    }

    public static DiskLruCache open(File file, int n, int n2, long l) {
        Object object;
        if (l <= 0L) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("valueCount <= 0");
        }
        File file2 = new File(file, JOURNAL_FILE_BACKUP);
        if (file2.exists()) {
            object = new File(file, JOURNAL_FILE);
            if (((File)object).exists()) {
                file2.delete();
            } else {
                DiskLruCache.renameTo(file2, (File)object, false);
            }
        }
        object = new DiskLruCache(file, n, n2, l);
        if (((DiskLruCache)object).journalFile.exists()) {
            try {
                super.readJournal();
                super.processJournal();
                ((DiskLruCache)object).journalWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(((DiskLruCache)object).journalFile, true), DiskLruCacheUtil.US_ASCII));
                return object;
            }
            catch (IOException iOException) {
                ((DiskLruCache)object).delete();
            }
        }
        file.mkdirs();
        object = new DiskLruCache(file, n, n2, l);
        ((DiskLruCache)object).rebuildJournal();
        return object;
    }

    private void readJournal() {
        DiskLruCacheStrictLineReader diskLruCacheStrictLineReader = new DiskLruCacheStrictLineReader(new FileInputStream(this.journalFile), DiskLruCacheUtil.US_ASCII);
        try {
            String string = diskLruCacheStrictLineReader.readLine();
            String string2 = diskLruCacheStrictLineReader.readLine();
            String string3 = diskLruCacheStrictLineReader.readLine();
            String string4 = diskLruCacheStrictLineReader.readLine();
            String string5 = diskLruCacheStrictLineReader.readLine();
            if (!(MAGIC.equals(string) && VERSION_1.equals(string2) && Integer.toString(this.appVersion).equals(string3) && Integer.toString(this.valueCount).equals(string4) && "".equals(string5))) {
                throw new IOException("unexpected journal header: [" + string + ", " + string2 + ", " + string4 + ", " + string5 + "]");
            }
            int n = 0;
            try {
                while (true) {
                    this.readJournalLine(diskLruCacheStrictLineReader.readLine());
                    ++n;
                }
            }
            catch (EOFException eOFException) {
                this.redundantOpCount = n - this.lruEntries.size();
                return;
            }
        }
        finally {
            DiskLruCacheUtil.closeQuietly(diskLruCacheStrictLineReader);
        }
    }

    private void readJournalLine(String stringArray) {
        Entry entry;
        String string;
        int n = stringArray.indexOf(32);
        if (n == -1) {
            throw new IOException("unexpected journal line: ".concat(String.valueOf(stringArray)));
        }
        int n2 = n + 1;
        int n3 = stringArray.indexOf(32, n2);
        if (n3 == -1) {
            string = stringArray.substring(n2);
            if (n == 6 && stringArray.startsWith(REMOVE)) {
                this.lruEntries.remove(string);
                return;
            }
        } else {
            string = stringArray.substring(n2, n3);
        }
        if ((entry = this.lruEntries.get(string)) == null) {
            entry = new Entry(string);
            this.lruEntries.put(string, entry);
        }
        if (n3 != -1 && n == 5 && stringArray.startsWith(CLEAN)) {
            stringArray = stringArray.substring(n3 + 1).split(" ");
            entry.readable = true;
            entry.currentEditor = null;
            entry.setLengths(stringArray);
            return;
        }
        if (n3 == -1 && n == 5 && stringArray.startsWith(DIRTY)) {
            entry.currentEditor = new Editor(entry);
            return;
        }
        if (n3 != -1 || n != 4 || !stringArray.startsWith(READ)) {
            throw new IOException("unexpected journal line: ".concat(String.valueOf(stringArray)));
        }
    }

    private void processJournal() {
        DiskLruCache.deleteIfExists(this.journalFileTmp);
        Iterator<Entry> iterator = this.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            int n;
            Entry entry = iterator.next();
            if (entry.currentEditor == null) {
                for (n = 0; n < this.valueCount; ++n) {
                    this.size += entry.lengths[n];
                }
                continue;
            }
            entry.currentEditor = null;
            for (n = 0; n < this.valueCount; ++n) {
                DiskLruCache.deleteIfExists(entry.getCleanFile(n));
                DiskLruCache.deleteIfExists(entry.getDirtyFile(n));
            }
            iterator.remove();
        }
    }

    private synchronized void rebuildJournal() {
        if (this.journalWriter != null) {
            this.journalWriter.close();
        }
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.journalFileTmp), DiskLruCacheUtil.US_ASCII));){
            bufferedWriter.write(MAGIC);
            bufferedWriter.write("\n");
            bufferedWriter.write(VERSION_1);
            bufferedWriter.write("\n");
            bufferedWriter.write(Integer.toString(this.appVersion));
            bufferedWriter.write("\n");
            bufferedWriter.write(Integer.toString(this.valueCount));
            bufferedWriter.write("\n");
            bufferedWriter.write("\n");
            for (Entry entry : this.lruEntries.values()) {
                if (entry.currentEditor != null) {
                    bufferedWriter.write("DIRTY " + entry.key + '\n');
                    continue;
                }
                bufferedWriter.write("CLEAN " + entry.key + entry.getLengths() + '\n');
            }
        }
        if (this.journalFile.exists()) {
            DiskLruCache.renameTo(this.journalFile, this.journalFileBackup, true);
        }
        DiskLruCache.renameTo(this.journalFileTmp, this.journalFile, false);
        this.journalFileBackup.delete();
        this.journalWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.journalFile, true), DiskLruCacheUtil.US_ASCII));
    }

    private static void deleteIfExists(File file) {
        if (file.exists() && !file.delete()) {
            throw new IOException();
        }
    }

    private static void renameTo(File file, File file2, boolean bl) {
        if (bl) {
            DiskLruCache.deleteIfExists(file2);
        }
        if (!file.renameTo(file2)) {
            throw new IOException();
        }
    }

    public final synchronized Snapshot get(String string) {
        this.checkNotClosed();
        this.validateKey(string);
        Entry entry = this.lruEntries.get(string);
        if (entry == null) {
            return null;
        }
        if (!entry.readable) {
            return null;
        }
        InputStream[] inputStreamArray = new InputStream[this.valueCount];
        try {
            for (int i = 0; i < this.valueCount; ++i) {
                inputStreamArray[i] = new FileInputStream(entry.getCleanFile(i));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            for (int i = 0; i < this.valueCount && inputStreamArray[i] != null; ++i) {
                DiskLruCacheUtil.closeQuietly(inputStreamArray[i]);
            }
            return null;
        }
        ++this.redundantOpCount;
        this.journalWriter.append("READ " + string + '\n');
        if (this.journalRebuildRequired()) {
            this.executorService.submit(this.cleanupCallable);
        }
        return new Snapshot(string, entry.sequenceNumber, inputStreamArray, entry.lengths);
    }

    public final Editor edit(String string) {
        return this.edit(string, -1L);
    }

    private synchronized Editor edit(String string, long l) {
        this.checkNotClosed();
        this.validateKey(string);
        Entry entry = this.lruEntries.get(string);
        if (l != -1L && (entry == null || entry.sequenceNumber != l)) {
            return null;
        }
        if (entry == null) {
            entry = new Entry(string);
            this.lruEntries.put(string, entry);
        } else if (entry.currentEditor != null) {
            return null;
        }
        Editor editor = new Editor(entry);
        entry.currentEditor = editor;
        this.journalWriter.write("DIRTY " + string + '\n');
        this.journalWriter.flush();
        return editor;
    }

    public final File getDirectory() {
        return this.directory;
    }

    public final synchronized long getMaxSize() {
        return this.maxSize;
    }

    public final synchronized void setMaxSize(long l) {
        this.maxSize = l;
        this.executorService.submit(this.cleanupCallable);
    }

    public final synchronized long size() {
        return this.size;
    }

    private synchronized void completeEdit(Editor object, boolean bl) {
        int n;
        Entry entry = ((Editor)object).entry;
        if (entry.currentEditor != object) {
            throw new IllegalStateException();
        }
        if (bl && !entry.readable) {
            for (n = 0; n < this.valueCount; ++n) {
                if (!((Editor)object).written[n]) {
                    ((Editor)object).abort();
                    throw new IllegalStateException("Newly created entry didn't create value for index ".concat(String.valueOf(n)));
                }
                if (entry.getDirtyFile(n).exists()) continue;
                ((Editor)object).abort();
                return;
            }
        }
        for (n = 0; n < this.valueCount; ++n) {
            object = entry.getDirtyFile(n);
            if (bl) {
                long l;
                if (!((File)object).exists()) continue;
                File file = entry.getCleanFile(n);
                ((File)object).renameTo(file);
                long l2 = entry.lengths[n];
                ((Entry)entry).lengths[n] = l = file.length();
                this.size = this.size - l2 + l;
                continue;
            }
            DiskLruCache.deleteIfExists((File)object);
        }
        ++this.redundantOpCount;
        entry.currentEditor = null;
        if (entry.readable | bl) {
            entry.readable = true;
            this.journalWriter.write("CLEAN " + entry.key + entry.getLengths() + '\n');
            if (bl) {
                entry.sequenceNumber = this.nextSequenceNumber++;
            }
        } else {
            this.lruEntries.remove(entry.key);
            this.journalWriter.write("REMOVE " + entry.key + '\n');
        }
        this.journalWriter.flush();
        if (this.size > this.maxSize || this.journalRebuildRequired()) {
            this.executorService.submit(this.cleanupCallable);
        }
    }

    private boolean journalRebuildRequired() {
        return this.redundantOpCount >= 2000 && this.redundantOpCount >= this.lruEntries.size();
    }

    public final synchronized boolean remove(String string) {
        this.checkNotClosed();
        this.validateKey(string);
        Entry entry = this.lruEntries.get(string);
        if (entry == null || entry.currentEditor != null) {
            return false;
        }
        for (int i = 0; i < this.valueCount; ++i) {
            File file = entry.getCleanFile(i);
            if (file.exists() && !file.delete()) {
                throw new IOException("failed to delete ".concat(String.valueOf(file)));
            }
            this.size -= entry.lengths[i];
            ((Entry)entry).lengths[i] = 0L;
        }
        ++this.redundantOpCount;
        this.journalWriter.append("REMOVE " + string + '\n');
        this.lruEntries.remove(string);
        if (this.journalRebuildRequired()) {
            this.executorService.submit(this.cleanupCallable);
        }
        return true;
    }

    public final synchronized boolean isClosed() {
        return this.journalWriter == null;
    }

    private void checkNotClosed() {
        if (this.journalWriter == null) {
            throw new IllegalStateException("cache is closed");
        }
    }

    public final synchronized void flush() {
        this.checkNotClosed();
        this.trimToSize();
        this.journalWriter.flush();
    }

    @Override
    public final synchronized void close() {
        if (this.journalWriter == null) {
            return;
        }
        for (Entry entry : new ArrayList<Entry>(this.lruEntries.values())) {
            if (entry.currentEditor == null) continue;
            entry.currentEditor.abort();
        }
        this.trimToSize();
        this.journalWriter.close();
        this.journalWriter = null;
    }

    private void trimToSize() {
        while (this.size > this.maxSize) {
            Map.Entry<String, Entry> entry = this.lruEntries.entrySet().iterator().next();
            this.remove(entry.getKey());
        }
    }

    public final void delete() {
        this.close();
        DiskLruCacheUtil.deleteContents(this.directory);
    }

    private void validateKey(String string) {
        if (!LEGAL_KEY_PATTERN.matcher(string).matches()) {
            throw new IllegalArgumentException("keys must match regex [a-z0-9_-]{1,64}: \"" + string + "\"");
        }
    }

    private static String inputStreamToString(InputStream inputStream) {
        return DiskLruCacheUtil.readFully(new InputStreamReader(inputStream, DiskLruCacheUtil.UTF_8));
    }

    final class Entry {
        private final String key;
        private final long[] lengths;
        private boolean readable;
        private Editor currentEditor;
        private long sequenceNumber;

        private Entry(String string) {
            this.key = string;
            this.lengths = new long[DiskLruCache.this.valueCount];
        }

        public final String getLengths() {
            StringBuilder stringBuilder = new StringBuilder();
            long[] lArray = this.lengths;
            int n = this.lengths.length;
            for (int i = 0; i < n; ++i) {
                long l = lArray[i];
                stringBuilder.append(' ').append(l);
            }
            return stringBuilder.toString();
        }

        private void setLengths(String[] stringArray) {
            if (stringArray.length != DiskLruCache.this.valueCount) {
                throw this.invalidLengths(stringArray);
            }
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.lengths[i] = Long.parseLong(stringArray[i]);
                }
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidLengths(stringArray);
            }
        }

        private IOException invalidLengths(String[] stringArray) {
            throw new IOException("unexpected journal line: " + Arrays.toString(stringArray));
        }

        public final File getCleanFile(int n) {
            return new File(DiskLruCache.this.directory, this.key + "." + n);
        }

        public final File getDirtyFile(int n) {
            return new File(DiskLruCache.this.directory, this.key + "." + n + ".tmp");
        }
    }

    public final class Editor {
        private final Entry entry;
        private final boolean[] written;
        private boolean hasErrors;
        private boolean committed;

        private Editor(Entry entry) {
            this.entry = entry;
            this.written = entry.readable ? null : new boolean[DiskLruCache.this.valueCount];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final InputStream newInputStream(int n) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                if (this.entry.currentEditor != this) {
                    throw new IllegalStateException();
                }
                if (!this.entry.readable) {
                    return null;
                }
                try {
                    return new FileInputStream(this.entry.getCleanFile(n));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        }

        public final String getString(int n) {
            InputStream inputStream = this.newInputStream(n);
            if (inputStream != null) {
                return DiskLruCache.inputStreamToString(inputStream);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final OutputStream newOutputStream(int n) {
            DiskLruCache diskLruCache = DiskLruCache.this;
            synchronized (diskLruCache) {
                FileOutputStream fileOutputStream;
                if (this.entry.currentEditor != this) {
                    throw new IllegalStateException();
                }
                if (!this.entry.readable) {
                    this.written[n] = true;
                }
                File file = this.entry.getDirtyFile(n);
                try {
                    fileOutputStream = new FileOutputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    DiskLruCache.this.directory.mkdirs();
                    try {
                        fileOutputStream = new FileOutputStream(file);
                    }
                    catch (FileNotFoundException fileNotFoundException2) {
                        return NULL_OUTPUT_STREAM;
                    }
                }
                return new FaultHidingOutputStream(fileOutputStream);
            }
        }

        public final void set(int n, String string) {
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter(this.newOutputStream(n), DiskLruCacheUtil.UTF_8);
                outputStreamWriter.write(string);
            }
            catch (Throwable throwable) {
                DiskLruCacheUtil.closeQuietly(outputStreamWriter);
                throw throwable;
            }
            DiskLruCacheUtil.closeQuietly(outputStreamWriter);
        }

        public final void commit() {
            if (this.hasErrors) {
                DiskLruCache.this.completeEdit(this, false);
                DiskLruCache.this.remove(this.entry.key);
            } else {
                DiskLruCache.this.completeEdit(this, true);
            }
            this.committed = true;
        }

        public final void abort() {
            DiskLruCache.this.completeEdit(this, false);
        }

        public final void abortUnlessCommitted() {
            if (!this.committed) {
                try {
                    this.abort();
                    return;
                }
                catch (IOException iOException) {}
            }
        }

        class FaultHidingOutputStream
        extends FilterOutputStream {
            private FaultHidingOutputStream(OutputStream outputStream) {
                super(outputStream);
            }

            @Override
            public void write(int n) {
                try {
                    this.out.write(n);
                    return;
                }
                catch (IOException iOException) {
                    Editor.this.hasErrors = true;
                    return;
                }
            }

            @Override
            public void write(byte[] byArray, int n, int n2) {
                try {
                    this.out.write(byArray, n, n2);
                    return;
                }
                catch (IOException iOException) {
                    Editor.this.hasErrors = true;
                    return;
                }
            }

            @Override
            public void close() {
                try {
                    this.out.close();
                    return;
                }
                catch (IOException iOException) {
                    Editor.this.hasErrors = true;
                    return;
                }
            }

            @Override
            public void flush() {
                try {
                    this.out.flush();
                    return;
                }
                catch (IOException iOException) {
                    Editor.this.hasErrors = true;
                    return;
                }
            }
        }
    }

    public final class Snapshot
    implements Closeable {
        private final String key;
        private final long sequenceNumber;
        private final InputStream[] ins;
        private final long[] lengths;

        private Snapshot(String string, long l, InputStream[] inputStreamArray, long[] lArray) {
            this.key = string;
            this.sequenceNumber = l;
            this.ins = inputStreamArray;
            this.lengths = lArray;
        }

        public final Editor edit() {
            return DiskLruCache.this.edit(this.key, this.sequenceNumber);
        }

        public final InputStream getInputStream(int n) {
            return this.ins[n];
        }

        public final String getString(int n) {
            return DiskLruCache.inputStreamToString(this.getInputStream(n));
        }

        public final long getLength(int n) {
            return this.lengths[n];
        }

        @Override
        public final void close() {
            InputStream[] inputStreamArray = this.ins;
            int n = this.ins.length;
            for (int i = 0; i < n; ++i) {
                DiskLruCacheUtil.closeQuietly(inputStreamArray[i]);
            }
        }
    }
}

