/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import com.tradplus.ads.common.DiskLruCacheUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

class DiskLruCacheStrictLineReader
implements Closeable {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private final InputStream in;
    private final Charset charset;
    private byte[] buf;
    private int pos;
    private int end;

    public DiskLruCacheStrictLineReader(InputStream inputStream, Charset charset) {
        this(inputStream, 8192, charset);
    }

    public DiskLruCacheStrictLineReader(InputStream inputStream, int n, Charset charset) {
        if (inputStream == null || charset == null) {
            throw new NullPointerException();
        }
        if (n < 0) {
            throw new IllegalArgumentException("capacity <= 0");
        }
        if (!charset.equals(DiskLruCacheUtil.US_ASCII)) {
            throw new IllegalArgumentException("Unsupported encoding");
        }
        this.in = inputStream;
        this.charset = charset;
        this.buf = new byte[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            if (this.buf != null) {
                this.buf = null;
                this.in.close();
            }
            return;
        }
    }

    public String readLine() {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            if (this.buf == null) {
                throw new IOException("LineReader is closed");
            }
            if (this.pos >= this.end) {
                this.fillBuf();
            }
            for (int i = this.pos; i != this.end; ++i) {
                if (this.buf[i] != 10) continue;
                int n = i != this.pos && this.buf[i - 1] == 13 ? i - 1 : i;
                String string = new String(this.buf, this.pos, n - this.pos, this.charset.name());
                this.pos = i + 1;
                return string;
            }
            DiskLruCacheStrictLineReader diskLruCacheStrictLineReader = this;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(diskLruCacheStrictLineReader.end - this.pos + 80){

                @Override
                public String toString() {
                    int n = this.count > 0 && this.buf[this.count - 1] == 13 ? this.count - 1 : this.count;
                    try {
                        return new String(this.buf, 0, n, DiskLruCacheStrictLineReader.this.charset.name());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new AssertionError((Object)unsupportedEncodingException);
                    }
                }
            };
            block4: while (true) {
                byteArrayOutputStream.write(this.buf, this.pos, this.end - this.pos);
                this.end = -1;
                this.fillBuf();
                int n = this.pos;
                while (true) {
                    if (n == this.end) continue block4;
                    if (this.buf[n] == 10) {
                        if (n != this.pos) {
                            byteArrayOutputStream.write(this.buf, this.pos, n - this.pos);
                        }
                        this.pos = n + 1;
                        return byteArrayOutputStream.toString();
                    }
                    ++n;
                }
                break;
            }
        }
    }

    private void fillBuf() {
        int n = this.in.read(this.buf, 0, this.buf.length);
        if (n == -1) {
            throw new EOFException();
        }
        this.pos = 0;
        this.end = n;
    }
}

