/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.os.SystemClock;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.common.util.LogUtil;

public class DoubleTimeTracker {
    private volatile State state;
    private long startedTimestamp;
    private long interval;
    private final Clock mClock;

    public DoubleTimeTracker() {
        this(new SystemClockClock());
    }

    @VisibleForTesting
    public DoubleTimeTracker(Clock clock) {
        this.mClock = clock;
        this.state = State.PAUSED;
    }

    public synchronized void start() {
        if (this.state == State.STARTED) {
            LogUtil.show("DoubleTimeTracker already started.");
            return;
        }
        this.state = State.STARTED;
        this.startedTimestamp = this.mClock.elapsedRealTime();
    }

    public synchronized void pause() {
        if (this.state == State.PAUSED) {
            LogUtil.show("DoubleTimeTracker already paused.");
            return;
        }
        this.interval += this.computeIntervalDiff();
        this.startedTimestamp = 0L;
        this.state = State.PAUSED;
    }

    public synchronized double getInterval() {
        return this.interval + this.computeIntervalDiff();
    }

    private synchronized long computeIntervalDiff() {
        if (this.state == State.PAUSED) {
            return 0L;
        }
        return this.mClock.elapsedRealTime() - this.startedTimestamp;
    }

    static class SystemClockClock
    implements Clock {
        private SystemClockClock() {
        }

        @Override
        public long elapsedRealTime() {
            return SystemClock.elapsedRealtime();
        }
    }

    static enum State {
        STARTED,
        PAUSED;

    }

    public static interface Clock {
        public long elapsedRealTime();
    }
}

