/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import com.tradplus.ads.common.util.ResponseHeader;
import com.tradplus.ads.common.util.Streams;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

public class DownloadResponse {
    private byte[] mBytes = new byte[0];
    private final int mStatusCode;
    private final long mContentLength;
    private final Header[] mHeaders;

    public DownloadResponse(HttpResponse httpResponse) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedInputStream bufferedInputStream = null;
        try {
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                bufferedInputStream = new BufferedInputStream(httpEntity.getContent());
                Streams.copyContent(bufferedInputStream, byteArrayOutputStream);
                this.mBytes = byteArrayOutputStream.toByteArray();
            }
        }
        finally {
            Streams.closeStream(bufferedInputStream);
            Streams.closeStream(byteArrayOutputStream);
        }
        this.mStatusCode = httpResponse.getStatusLine().getStatusCode();
        this.mContentLength = this.mBytes.length;
        this.mHeaders = httpResponse.getAllHeaders();
    }

    public byte[] getByteArray() {
        return this.mBytes;
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    public long getContentLength() {
        return this.mContentLength;
    }

    public String getFirstHeader(ResponseHeader responseHeader) {
        Header[] headerArray = this.mHeaders;
        int n = this.mHeaders.length;
        for (int i = 0; i < n; ++i) {
            Header header = headerArray[i];
            if (!header.getName().equalsIgnoreCase(responseHeader.getKey())) continue;
            return header.getValue();
        }
        return null;
    }
}

