/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.util.Log;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.LogUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;

public class JSONHelper {
    private static String TAG = "JSONHelper";

    public static String toJSON(Object object) {
        return JSON.toJSONString(object);
    }

    public static String obj2Json(Object object) {
        if (object == null) {
            return null;
        }
        return JSON.toJSONString(object);
    }

    private static boolean isBasicType(Object object) {
        if (object.getClass() == Integer.TYPE || object instanceof Integer) {
            return true;
        }
        if (object.getClass() == Long.TYPE || object instanceof Long) {
            return true;
        }
        if (object.getClass() == Short.TYPE || object instanceof Short) {
            return true;
        }
        if (object.getClass() == Byte.TYPE || object instanceof Byte) {
            return true;
        }
        if (object.getClass() == Boolean.TYPE || object instanceof Boolean) {
            return true;
        }
        if (object.getClass() == Double.TYPE || object instanceof Double) {
            return true;
        }
        if (object.getClass() == Float.TYPE || object instanceof Float) {
            return true;
        }
        if (object.getClass() == Character.TYPE || object instanceof Character) {
            return true;
        }
        return object instanceof String;
    }

    private static void serialize(JSONStringer jSONStringer, Object object) {
        if (JSONHelper.isNull(object)) {
            try {
                jSONStringer.value(null);
                return;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                return;
            }
        }
        Class<?> clazz = object.getClass();
        if (JSONHelper.isObject(clazz)) {
            JSONHelper.serializeObject(jSONStringer, object);
            return;
        }
        if (JSONHelper.isArray(clazz)) {
            JSONHelper.serializeArray(jSONStringer, object);
            return;
        }
        if (JSONHelper.isCollection(clazz)) {
            object = (Collection)object;
            JSONHelper.serializeCollect(jSONStringer, object);
            return;
        }
        if (JSONHelper.isMap(clazz)) {
            object = (HashMap)object;
            JSONHelper.serializeMap(jSONStringer, object);
            return;
        }
        try {
            jSONStringer.value(object);
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return;
        }
    }

    private static void serializeArray(JSONStringer jSONStringer, Object object) {
        try {
            jSONStringer.array();
            for (int i = 0; i < Array.getLength(object); ++i) {
                Object object2 = Array.get(object, i);
                JSONHelper.serialize(jSONStringer, object2);
            }
            jSONStringer.endArray();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private static void serializeCollect(JSONStringer jSONStringer, Collection<?> object) {
        try {
            jSONStringer.array();
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                JSONHelper.serialize(jSONStringer, e);
            }
            jSONStringer.endArray();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private static void serializeMap(JSONStringer jSONStringer, Map<?, ?> object) {
        try {
            jSONStringer.object();
            for (Map.Entry entry : object.entrySet()) {
                jSONStringer.key((String)entry.getKey());
                JSONHelper.serialize(jSONStringer, entry.getValue());
            }
            jSONStringer.endObject();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private static void serializeObject(JSONStringer jSONStringer, Object object) {
        try {
            jSONStringer.object();
            Class<?> clazz = object.getClass();
            Method[] methodArray = clazz.getDeclaredMethods();
            for (Field field : clazz.getDeclaredFields()) {
                try {
                    String string = field.getType().getSimpleName();
                    Object object2 = JSONHelper.parseMethodName(field.getName(), "get");
                    if (!JSONHelper.haveMethod(methodArray, (String)object2)) continue;
                    object2 = clazz.getMethod((String)object2, new Class[0]).invoke(object, new Object[0]);
                    String string2 = null;
                    if ("Date".equals(string)) {
                        string2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US).format((Date)object2);
                    } else if (object2 != null) {
                        string2 = String.valueOf(object2);
                    }
                    jSONStringer.key(field.getName());
                    JSONHelper.serialize(jSONStringer, string2);
                }
                catch (Exception exception) {}
            }
            jSONStringer.endObject();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static boolean haveMethod(Method[] methodArray, String string) {
        for (Method method : methodArray) {
            if (!string.equals(method.getName())) continue;
            return true;
        }
        return false;
    }

    public static String parseMethodName(String string, String string2) {
        if (string == null || "".equals(string)) {
            return null;
        }
        return string2 + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    public static void setFieldValue(Object object, Map<String, String> map) {
        Class<?> clazz = object.getClass();
        Method[] methodArray = clazz.getDeclaredMethods();
        for (Field field : clazz.getDeclaredFields()) {
            try {
                Object object2 = JSONHelper.parseMethodName(field.getName(), "set");
                if (!JSONHelper.haveMethod(methodArray, (String)object2)) continue;
                object2 = clazz.getMethod((String)object2, field.getType());
                String string = map.get(field.getName());
                if (string == null || "".equals(string)) continue;
                String string2 = field.getType().getSimpleName();
                if ("String".equals(string2)) {
                    ((Method)object2).invoke(object, string);
                    continue;
                }
                if ("Date".equals(string2)) {
                    Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US).parse(string);
                    ((Method)object2).invoke(object, date);
                    continue;
                }
                if ("Integer".equals(string2) || "int".equals(string2)) {
                    Integer n = Integer.parseInt(string);
                    ((Method)object2).invoke(object, n);
                    continue;
                }
                if ("Long".equalsIgnoreCase(string2)) {
                    Long l = Long.parseLong(string);
                    ((Method)object2).invoke(object, l);
                    continue;
                }
                if ("Double".equalsIgnoreCase(string2)) {
                    Double d = Double.parseDouble(string);
                    ((Method)object2).invoke(object, d);
                    continue;
                }
                if (!"Boolean".equalsIgnoreCase(string2)) continue;
                Boolean bl = Boolean.parseBoolean(string);
                ((Method)object2).invoke(object, bl);
            }
            catch (Exception exception) {}
        }
    }

    public static Map<String, String> beanToMap(Object object) {
        Class<?> clazz = object.getClass();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Method[] methodArray = clazz.getDeclaredMethods();
        for (Field field : clazz.getDeclaredFields()) {
            try {
                String string = field.getType().getSimpleName();
                Object object2 = JSONHelper.parseMethodName(field.getName(), "get");
                if (!JSONHelper.haveMethod(methodArray, (String)object2)) continue;
                object2 = clazz.getMethod((String)object2, new Class[0]).invoke(object, new Object[0]);
                String string2 = null;
                if ("Date".equals(string)) {
                    string2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA).format((Date)object2);
                } else if (object2 != null) {
                    string2 = String.valueOf(object2);
                }
                hashMap.put(field.getName(), string2);
            }
            catch (Exception exception) {}
        }
        return hashMap;
    }

    public static void setFiedlValue(Object object, Method method, String object2, Object object3) {
        try {
            if (object3 != null && !"".equals(object3)) {
                if ("String".equals(object2)) {
                    method.invoke(object, object3.toString());
                    return;
                }
                if ("Date".equals(object2)) {
                    object2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA).parse(object3.toString());
                    method.invoke(object, object2);
                    return;
                }
                if ("Integer".equals(object2) || "int".equals(object2)) {
                    object2 = Integer.parseInt(object3.toString());
                    method.invoke(object, object2);
                    return;
                }
                if ("Long".equalsIgnoreCase((String)object2)) {
                    object2 = Long.parseLong(object3.toString());
                    method.invoke(object, object2);
                    return;
                }
                if ("Double".equalsIgnoreCase((String)object2)) {
                    object2 = Double.parseDouble(object3.toString());
                    method.invoke(object, object2);
                    return;
                }
                if ("Boolean".equalsIgnoreCase((String)object2)) {
                    object2 = Boolean.parseBoolean(object3.toString());
                    method.invoke(object, object2);
                    return;
                }
                method.invoke(object, object3);
                Log.e((String)TAG, (String)(TAG + ">>>>setFiedlValue -> not supper type" + (String)object2));
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static <T> T parseObject(JSONObject jSONObject, Class<T> clazz) {
        if (clazz == null || JSONHelper.isNull(jSONObject)) {
            return null;
        }
        T t = JSONHelper.newInstance(clazz);
        if (t == null) {
            return null;
        }
        if (JSONHelper.isMap(clazz)) {
            JSONHelper.setField(t, jSONObject);
        } else {
            Method[] methodArray = clazz.getDeclaredMethods();
            for (Field field : clazz.getDeclaredFields()) {
                Object object = JSONHelper.parseMethodName(field.getName(), "set");
                LogUtil.ownShow("locale \u8f6c\u6362\u524d = ".concat(String.valueOf(object)));
                object = ((String)object).replace("\u0130", "I");
                LogUtil.ownShow("locale \u8f6c\u6362\u540e = ".concat(String.valueOf(object)));
                if (!JSONHelper.haveMethod(methodArray, (String)object)) continue;
                try {
                    object = clazz.getMethod((String)object, field.getType());
                    JSONHelper.setField(t, (Method)object, field, jSONObject);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return t;
    }

    public static <T> T fromJson(String string, Class<T> clazz) {
        try {
            return JSON.parseObject(string, clazz);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static <T> T parseObject(String string, Class<T> clazz) {
        if (clazz == null || string == null || string.length() == 0) {
            return null;
        }
        if (JSONHelper.isNull(string = new JSONObject(string))) {
            return null;
        }
        return JSONHelper.parseObject((JSONObject)string, clazz);
    }

    public static <T> T[] parseArray(JSONArray jSONArray, Class<T> clazz) {
        if (clazz == null || JSONHelper.isNull(jSONArray)) {
            return null;
        }
        int n = jSONArray.length();
        Object[] objectArray = (Object[])Array.newInstance(clazz, n);
        for (int i = 0; i < n; ++i) {
            try {
                T t = JSONHelper.parseObject(jSONArray.getJSONObject(i), clazz);
                objectArray[i] = t;
                continue;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return objectArray;
    }

    public static <T> T[] parseArray(String string, Class<T> clazz) {
        if (clazz == null || string == null || string.length() == 0) {
            return null;
        }
        JSONArray jSONArray = null;
        try {
            jSONArray = new JSONArray(string);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (JSONHelper.isNull(jSONArray)) {
            return null;
        }
        return JSONHelper.parseArray(jSONArray, clazz);
    }

    public static <T> Collection<T> parseCollection(JSONArray jSONArray, Class<?> object, Class<T> clazz) {
        if (object == null || clazz == null || JSONHelper.isNull(jSONArray)) {
            return null;
        }
        object = (Collection)JSONHelper.newInstance(object);
        for (int i = 0; i < jSONArray.length(); ++i) {
            try {
                T t = JSONHelper.parseObject(jSONArray.getJSONObject(i), clazz);
                object.add(t);
                continue;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return object;
    }

    public static <T> Collection<T> parseCollection(String string, Class<?> clazz, Class<T> clazz2) {
        if (clazz == null || clazz2 == null || string == null || string.length() == 0) {
            return null;
        }
        JSONArray jSONArray = null;
        try {
            int n = string.indexOf("[");
            String string2 = null;
            if (-1 != n) {
                string2 = string.substring(n);
            }
            jSONArray = string2 != null ? new JSONArray(string2) : new JSONArray(string);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (JSONHelper.isNull(jSONArray)) {
            return null;
        }
        return JSONHelper.parseCollection(jSONArray, clazz, clazz2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> T newInstance(Class<T> clazz) {
        void var1_5;
        if (clazz == null) {
            return null;
        }
        if (clazz.isInterface()) {
            if (clazz.equals(Map.class)) {
                HashMap hashMap = new HashMap();
                return var1_5;
            } else if (clazz.equals(List.class)) {
                ArrayList arrayList = new ArrayList();
                return var1_5;
            } else {
                if (!clazz.equals(Set.class)) throw new JSONException("unknown interface: ".concat(String.valueOf(clazz)));
                HashSet hashSet = new HashSet();
            }
            return var1_5;
        }
        try {
            T t = clazz.newInstance();
            return var1_5;
        }
        catch (Exception exception) {
            throw new JSONException("unknown class type: ".concat(String.valueOf(clazz)));
        }
    }

    private static void setField(Object object, JSONObject jSONObject) {
        try {
            Iterator iterator = jSONObject.keys();
            Map map = (Map)object;
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                Object object2 = jSONObject.get((String)object);
                map.put(object, object2);
            }
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return;
        }
    }

    private static void setField(Object object, Method method, Field annotatedElement, JSONObject object2) {
        String string = ((Field)annotatedElement).getName();
        annotatedElement = ((Field)annotatedElement).getType();
        try {
            if (JSONHelper.isSingle(annotatedElement)) {
                if ((object2 = object2.opt(string)) != null) {
                    JSONHelper.setFiedlValue(object, method, ((Class)annotatedElement).getSimpleName(), object2);
                }
                return;
            }
            if ((object2 = object2.optString(string)) != null) {
                JSONHelper.setFiedlValue(object, method, ((Class)annotatedElement).getSimpleName(), object2);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private static void setField(Object object, Field field, JSONObject object2) {
        String string = field.getName();
        Class<?> clazz = field.getType();
        try {
            if (JSONHelper.isSingle(clazz)) {
                if ((object2 = object2.opt(string)) != null) {
                    field.set(object, object2);
                }
                return;
            }
            if ((object2 = object2.optString(string)) != null) {
                field.set(object, object2);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private static boolean isNull(Object object) {
        if (object instanceof JSONObject) {
            return JSONObject.NULL.equals(object);
        }
        return object == null;
    }

    private static boolean isSingle(Class<?> clazz) {
        return JSONHelper.isBoolean(clazz) || JSONHelper.isNumber(clazz) || JSONHelper.isString(clazz);
    }

    public static boolean isBoolean(Class<?> clazz) {
        return clazz != null && (Boolean.TYPE.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz));
    }

    public static boolean isNumber(Class<?> clazz) {
        return clazz != null && (Byte.TYPE.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz));
    }

    public static boolean isString(Class<?> clazz) {
        return clazz != null && (String.class.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz));
    }

    private static boolean isObject(Class<?> clazz) {
        return clazz != null && !JSONHelper.isSingle(clazz) && !JSONHelper.isArray(clazz) && !JSONHelper.isCollection(clazz) && !JSONHelper.isMap(clazz);
    }

    public static boolean isArray(Class<?> clazz) {
        return clazz != null && clazz.isArray();
    }

    public static boolean isCollection(Class<?> clazz) {
        return clazz != null && Collection.class.isAssignableFrom(clazz);
    }

    public static boolean isMap(Class<?> clazz) {
        return clazz != null && Map.class.isAssignableFrom(clazz);
    }

    public static boolean isList(Class<?> clazz) {
        return clazz != null && List.class.isAssignableFrom(clazz);
    }
}

