/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.os.Looper;
import com.tradplus.ads.common.util.LogUtil;
import java.util.IllegalFormatException;

public final class Preconditions {
    public static final String EMPTY_ARGUMENTS = "";

    private Preconditions() {
    }

    public static void checkArgument(boolean bl) {
        Preconditions.checkArgumentInternal(bl, true, "Illegal argument.", EMPTY_ARGUMENTS);
    }

    public static void checkArgument(boolean bl, String string) {
        Preconditions.checkArgumentInternal(bl, true, string, EMPTY_ARGUMENTS);
    }

    public static void checkArgument(boolean bl, String string, Object ... objectArray) {
        Preconditions.checkArgumentInternal(bl, true, string, objectArray);
    }

    public static void checkState(boolean bl) {
        Preconditions.checkStateInternal(bl, true, "Illegal state.", EMPTY_ARGUMENTS);
    }

    public static void checkState(boolean bl, String string) {
        Preconditions.checkStateInternal(bl, true, string, EMPTY_ARGUMENTS);
    }

    public static void checkState(boolean bl, String string, Object ... objectArray) {
        Preconditions.checkStateInternal(bl, true, string, objectArray);
    }

    public static void checkNotNull(Object object) {
        Preconditions.checkNotNullInternal(object, true, "Object can not be null.", EMPTY_ARGUMENTS);
    }

    public static void checkNotNull(Object object, String string) {
        Preconditions.checkNotNullInternal(object, true, string, EMPTY_ARGUMENTS);
    }

    public static void checkNotNull(Object object, String string, Object ... objectArray) {
        Preconditions.checkNotNullInternal(object, true, string, objectArray);
    }

    public static void checkUiThread() {
        Preconditions.checkUiThreadInternal(true, "This method must be called from the UI thread.", EMPTY_ARGUMENTS);
    }

    public static void checkUiThread(String string) {
        Preconditions.checkUiThreadInternal(true, string, EMPTY_ARGUMENTS);
    }

    public static void checkUiThread(String string, Object ... objectArray) {
        Preconditions.checkUiThreadInternal(true, string, objectArray);
    }

    private static boolean checkArgumentInternal(boolean bl, boolean bl2, String string, Object ... objectArray) {
        if (bl) {
            return true;
        }
        String string2 = Preconditions.format(string, objectArray);
        if (bl2) {
            throw new IllegalArgumentException(string2);
        }
        LogUtil.show(string2);
        return false;
    }

    private static boolean checkStateInternal(boolean bl, boolean bl2, String string, Object ... objectArray) {
        if (bl) {
            return true;
        }
        String string2 = Preconditions.format(string, objectArray);
        if (bl2) {
            throw new IllegalStateException(string2);
        }
        LogUtil.show(string2);
        return false;
    }

    private static boolean checkNotNullInternal(Object object, boolean bl, String string, Object ... objectArray) {
        if (object != null) {
            return true;
        }
        object = Preconditions.format(string, objectArray);
        if (bl) {
            throw new NullPointerException((String)object);
        }
        LogUtil.show((String)object);
        return false;
    }

    private static boolean checkUiThreadInternal(boolean bl, String string, Object ... objectArray) {
        if (Looper.getMainLooper().equals(Looper.myLooper())) {
            return true;
        }
        string = Preconditions.format(string, objectArray);
        if (bl) {
            throw new IllegalStateException(string);
        }
        LogUtil.show(string);
        return false;
    }

    private static String format(String string, Object ... objectArray) {
        string = String.valueOf(string);
        try {
            return String.format(string, objectArray);
        }
        catch (IllegalFormatException illegalFormatException) {
            LogUtil.show("TradPlus preconditions had a format exception: " + illegalFormatException.getMessage());
            return string;
        }
    }

    public static final class NoThrow {
        private static volatile boolean sStrictMode = false;

        public static void setStrictMode(boolean bl) {
            sStrictMode = bl;
        }

        public static boolean checkArgument(boolean bl) {
            return Preconditions.checkArgumentInternal(bl, NoThrow.sStrictMode, "Illegal argument", new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkArgument(boolean bl, String string) {
            return Preconditions.checkArgumentInternal(bl, NoThrow.sStrictMode, string, new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkArgument(boolean bl, String string, Object ... objectArray) {
            return Preconditions.checkArgumentInternal(bl, NoThrow.sStrictMode, string, objectArray);
        }

        public static boolean checkState(boolean bl) {
            return Preconditions.checkStateInternal(bl, NoThrow.sStrictMode, "Illegal state.", new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkState(boolean bl, String string) {
            return Preconditions.checkStateInternal(bl, NoThrow.sStrictMode, string, new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkState(boolean bl, String string, Object ... objectArray) {
            return Preconditions.checkStateInternal(bl, NoThrow.sStrictMode, string, objectArray);
        }

        public static boolean checkNotNull(Object object) {
            return Preconditions.checkNotNullInternal(object, NoThrow.sStrictMode, "Object can not be null.", new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkNotNull(Object object, String string) {
            return Preconditions.checkNotNullInternal(object, NoThrow.sStrictMode, string, new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkNotNull(Object object, String string, Object ... objectArray) {
            return Preconditions.checkNotNullInternal(object, NoThrow.sStrictMode, string, objectArray);
        }

        public static boolean checkUiThread() {
            return Preconditions.checkUiThreadInternal(NoThrow.sStrictMode, "This method must be called from the UI thread.", new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkUiThread(String string) {
            return Preconditions.checkUiThreadInternal(NoThrow.sStrictMode, string, new Object[]{Preconditions.EMPTY_ARGUMENTS});
        }

        public static boolean checkUiThread(String string, Object ... objectArray) {
            return Preconditions.checkUiThreadInternal(false, string, objectArray);
        }
    }
}

