/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieSyncManager;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.tradplus.ads.base.util.WebViews;
import com.tradplus.ads.common.BrowserWebViewClient;
import com.tradplus.ads.common.DoubleTimeTracker;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.common.util.Drawables;

public class TPBrowser
extends Activity {
    public static final String DESTINATION_URL_KEY = "URL";
    public static final String DSP_CREATIVE_ID = "tp-dsp-creative-id";
    private static final int INNER_LAYOUT_ID = 1;
    private WebView mWebView;
    private ImageButton mBackButton;
    private ImageButton mForwardButton;
    private ImageButton mRefreshButton;
    private ImageButton mCloseButton;
    private DoubleTimeTracker dwellTimeTracker;
    private String mDspCreativeId;

    public ImageButton getBackButton() {
        return this.mBackButton;
    }

    public ImageButton getCloseButton() {
        return this.mCloseButton;
    }

    public ImageButton getForwardButton() {
        return this.mForwardButton;
    }

    public ImageButton getRefreshButton() {
        return this.mRefreshButton;
    }

    public WebView getWebView() {
        return this.mWebView;
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setResult(-1);
        this.getWindow().requestFeature(2);
        this.getWindow().setFeatureInt(2, -1);
        this.dwellTimeTracker = new DoubleTimeTracker();
        this.initializeWebView();
        this.initializeButtons();
        this.enableCookies();
    }

    private void initializeWebView() {
        WebSettings webSettings = this.mWebView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSavePassword(false);
        webSettings.setSupportZoom(true);
        webSettings.setBuiltInZoomControls(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setAllowFileAccessFromFileURLs(false);
        webSettings.setAllowFileAccess(false);
        webSettings.setSavePassword(false);
        this.mDspCreativeId = this.getIntent().getStringExtra(DSP_CREATIVE_ID);
        this.mWebView.removeJavascriptInterface("searchBoxJavaBridge_");
        this.mWebView.removeJavascriptInterface("accessibility");
        this.mWebView.removeJavascriptInterface("accessibilityTraversal");
        this.mWebView.loadUrl(this.getIntent().getStringExtra(DESTINATION_URL_KEY));
        this.mWebView.setWebViewClient((WebViewClient)new BrowserWebViewClient(this));
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onProgressChanged(WebView webView, int n) {
                TPBrowser.this.setTitle("Loading...");
                TPBrowser.this.setProgress(n * 100);
                if (n == 100) {
                    TPBrowser.this.setTitle(webView.getUrl());
                }
            }
        });
    }

    private void initializeButtons() {
        this.mBackButton.setBackgroundColor(0);
        this.mBackButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TPBrowser.this.mWebView.canGoBack()) {
                    TPBrowser.this.mWebView.goBack();
                }
            }
        });
        this.mForwardButton.setBackgroundColor(0);
        this.mForwardButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TPBrowser.this.mWebView.canGoForward()) {
                    TPBrowser.this.mWebView.goForward();
                }
            }
        });
        this.mRefreshButton.setBackgroundColor(0);
        this.mRefreshButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TPBrowser.this.mWebView.reload();
            }
        });
        this.mCloseButton.setBackgroundColor(0);
        this.mCloseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TPBrowser.this.finish();
            }
        });
    }

    private void enableCookies() {
        CookieSyncManager.createInstance((Context)this);
        CookieSyncManager.getInstance().startSync();
    }

    protected void onPause() {
        super.onPause();
        CookieSyncManager.getInstance().stopSync();
        WebViews.onPause(this.mWebView, this.isFinishing());
        this.dwellTimeTracker.pause();
    }

    protected void onResume() {
        super.onResume();
        CookieSyncManager.getInstance().startSync();
        WebViews.onResume(this.mWebView);
        this.dwellTimeTracker.start();
    }

    public void finish() {
        ((ViewGroup)this.getWindow().getDecorView()).removeAllViews();
        super.finish();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mWebView.destroy();
        this.mWebView = null;
    }

    private View getTPBrowserView() {
        LinearLayout linearLayout = new LinearLayout((Context)this);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        linearLayout.setOrientation(1);
        layoutParams = new RelativeLayout((Context)this);
        LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(-1, -2);
        layoutParams.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        linearLayout.addView((View)layoutParams);
        layoutParams2 = new LinearLayout((Context)this);
        layoutParams2.setId(1);
        RelativeLayout.LayoutParams layoutParams3 = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams3.addRule(12);
        layoutParams2.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
        layoutParams2.setBackgroundDrawable(Drawables.BACKGROUND.createDrawable((Context)this));
        layoutParams.addView((View)layoutParams2);
        this.mBackButton = this.getButton(Drawables.LEFT_ARROW.createDrawable((Context)this));
        this.mForwardButton = this.getButton(Drawables.RIGHT_ARROW.createDrawable((Context)this));
        this.mRefreshButton = this.getButton(Drawables.REFRESH.createDrawable((Context)this));
        this.mCloseButton = this.getButton(Drawables.CLOSE.createDrawable((Context)this));
        layoutParams2.addView((View)this.mBackButton);
        layoutParams2.addView((View)this.mForwardButton);
        layoutParams2.addView((View)this.mRefreshButton);
        layoutParams2.addView((View)this.mCloseButton);
        layoutParams2 = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams2.addRule(2, 1);
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        layoutParams.addView((View)this.mWebView);
        return linearLayout;
    }

    private ImageButton getButton(Drawable drawable) {
        ImageButton imageButton = new ImageButton((Context)this);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2, 1.0f);
        new LinearLayout.LayoutParams(-2, -2, 1.0f).gravity = 16;
        imageButton.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        imageButton.setImageDrawable(drawable);
        return imageButton;
    }

    @Deprecated
    @VisibleForTesting
    void setWebView(WebView webView) {
        this.mWebView = webView;
    }
}

