/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.tradplus.ads.base.network.TrackingRequest;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.UrlHandler;
import com.tradplus.ads.common.event.BaseEvent;
import com.tradplus.ads.common.util.Intents;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.exceptions.IntentNotResolvableException;
import com.tradplus.ads.exceptions.UrlParseException;
import java.net.URISyntaxException;
import java.util.List;

public enum UrlAction {
    HANDLE_TP_SCHEME(false){

        @Override
        public final boolean shouldTryHandlingUrl(Uri uri) {
            return "tp".equalsIgnoreCase(uri.getScheme());
        }

        @Override
        protected final void performAction(Context object, Uri uri, UrlHandler object2, String string) {
            object = uri.getHost();
            object2 = ((UrlHandler)object2).getTPSchemeListener();
            if ("finishLoad".equalsIgnoreCase((String)object)) {
                object2.onFinishLoad();
                return;
            }
            if ("close".equalsIgnoreCase((String)object)) {
                object2.onClose();
                return;
            }
            if ("failLoad".equalsIgnoreCase((String)object)) {
                object2.onFailLoad();
                return;
            }
            throw new IntentNotResolvableException("Could not handle TradPlus Scheme url: ".concat(String.valueOf(uri)));
        }
    }
    ,
    IGNORE_ABOUT_SCHEME(false){

        @Override
        public final boolean shouldTryHandlingUrl(Uri uri) {
            return "about".equalsIgnoreCase(uri.getScheme());
        }

        @Override
        protected final void performAction(Context context, Uri uri, UrlHandler urlHandler, String string) {
            LogUtil.show("Link to about page ignored.");
        }
    }
    ,
    HANDLE_PHONE_SCHEME(true){

        @Override
        public final boolean shouldTryHandlingUrl(Uri object) {
            return "tel".equalsIgnoreCase((String)(object = object.getScheme())) || "voicemail".equalsIgnoreCase((String)object) || "sms".equalsIgnoreCase((String)object) || "mailto".equalsIgnoreCase((String)object) || "geo".equalsIgnoreCase((String)object) || "google.streetview".equalsIgnoreCase((String)object);
        }

        @Override
        protected final void performAction(Context context, Uri uri, UrlHandler object, String string) {
            object = "Could not handle intent with URI: " + uri + "\n\tIs this intent supported on your phone?";
            Intents.launchActionViewIntent(context, uri, (String)object);
        }
    }
    ,
    OPEN_NATIVE_BROWSER(true){

        @Override
        public final boolean shouldTryHandlingUrl(Uri uri) {
            return "tpnativebrowser".equalsIgnoreCase(uri.getScheme());
        }

        @Override
        protected final void performAction(Context context, Uri uri, UrlHandler object, String string) {
            object = "Unable to load tp native browser url: ".concat(String.valueOf(uri));
            try {
                uri = Intents.intentForNativeBrowserScheme(uri);
                Intents.launchIntentForUserClick(context, (Intent)uri, (String)object);
                return;
            }
            catch (UrlParseException urlParseException) {
                throw new IntentNotResolvableException((String)object + "\n\t" + urlParseException.getMessage());
            }
        }
    }
    ,
    OPEN_APP_MARKET(true){

        @Override
        public final boolean shouldTryHandlingUrl(Uri uri) {
            String string = uri.getScheme();
            String string2 = uri.getHost();
            return "play.google.com".equalsIgnoreCase(string2) || "market.android.com".equalsIgnoreCase(string2) || "market".equalsIgnoreCase(string) || uri.toString().toLowerCase().startsWith("play.google.com/") || uri.toString().toLowerCase().startsWith("market.android.com/");
        }

        @Override
        protected final void performAction(Context context, Uri uri, UrlHandler urlHandler, String string) {
            Intents.launchApplicationUrl(context, uri);
        }
    }
    ,
    OPEN_IN_APP_BROWSER(true){

        @Override
        public final boolean shouldTryHandlingUrl(Uri object) {
            return "http".equalsIgnoreCase((String)(object = object.getScheme())) || "https".equalsIgnoreCase((String)object);
        }

        @Override
        protected final void performAction(Context context, Uri uri, UrlHandler urlHandler, String string) {
            if (!urlHandler.shouldskipShowTpBrowser()) {
                Intents.showTPBrowserForUrl(context, uri, string);
            }
        }
    }
    ,
    HANDLE_SHARE_TWEET(true){

        @Override
        public final boolean shouldTryHandlingUrl(Uri uri) {
            Preconditions.checkNotNull(uri);
            return "tpshare".equalsIgnoreCase(uri.getScheme()) && "tweet".equalsIgnoreCase(uri.getHost());
        }

        @Override
        protected final void performAction(Context context, Uri uri, UrlHandler object, String string) {
            Preconditions.checkNotNull(context);
            Preconditions.checkNotNull(uri);
            object = "Could not handle share tweet intent with URI ".concat(String.valueOf(uri));
            try {
                uri = Intent.createChooser((Intent)Intents.intentForShareTweet(uri), (CharSequence)"Share via");
                Intents.launchIntentForUserClick(context, (Intent)uri, (String)object);
                return;
            }
            catch (UrlParseException urlParseException) {
                throw new IntentNotResolvableException((String)object + "\n\t" + urlParseException.getMessage());
            }
        }
    }
    ,
    FOLLOW_DEEP_LINK_WITH_FALLBACK(true){

        @Override
        public final boolean shouldTryHandlingUrl(Uri uri) {
            return "deeplink+".equalsIgnoreCase(uri.getScheme());
        }

        @Override
        protected final void performAction(Context context, Uri object, UrlHandler urlHandler, String string) {
            String string2;
            List list;
            if (!"navigate".equalsIgnoreCase(object.getHost())) {
                throw new IntentNotResolvableException("Deeplink+ URL did not have 'navigate' as the host.");
            }
            try {
                string = object.getQueryParameter("primaryUrl");
                list = object.getQueryParameters("primaryTrackingUrl");
                string2 = object.getQueryParameter("fallbackUrl");
                object = object.getQueryParameters("fallbackTrackingUrl");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw new IntentNotResolvableException("Deeplink+ URL was not a hierarchical URI.");
            }
            if (string == null) {
                throw new IntentNotResolvableException("Deeplink+ did not have 'primaryUrl' query param.");
            }
            if (this.shouldTryHandlingUrl((Uri)(string = Uri.parse((String)string)))) {
                throw new IntentNotResolvableException("Deeplink+ had another Deeplink+ as the 'primaryUrl'.");
            }
            try {
                Intents.launchApplicationUrl(context, (Uri)string);
                TrackingRequest.makeTrackingHttpRequest(list, context, BaseEvent.Name.CLICK_REQUEST);
                return;
            }
            catch (IntentNotResolvableException intentNotResolvableException) {
                if (string2 == null) {
                    throw new IntentNotResolvableException("Unable to handle 'primaryUrl' for Deeplink+ and 'fallbackUrl' was missing.");
                }
                if (this.shouldTryHandlingUrl(Uri.parse((String)string2))) {
                    throw new IntentNotResolvableException("Deeplink+ URL had another Deeplink+ URL as the 'fallbackUrl'.");
                }
                urlHandler.handleUrl(context, string2, true, (Iterable<String>)object);
                return;
            }
        }
    }
    ,
    FOLLOW_DEEP_LINK(true){

        @Override
        public final boolean shouldTryHandlingUrl(Uri uri) {
            return !TextUtils.isEmpty((CharSequence)uri.getScheme());
        }

        @Override
        protected final void performAction(Context context, Uri uri, UrlHandler urlHandler, String string) {
            if ("intent".equalsIgnoreCase(uri.getScheme())) {
                try {
                    urlHandler = Intent.parseUri((String)uri.toString(), (int)1);
                    urlHandler.addCategory("android.intent.category.BROWSABLE");
                    urlHandler.setComponent(null);
                    if (Build.VERSION.SDK_INT >= 15) {
                        urlHandler.setSelector(null);
                    }
                    Intents.launchApplicationIntent(context, (Intent)urlHandler);
                    return;
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IntentNotResolvableException("Intent uri had invalid syntax: " + uri.toString());
                }
            }
            Intents.launchApplicationUrl(context, uri);
        }
    }
    ,
    NOOP(false){

        @Override
        public final boolean shouldTryHandlingUrl(Uri uri) {
            return false;
        }

        @Override
        protected final void performAction(Context context, Uri uri, UrlHandler urlHandler, String string) {
        }
    };

    private final boolean mRequiresUserInteraction;

    public void handleUrl(UrlHandler urlHandler, Context context, Uri uri, boolean bl, String string) {
        LogUtil.show("Ad event URL: ".concat(String.valueOf(uri)));
        if (this.mRequiresUserInteraction && !bl) {
            throw new IntentNotResolvableException("Attempted to handle action without user interaction.");
        }
        this.performAction(context, uri, urlHandler, string);
    }

    private UrlAction(boolean bl) {
        this.mRequiresUserInteraction = bl;
    }

    public abstract boolean shouldTryHandlingUrl(Uri var1);

    protected abstract void performAction(Context var1, Uri var2, UrlHandler var3, String var4);
}

