/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.tradplus.ads.base.network.TrackingRequest;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.UrlAction;
import com.tradplus.ads.common.UrlResolutionTask;
import com.tradplus.ads.common.event.BaseEvent;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.exceptions.IntentNotResolvableException;
import java.util.EnumSet;

public class UrlHandler {
    private static final ResultActions EMPTY_CLICK_LISTENER = new ResultActions(){

        @Override
        public void urlHandlingSucceeded(String string, UrlAction urlAction) {
        }

        @Override
        public void urlHandlingFailed(String string, UrlAction urlAction) {
        }
    };
    private static final TPSchemeListener EMPTY_MOPUB_SCHEME_LISTENER = new TPSchemeListener(){

        @Override
        public void onFinishLoad() {
        }

        @Override
        public void onClose() {
        }

        @Override
        public void onFailLoad() {
        }
    };
    private EnumSet<UrlAction> mSupportedUrlActions;
    private ResultActions mResultActions;
    private TPSchemeListener mTPSchemeListener;
    private String mDspCreativeId;
    private boolean mskipShowTpBrowser;
    private boolean mAlreadySucceeded;
    private boolean mTaskPending;

    private UrlHandler(EnumSet<UrlAction> enumSet, ResultActions resultActions, TPSchemeListener tPSchemeListener, boolean bl, String string) {
        this.mSupportedUrlActions = EnumSet.copyOf(enumSet);
        this.mResultActions = resultActions;
        this.mTPSchemeListener = tPSchemeListener;
        this.mskipShowTpBrowser = bl;
        this.mDspCreativeId = string;
        this.mAlreadySucceeded = false;
        this.mTaskPending = false;
    }

    EnumSet<UrlAction> getSupportedUrlActions() {
        return EnumSet.copyOf(this.mSupportedUrlActions);
    }

    ResultActions getResultActions() {
        return this.mResultActions;
    }

    TPSchemeListener getTPSchemeListener() {
        return this.mTPSchemeListener;
    }

    boolean shouldskipShowTpBrowser() {
        return this.mskipShowTpBrowser;
    }

    public void handleUrl(Context context, String string) {
        Preconditions.checkNotNull(context);
        this.handleUrl(context, string, true);
    }

    public void handleUrl(Context context, String string, boolean bl) {
        Preconditions.checkNotNull(context);
        this.handleUrl(context, string, bl, null);
    }

    public void handleUrl(Context object, String string, boolean bl, Iterable<String> iterable) {
        Preconditions.checkNotNull(object);
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.failUrlHandling(string, null, "Attempted to handle empty url.", null);
            return;
        }
        object = new UrlResolutionTask.UrlResolutionListener((Context)object, bl, iterable, string){
            final /* synthetic */ Context val$context;
            final /* synthetic */ boolean val$fromUserInteraction;
            final /* synthetic */ Iterable val$trackingUrls;
            final /* synthetic */ String val$destinationUrl;
            {
                this.val$context = context;
                this.val$fromUserInteraction = bl;
                this.val$trackingUrls = iterable;
                this.val$destinationUrl = string;
            }

            @Override
            public void onSuccess(String string) {
                UrlHandler.this.mTaskPending = false;
                UrlHandler.this.handleResolvedUrl(this.val$context, string, this.val$fromUserInteraction, this.val$trackingUrls);
            }

            @Override
            public void onFailure(String string, Throwable throwable) {
                UrlHandler.this.mTaskPending = false;
                UrlHandler.this.failUrlHandling(this.val$destinationUrl, null, string, throwable);
            }
        };
        UrlResolutionTask.getResolvedUrl(string, (UrlResolutionTask.UrlResolutionListener)object);
        this.mTaskPending = true;
    }

    public boolean handleResolvedUrl(Context context, String string, boolean bl, Iterable<String> iterable) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.failUrlHandling(string, null, "Attempted to handle empty url.", null);
            return false;
        }
        Object object = UrlAction.NOOP;
        Uri uri = Uri.parse((String)string);
        for (UrlAction urlAction : this.mSupportedUrlActions) {
            if (!urlAction.shouldTryHandlingUrl(uri)) continue;
            try {
                urlAction.handleUrl(this, context, uri, bl, this.mDspCreativeId);
                if (!(this.mAlreadySucceeded || this.mTaskPending || UrlAction.IGNORE_ABOUT_SCHEME.equals((Object)urlAction) || UrlAction.HANDLE_TP_SCHEME.equals((Object)urlAction))) {
                    TrackingRequest.makeTrackingHttpRequest(iterable, context, BaseEvent.Name.CLICK_REQUEST);
                    this.mResultActions.urlHandlingSucceeded(uri.toString(), urlAction);
                    this.mAlreadySucceeded = true;
                }
                return true;
            }
            catch (IntentNotResolvableException intentNotResolvableException) {
                object = intentNotResolvableException;
                LogUtil.show(intentNotResolvableException.getMessage(), object);
                object = urlAction;
            }
        }
        this.failUrlHandling(string, (UrlAction)((Object)object), "Link ignored. Unable to handle url: ".concat(String.valueOf(string)), null);
        return false;
    }

    private void failUrlHandling(String string, UrlAction urlAction, String string2, Throwable throwable) {
        Preconditions.checkNotNull(string2);
        if (urlAction == null) {
            urlAction = UrlAction.NOOP;
        }
        LogUtil.show(string2, throwable);
        this.mResultActions.urlHandlingFailed(string, urlAction);
    }

    static /* synthetic */ ResultActions access$000() {
        return EMPTY_CLICK_LISTENER;
    }

    static /* synthetic */ TPSchemeListener access$100() {
        return EMPTY_MOPUB_SCHEME_LISTENER;
    }

    public static class Builder {
        private EnumSet<UrlAction> supportedUrlActions = EnumSet.of(UrlAction.NOOP);
        private ResultActions resultActions = UrlHandler.access$000();
        private TPSchemeListener TPSchemeListener = UrlHandler.access$100();
        private boolean skipShowTpBrowser = false;
        private String creativeId;

        public Builder withSupportedUrlActions(UrlAction urlAction, UrlAction ... urlActionArray) {
            this.supportedUrlActions = EnumSet.of(urlAction, urlActionArray);
            return this;
        }

        public Builder withSupportedUrlActions(EnumSet<UrlAction> enumSet) {
            this.supportedUrlActions = EnumSet.copyOf(enumSet);
            return this;
        }

        public Builder withResultActions(ResultActions resultActions) {
            this.resultActions = resultActions;
            return this;
        }

        public Builder withTPSchemeListener(TPSchemeListener tPSchemeListener) {
            this.TPSchemeListener = tPSchemeListener;
            return this;
        }

        public Builder withoutTPBrowser() {
            this.skipShowTpBrowser = true;
            return this;
        }

        public Builder withDspCreativeId(String string) {
            this.creativeId = string;
            return this;
        }

        public UrlHandler build() {
            return new UrlHandler(this.supportedUrlActions, this.resultActions, this.TPSchemeListener, this.skipShowTpBrowser, this.creativeId);
        }
    }

    public static interface TPSchemeListener {
        public void onFinishLoad();

        public void onClose();

        public void onFailLoad();
    }

    public static interface ResultActions {
        public void urlHandlingSucceeded(String var1, UrlAction var2);

        public void urlHandlingFailed(String var1, UrlAction var2);
    }
}

