/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.net.Uri;
import android.os.AsyncTask;
import com.tradplus.ads.common.UrlAction;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.common.util.AsyncTasks;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;

@VisibleForTesting
public class UrlResolutionTask
extends AsyncTask<String, Void, String> {
    private static final int REDIRECT_LIMIT = 10;
    private final UrlResolutionListener mListener;

    public static void getResolvedUrl(String string, UrlResolutionListener urlResolutionListener) {
        UrlResolutionTask urlResolutionTask = new UrlResolutionTask(urlResolutionListener);
        try {
            AsyncTasks.safeExecuteOnExecutor(urlResolutionTask, string);
            return;
        }
        catch (Exception exception) {
            urlResolutionListener.onFailure("Failed to resolve url", exception);
            return;
        }
    }

    UrlResolutionTask(UrlResolutionListener urlResolutionListener) {
        this.mListener = urlResolutionListener;
    }

    protected String doInBackground(String ... object) {
        if (object == null || ((String[])object).length == 0) {
            return null;
        }
        Object object2 = null;
        try {
            object = object[0];
            for (int i = 0; object != null && i < 10; ++i) {
                if (!UrlAction.OPEN_IN_APP_BROWSER.shouldTryHandlingUrl(Uri.parse((String)object))) {
                    return object;
                }
                object2 = object;
                object = this.getRedirectLocation((String)object);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        return object2;
    }

    private String getRedirectLocation(String string) {
        URL uRL = new URL(string);
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setInstanceFollowRedirects(false);
            string = UrlResolutionTask.resolveRedirectLocation(string, httpURLConnection);
            return string;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    @VisibleForTesting
    static String resolveRedirectLocation(String object, HttpURLConnection object2) {
        object = new URI((String)object);
        int n = ((HttpURLConnection)object2).getResponseCode();
        object2 = ((URLConnection)object2).getHeaderField("Location");
        String string = null;
        if (n >= 300 && n < 400) {
            try {
                string = ((URI)object).resolve((String)object2).toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new URISyntaxException((String)object2, "Unable to parse invalid URL");
            }
        }
        return string;
    }

    protected void onPostExecute(String string) {
        super.onPostExecute((Object)string);
        if (this.isCancelled() || string == null) {
            this.onCancelled();
            return;
        }
        this.mListener.onSuccess(string);
    }

    protected void onCancelled() {
        super.onCancelled();
        this.mListener.onFailure("Task for resolving url was cancelled", null);
    }

    static interface UrlResolutionListener {
        public void onSuccess(String var1);

        public void onFailure(String var1, Throwable var2);
    }
}

