/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewTreeObserver;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.Views;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class VisibilityTracker {
    private static final int VISIBILITY_THROTTLE_MILLIS = 100;
    @VisibleForTesting
    static final int NUM_ACCESSES_BEFORE_TRIMMING = 50;
    private final ArrayList<View> mTrimmedViews;
    private long mAccessCounter = 0L;
    @VisibleForTesting
    final ViewTreeObserver.OnPreDrawListener mOnPreDrawListener;
    @VisibleForTesting
    WeakReference<ViewTreeObserver> mWeakViewTreeObserver;
    private final Map<View, TrackingInfo> mTrackedViews;
    private final VisibilityChecker mVisibilityChecker;
    private VisibilityTrackerListener mVisibilityTrackerListener;
    private final VisibilityRunnable mVisibilityRunnable;
    private final Handler mVisibilityHandler;
    private boolean mIsVisibilityScheduled;

    public VisibilityTracker(Context context) {
        this(context, new WeakHashMap<View, TrackingInfo>(10), new VisibilityChecker(), new Handler());
    }

    @VisibleForTesting
    VisibilityTracker(Context context, Map<View, TrackingInfo> map, VisibilityChecker visibilityChecker, Handler handler) {
        this.mTrackedViews = map;
        this.mVisibilityChecker = visibilityChecker;
        this.mVisibilityHandler = handler;
        this.mVisibilityRunnable = new VisibilityRunnable();
        this.mTrimmedViews = new ArrayList(50);
        this.mOnPreDrawListener = new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                VisibilityTracker.this.scheduleVisibilityCheck();
                return true;
            }
        };
        this.mWeakViewTreeObserver = new WeakReference<Object>(null);
        this.setViewTreeObserver(context, null);
    }

    private void setViewTreeObserver(Context context, View view) {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.mWeakViewTreeObserver.get();
        if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
            return;
        }
        if ((context = Views.getTopmostView(context, view)) == null) {
            LogUtil.show("Unable to set Visibility Tracker due to no available root view.");
            return;
        }
        if (!(context = context.getViewTreeObserver()).isAlive()) {
            LogUtil.show("Visibility Tracker was unable to track views because the root view tree observer was not alive");
            return;
        }
        this.mWeakViewTreeObserver = new WeakReference<Context>(context);
        context.addOnPreDrawListener(this.mOnPreDrawListener);
    }

    public void setVisibilityTrackerListener(VisibilityTrackerListener visibilityTrackerListener) {
        this.mVisibilityTrackerListener = visibilityTrackerListener;
    }

    public void addView(View view, int n, Integer n2) {
        View view2 = view;
        this.addView(view2, view2, n, n2);
    }

    public void addView(View view, View view2, int n, Integer n2) {
        int n3 = n;
        this.addView(view, view2, n3, n3, n2);
    }

    public void addView(View view, View view2, int n, int n2, Integer n3) {
        this.setViewTreeObserver(view2.getContext(), view2);
        TrackingInfo trackingInfo = this.mTrackedViews.get(view2);
        if (trackingInfo == null) {
            trackingInfo = new TrackingInfo();
            this.mTrackedViews.put(view2, trackingInfo);
            this.scheduleVisibilityCheck();
        }
        int n4 = Math.min(n2, n);
        trackingInfo.mRootView = view;
        trackingInfo.mMinViewablePercent = n;
        trackingInfo.mMaxInvisiblePercent = n4;
        trackingInfo.mAccessOrder = this.mAccessCounter++;
        trackingInfo.mMinVisiblePx = n3;
        if (this.mAccessCounter % 50L == 0L) {
            VisibilityTracker visibilityTracker = this;
            visibilityTracker.trimTrackedViews(visibilityTracker.mAccessCounter - 50L);
        }
    }

    private void trimTrackedViews(long l) {
        for (Map.Entry<View, TrackingInfo> view : this.mTrackedViews.entrySet()) {
            if (view.getValue().mAccessOrder >= l) continue;
            this.mTrimmedViews.add(view.getKey());
        }
        for (View view : this.mTrimmedViews) {
            this.removeView(view);
        }
        this.mTrimmedViews.clear();
    }

    public void removeView(View view) {
        this.mTrackedViews.remove(view);
    }

    public void clear() {
        this.mTrackedViews.clear();
        this.mVisibilityHandler.removeMessages(0);
        this.mIsVisibilityScheduled = false;
    }

    public void destroy() {
        this.clear();
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.mWeakViewTreeObserver.get();
        if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
            viewTreeObserver.removeOnPreDrawListener(this.mOnPreDrawListener);
        }
        this.mWeakViewTreeObserver.clear();
        this.mVisibilityTrackerListener = null;
    }

    public void scheduleVisibilityCheck() {
        if (this.mIsVisibilityScheduled) {
            return;
        }
        this.mIsVisibilityScheduled = true;
        this.mVisibilityHandler.postDelayed((Runnable)this.mVisibilityRunnable, 100L);
    }

    public static class VisibilityChecker {
        private final Rect mClipRect = new Rect();

        public boolean hasRequiredTimeElapsed(long l, int n) {
            return SystemClock.uptimeMillis() - l >= (long)n;
        }

        public boolean isVisible(View view, View view2, int n, Integer n2) {
            if (view2 == null || view2.getVisibility() != 0 || view.getParent() == null) {
                return false;
            }
            if (!view2.getGlobalVisibleRect(this.mClipRect)) {
                return false;
            }
            long l = (long)this.mClipRect.height() * (long)this.mClipRect.width();
            long l2 = (long)view2.getHeight() * (long)view2.getWidth();
            if (l2 <= 0L) {
                return false;
            }
            if (n2 != null && n2 > 0) {
                return l >= (long)n2.intValue();
            }
            return 100L * l >= (long)n * l2;
        }
    }

    class VisibilityRunnable
    implements Runnable {
        private final ArrayList<View> mVisibleViews;
        private final ArrayList<View> mInvisibleViews = new ArrayList();

        VisibilityRunnable() {
            this.mVisibleViews = new ArrayList();
        }

        @Override
        public void run() {
            VisibilityTracker.this.mIsVisibilityScheduled = false;
            for (Map.Entry entry : VisibilityTracker.this.mTrackedViews.entrySet()) {
                View view = (View)entry.getKey();
                int n = ((TrackingInfo)entry.getValue()).mMinViewablePercent;
                int n2 = ((TrackingInfo)entry.getValue()).mMaxInvisiblePercent;
                Integer n3 = ((TrackingInfo)entry.getValue()).mMinVisiblePx;
                View view2 = ((TrackingInfo)entry.getValue()).mRootView;
                if (VisibilityTracker.this.mVisibilityChecker.isVisible(view2, view, n, n3)) {
                    this.mVisibleViews.add(view);
                    continue;
                }
                if (VisibilityTracker.this.mVisibilityChecker.isVisible(view2, view, n2, null)) continue;
                this.mInvisibleViews.add(view);
            }
            if (VisibilityTracker.this.mVisibilityTrackerListener != null) {
                VisibilityTracker.this.mVisibilityTrackerListener.onVisibilityChanged(this.mVisibleViews, this.mInvisibleViews);
            }
            this.mVisibleViews.clear();
            this.mInvisibleViews.clear();
        }
    }

    static class TrackingInfo {
        int mMinViewablePercent;
        int mMaxInvisiblePercent;
        long mAccessOrder;
        View mRootView;
        Integer mMinVisiblePx;

        TrackingInfo() {
        }
    }

    public static interface VisibilityTrackerListener {
        public void onVisibilityChanged(List<View> var1, List<View> var2);
    }
}

