/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.event;

import com.tradplus.ads.common.event.BaseEvent;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ErrorEvent
extends BaseEvent {
    private final String mErrorExceptionClassName;
    private final String mErrorMessage;
    private final String mErrorStackTrace;
    private final String mErrorFileName;
    private final String mErrorClassName;
    private final String mErrorMethodName;
    private final Integer mErrorLineNumber;

    private ErrorEvent(Builder builder) {
        super(builder);
        this.mErrorExceptionClassName = builder.mErrorExceptionClassName;
        this.mErrorMessage = builder.mErrorMessage;
        this.mErrorStackTrace = builder.mErrorStackTrace;
        this.mErrorFileName = builder.mErrorFileName;
        this.mErrorClassName = builder.mErrorClassName;
        this.mErrorMethodName = builder.mErrorMethodName;
        this.mErrorLineNumber = builder.mErrorLineNumber;
    }

    public String getErrorExceptionClassName() {
        return this.mErrorExceptionClassName;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public String getErrorStackTrace() {
        return this.mErrorStackTrace;
    }

    public String getErrorFileName() {
        return this.mErrorFileName;
    }

    public String getErrorClassName() {
        return this.mErrorClassName;
    }

    public String getErrorMethodName() {
        return this.mErrorMethodName;
    }

    public Integer getErrorLineNumber() {
        return this.mErrorLineNumber;
    }

    @Override
    public String toString() {
        String string = super.toString();
        return string + "ErrorEvent\nErrorExceptionClassName: " + this.getErrorExceptionClassName() + "\nErrorMessage: " + this.getErrorMessage() + "\nErrorStackTrace: " + this.getErrorStackTrace() + "\nErrorFileName: " + this.getErrorFileName() + "\nErrorClassName: " + this.getErrorClassName() + "\nErrorMethodName: " + this.getErrorMethodName() + "\nErrorLineNumber: " + this.getErrorLineNumber() + "\n";
    }

    public static class Builder
    extends BaseEvent.Builder {
        private String mErrorExceptionClassName;
        private String mErrorMessage;
        private String mErrorStackTrace;
        private String mErrorFileName;
        private String mErrorClassName;
        private String mErrorMethodName;
        private Integer mErrorLineNumber;

        public Builder(BaseEvent.Name name, BaseEvent.Category category, double d) {
            super(BaseEvent.ScribeCategory.EXCHANGE_CLIENT_ERROR, name, category, d);
        }

        public Builder withErrorExceptionClassName(String string) {
            this.mErrorExceptionClassName = string;
            return this;
        }

        public Builder withErrorMessage(String string) {
            this.mErrorMessage = string;
            return this;
        }

        public Builder withErrorStackTrace(String string) {
            this.mErrorStackTrace = string;
            return this;
        }

        public Builder withErrorFileName(String string) {
            this.mErrorFileName = string;
            return this;
        }

        public Builder withErrorClassName(String string) {
            this.mErrorClassName = string;
            return this;
        }

        public Builder withErrorMethodName(String string) {
            this.mErrorMethodName = string;
            return this;
        }

        public Builder withErrorLineNumber(Integer n) {
            this.mErrorLineNumber = n;
            return this;
        }

        public Builder withException(Exception exception) {
            this.mErrorExceptionClassName = exception.getClass().getName();
            this.mErrorMessage = exception.getMessage();
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            this.mErrorStackTrace = stringWriter.toString();
            if (exception.getStackTrace().length > 0) {
                this.mErrorFileName = exception.getStackTrace()[0].getFileName();
                this.mErrorClassName = exception.getStackTrace()[0].getClassName();
                this.mErrorMethodName = exception.getStackTrace()[0].getMethodName();
                this.mErrorLineNumber = exception.getStackTrace()[0].getLineNumber();
            }
            return this;
        }

        @Override
        public ErrorEvent build() {
            return new ErrorEvent(this);
        }
    }
}

