/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.event;

import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.util.Json;
import java.util.HashMap;
import java.util.Map;

public class EventDetails {
    private static final String AD_UNIT_ID_KEY = "ad_unit_id";
    private static final String DSP_CREATIVE_ID_KEY = "dsp_creative_id";
    private static final String AD_TYPE_KEY = "ad_type";
    private static final String AD_NETWORK_TYPE_KEY = "ad_network_type";
    private static final String AD_WIDTH_PX_KEY = "ad_width_px";
    private static final String AD_HEIGHT_PX_KEY = "ad_height_px_key";
    private static final String GEO_LATITUDE_KEY = "geo_latitude";
    private static final String GEO_LONGITUDE_KEY = "geo_longitude";
    private static final String GEO_ACCURACY_KEY = "geo_accuracy_key";
    private static final String PERFORMANCE_DURATION_MS_KEY = "performance_duration_ms";
    private static final String REQUEST_ID_KEY = "request_id_key";
    private static final String REQUEST_STATUS_CODE_KEY = "request_status_code";
    private static final String REQUEST_URI_KEY = "request_uri_key";
    private final Map<String, String> mEventDetailsMap;

    private EventDetails(Map<String, String> map) {
        Preconditions.checkNotNull(map);
        this.mEventDetailsMap = map;
    }

    public String getAdUnitId() {
        return this.mEventDetailsMap.get(AD_UNIT_ID_KEY);
    }

    public String getDspCreativeId() {
        return this.mEventDetailsMap.get(DSP_CREATIVE_ID_KEY);
    }

    public String getAdType() {
        return this.mEventDetailsMap.get(AD_TYPE_KEY);
    }

    public String getAdNetworkType() {
        return this.mEventDetailsMap.get(AD_NETWORK_TYPE_KEY);
    }

    public Double getAdWidthPx() {
        return EventDetails.getNullableDoubleValue(this.mEventDetailsMap, AD_WIDTH_PX_KEY);
    }

    public Double getAdHeightPx() {
        return EventDetails.getNullableDoubleValue(this.mEventDetailsMap, AD_HEIGHT_PX_KEY);
    }

    public Double getGeoLatitude() {
        return EventDetails.getNullableDoubleValue(this.mEventDetailsMap, GEO_LATITUDE_KEY);
    }

    public Double getGeoLongitude() {
        return EventDetails.getNullableDoubleValue(this.mEventDetailsMap, GEO_LONGITUDE_KEY);
    }

    public Double getGeoAccuracy() {
        return EventDetails.getNullableDoubleValue(this.mEventDetailsMap, GEO_ACCURACY_KEY);
    }

    public Double getPerformanceDurationMs() {
        return EventDetails.getNullableDoubleValue(this.mEventDetailsMap, PERFORMANCE_DURATION_MS_KEY);
    }

    public String getRequestId() {
        return this.mEventDetailsMap.get(REQUEST_ID_KEY);
    }

    public Integer getRequestStatusCode() {
        return EventDetails.getNullableIntegerValue(this.mEventDetailsMap, REQUEST_STATUS_CODE_KEY);
    }

    public String getRequestUri() {
        return this.mEventDetailsMap.get(REQUEST_URI_KEY);
    }

    public String toJsonString() {
        return Json.mapToJsonString(this.mEventDetailsMap);
    }

    public String toString() {
        return this.toJsonString();
    }

    private static Double getNullableDoubleValue(Map<String, String> object, String string) {
        if ((object = object.get(string)) == null) {
            return null;
        }
        try {
            return Double.parseDouble((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private static Integer getNullableIntegerValue(Map<String, String> object, String string) {
        if ((object = object.get(string)) == null) {
            return null;
        }
        try {
            return Integer.parseInt((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static class Builder {
        private final Map<String, String> eventDetailsMap = new HashMap<String, String>();

        public Builder adUnitId(String string) {
            if (string != null) {
                this.eventDetailsMap.put(EventDetails.AD_UNIT_ID_KEY, string);
            }
            return this;
        }

        public Builder dspCreativeId(String string) {
            if (string != null) {
                this.eventDetailsMap.put(EventDetails.DSP_CREATIVE_ID_KEY, string);
            }
            return this;
        }

        public Builder adType(String string) {
            if (string != null) {
                this.eventDetailsMap.put(EventDetails.AD_TYPE_KEY, string);
            }
            return this;
        }

        public Builder adNetworkType(String string) {
            if (string != null) {
                this.eventDetailsMap.put(EventDetails.AD_NETWORK_TYPE_KEY, string);
            }
            return this;
        }

        public Builder adWidthPx(Integer n) {
            if (n != null) {
                this.eventDetailsMap.put(EventDetails.AD_WIDTH_PX_KEY, String.valueOf(n));
            }
            return this;
        }

        public Builder adHeightPx(Integer n) {
            if (n != null) {
                this.eventDetailsMap.put(EventDetails.AD_HEIGHT_PX_KEY, String.valueOf(n));
            }
            return this;
        }

        public Builder geoLatitude(Double d) {
            if (d != null) {
                this.eventDetailsMap.put(EventDetails.GEO_LATITUDE_KEY, String.valueOf(d));
            }
            return this;
        }

        public Builder geoLongitude(Double d) {
            if (d != null) {
                this.eventDetailsMap.put(EventDetails.GEO_LONGITUDE_KEY, String.valueOf(d));
            }
            return this;
        }

        public Builder geoAccuracy(Float f) {
            if (f != null) {
                this.eventDetailsMap.put(EventDetails.GEO_ACCURACY_KEY, String.valueOf((double)f.floatValue()));
            }
            return this;
        }

        public Builder performanceDurationMs(Long l) {
            if (l != null) {
                this.eventDetailsMap.put(EventDetails.PERFORMANCE_DURATION_MS_KEY, String.valueOf((double)l.longValue()));
            }
            return this;
        }

        public Builder requestId(String string) {
            if (string != null) {
                this.eventDetailsMap.put(EventDetails.REQUEST_ID_KEY, string);
            }
            return this;
        }

        public Builder requestStatusCode(Integer n) {
            if (n != null) {
                this.eventDetailsMap.put(EventDetails.REQUEST_STATUS_CODE_KEY, String.valueOf(n));
            }
            return this;
        }

        public Builder requestUri(String string) {
            if (string != null) {
                this.eventDetailsMap.put(EventDetails.REQUEST_URI_KEY, string);
            }
            return this;
        }

        public EventDetails build() {
            return new EventDetails(this.eventDetailsMap);
        }
    }
}

