/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.event;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.common.event.BaseEvent;
import com.tradplus.ads.common.event.EventRecorder;
import com.tradplus.ads.common.util.LogUtil;
import java.util.Iterator;

public class EventDispatcher {
    private final Iterable<EventRecorder> mEventRecorders;
    private final Looper mLooper;
    private final Handler mMessageHandler;
    private final Handler.Callback mHandlerCallback;

    @VisibleForTesting
    EventDispatcher(Iterable<EventRecorder> iterable, Looper looper) {
        this.mEventRecorders = iterable;
        this.mLooper = looper;
        this.mHandlerCallback = new Handler.Callback(){

            public boolean handleMessage(Message message) {
                if (message.obj instanceof BaseEvent) {
                    Iterator iterator = EventDispatcher.this.mEventRecorders.iterator();
                    while (iterator.hasNext()) {
                        ((EventRecorder)iterator.next()).record((BaseEvent)message.obj);
                    }
                } else {
                    LogUtil.show("EventDispatcher received non-BaseEvent message type.");
                }
                return true;
            }
        };
        this.mMessageHandler = new Handler(this.mLooper, this.mHandlerCallback);
    }

    public void dispatch(BaseEvent baseEvent) {
        Message.obtain((Handler)this.mMessageHandler, (int)0, (Object)baseEvent).sendToTarget();
    }

    @VisibleForTesting
    Iterable<EventRecorder> getEventRecorders() {
        return this.mEventRecorders;
    }

    @VisibleForTesting
    Handler.Callback getHandlerCallback() {
        return this.mHandlerCallback;
    }
}

