/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.event;

import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.common.event.BaseEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;

public class EventSampler {
    @VisibleForTesting
    static final int MAX_SIZE = 100;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int CAPACITY = 135;
    private Random mRandom;
    private LinkedHashMap<String, Boolean> mSampleDecisionsCache;

    public EventSampler() {
        this(new Random());
    }

    @VisibleForTesting
    public EventSampler(Random random) {
        this.mRandom = random;
        this.mSampleDecisionsCache = new LinkedHashMap<String, Boolean>(135, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Boolean> entry) {
                return this.size() > 100;
            }
        };
    }

    boolean sample(BaseEvent baseEvent) {
        Preconditions.checkNotNull(baseEvent);
        String string = baseEvent.getRequestId();
        if (string == null) {
            return this.mRandom.nextDouble() < baseEvent.getSamplingRate();
        }
        Boolean bl = this.mSampleDecisionsCache.get(string);
        if (bl != null) {
            return bl;
        }
        boolean bl2 = this.mRandom.nextDouble() < baseEvent.getSamplingRate();
        this.mSampleDecisionsCache.put(string, bl2);
        return bl2;
    }

    @VisibleForTesting
    int getCacheSize() {
        return this.mSampleDecisionsCache.size();
    }
}

