/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONArray;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.TypeReference;
import com.tradplus.ads.common.serialization.annotation.JSONField;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.ParserConfig;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class JSONObject
extends JSON
implements Serializable,
Cloneable,
InvocationHandler,
Map<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private final Map<String, Object> map;

    public JSONObject() {
        this(16, false);
    }

    public JSONObject(Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("map is null.");
        }
        this.map = map;
    }

    public JSONObject(boolean bl) {
        this(16, bl);
    }

    public JSONObject(int n) {
        this(n, false);
    }

    public JSONObject(int n, boolean bl) {
        if (bl) {
            this.map = new LinkedHashMap<String, Object>(n);
            return;
        }
        this.map = new HashMap<String, Object>(n);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        boolean bl = this.map.containsKey(object);
        if (!bl && (object instanceof Number || object instanceof Character || object instanceof Boolean || object instanceof UUID)) {
            bl = this.map.containsKey(object.toString());
        }
        return bl;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public Object get(Object object) {
        Object object2 = this.map.get(object);
        if (object2 == null && (object instanceof Number || object instanceof Character || object instanceof Boolean || object instanceof UUID)) {
            object2 = this.map.get(object.toString());
        }
        return object2;
    }

    public JSONObject getJSONObject(String object) {
        if ((object = this.map.get(object)) instanceof JSONObject) {
            return (JSONObject)object;
        }
        if (object instanceof Map) {
            return new JSONObject((Map)object);
        }
        if (object instanceof String) {
            return JSON.parseObject((String)object);
        }
        return (JSONObject)JSONObject.toJSON(object);
    }

    public JSONArray getJSONArray(String object) {
        if ((object = this.map.get(object)) instanceof JSONArray) {
            return (JSONArray)object;
        }
        if (object instanceof List) {
            return new JSONArray((List)object);
        }
        if (object instanceof String) {
            return (JSONArray)JSON.parse((String)object);
        }
        return (JSONArray)JSONObject.toJSON(object);
    }

    public <T> T getObject(String string, Class<T> clazz) {
        return TypeUtils.castToJavaBean(this.map.get(string), clazz);
    }

    public <T> T getObject(String string, Type type) {
        return TypeUtils.cast(this.map.get(string), type, ParserConfig.getGlobalInstance());
    }

    public <T> T getObject(String object, TypeReference typeReference) {
        object = this.map.get(object);
        if (typeReference == null) {
            return (T)object;
        }
        return TypeUtils.cast(object, typeReference.getType(), ParserConfig.getGlobalInstance());
    }

    public Boolean getBoolean(String object) {
        if ((object = this.get(object)) == null) {
            return null;
        }
        return TypeUtils.castToBoolean(object);
    }

    public byte[] getBytes(String object) {
        if ((object = this.get(object)) == null) {
            return null;
        }
        return TypeUtils.castToBytes(object);
    }

    public boolean getBooleanValue(String object) {
        if ((object = TypeUtils.castToBoolean(this.get(object))) == null) {
            return false;
        }
        return (Boolean)object;
    }

    public Byte getByte(String string) {
        return TypeUtils.castToByte(this.get(string));
    }

    public byte getByteValue(String object) {
        if ((object = TypeUtils.castToByte(this.get(object))) == null) {
            return 0;
        }
        return (Byte)object;
    }

    public Short getShort(String string) {
        return TypeUtils.castToShort(this.get(string));
    }

    public short getShortValue(String object) {
        if ((object = TypeUtils.castToShort(this.get(object))) == null) {
            return 0;
        }
        return (Short)object;
    }

    public Integer getInteger(String string) {
        return TypeUtils.castToInt(this.get(string));
    }

    public int getIntValue(String object) {
        if ((object = TypeUtils.castToInt(this.get(object))) == null) {
            return 0;
        }
        return (Integer)object;
    }

    public Long getLong(String string) {
        return TypeUtils.castToLong(this.get(string));
    }

    public long getLongValue(String object) {
        if ((object = TypeUtils.castToLong(this.get(object))) == null) {
            return 0L;
        }
        return (Long)object;
    }

    public Float getFloat(String string) {
        return TypeUtils.castToFloat(this.get(string));
    }

    public float getFloatValue(String object) {
        if ((object = TypeUtils.castToFloat(this.get(object))) == null) {
            return 0.0f;
        }
        return ((Float)object).floatValue();
    }

    public Double getDouble(String string) {
        return TypeUtils.castToDouble(this.get(string));
    }

    public double getDoubleValue(String object) {
        if ((object = TypeUtils.castToDouble(this.get(object))) == null) {
            return 0.0;
        }
        return (Double)object;
    }

    public BigDecimal getBigDecimal(String string) {
        return TypeUtils.castToBigDecimal(this.get(string));
    }

    public BigInteger getBigInteger(String string) {
        return TypeUtils.castToBigInteger(this.get(string));
    }

    public String getString(String object) {
        if ((object = this.get(object)) == null) {
            return null;
        }
        return object.toString();
    }

    public java.util.Date getDate(String string) {
        return TypeUtils.castToDate(this.get(string));
    }

    public Date getSqlDate(String string) {
        return TypeUtils.castToSqlDate(this.get(string));
    }

    public Timestamp getTimestamp(String string) {
        return TypeUtils.castToTimestamp(this.get(string));
    }

    @Override
    public Object put(String string, Object object) {
        return this.map.put(string, object);
    }

    public JSONObject fluentPut(String string, Object object) {
        this.map.put(string, object);
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        this.map.putAll(map);
    }

    public JSONObject fluentPutAll(Map<? extends String, ?> map) {
        this.map.putAll(map);
        return this;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public JSONObject fluentClear() {
        this.map.clear();
        return this;
    }

    @Override
    public Object remove(Object object) {
        return this.map.remove(object);
    }

    public JSONObject fluentRemove(Object object) {
        this.map.remove(object);
        return this;
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    public Object clone() {
        return new JSONObject(this.map instanceof LinkedHashMap ? new LinkedHashMap<String, Object>(this.map) : new HashMap<String, Object>(this.map));
    }

    @Override
    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        object = method.getParameterTypes();
        if (((Class<?>[])object).length == 1) {
            if (method.getName().equals("equals")) {
                return this.equals(objectArray[0]);
            }
            if (method.getReturnType() != Void.TYPE) {
                throw new JSONException("illegal setter");
            }
            object = null;
            JSONField jSONField = TypeUtils.getAnnotation(method, JSONField.class);
            if (jSONField != null && jSONField.name().length() != 0) {
                object = jSONField.name();
            }
            if (object == null) {
                object = method.getName();
                if (!((String)object).startsWith("set")) {
                    throw new JSONException("illegal setter");
                }
                if (((String)(object = ((String)object).substring(3))).length() == 0) {
                    throw new JSONException("illegal setter");
                }
                object = Character.toLowerCase(((String)object).charAt(0)) + ((String)object).substring(1);
            }
            this.map.put((String)object, objectArray[0]);
            return null;
        }
        if (((Class<?>[])object).length == 0) {
            if (method.getReturnType() == Void.TYPE) {
                throw new JSONException("illegal getter");
            }
            object = null;
            JSONField jSONField = TypeUtils.getAnnotation(method, JSONField.class);
            if (jSONField != null && jSONField.name().length() != 0) {
                object = jSONField.name();
            }
            if (object == null) {
                object = method.getName();
                if (((String)object).startsWith("get")) {
                    if (((String)(object = ((String)object).substring(3))).length() == 0) {
                        throw new JSONException("illegal getter");
                    }
                    object = Character.toLowerCase(((String)object).charAt(0)) + ((String)object).substring(1);
                } else if (((String)object).startsWith("is")) {
                    if (((String)(object = ((String)object).substring(2))).length() == 0) {
                        throw new JSONException("illegal getter");
                    }
                    object = Character.toLowerCase(((String)object).charAt(0)) + ((String)object).substring(1);
                } else {
                    if (((String)object).startsWith("hashCode")) {
                        return this.hashCode();
                    }
                    if (((String)object).startsWith("toString")) {
                        return this.toString();
                    }
                    throw new JSONException("illegal getter");
                }
            }
            return TypeUtils.cast(this.map.get(object), method.getGenericReturnType(), ParserConfig.getGlobalInstance());
        }
        throw new UnsupportedOperationException(method.toGenericString());
    }

    public Map<String, Object> getInnerMap() {
        return this.map;
    }

    private void readObject(ObjectInputStream object2) {
        SecureObjectInputStream.ensureFields();
        if (SecureObjectInputStream.fields != null && !SecureObjectInputStream.fields_error) {
            SecureObjectInputStream secureObjectInputStream = new SecureObjectInputStream((ObjectInputStream)object2);
            try {
                secureObjectInputStream.defaultReadObject();
                return;
            }
            catch (NotActiveException notActiveException) {}
        }
        ((ObjectInputStream)object2).defaultReadObject();
        for (Map.Entry entry : this.map.entrySet()) {
            Object v;
            Object k = entry.getKey();
            if (k != null) {
                ParserConfig.global.checkAutoType(k.getClass());
            }
            if ((v = entry.getValue()) == null) continue;
            ParserConfig.global.checkAutoType(v.getClass());
        }
    }

    @Override
    public <T> T toJavaObject(Class<T> clazz) {
        if (clazz == Map.class || clazz == JSONObject.class || clazz == JSON.class) {
            return (T)this;
        }
        if (clazz == Object.class && !this.containsKey(JSON.DEFAULT_TYPE_KEY)) {
            return (T)this;
        }
        return TypeUtils.castToJavaBean(this, clazz, ParserConfig.getGlobalInstance());
    }

    public <T> T toJavaObject(Class<T> clazz, ParserConfig parserConfig, int n) {
        if (clazz == Map.class) {
            return (T)this;
        }
        if (clazz == Object.class && !this.containsKey(JSON.DEFAULT_TYPE_KEY)) {
            return (T)this;
        }
        return TypeUtils.castToJavaBean(this, clazz, parserConfig);
    }

    static class SecureObjectInputStream
    extends ObjectInputStream {
        static Field[] fields;
        static volatile boolean fields_error;

        static void ensureFields() {
            if (fields == null && !fields_error) {
                try {
                    Field[] fieldArray = ObjectInputStream.class.getDeclaredFields();
                    String[] stringArray = new String[]{"bin", "passHandle", "handles", "curContext"};
                    Field[] fieldArray2 = new Field[4];
                    for (int i = 0; i < 4; ++i) {
                        Field field = TypeUtils.getField(ObjectInputStream.class, stringArray[i], fieldArray);
                        field.setAccessible(true);
                        fieldArray2[i] = field;
                    }
                    fields = fieldArray2;
                    return;
                }
                catch (Throwable throwable) {
                    fields_error = true;
                }
            }
        }

        public SecureObjectInputStream(ObjectInputStream objectInputStream) {
            super(objectInputStream);
            try {
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    Object object = field.get(objectInputStream);
                    field.set(this, object);
                }
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                fields_error = true;
                return;
            }
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) {
            String string = objectStreamClass.getName();
            if (string.length() > 2) {
                int n = string.lastIndexOf(91);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                if (string.length() > 2 && string.charAt(0) == 'L') {
                    String string2 = string;
                    if (string2.charAt(string2.length() - 1) == ';') {
                        string = string.substring(1, string.length() - 1);
                    }
                }
                if (TypeUtils.getClassFromMapping(string) == null) {
                    ParserConfig.global.checkAutoType(string, null, Feature.SupportAutoType.mask);
                }
            }
            return super.resolveClass(objectStreamClass);
        }

        @Override
        protected Class<?> resolveProxyClass(String[] stringArray) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray2[i];
                if (TypeUtils.getClassFromMapping(string) != null) continue;
                ParserConfig.global.checkAutoType(string, null);
            }
            return super.resolveProxyClass(stringArray);
        }

        @Override
        protected void readStreamHeader() {
        }
    }
}

