/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONArray;
import com.tradplus.ads.common.serialization.JSONAware;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.JSONObject;
import com.tradplus.ads.common.serialization.JSONPathException;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.JSONLexerBase;
import com.tradplus.ads.common.serialization.parser.ParserConfig;
import com.tradplus.ads.common.serialization.parser.deserializer.FieldDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.JavaBeanDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.FieldSerializer;
import com.tradplus.ads.common.serialization.serializer.JavaBeanSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeConfig;
import com.tradplus.ads.common.serialization.util.IOUtils;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

public class JSONPath
implements JSONAware {
    private static ConcurrentMap<String, JSONPath> pathCache = new ConcurrentHashMap<String, JSONPath>(128, 0.75f, 1);
    private final String path;
    private Segment[] segments;
    private boolean hasRefSegment;
    private SerializeConfig serializeConfig;
    private ParserConfig parserConfig;
    static final long SIZE = 5614464919154503228L;
    static final long LENGTH = -1580386065683472715L;

    public JSONPath(String string) {
        this(string, SerializeConfig.getGlobalInstance(), ParserConfig.getGlobalInstance());
    }

    public JSONPath(String string, SerializeConfig serializeConfig, ParserConfig parserConfig) {
        if (string == null || string.length() == 0) {
            throw new JSONPathException("json-path can not be null or empty");
        }
        this.path = string;
        this.serializeConfig = serializeConfig;
        this.parserConfig = parserConfig;
    }

    protected void init() {
        if (this.segments != null) {
            return;
        }
        if ("*".equals(this.path)) {
            this.segments = new Segment[]{WildCardSegment.instance};
            return;
        }
        JSONPathParser jSONPathParser = new JSONPathParser(this.path);
        this.segments = jSONPathParser.explain();
        this.hasRefSegment = jSONPathParser.hasRefSegment;
    }

    public boolean isRef() {
        try {
            this.init();
            for (int i = 0; i < this.segments.length; ++i) {
                Class<?> clazz = this.segments[i].getClass();
                if (clazz == ArrayAccessSegment.class || clazz == PropertySegment.class) continue;
                return false;
            }
            return true;
        }
        catch (JSONPathException jSONPathException) {
            return false;
        }
    }

    public Object eval(Object object) {
        if (object == null) {
            return null;
        }
        this.init();
        Object object2 = object;
        for (int i = 0; i < this.segments.length; ++i) {
            object2 = this.segments[i].eval(this, object, object2);
        }
        return object2;
    }

    /*
     * Unable to fully structure code
     */
    public Object extract(DefaultJSONParser var1_1) {
        if (var1_1 == null) {
            return null;
        }
        this.init();
        if (this.hasRefSegment) {
            var2_2 = var1_1.parse();
            return this.eval(var2_2);
        }
        if (this.segments.length == 0) {
            return var1_1.parse();
        }
        var2_3 = this.segments[this.segments.length - 1];
        if (var2_3 instanceof TypeSegment || var2_3 instanceof FloorSegment) {
            return this.eval(var1_1.parse());
        }
        var2_3 = null;
        for (var3_4 = 0; var3_4 < this.segments.length; ++var3_4) {
            var4_5 = this.segments[var3_4];
            v0 = var5_6 = var3_4 == this.segments.length - 1;
            if (var2_3 != null && var2_3.object != null) {
                var2_3.object = var4_5.eval(this, null, var2_3.object);
                continue;
            }
            if (var5_6) ** GOTO lbl-1000
            var5_7 = this.segments[var3_4 + 1];
            if (var4_5 instanceof PropertySegment && PropertySegment.access$100((PropertySegment)var4_5) && (var5_7 instanceof ArrayAccessSegment || var5_7 instanceof MultiIndexSegment || var5_7 instanceof MultiPropertySegment || var5_7 instanceof SizeSegment || var5_7 instanceof PropertySegment || var5_7 instanceof FilterSegment)) {
                var5_6 = true;
            } else if (!(var5_7 instanceof ArrayAccessSegment && ArrayAccessSegment.access$200((ArrayAccessSegment)var5_7) < 0 || var5_7 instanceof FilterSegment || var4_5 instanceof WildCardSegment)) {
                var5_6 = false;
            } else lbl-1000:
            // 2 sources

            {
                var5_6 = true;
            }
            var2_3 = new Context((Context)var2_3, var5_6);
            var4_5.extract(this, var1_1, (Context)var2_3);
        }
        return var2_3.object;
    }

    public boolean contains(Object object) {
        if (object == null) {
            return false;
        }
        this.init();
        Object object2 = object;
        for (int i = 0; i < this.segments.length; ++i) {
            Object object3 = object2;
            if ((object2 = this.segments[i].eval(this, object, object2)) == null) {
                return false;
            }
            if (object2 != Collections.EMPTY_LIST || !(object3 instanceof List)) continue;
            return ((List)object3).contains(object2);
        }
        return true;
    }

    public boolean containsValue(Object iterator, Object object) {
        if ((iterator = this.eval(iterator)) == object) {
            return true;
        }
        if (iterator == null) {
            return false;
        }
        if (iterator instanceof Iterable) {
            iterator = ((Iterable)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                if (!JSONPath.eq(iterator.next(), object)) continue;
                return true;
            }
            return false;
        }
        return JSONPath.eq(iterator, object);
    }

    public int size(Object object) {
        if (object == null) {
            return -1;
        }
        this.init();
        Object object2 = object;
        for (int i = 0; i < this.segments.length; ++i) {
            object2 = this.segments[i].eval(this, object, object2);
        }
        return this.evalSize(object2);
    }

    public Set<?> keySet(Object object) {
        if (object == null) {
            return null;
        }
        this.init();
        Object object2 = object;
        for (int i = 0; i < this.segments.length; ++i) {
            object2 = this.segments[i].eval(this, object, object2);
        }
        return this.evalKeySet(object2);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void patchAdd(Object var1_1, Object var2_2, boolean var3_3) {
        if (var1_1 == null) {
            return;
        }
        this.init();
        var4_4 = var1_1;
        var5_5 = null;
        for (var6_6 = 0; var6_6 < this.segments.length; ++var6_6) {
            var5_5 = var4_4;
            var7_8 = this.segments[var6_6];
            if ((var4_4 = var7_8.eval(this, var1_1, var4_4)) != null || var6_6 == this.segments.length - 1 || !(var7_8 instanceof PropertySegment)) continue;
            var4_4 = new JSONObject();
            ((PropertySegment)var7_8).setValue(this, var5_5, var4_4);
        }
        var6_7 = var4_4;
        if (!var3_3 && var6_7 instanceof Collection) {
            ((Collection)var6_7).add(var2_2);
            return;
        }
        if (var6_7 == null || var3_3) ** GOTO lbl29
        var1_1 = var6_7.getClass();
        if (var1_1.isArray()) {
            var3_3 = Array.getLength(var6_7);
            var1_1 = Array.newInstance(var1_1.getComponentType(), var3_3 + 1);
            System.arraycopy(var6_7, 0, var1_1, 0, (int)var3_3);
            Array.set(var1_1, (int)var3_3, var2_2);
            var7_8 = var1_1;
        } else {
            if (!Map.class.isAssignableFrom(var1_1)) {
                throw new JSONException("unsupported array put operation. ".concat(String.valueOf(var1_1)));
            }
lbl29:
            // 3 sources

            var7_8 = var2_2;
        }
        var1_1 = this.segments[this.segments.length - 1];
        if (var1_1 instanceof PropertySegment) {
            ((PropertySegment)var1_1).setValue(this, var5_5, var7_8);
            return;
        }
        if (var1_1 instanceof ArrayAccessSegment) {
            ((ArrayAccessSegment)var1_1).setValue(this, var5_5, var7_8);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void arrayAdd(Object clazz, Object ... object) {
        Object object2;
        if (object == null || ((Object)object).length == 0) {
            return;
        }
        if (clazz == null) {
            return;
        }
        this.init();
        Object object3 = clazz;
        Class<?> clazz2 = null;
        for (int object42 = 0; object42 < this.segments.length; ++object42) {
            if (object42 == this.segments.length - 1) {
                clazz2 = object3;
            }
            object3 = this.segments[object42].eval(this, clazz, object3);
        }
        Object i2 = object3;
        if (i2 == null) {
            throw new JSONPathException("value not found in path " + this.path);
        }
        if (i2 instanceof Collection) {
            clazz = (Collection)i2;
            for (Object i2 : object) {
                clazz.add((Object)i2);
            }
            return;
        }
        clazz = i2.getClass();
        if (clazz.isArray()) {
            int segment = Array.getLength(i2);
            object2 = Array.newInstance(clazz.getComponentType(), segment + ((Object)object).length);
            System.arraycopy(i2, 0, object2, 0, segment);
            for (int j = 0; j < ((Object)object).length; ++j) {
                Array.set(object2, segment + j, object[j]);
            }
        } else {
            throw new JSONException("unsupported array put operation. ".concat(String.valueOf(clazz)));
        }
        Object object4 = object2;
        Segment segment = this.segments[this.segments.length - 1];
        if (segment instanceof PropertySegment) {
            ((PropertySegment)segment).setValue(this, clazz2, object4);
            return;
        }
        if (segment instanceof ArrayAccessSegment) {
            ((ArrayAccessSegment)segment).setValue(this, clazz2, object4);
            return;
        }
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object iterator) {
        Object object;
        Object object2;
        Segment segment;
        if (iterator == null) {
            return false;
        }
        this.init();
        Iterator iterator2 = iterator;
        Iterator iterator3 = null;
        Object object3 = this.segments[this.segments.length - 1];
        for (int i = 0; i < this.segments.length; ++i) {
            if (i == this.segments.length - 1) {
                iterator3 = iterator2;
                break;
            }
            segment = this.segments[i];
            if (i == this.segments.length - 2 && object3 instanceof FilterSegment && segment instanceof PropertySegment) {
                PropertySegment propertySegment;
                object2 = (FilterSegment)object3;
                if (iterator2 instanceof List) {
                    propertySegment = (PropertySegment)segment;
                    iterator3 = ((List)((Object)iterator2)).iterator();
                    while (iterator3.hasNext()) {
                        object3 = iterator3.next();
                        if ((object3 = propertySegment.eval(this, iterator, object3)) instanceof Iterable) {
                            ((FilterSegment)object2).remove(this, iterator, object3);
                            continue;
                        }
                        if (!(object3 instanceof Map) || !((FilterSegment)object2).filter.apply(this, iterator, iterator2, object3)) continue;
                        iterator3.remove();
                    }
                    return true;
                }
                if (iterator2 instanceof Map) {
                    propertySegment = (PropertySegment)segment;
                    object = propertySegment.eval(this, iterator, iterator2);
                    if (object == null) {
                        return false;
                    }
                    if (object instanceof Map && ((FilterSegment)object2).filter.apply(this, iterator, iterator2, object)) {
                        propertySegment.remove(this, iterator2);
                        return true;
                    }
                }
            }
            if ((iterator2 = segment.eval(this, iterator, iterator2)) == null) break;
        }
        if (iterator3 == null) {
            return false;
        }
        if (object3 instanceof PropertySegment) {
            PropertySegment propertySegment = (PropertySegment)object3;
            if (iterator3 instanceof Collection && this.segments.length > 1 && ((segment = this.segments[this.segments.length - 2]) instanceof RangeSegment || segment instanceof MultiIndexSegment)) {
                object2 = (Collection)((Object)iterator3);
                boolean bl = false;
                object = object2.iterator();
                while (object.hasNext()) {
                    iterator3 = object.next();
                    if (!propertySegment.remove(this, iterator3)) continue;
                    bl = true;
                }
                return bl;
            }
            return propertySegment.remove(this, iterator3);
        }
        if (object3 instanceof ArrayAccessSegment) {
            return ((ArrayAccessSegment)object3).remove(this, iterator3);
        }
        if (object3 instanceof FilterSegment) {
            return ((FilterSegment)object3).remove(this, iterator, iterator3);
        }
        throw new UnsupportedOperationException();
    }

    public boolean set(Object object, Object object2) {
        return this.set(object, object2, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean set(Object object, Object object2, boolean bl) {
        if (object == null) {
            return false;
        }
        this.init();
        Object object3 = object;
        Object object4 = null;
        for (int i = 0; i < this.segments.length; ++i) {
            object4 = object3;
            Segment segment = this.segments[i];
            if ((object3 = segment.eval(this, object, object3)) != null) continue;
            object3 = null;
            if (i < this.segments.length - 1) {
                object3 = this.segments[i + 1];
            }
            Class<?> clazz = null;
            if (object3 instanceof PropertySegment) {
                object3 = null;
                clazz = null;
                if (segment instanceof PropertySegment) {
                    String string = ((PropertySegment)segment).propertyName;
                    Object object5 = object4.getClass();
                    if ((object5 = this.getJavaBeanDeserializer((Class<?>)object5)) != null) {
                        clazz = ((JavaBeanDeserializer)object5).getFieldDeserializer((String)string).fieldInfo.fieldClass;
                        object3 = this.getJavaBeanDeserializer(clazz);
                    }
                }
                if (object3 != null) {
                    if (((JavaBeanDeserializer)object3).beanInfo.defaultConstructor == null) return false;
                    clazz = ((JavaBeanDeserializer)object3).createInstance(null, clazz);
                } else {
                    clazz = new JSONObject();
                }
            } else if (object3 instanceof ArrayAccessSegment) {
                clazz = new JSONArray();
            }
            if (clazz == null) break;
            if (segment instanceof PropertySegment) {
                ((PropertySegment)segment).setValue(this, object4, clazz);
                object3 = clazz;
                continue;
            }
            if (!(segment instanceof ArrayAccessSegment)) break;
            ((ArrayAccessSegment)segment).setValue(this, object4, clazz);
            object3 = clazz;
        }
        if (object4 == null) {
            return false;
        }
        Segment segment = this.segments[this.segments.length - 1];
        if (segment instanceof PropertySegment) {
            ((PropertySegment)segment).setValue(this, object4, object2);
            return true;
        }
        if (!(segment instanceof ArrayAccessSegment)) throw new UnsupportedOperationException();
        return ((ArrayAccessSegment)segment).setValue(this, object4, object2);
    }

    public static Object eval(Object object, String string) {
        return JSONPath.compile(string).eval(object);
    }

    public static int size(Object object, String object2) {
        object2 = JSONPath.compile((String)object2);
        object = ((JSONPath)object2).eval(object);
        return ((JSONPath)object2).evalSize(object);
    }

    public static Set<?> keySet(Object object, String object2) {
        object2 = JSONPath.compile((String)object2);
        object = ((JSONPath)object2).eval(object);
        return ((JSONPath)object2).evalKeySet(object);
    }

    public static boolean contains(Object object, String string) {
        if (object == null) {
            return false;
        }
        return JSONPath.compile(string).contains(object);
    }

    public static boolean containsValue(Object object, String string, Object object2) {
        return JSONPath.compile(string).containsValue(object, object2);
    }

    public static void arrayAdd(Object object, String string, Object ... objectArray) {
        JSONPath.compile(string).arrayAdd(object, objectArray);
    }

    public static boolean set(Object object, String string, Object object2) {
        return JSONPath.compile(string).set(object, object2);
    }

    public static boolean remove(Object object, String string) {
        return JSONPath.compile(string).remove(object);
    }

    public static JSONPath compile(String string) {
        if (string == null) {
            throw new JSONPathException("jsonpath can not be null");
        }
        JSONPath jSONPath = (JSONPath)pathCache.get(string);
        if (jSONPath == null) {
            jSONPath = new JSONPath(string);
            if (pathCache.size() < 1024) {
                pathCache.putIfAbsent(string, jSONPath);
                jSONPath = (JSONPath)pathCache.get(string);
            }
        }
        return jSONPath;
    }

    public static Object read(String string, String string2) {
        return JSONPath.compile(string2).eval(JSON.parse(string));
    }

    public static Object extract(String object, String object2, ParserConfig parserConfig, int n, Feature ... featureArray) {
        object = new DefaultJSONParser((String)object, parserConfig, n |= Feature.OrderedField.mask);
        object2 = JSONPath.compile((String)object2).extract((DefaultJSONParser)object);
        ((DefaultJSONParser)object).lexer.close();
        return object2;
    }

    public static Object extract(String string, String string2) {
        return JSONPath.extract(string, string2, ParserConfig.global, JSON.DEFAULT_PARSER_FEATURE, new Feature[0]);
    }

    public static Map<String, Object> paths(Object object) {
        return JSONPath.paths(object, SerializeConfig.globalInstance);
    }

    public static Map<String, Object> paths(Object object, SerializeConfig serializeConfig) {
        IdentityHashMap<Object, String> identityHashMap = new IdentityHashMap<Object, String>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        JSONPath.paths(identityHashMap, hashMap, "/", object, serializeConfig);
        return hashMap;
    }

    private static void paths(Map<Object, String> map, Map<String, Object> map2, String string, Object entry3, SerializeConfig serializeConfig) {
        Object object;
        if (entry3 == null) {
            return;
        }
        if (map.put(entry3, string) != null && !((object = entry3.getClass()) == String.class || object == Boolean.class || object == Character.class || object == UUID.class || ((Class)object).isEnum() || entry3 instanceof Number || entry3 instanceof Date)) {
            return;
        }
        map2.put(string, entry3);
        if (entry3 instanceof Map) {
            for (Map.Entry entry2 : ((Map)((Object)entry3)).entrySet()) {
                Object k = entry2.getKey();
                if (!(k instanceof String)) continue;
                entry3 = string.equals("/") ? "/".concat(String.valueOf(k)) : string + "/" + k;
                JSONPath.paths(map, map2, (String)((Object)entry3), entry2.getValue(), serializeConfig);
            }
            return;
        }
        if (entry3 instanceof Collection) {
            object = (Collection)((Object)entry3);
            int n = 0;
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                String string2 = string.equals("/") ? "/".concat(String.valueOf(n)) : string + "/" + n;
                JSONPath.paths(map, map2, string2, e, serializeConfig);
                ++n;
            }
            return;
        }
        object = entry3.getClass();
        if (((Class)object).isArray()) {
            int n = Array.getLength(entry3);
            for (int i = 0; i < n; ++i) {
                Object object2 = Array.get(entry3, i);
                String string3 = string.equals("/") ? "/".concat(String.valueOf(i)) : string + "/" + i;
                JSONPath.paths(map, map2, string3, object2, serializeConfig);
            }
            return;
        }
        if (ParserConfig.isPrimitive2(object) || ((Class)object).isEnum()) {
            return;
        }
        ObjectSerializer objectSerializer = serializeConfig.getObjectWriter((Class<?>)object);
        if (objectSerializer instanceof JavaBeanSerializer) {
            object = (JavaBeanSerializer)objectSerializer;
            try {
                for (Map.Entry<String, Object> entry3 : ((JavaBeanSerializer)object).getFieldValuesMap(entry3).entrySet()) {
                    object = entry3.getKey();
                    if (!(object instanceof String)) continue;
                    object = string.equals("/") ? "/".concat(String.valueOf(object)) : string + "/" + (String)object;
                    JSONPath.paths(map, map2, (String)object, entry3.getValue(), serializeConfig);
                }
                return;
            }
            catch (Exception exception) {
                throw new JSONException("toJSON error", exception);
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    static int compare(Object object, Object object2) {
        if (object.getClass() == object2.getClass()) {
            return ((Comparable)object).compareTo(object2);
        }
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = object2.getClass();
        if (clazz == BigDecimal.class) {
            if (clazz2 == Integer.class) {
                object2 = new BigDecimal((Integer)object2);
            } else if (clazz2 == Long.class) {
                object2 = new BigDecimal((Long)object2);
            } else if (clazz2 == Float.class) {
                object2 = new BigDecimal(((Float)object2).floatValue());
            } else if (clazz2 == Double.class) {
                object2 = new BigDecimal((Double)object2);
            }
        } else if (clazz == Long.class) {
            if (clazz2 == Integer.class) {
                object2 = new Long(((Integer)object2).intValue());
            } else if (clazz2 == BigDecimal.class) {
                object = new BigDecimal((Long)object);
            } else if (clazz2 == Float.class) {
                object = new Float(((Long)object).longValue());
            } else if (clazz2 == Double.class) {
                object = new Double(((Long)object).longValue());
            }
        } else if (clazz == Integer.class) {
            if (clazz2 == Long.class) {
                object = new Long(((Integer)object).intValue());
            } else if (clazz2 == BigDecimal.class) {
                object = new BigDecimal((Integer)object);
            } else if (clazz2 == Float.class) {
                object = new Float(((Integer)object).intValue());
            } else if (clazz2 == Double.class) {
                object = new Double(((Integer)object).intValue());
            }
        } else if (clazz == Double.class) {
            if (clazz2 == Integer.class) {
                object2 = new Double(((Integer)object2).intValue());
            } else if (clazz2 == Long.class) {
                object2 = new Double(((Long)object2).longValue());
            } else if (clazz2 == Float.class) {
                object2 = new Double(((Float)object2).floatValue());
            }
        } else if (clazz == Float.class) {
            if (clazz2 == Integer.class) {
                object2 = new Float(((Integer)object2).intValue());
            } else if (clazz2 == Long.class) {
                object2 = new Float(((Long)object2).longValue());
            } else if (clazz2 == Double.class) {
                object = new Double(((Float)object).floatValue());
            }
        }
        return ((Comparable)object).compareTo(object2);
    }

    protected Object getArrayItem(Object object, int n) {
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (n >= 0) {
                if (n < list.size()) {
                    return list.get(n);
                }
                return null;
            }
            if (Math.abs(n) <= list.size()) {
                List list2 = list;
                return list2.get(list2.size() + n);
            }
            return null;
        }
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            if (n >= 0) {
                if (n < n2) {
                    return Array.get(object, n);
                }
                return null;
            }
            if (Math.abs(n) <= n2) {
                return Array.get(object, n2 + n);
            }
            return null;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if ((object = map.get(n)) == null) {
                object = map.get(Integer.toString(n));
            }
            return object;
        }
        if (object instanceof Collection) {
            Object object2 = (Collection)object;
            int n3 = 0;
            object2 = object2.iterator();
            while (object2.hasNext()) {
                Object e = object2.next();
                if (n3 == n) {
                    return e;
                }
                ++n3;
            }
            return null;
        }
        if (n == 0) {
            return object;
        }
        throw new UnsupportedOperationException();
    }

    public boolean setArrayItem(JSONPath clazz, Object object, int n, Object object2) {
        if (object instanceof List) {
            clazz = (List)object;
            if (n >= 0) {
                clazz.set(n, (Object)object2);
            } else {
                Class<?> clazz2 = clazz;
                clazz2.set(clazz2.size() + n, (Object)object2);
            }
            return true;
        }
        clazz = object.getClass();
        if (clazz.isArray()) {
            int n2 = Array.getLength(object);
            if (n >= 0) {
                if (n < n2) {
                    Array.set(object, n, object2);
                }
            } else if (Math.abs(n) <= n2) {
                Array.set(object, n2 + n, object2);
            }
            return true;
        }
        throw new JSONPathException("unsupported set operation.".concat(String.valueOf(clazz)));
    }

    public boolean removeArrayItem(JSONPath clazz, Object object, int n) {
        if (object instanceof List) {
            clazz = (List)object;
            if (n >= 0) {
                if (n >= clazz.size()) {
                    return false;
                }
                clazz.remove(n);
            } else {
                int n2 = clazz.size() + n;
                if (n2 < 0) {
                    return false;
                }
                clazz.remove(n2);
            }
            return true;
        }
        clazz = object.getClass();
        throw new JSONPathException("unsupported set operation.".concat(String.valueOf(clazz)));
    }

    protected Collection<Object> getPropertyValues(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = object.getClass();
        if ((object2 = this.getJavaBeanSerializer((Class<?>)object2)) != null) {
            try {
                return ((JavaBeanSerializer)object2).getFieldValues(object);
            }
            catch (Exception exception) {
                throw new JSONPathException("jsonpath error, path " + this.path, exception);
            }
        }
        if (object instanceof Map) {
            return ((Map)object).values();
        }
        if (object instanceof Collection) {
            return (Collection)object;
        }
        throw new UnsupportedOperationException();
    }

    protected void deepGetPropertyValues(Object iterator, List<Object> list) {
        Object object2 = iterator.getClass();
        JavaBeanSerializer javaBeanSerializer = this.getJavaBeanSerializer((Class<?>)object2);
        Collection<Object> collection = null;
        if (javaBeanSerializer != null) {
            try {
                collection = javaBeanSerializer.getFieldValues(iterator);
            }
            catch (Exception exception) {
                throw new JSONPathException("jsonpath error, path " + this.path, exception);
            }
        } else if (iterator instanceof Map) {
            collection = ((Map)((Object)iterator)).values();
        } else if (iterator instanceof Collection) {
            collection = (Collection)((Object)iterator);
        }
        if (collection != null) {
            for (Object object2 : collection) {
                if (object2 == null || ParserConfig.isPrimitive2(object2.getClass())) {
                    list.add(object2);
                    continue;
                }
                this.deepGetPropertyValues(object2, list);
            }
            return;
        }
        throw new UnsupportedOperationException(((Class)object2).getName());
    }

    static boolean eq(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object.getClass() == object2.getClass()) {
            return object.equals(object2);
        }
        if (object instanceof Number) {
            if (object2 instanceof Number) {
                return JSONPath.eqNotNull((Number)object, (Number)object2);
            }
            return false;
        }
        return object.equals(object2);
    }

    static boolean eqNotNull(Number number, Number number2) {
        Number number3;
        Serializable serializable = number.getClass();
        boolean bl = JSONPath.isInt(serializable);
        Class<?> clazz = number2.getClass();
        boolean bl2 = JSONPath.isInt(clazz);
        if (number instanceof BigDecimal) {
            number3 = (BigDecimal)number;
            if (bl2) {
                return ((BigDecimal)number3).equals(BigDecimal.valueOf(TypeUtils.longExtractValue(number2)));
            }
        }
        if (bl) {
            if (bl2) {
                return number.longValue() == number2.longValue();
            }
            if (number2 instanceof BigInteger) {
                number3 = (BigInteger)number;
                return BigInteger.valueOf(number.longValue()).equals(number3);
            }
        }
        if (bl2 && number instanceof BigInteger) {
            number3 = (BigInteger)number;
            serializable = BigInteger.valueOf(TypeUtils.longExtractValue(number2));
            return ((BigInteger)number3).equals(serializable);
        }
        boolean bl3 = JSONPath.isDouble(serializable);
        boolean bl4 = JSONPath.isDouble(clazz);
        if (bl3 && bl4 || bl3 && bl2 || bl4 && bl) {
            return number.doubleValue() == number2.doubleValue();
        }
        return false;
    }

    protected static boolean isDouble(Class<?> clazz) {
        return clazz == Float.class || clazz == Double.class;
    }

    protected static boolean isInt(Class<?> clazz) {
        return clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class;
    }

    protected Object getPropertyValue(Object object, String string, long l) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            try {
                object = JSON.parseObject((String)object);
            }
            catch (Exception exception) {}
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Object object2 = map.get(string);
            if (object2 == null && (5614464919154503228L == l || -1580386065683472715L == l)) {
                object2 = map.size();
            }
            return object2;
        }
        Class<?> clazz = object.getClass();
        JavaBeanSerializer javaBeanSerializer = this.getJavaBeanSerializer(clazz);
        if (javaBeanSerializer != null) {
            try {
                return javaBeanSerializer.getFieldValue(object, string, l, false);
            }
            catch (Exception exception) {
                throw new JSONPathException("jsonpath error, path " + this.path + ", segement " + string, exception);
            }
        }
        if (object instanceof List) {
            object = (List)object;
            if (5614464919154503228L == l || -1580386065683472715L == l) {
                return object.size();
            }
            clazz = null;
            for (int i = 0; i < object.size(); ++i) {
                Object object3 = object.get(i);
                if (object3 == object) {
                    if (clazz == null) {
                        clazz = new JSONArray(object.size());
                    }
                    clazz.add(object3);
                    continue;
                }
                if ((object3 = this.getPropertyValue(object3, string, l)) instanceof Collection) {
                    object3 = (Collection)object3;
                    if (clazz == null) {
                        clazz = new JSONArray(object.size());
                    }
                    clazz.addAll(object3);
                    continue;
                }
                if (object3 == null) continue;
                if (clazz == null) {
                    clazz = new JSONArray(object.size());
                }
                clazz.add(object3);
            }
            if (clazz == null) {
                clazz = Collections.emptyList();
            }
            return clazz;
        }
        if (object instanceof Object[]) {
            object = (Object[])object;
            if (5614464919154503228L == l || -1580386065683472715L == l) {
                return ((Object[])object).length;
            }
            clazz = new JSONArray(((Object)object).length);
            for (int i = 0; i < ((Object)object).length; ++i) {
                Object object4 = object[i];
                if (object4 == object) {
                    clazz.add(object4);
                    continue;
                }
                if ((object4 = this.getPropertyValue(object4, string, l)) instanceof Collection) {
                    object4 = (Collection)object4;
                    clazz.addAll(object4);
                    continue;
                }
                if (object4 == null) continue;
                clazz.add(object4);
            }
            return clazz;
        }
        if (object instanceof Enum) {
            Enum enum_ = (Enum)object;
            if (-4270347329889690746L == l) {
                return enum_.name();
            }
            if (-1014497654951707614L == l) {
                return enum_.ordinal();
            }
        }
        if (object instanceof Calendar) {
            object = (Calendar)object;
            if (8963398325558730460L == l) {
                return ((Calendar)object).get(1);
            }
            if (-811277319855450459L == l) {
                return ((Calendar)object).get(2);
            }
            if (-3851359326990528739L == l) {
                return ((Calendar)object).get(5);
            }
            if (4647432019745535567L == l) {
                return ((Calendar)object).get(11);
            }
            if (6607618197526598121L == l) {
                return ((Calendar)object).get(12);
            }
            if (-6586085717218287427L == l) {
                return ((Calendar)object).get(13);
            }
        }
        return null;
    }

    protected void deepScan(Object object3, String string, List<Object> list) {
        if (object3 == null) {
            return;
        }
        if (object3 instanceof Map) {
            for (Map.Entry entry : ((Map)object3).entrySet()) {
                object3 = entry.getValue();
                if (string.equals(entry.getKey())) {
                    if (object3 instanceof Collection) {
                        list.addAll((Collection)object3);
                        continue;
                    }
                    list.add(object3);
                    continue;
                }
                if (object3 == null || ParserConfig.isPrimitive2(object3.getClass())) continue;
                this.deepScan(object3, string, list);
            }
            return;
        }
        if (object3 instanceof Collection) {
            for (Object e : (Collection)object3) {
                if (ParserConfig.isPrimitive2(e.getClass())) continue;
                this.deepScan(e, string, list);
            }
            return;
        }
        Class<?> clazz = object3.getClass();
        Object object2 = this.getJavaBeanSerializer(clazz);
        if (object2 != null) {
            try {
                clazz = ((JavaBeanSerializer)object2).getFieldSerializer(string);
                if (clazz != null) {
                    try {
                        object3 = ((FieldSerializer)((Object)clazz)).getPropertyValueDirect(object3);
                        list.add(object3);
                        return;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new JSONException("getFieldValue error.".concat(String.valueOf(string)), invocationTargetException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new JSONException("getFieldValue error.".concat(String.valueOf(string)), illegalAccessException);
                    }
                }
                for (Object object3 : ((JavaBeanSerializer)object2).getFieldValues(object3)) {
                    this.deepScan(object3, string, list);
                }
                return;
            }
            catch (Exception exception) {
                throw new JSONPathException("jsonpath error, path " + this.path + ", segement " + string, exception);
            }
        }
        if (object3 instanceof List) {
            clazz = (List)object3;
            for (int i = 0; i < clazz.size(); ++i) {
                object2 = clazz.get(i);
                this.deepScan(object2, string, list);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void deepSet(Object iterator, String string, long l, Object object) {
        if (iterator == null) {
            return;
        }
        if (iterator instanceof Map) {
            Map map = (Map)((Object)iterator);
            if (map.containsKey(string)) {
                map.get(string);
                map.put(string, object);
                return;
            }
            for (Object list : map.values()) {
                this.deepSet(list, string, l, object);
            }
            return;
        }
        Class<?> clazz2 = iterator.getClass();
        JavaBeanDeserializer javaBeanDeserializer = this.getJavaBeanDeserializer(clazz2);
        if (javaBeanDeserializer != null) {
            try {
                FieldDeserializer fieldDeserializer = javaBeanDeserializer.getFieldDeserializer(string);
                if (fieldDeserializer != null) {
                    fieldDeserializer.setValue(iterator, object);
                    return;
                }
                for (Object object2 : this.getJavaBeanSerializer(clazz2).getObjectFieldValues(iterator)) {
                    this.deepSet(object2, string, l, object);
                }
                return;
            }
            catch (Exception exception) {
                throw new JSONPathException("jsonpath error, path " + this.path + ", segement " + string, exception);
            }
        }
        if (iterator instanceof List) {
            void var6_10;
            List list = (List)((Object)iterator);
            boolean bl = false;
            while (var6_10 < list.size()) {
                iterator = list.get((int)var6_10);
                this.deepSet(iterator, string, l, object);
                ++var6_10;
            }
            return;
        }
    }

    protected boolean setPropertyValue(Object object, String object2, long l, Object object3) {
        if (object instanceof Map) {
            ((Map)object).put(object2, object3);
            return true;
        }
        if (object instanceof List) {
            for (Object e : (List)object) {
                if (e == null) continue;
                this.setPropertyValue(e, (String)object2, l, object3);
            }
            return true;
        }
        ObjectDeserializer objectDeserializer = this.parserConfig.getDeserializer(object.getClass());
        JavaBeanDeserializer javaBeanDeserializer = null;
        if (objectDeserializer instanceof JavaBeanDeserializer) {
            javaBeanDeserializer = (JavaBeanDeserializer)objectDeserializer;
        }
        if (javaBeanDeserializer != null) {
            object2 = javaBeanDeserializer.getFieldDeserializer(l);
            if (object2 == null) {
                return false;
            }
            if (object3 != null && object3.getClass() != ((FieldDeserializer)object2).fieldInfo.fieldClass) {
                object3 = TypeUtils.cast(object3, ((FieldDeserializer)object2).fieldInfo.fieldType, this.parserConfig);
            }
            ((FieldDeserializer)object2).setValue(object, object3);
            return true;
        }
        throw new UnsupportedOperationException();
    }

    protected boolean removePropertyValue(Object iterator, String string, boolean bl) {
        if (iterator instanceof Map) {
            boolean bl2;
            boolean bl3 = bl2 = ((Map)((Object)iterator)).remove(string) != null;
            if (bl) {
                for (Object v : ((Map)((Object)iterator)).values()) {
                    this.removePropertyValue(v, string, bl);
                }
            }
            return bl2;
        }
        Object object2 = this.parserConfig.getDeserializer(iterator.getClass());
        JavaBeanDeserializer javaBeanDeserializer = null;
        if (object2 instanceof JavaBeanDeserializer) {
            javaBeanDeserializer = (JavaBeanDeserializer)object2;
        }
        if (javaBeanDeserializer != null) {
            object2 = javaBeanDeserializer.getFieldDeserializer(string);
            boolean bl4 = false;
            if (object2 != null) {
                ((FieldDeserializer)object2).setValue((Object)iterator, null);
                bl4 = true;
            }
            if (bl) {
                for (Object object2 : this.getPropertyValues(iterator)) {
                    if (object2 == null) continue;
                    this.removePropertyValue(object2, string, bl);
                }
            }
            return bl4;
        }
        if (bl) {
            return false;
        }
        throw new UnsupportedOperationException();
    }

    protected JavaBeanSerializer getJavaBeanSerializer(Class<?> object) {
        JavaBeanSerializer javaBeanSerializer = null;
        if ((object = this.serializeConfig.getObjectWriter((Class<?>)object)) instanceof JavaBeanSerializer) {
            javaBeanSerializer = (JavaBeanSerializer)object;
        }
        return javaBeanSerializer;
    }

    protected JavaBeanDeserializer getJavaBeanDeserializer(Class<?> object) {
        JavaBeanDeserializer javaBeanDeserializer = null;
        if ((object = this.parserConfig.getDeserializer((Type)object)) instanceof JavaBeanDeserializer) {
            javaBeanDeserializer = (JavaBeanDeserializer)object;
        }
        return javaBeanDeserializer;
    }

    int evalSize(Object iterator) {
        if (iterator == null) {
            return -1;
        }
        if (iterator instanceof Collection) {
            return ((Collection)((Object)iterator)).size();
        }
        if (iterator instanceof Object[]) {
            return ((Object[])iterator).length;
        }
        if (iterator.getClass().isArray()) {
            return Array.getLength(iterator);
        }
        if (iterator instanceof Map) {
            int n = 0;
            iterator = ((Map)((Object)iterator)).values().iterator();
            while (iterator.hasNext()) {
                if (iterator.next() == null) continue;
                ++n;
            }
            return n;
        }
        JavaBeanSerializer javaBeanSerializer = this.getJavaBeanSerializer(iterator.getClass());
        if (javaBeanSerializer == null) {
            return -1;
        }
        try {
            return javaBeanSerializer.getSize(iterator);
        }
        catch (Exception exception) {
            throw new JSONPathException("evalSize error : " + this.path, exception);
        }
    }

    Set<?> evalKeySet(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Map) {
            return ((Map)object).keySet();
        }
        if (object instanceof Collection || object instanceof Object[] || object.getClass().isArray()) {
            return null;
        }
        JavaBeanSerializer javaBeanSerializer = this.getJavaBeanSerializer(object.getClass());
        if (javaBeanSerializer == null) {
            return null;
        }
        try {
            return javaBeanSerializer.getFieldNames(object);
        }
        catch (Exception exception) {
            throw new JSONPathException("evalKeySet error : " + this.path, exception);
        }
    }

    @Override
    public String toJSONString() {
        return JSON.toJSONString(this.path);
    }

    public static Object reserveToArray(Object object, String ... stringArray) {
        JSONArray jSONArray = new JSONArray();
        if (stringArray == null || stringArray.length == 0) {
            return jSONArray;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Object object2 = JSONPath.compile(stringArray[i]);
            ((JSONPath)object2).init();
            object2 = ((JSONPath)object2).eval(object);
            jSONArray.add(object2);
        }
        return jSONArray;
    }

    public static Object reserveToObject(Object object, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return object;
        }
        JSONObject jSONObject = new JSONObject(true);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Object object2;
            JSONPath jSONPath = JSONPath.compile(stringArray[i]);
            jSONPath.init();
            if (!(jSONPath.segments[jSONPath.segments.length - 1] instanceof PropertySegment) || (object2 = jSONPath.eval(object)) == null) continue;
            jSONPath.set(jSONObject, object2);
        }
        return jSONObject;
    }

    static class FilterGroup
    implements Filter {
        private boolean and;
        private List<Filter> fitlers = new ArrayList<Filter>(2);

        public FilterGroup(Filter filter, Filter filter2, boolean bl) {
            this.fitlers.add(filter);
            this.fitlers.add(filter2);
            this.and = bl;
        }

        @Override
        public boolean apply(JSONPath jSONPath, Object object, Object object2, Object object3) {
            if (this.and) {
                Iterator<Filter> iterator = this.fitlers.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().apply(jSONPath, object, object2, object3)) continue;
                    return false;
                }
                return true;
            }
            Iterator<Filter> iterator = this.fitlers.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().apply(jSONPath, object, object2, object3)) continue;
                return true;
            }
            return false;
        }
    }

    static interface Filter {
        public boolean apply(JSONPath var1, Object var2, Object var3, Object var4);
    }

    public static class FilterSegment
    implements Segment {
        private final Filter filter;

        public FilterSegment(Filter filter) {
            this.filter = filter;
        }

        @Override
        public Object eval(JSONPath jSONPath, Object object, Object object2) {
            if (object2 == null) {
                return null;
            }
            JSONArray jSONArray = new JSONArray();
            if (object2 instanceof Iterable) {
                for (Object t : (Iterable)object2) {
                    if (!this.filter.apply(jSONPath, object, object2, t)) continue;
                    jSONArray.add(t);
                }
                return jSONArray;
            }
            Object object3 = object2;
            if (this.filter.apply(jSONPath, object, object3, object3)) {
                return object2;
            }
            return null;
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser object, Context context) {
            Object object2 = object = ((DefaultJSONParser)object).parse();
            context.object = this.eval(jSONPath, object2, object2);
        }

        public boolean remove(JSONPath jSONPath, Object object, Object object2) {
            if (object2 == null) {
                return false;
            }
            if (object2 instanceof Iterable) {
                Iterator iterator = ((Iterable)object2).iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    if (!this.filter.apply(jSONPath, object, object2, t)) continue;
                    iterator.remove();
                }
                return true;
            }
            return false;
        }
    }

    static enum Operator {
        EQ,
        NE,
        GT,
        GE,
        LT,
        LE,
        LIKE,
        NOT_LIKE,
        RLIKE,
        NOT_RLIKE,
        IN,
        NOT_IN,
        BETWEEN,
        NOT_BETWEEN,
        And,
        Or,
        REG_MATCH;

    }

    static class RegMatchSegement
    extends PropertyFilter {
        private final Pattern pattern;
        private final Operator op;

        public RegMatchSegement(String string, boolean bl, Pattern pattern, Operator operator) {
            super(string, bl);
            this.pattern = pattern;
            this.op = operator;
        }

        @Override
        public boolean apply(JSONPath object, Object object2, Object object3, Object object4) {
            if ((object = this.get((JSONPath)object, object2, object4)) == null) {
                return false;
            }
            object = object.toString();
            return this.pattern.matcher((CharSequence)object).matches();
        }
    }

    static class StringOpSegement
    extends PropertyFilter {
        private final String value;
        private final Operator op;

        public StringOpSegement(String string, boolean bl, String string2, Operator operator) {
            super(string, bl);
            this.value = string2;
            this.op = operator;
        }

        @Override
        public boolean apply(JSONPath object, Object object2, Object object3, Object object4) {
            object = this.get((JSONPath)object, object2, object4);
            if (this.op == Operator.EQ) {
                return this.value.equals(object);
            }
            if (this.op == Operator.NE) {
                return !this.value.equals(object);
            }
            if (object == null) {
                return false;
            }
            int n = this.value.compareTo(object.toString());
            if (this.op == Operator.GE) {
                return n <= 0;
            }
            if (this.op == Operator.GT) {
                return n < 0;
            }
            if (this.op == Operator.LE) {
                return n >= 0;
            }
            if (this.op == Operator.LT) {
                return n > 0;
            }
            return false;
        }
    }

    static class RlikeSegement
    extends PropertyFilter {
        private final Pattern pattern;
        private final boolean not;

        public RlikeSegement(String string, boolean bl, String string2, boolean bl2) {
            super(string, bl);
            this.pattern = Pattern.compile(string2);
            this.not = bl2;
        }

        @Override
        public boolean apply(JSONPath object, Object object2, Object object3, Object object4) {
            if ((object = this.get((JSONPath)object, object2, object4)) == null) {
                return false;
            }
            object = object.toString();
            boolean bl = this.pattern.matcher((CharSequence)object).matches();
            if (this.not) {
                bl = !bl;
            }
            return bl;
        }
    }

    static class MatchSegement
    extends PropertyFilter {
        private final String startsWithValue;
        private final String endsWithValue;
        private final String[] containsValues;
        private final int minLength;
        private final boolean not;

        public MatchSegement(String string, boolean bl, String string2, String string3, String[] object, boolean bl2) {
            super(string, bl);
            this.startsWithValue = string2;
            this.endsWithValue = string3;
            this.containsValues = object;
            this.not = bl2;
            int n = 0;
            if (string2 != null) {
                n = 0 + string2.length();
            }
            if (string3 != null) {
                n += string3.length();
            }
            if (object != null) {
                String[] stringArray = object;
                int n2 = ((String[])object).length;
                for (int i = 0; i < n2; ++i) {
                    object = stringArray[i];
                    n += ((String)object).length();
                }
            }
            this.minLength = n;
        }

        @Override
        public boolean apply(JSONPath object, Object object2, Object stringArray, Object object3) {
            if ((object = this.get((JSONPath)object, object2, object3)) == null) {
                return false;
            }
            if (((String)(object = object.toString())).length() < this.minLength) {
                return this.not;
            }
            int n = 0;
            if (this.startsWithValue != null) {
                if (!((String)object).startsWith(this.startsWithValue)) {
                    return this.not;
                }
                n = 0 + this.startsWithValue.length();
            }
            if (this.containsValues != null) {
                stringArray = this.containsValues;
                int n2 = this.containsValues.length;
                for (int i = 0; i < n2; ++i) {
                    String string = stringArray[i];
                    if ((n = ((String)object).indexOf(string, n)) == -1) {
                        return this.not;
                    }
                    n += string.length();
                }
            }
            if (this.endsWithValue != null && !((String)object).endsWith(this.endsWithValue)) {
                return this.not;
            }
            return !this.not;
        }
    }

    static class RefOpSegement
    extends PropertyFilter {
        private final Segment refSgement;
        private final Operator op;

        public RefOpSegement(String string, boolean bl, Segment segment, Operator operator) {
            super(string, bl);
            this.refSgement = segment;
            this.op = operator;
        }

        @Override
        public boolean apply(JSONPath object, Object object2, Object object3, Object object4) {
            object3 = this.get((JSONPath)object, object2, object4);
            if (object3 == null) {
                return false;
            }
            if (!(object3 instanceof Number)) {
                return false;
            }
            Object object5 = object2;
            if ((object = this.refSgement.eval((JSONPath)object, object5, object5)) instanceof Integer || object instanceof Long || object instanceof Short || object instanceof Byte) {
                long l = TypeUtils.longExtractValue((Number)object);
                if (object3 instanceof Integer || object3 instanceof Long || object3 instanceof Short || object3 instanceof Byte) {
                    long l2 = TypeUtils.longExtractValue((Number)object3);
                    switch (this.op) {
                        case EQ: {
                            return l2 == l;
                        }
                        case NE: {
                            return l2 != l;
                        }
                        case GE: {
                            return l2 >= l;
                        }
                        case GT: {
                            return l2 > l;
                        }
                        case LE: {
                            return l2 <= l;
                        }
                        case LT: {
                            return l2 < l;
                        }
                    }
                } else if (object3 instanceof BigDecimal) {
                    int n = BigDecimal.valueOf(l).compareTo((BigDecimal)object3);
                    switch (this.op) {
                        case EQ: {
                            return n == 0;
                        }
                        case NE: {
                            return n != 0;
                        }
                        case GE: {
                            return n <= 0;
                        }
                        case GT: {
                            return n < 0;
                        }
                        case LE: {
                            return n >= 0;
                        }
                        case LT: {
                            return n > 0;
                        }
                    }
                    return false;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    static class DoubleOpSegement
    extends PropertyFilter {
        private final double value;
        private final Operator op;

        public DoubleOpSegement(String string, boolean bl, double d, Operator operator) {
            super(string, bl);
            this.value = d;
            this.op = operator;
        }

        @Override
        public boolean apply(JSONPath object, Object object2, Object object3, Object object4) {
            if ((object = this.get((JSONPath)object, object2, object4)) == null) {
                return false;
            }
            if (!(object instanceof Number)) {
                return false;
            }
            double d = ((Number)object).doubleValue();
            switch (this.op) {
                case EQ: {
                    return d == this.value;
                }
                case NE: {
                    return d != this.value;
                }
                case GE: {
                    return d >= this.value;
                }
                case GT: {
                    return d > this.value;
                }
                case LE: {
                    return d <= this.value;
                }
                case LT: {
                    return d < this.value;
                }
            }
            return false;
        }
    }

    static abstract class PropertyFilter
    implements Filter {
        static long TYPE = TypeUtils.fnv1a_64("type");
        protected final String propertyName;
        protected final long propertyNameHash;
        protected final boolean function;
        protected Segment functionExpr;

        protected PropertyFilter(String string, boolean bl) {
            this.propertyName = string;
            this.propertyNameHash = TypeUtils.fnv1a_64(string);
            this.function = bl;
            if (bl) {
                if (this.propertyNameHash == TYPE) {
                    this.functionExpr = TypeSegment.instance;
                    return;
                }
                if (this.propertyNameHash == 5614464919154503228L) {
                    this.functionExpr = SizeSegment.instance;
                    return;
                }
                throw new JSONPathException("unsupported funciton : ".concat(String.valueOf(string)));
            }
        }

        protected Object get(JSONPath jSONPath, Object object, Object object2) {
            if (this.functionExpr != null) {
                return this.functionExpr.eval(jSONPath, object, object2);
            }
            return jSONPath.getPropertyValue(object2, this.propertyName, this.propertyNameHash);
        }
    }

    static class IntOpSegement
    extends PropertyFilter {
        private final long value;
        private final Operator op;
        private BigDecimal valueDecimal;
        private Float valueFloat;
        private Double valueDouble;

        public IntOpSegement(String string, boolean bl, long l, Operator operator) {
            super(string, bl);
            this.value = l;
            this.op = operator;
        }

        @Override
        public boolean apply(JSONPath object, Object object2, Object object3, Object object4) {
            if ((object = this.get((JSONPath)object, object2, object4)) == null) {
                return false;
            }
            if (!(object instanceof Number)) {
                return false;
            }
            if (object instanceof BigDecimal) {
                if (this.valueDecimal == null) {
                    this.valueDecimal = BigDecimal.valueOf(this.value);
                }
                int n = this.valueDecimal.compareTo((BigDecimal)object);
                switch (this.op) {
                    case EQ: {
                        return n == 0;
                    }
                    case NE: {
                        return n != 0;
                    }
                    case GE: {
                        return n <= 0;
                    }
                    case GT: {
                        return n < 0;
                    }
                    case LE: {
                        return n >= 0;
                    }
                    case LT: {
                        return n > 0;
                    }
                }
                return false;
            }
            if (object instanceof Float) {
                if (this.valueFloat == null) {
                    this.valueFloat = Float.valueOf(this.value);
                }
                int n = this.valueFloat.compareTo((Float)object);
                switch (this.op) {
                    case EQ: {
                        return n == 0;
                    }
                    case NE: {
                        return n != 0;
                    }
                    case GE: {
                        return n <= 0;
                    }
                    case GT: {
                        return n < 0;
                    }
                    case LE: {
                        return n >= 0;
                    }
                    case LT: {
                        return n > 0;
                    }
                }
                return false;
            }
            if (object instanceof Double) {
                if (this.valueDouble == null) {
                    this.valueDouble = this.value;
                }
                int n = this.valueDouble.compareTo((Double)object);
                switch (this.op) {
                    case EQ: {
                        return n == 0;
                    }
                    case NE: {
                        return n != 0;
                    }
                    case GE: {
                        return n <= 0;
                    }
                    case GT: {
                        return n < 0;
                    }
                    case LE: {
                        return n >= 0;
                    }
                    case LT: {
                        return n > 0;
                    }
                }
                return false;
            }
            long l = TypeUtils.longExtractValue((Number)object);
            switch (this.op) {
                case EQ: {
                    return l == this.value;
                }
                case NE: {
                    return l != this.value;
                }
                case GE: {
                    return l >= this.value;
                }
                case GT: {
                    return l > this.value;
                }
                case LE: {
                    return l <= this.value;
                }
                case LT: {
                    return l < this.value;
                }
            }
            return false;
        }
    }

    static class StringInSegement
    extends PropertyFilter {
        private final String[] values;
        private final boolean not;

        public StringInSegement(String string, boolean bl, String[] stringArray, boolean bl2) {
            super(string, bl);
            this.values = stringArray;
            this.not = bl2;
        }

        @Override
        public boolean apply(JSONPath object, Object stringArray, Object object2, Object object3) {
            object = this.get((JSONPath)object, stringArray, object3);
            stringArray = this.values;
            int n = this.values.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                if (string == object) {
                    return !this.not;
                }
                if (string == null || !string.equals(object)) continue;
                return !this.not;
            }
            return this.not;
        }
    }

    static class IntObjInSegement
    extends PropertyFilter {
        private final Long[] values;
        private final boolean not;

        public IntObjInSegement(String string, boolean bl, Long[] longArray, boolean bl2) {
            super(string, bl);
            this.values = longArray;
            this.not = bl2;
        }

        @Override
        public boolean apply(JSONPath longArray, Object object, Object object2, Object object3) {
            if ((longArray = this.get((JSONPath)longArray, object, object3)) == null) {
                Long[] longArray2 = this.values;
                int n = this.values.length;
                for (int i = 0; i < n; ++i) {
                    if (longArray2[i] != null) continue;
                    return !this.not;
                }
                return this.not;
            }
            if (longArray instanceof Number) {
                long l = TypeUtils.longExtractValue((Number)longArray);
                longArray = this.values;
                int n = this.values.length;
                for (int i = 0; i < n; ++i) {
                    object3 = longArray[i];
                    if (object3 == null || (Long)object3 != l) continue;
                    return !this.not;
                }
            }
            return this.not;
        }
    }

    static class IntBetweenSegement
    extends PropertyFilter {
        private final long startValue;
        private final long endValue;
        private final boolean not;

        public IntBetweenSegement(String string, boolean bl, long l, long l2, boolean bl2) {
            super(string, bl);
            this.startValue = l;
            this.endValue = l2;
            this.not = bl2;
        }

        @Override
        public boolean apply(JSONPath object, Object object2, Object object3, Object object4) {
            long l;
            if ((object = this.get((JSONPath)object, object2, object4)) == null) {
                return false;
            }
            if (object instanceof Number && (l = TypeUtils.longExtractValue((Number)object)) >= this.startValue && l <= this.endValue) {
                return !this.not;
            }
            return this.not;
        }
    }

    static class IntInSegement
    extends PropertyFilter {
        private final long[] values;
        private final boolean not;

        public IntInSegement(String string, boolean bl, long[] lArray, boolean bl2) {
            super(string, bl);
            this.values = lArray;
            this.not = bl2;
        }

        @Override
        public boolean apply(JSONPath object, Object object2, Object object3, Object object4) {
            if ((object = this.get((JSONPath)object, object2, object4)) == null) {
                return false;
            }
            if (object instanceof Number) {
                long l = TypeUtils.longExtractValue((Number)object);
                object = this.values;
                int n = this.values.length;
                for (int i = 0; i < n; ++i) {
                    if (object[i] != l) continue;
                    return !this.not;
                }
            }
            return this.not;
        }
    }

    static class ValueSegment
    extends PropertyFilter {
        private final Object value;
        private boolean eq = true;

        public ValueSegment(String string, boolean bl, Object object, boolean bl2) {
            super(string, bl);
            if (object == null) {
                throw new IllegalArgumentException("value is null");
            }
            this.value = object;
            this.eq = bl2;
        }

        @Override
        public boolean apply(JSONPath object, Object object2, Object object3, Object object4) {
            object = this.get((JSONPath)object, object2, object4);
            boolean bl = this.value.equals(object);
            if (!this.eq) {
                bl = !bl;
            }
            return bl;
        }
    }

    static class NullSegement
    extends PropertyFilter {
        public NullSegement(String string, boolean bl) {
            super(string, bl);
        }

        @Override
        public boolean apply(JSONPath jSONPath, Object object, Object object2, Object object3) {
            return this.get(jSONPath, object, object3) == null;
        }
    }

    static class NotNullSegement
    extends PropertyFilter {
        public NotNullSegement(String string, boolean bl) {
            super(string, bl);
        }

        @Override
        public boolean apply(JSONPath jSONPath, Object object, Object object2, Object object3) {
            return jSONPath.getPropertyValue(object3, this.propertyName, this.propertyNameHash) != null;
        }
    }

    static class RangeSegment
    implements Segment {
        private final int start;
        private final int end;
        private final int step;

        public RangeSegment(int n, int n2, int n3) {
            this.start = n;
            this.end = n2;
            this.step = n3;
        }

        @Override
        public Object eval(JSONPath jSONPath, Object object, Object object2) {
            int n;
            int n2 = SizeSegment.instance.eval(jSONPath, object, object2);
            int n3 = this.end >= 0 ? this.end : this.end + n2;
            int n4 = (n3 - (n = this.start >= 0 ? this.start : this.start + n2)) / this.step + 1;
            if (n4 == -1) {
                return null;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(n4);
            while (n <= n3 && n < n2) {
                Object object3 = jSONPath.getArrayItem(object2, n);
                arrayList.add(object3);
                n += this.step;
            }
            return arrayList;
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser defaultJSONParser, Context context) {
            throw new UnsupportedOperationException();
        }
    }

    static class MultiIndexSegment
    implements Segment {
        private final int[] indexes;

        public MultiIndexSegment(int[] nArray) {
            this.indexes = nArray;
        }

        @Override
        public Object eval(JSONPath jSONPath, Object object, Object object2) {
            object = new JSONArray(this.indexes.length);
            for (int i = 0; i < this.indexes.length; ++i) {
                Object object3 = jSONPath.getArrayItem(object2, this.indexes[i]);
                object.add(object3);
            }
            return object;
        }

        @Override
        public void extract(JSONPath object, DefaultJSONParser object2, Context context) {
            if (context.eval && (object = ((DefaultJSONParser)object2).parse()) instanceof List) {
                object2 = new int[this.indexes.length];
                System.arraycopy(this.indexes, 0, object2, 0, ((Object)object2).length);
                int n = object2[0] >= 0 ? 1 : 0;
                object = (List)object;
                if (n != 0) {
                    for (n = object.size() - 1; n >= 0; --n) {
                        if (Arrays.binarySearch((int[])object2, n) >= 0) continue;
                        object.remove(n);
                    }
                    context.object = object;
                    return;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    static class ArrayAccessSegment
    implements Segment {
        private final int index;

        public ArrayAccessSegment(int n) {
            this.index = n;
        }

        @Override
        public Object eval(JSONPath jSONPath, Object object, Object object2) {
            return jSONPath.getArrayItem(object2, this.index);
        }

        public boolean setValue(JSONPath jSONPath, Object object, Object object2) {
            JSONPath jSONPath2 = jSONPath;
            return jSONPath2.setArrayItem(jSONPath2, object, this.index, object2);
        }

        public boolean remove(JSONPath jSONPath, Object object) {
            JSONPath jSONPath2 = jSONPath;
            return jSONPath2.removeArrayItem(jSONPath2, object, this.index);
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser defaultJSONParser, Context context) {
            if (((JSONLexerBase)defaultJSONParser.lexer).seekArrayToItem(this.index) && context.eval) {
                context.object = defaultJSONParser.parse();
            }
        }

        static /* synthetic */ int access$200(ArrayAccessSegment arrayAccessSegment) {
            return arrayAccessSegment.index;
        }
    }

    static class WildCardSegment
    implements Segment {
        private boolean deep;
        public static final WildCardSegment instance = new WildCardSegment(false);
        public static final WildCardSegment instance_deep = new WildCardSegment(true);

        private WildCardSegment(boolean bl) {
            this.deep = bl;
        }

        @Override
        public Object eval(JSONPath jSONPath, Object arrayList, Object object) {
            if (!this.deep) {
                return jSONPath.getPropertyValues(object);
            }
            arrayList = new ArrayList<Object>();
            jSONPath.deepGetPropertyValues(object, arrayList);
            return arrayList;
        }

        @Override
        public void extract(JSONPath jSONAware, DefaultJSONParser iterator, Context context) {
            if (context.eval) {
                iterator = ((DefaultJSONParser)((Object)iterator)).parse();
                if (this.deep) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    ((JSONPath)jSONAware).deepGetPropertyValues(iterator, arrayList);
                    context.object = arrayList;
                    return;
                }
                if (iterator instanceof JSONObject) {
                    Object object = ((JSONObject)((Object)iterator)).values();
                    jSONAware = new JSONArray(object.size());
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        ((JSONArray)jSONAware).add(object);
                    }
                    context.object = jSONAware;
                    return;
                }
                if (iterator instanceof JSONArray) {
                    context.object = iterator;
                    return;
                }
            }
            throw new JSONException("TODO");
        }
    }

    static class MultiPropertySegment
    implements Segment {
        private final String[] propertyNames;
        private final long[] propertyNamesHash;

        public MultiPropertySegment(String[] stringArray) {
            this.propertyNames = stringArray;
            this.propertyNamesHash = new long[stringArray.length];
            for (int i = 0; i < this.propertyNamesHash.length; ++i) {
                this.propertyNamesHash[i] = TypeUtils.fnv1a_64(stringArray[i]);
            }
        }

        @Override
        public Object eval(JSONPath jSONPath, Object arrayList, Object object) {
            arrayList = new ArrayList<Object>(this.propertyNames.length);
            for (int i = 0; i < this.propertyNames.length; ++i) {
                Object object2 = jSONPath.getPropertyValue(object, this.propertyNames[i], this.propertyNamesHash[i]);
                arrayList.add(object2);
            }
            return arrayList;
        }

        @Override
        public void extract(JSONPath object, DefaultJSONParser defaultJSONParser, Context object2) {
            int n;
            object = (JSONLexerBase)defaultJSONParser.lexer;
            if (((Context)object2).object == null) {
                ((Context)object2).object = object2 = new JSONArray();
            } else {
                object2 = (JSONArray)((Context)object2).object;
            }
            for (n = ((JSONArray)object2).size(); n < this.propertyNamesHash.length; ++n) {
                ((JSONArray)object2).add((Object)null);
            }
            do {
                Object object3;
                n = ((JSONLexerBase)object).seekObjectToField(this.propertyNamesHash);
                if (((JSONLexerBase)object).matchStat != 3) break;
                switch (((JSONLexerBase)object).token()) {
                    case 2: {
                        object3 = ((JSONLexerBase)object).integerValue();
                        ((JSONLexerBase)object).nextToken(16);
                        break;
                    }
                    case 3: {
                        object3 = ((JSONLexerBase)object).decimalValue();
                        ((JSONLexerBase)object).nextToken(16);
                        break;
                    }
                    case 4: {
                        object3 = ((JSONLexerBase)object).stringVal();
                        ((JSONLexerBase)object).nextToken(16);
                        break;
                    }
                    default: {
                        object3 = defaultJSONParser.parse();
                    }
                }
                ((JSONArray)object2).set(n, object3);
            } while (((JSONLexerBase)object).token() == 16);
        }
    }

    static class PropertySegment
    implements Segment {
        private final String propertyName;
        private final long propertyNameHash;
        private final boolean deep;

        public PropertySegment(String string, boolean bl) {
            this.propertyName = string;
            this.propertyNameHash = TypeUtils.fnv1a_64(string);
            this.deep = bl;
        }

        @Override
        public Object eval(JSONPath jSONPath, Object arrayList, Object object) {
            if (this.deep) {
                arrayList = new ArrayList<Object>();
                jSONPath.deepScan(object, this.propertyName, arrayList);
                return arrayList;
            }
            return jSONPath.getPropertyValue(object, this.propertyName, this.propertyNameHash);
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser defaultJSONParser, Context context) {
            int n;
            JSONLexerBase jSONLexerBase = (JSONLexerBase)defaultJSONParser.lexer;
            if (this.deep && context.object == null) {
                context.object = new JSONArray();
            }
            if (jSONLexerBase.token() == 14) {
                JSONArray jSONArray;
                block35: {
                    if ("*".equals(this.propertyName)) {
                        return;
                    }
                    jSONLexerBase.nextToken();
                    jSONArray = this.deep ? (JSONArray)context.object : new JSONArray();
                    block19: while (true) {
                        switch (jSONLexerBase.token()) {
                            case 12: {
                                if (this.deep) {
                                    this.extract(jSONPath, defaultJSONParser, context);
                                    break;
                                }
                                int n2 = jSONLexerBase.seekObjectToField(this.propertyNameHash, this.deep);
                                if (n2 == 3) {
                                    Object object;
                                    switch (jSONLexerBase.token()) {
                                        case 2: {
                                            object = jSONLexerBase.integerValue();
                                            jSONLexerBase.nextToken();
                                            break;
                                        }
                                        case 4: {
                                            object = jSONLexerBase.stringVal();
                                            jSONLexerBase.nextToken();
                                            break;
                                        }
                                        default: {
                                            object = defaultJSONParser.parse();
                                        }
                                    }
                                    jSONArray.add(object);
                                    if (jSONLexerBase.token() == 13) {
                                        jSONLexerBase.nextToken();
                                        continue block19;
                                    }
                                    jSONLexerBase.skipObject(false);
                                    break;
                                }
                                if (n2 == -1) continue block19;
                                if (this.deep) {
                                    throw new UnsupportedOperationException(jSONLexerBase.info());
                                }
                                jSONLexerBase.skipObject(false);
                                break;
                            }
                            case 14: {
                                if (this.deep) {
                                    this.extract(jSONPath, defaultJSONParser, context);
                                    break;
                                }
                                jSONLexerBase.skipObject(false);
                                break;
                            }
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: {
                                jSONLexerBase.nextToken();
                            }
                        }
                        if (jSONLexerBase.token() == 15) break block35;
                        if (jSONLexerBase.token() != 16) break;
                        jSONLexerBase.nextToken();
                    }
                    throw new JSONException("illegal json : " + jSONLexerBase.info());
                }
                jSONLexerBase.nextToken();
                if (!this.deep && jSONArray.size() > 0) {
                    context.object = jSONArray;
                }
                return;
            }
            if (!this.deep) {
                if (jSONLexerBase.seekObjectToField(this.propertyNameHash, this.deep) == 3 && context.eval) {
                    Object object;
                    switch (jSONLexerBase.token()) {
                        case 2: {
                            object = jSONLexerBase.integerValue();
                            jSONLexerBase.nextToken(16);
                            break;
                        }
                        case 3: {
                            object = jSONLexerBase.decimalValue();
                            jSONLexerBase.nextToken(16);
                            break;
                        }
                        case 4: {
                            object = jSONLexerBase.stringVal();
                            jSONLexerBase.nextToken(16);
                            break;
                        }
                        default: {
                            object = defaultJSONParser.parse();
                        }
                    }
                    if (context.eval) {
                        context.object = object;
                    }
                }
                return;
            }
            while ((n = jSONLexerBase.seekObjectToField(this.propertyNameHash, this.deep)) != -1) {
                if (n == 3) {
                    List list;
                    Object object;
                    if (!context.eval) continue;
                    switch (jSONLexerBase.token()) {
                        case 2: {
                            object = jSONLexerBase.integerValue();
                            jSONLexerBase.nextToken(16);
                            break;
                        }
                        case 3: {
                            object = jSONLexerBase.decimalValue();
                            jSONLexerBase.nextToken(16);
                            break;
                        }
                        case 4: {
                            object = jSONLexerBase.stringVal();
                            jSONLexerBase.nextToken(16);
                            break;
                        }
                        default: {
                            object = defaultJSONParser.parse();
                        }
                    }
                    if (!context.eval) continue;
                    if (context.object instanceof List && ((list = (List)context.object).size() != 0 || !(object instanceof List))) {
                        list.add(object);
                        continue;
                    }
                    context.object = object;
                    continue;
                }
                if (n != 1 && n != 2) continue;
                this.extract(jSONPath, defaultJSONParser, context);
            }
        }

        public void setValue(JSONPath jSONPath, Object object, Object object2) {
            if (this.deep) {
                jSONPath.deepSet(object, this.propertyName, this.propertyNameHash, object2);
                return;
            }
            jSONPath.setPropertyValue(object, this.propertyName, this.propertyNameHash, object2);
        }

        public boolean remove(JSONPath jSONPath, Object object) {
            return jSONPath.removePropertyValue(object, this.propertyName, this.deep);
        }
    }

    static class KeySetSegment
    implements Segment {
        public static final KeySetSegment instance = new KeySetSegment();

        KeySetSegment() {
        }

        @Override
        public Object eval(JSONPath jSONPath, Object object, Object object2) {
            return jSONPath.evalKeySet(object2);
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser defaultJSONParser, Context context) {
            throw new UnsupportedOperationException();
        }
    }

    static class MinSegment
    implements Segment {
        public static final MinSegment instance = new MinSegment();

        MinSegment() {
        }

        @Override
        public Object eval(JSONPath object, Object iterator, Object object22) {
            object = null;
            if (object22 instanceof Collection) {
                for (Object object22 : (Collection)object22) {
                    if (object22 == null) continue;
                    if (object == null) {
                        object = object22;
                        continue;
                    }
                    if (JSONPath.compare(object, object22) <= 0) continue;
                    object = object22;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            return object;
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser defaultJSONParser, Context context) {
            throw new UnsupportedOperationException();
        }
    }

    static class MaxSegment
    implements Segment {
        public static final MaxSegment instance = new MaxSegment();

        MaxSegment() {
        }

        @Override
        public Object eval(JSONPath object, Object iterator, Object object22) {
            object = null;
            if (object22 instanceof Collection) {
                for (Object object22 : (Collection)object22) {
                    if (object22 == null) continue;
                    if (object == null) {
                        object = object22;
                        continue;
                    }
                    if (JSONPath.compare(object, object22) >= 0) continue;
                    object = object22;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            return object;
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser defaultJSONParser, Context context) {
            throw new UnsupportedOperationException();
        }
    }

    static class FloorSegment
    implements Segment {
        public static final FloorSegment instance = new FloorSegment();

        FloorSegment() {
        }

        @Override
        public Object eval(JSONPath jSONAware, Object object, Object object2) {
            if (object2 instanceof JSONArray) {
                jSONAware = (JSONArray)((JSONArray)object2).clone();
                for (int i = 0; i < ((JSONArray)jSONAware).size(); ++i) {
                    object2 = ((JSONArray)jSONAware).get(i);
                    Object object3 = FloorSegment.floor(object2);
                    if (object3 == object2) continue;
                    ((JSONArray)jSONAware).set(i, object3);
                }
                return jSONAware;
            }
            return FloorSegment.floor(object2);
        }

        private static Object floor(Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof Float) {
                return Math.floor(((Float)object).floatValue());
            }
            if (object instanceof Double) {
                return Math.floor((Double)object);
            }
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).setScale(0, RoundingMode.FLOOR);
            }
            if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof BigInteger) {
                return object;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser defaultJSONParser, Context context) {
            throw new UnsupportedOperationException();
        }
    }

    static class TypeSegment
    implements Segment {
        public static final TypeSegment instance = new TypeSegment();

        TypeSegment() {
        }

        @Override
        public String eval(JSONPath jSONPath, Object object, Object object2) {
            if (object2 == null) {
                return "null";
            }
            if (object2 instanceof Collection) {
                return "array";
            }
            if (object2 instanceof Number) {
                return "number";
            }
            if (object2 instanceof Boolean) {
                return "boolean";
            }
            if (object2 instanceof String || object2 instanceof UUID || object2 instanceof Enum) {
                return "string";
            }
            return "object";
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser defaultJSONParser, Context context) {
            throw new UnsupportedOperationException();
        }
    }

    static class SizeSegment
    implements Segment {
        public static final SizeSegment instance = new SizeSegment();

        SizeSegment() {
        }

        @Override
        public Integer eval(JSONPath jSONPath, Object object, Object object2) {
            return jSONPath.evalSize(object2);
        }

        @Override
        public void extract(JSONPath jSONPath, DefaultJSONParser object, Context context) {
            object = ((DefaultJSONParser)object).parse();
            context.object = jSONPath.evalSize(object);
        }
    }

    static interface Segment {
        public Object eval(JSONPath var1, Object var2, Object var3);

        public void extract(JSONPath var1, DefaultJSONParser var2, Context var3);
    }

    static class JSONPathParser {
        private final String path;
        private int pos;
        private char ch;
        private int level;
        private boolean hasRefSegment;
        private static final String strArrayRegex = "'\\s*,\\s*'";
        private static final Pattern strArrayPatternx = Pattern.compile("'\\s*,\\s*'");

        public JSONPathParser(String string) {
            this.path = string;
            this.next();
        }

        void next() {
            this.ch = this.path.charAt(this.pos++);
        }

        char getNextChar() {
            return this.path.charAt(this.pos);
        }

        boolean isEOF() {
            return this.pos >= this.path.length();
        }

        Segment readSegement() {
            if (this.level == 0 && this.path.length() == 1) {
                if (JSONPathParser.isDigitFirst(this.ch)) {
                    int n = this.ch - 48;
                    return new ArrayAccessSegment(n);
                }
                if (this.ch >= 'a' && this.ch <= 'z' || this.ch >= 'A' && this.ch <= 'Z') {
                    return new PropertySegment(Character.toString(this.ch), false);
                }
            }
            while (!this.isEOF()) {
                this.skipWhitespace();
                if (this.ch == '$') {
                    this.next();
                    this.skipWhitespace();
                    if (this.ch != '?') continue;
                    return new FilterSegment((Filter)this.parseArrayAccessFilter(false));
                }
                if (this.ch == '.' || this.ch == '/') {
                    char c = this.ch;
                    boolean bl = false;
                    this.next();
                    if (c == '.' && this.ch == '.') {
                        this.next();
                        bl = true;
                        if (this.path.length() > this.pos + 3 && this.ch == '[' && this.path.charAt(this.pos) == '*' && this.path.charAt(this.pos + 1) == ']' && this.path.charAt(this.pos + 2) == '.') {
                            this.next();
                            this.next();
                            this.next();
                            this.next();
                        }
                    }
                    if (this.ch == '*') {
                        if (!this.isEOF()) {
                            this.next();
                        }
                        if (bl) {
                            return WildCardSegment.instance_deep;
                        }
                        return WildCardSegment.instance;
                    }
                    if (JSONPathParser.isDigitFirst(this.ch)) {
                        return this.parseArrayAccess(false);
                    }
                    String string = this.readName();
                    if (this.ch == '(') {
                        this.next();
                        if (this.ch == ')') {
                            if (!this.isEOF()) {
                                this.next();
                            }
                            if ("size".equals(string) || "length".equals(string)) {
                                return SizeSegment.instance;
                            }
                            if ("max".equals(string)) {
                                return MaxSegment.instance;
                            }
                            if ("min".equals(string)) {
                                return MinSegment.instance;
                            }
                            if ("keySet".equals(string)) {
                                return KeySetSegment.instance;
                            }
                            if ("type".equals(string)) {
                                return TypeSegment.instance;
                            }
                            if ("floor".equals(string)) {
                                return FloorSegment.instance;
                            }
                            throw new JSONPathException("not support jsonpath : " + this.path);
                        }
                        throw new JSONPathException("not support jsonpath : " + this.path);
                    }
                    return new PropertySegment(string, bl);
                }
                if (this.ch == '[') {
                    return this.parseArrayAccess(true);
                }
                if (this.level == 0) {
                    String string = this.readName();
                    return new PropertySegment(string, false);
                }
                if (this.ch == '?') {
                    return new FilterSegment((Filter)this.parseArrayAccessFilter(false));
                }
                throw new JSONPathException("not support jsonpath : " + this.path);
            }
            return null;
        }

        public final void skipWhitespace() {
            while (this.ch <= ' ' && (this.ch == ' ' || this.ch == '\r' || this.ch == '\n' || this.ch == '\t' || this.ch == '\f' || this.ch == '\b')) {
                this.next();
            }
        }

        Segment parseArrayAccess(boolean bl) {
            Object object = this.parseArrayAccessFilter(bl);
            if (object instanceof Segment) {
                return (Segment)object;
            }
            return new FilterSegment((Filter)object);
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        Object parseArrayAccessFilter(boolean var1_1) {
            block141: {
                if (var1_1) {
                    this.accept('[');
                }
                var2_2 = false;
                var3_3 = 0;
                if (this.ch == '?') {
                    this.next();
                    this.accept('(');
                    ++var3_3;
                    while (this.ch == '(') {
                        this.next();
                        ++var3_3;
                    }
                    var2_2 = true;
                }
                this.skipWhitespace();
                if (var2_2 || IOUtils.firstIdentifier(this.ch) || Character.isJavaIdentifierStart(this.ch) || this.ch == '\\' || this.ch == '@') {
                    if (this.ch == '@') {
                        this.next();
                        this.accept('.');
                    }
                    var4_9 = this.readName();
                    this.skipWhitespace();
                    if (var2_2 && this.ch == ')') {
                        this.next();
                        var5_11 /* !! */  = new NotNullSegement(var4_9, false);
                        while (this.ch == ' ') {
                            this.next();
                        }
                        if (this.ch == '&' || this.ch == '|') {
                            var5_11 /* !! */  = this.filterRest(var5_11 /* !! */ );
                        }
                        if (var1_1) {
                            this.accept(']');
                        }
                        return var5_11 /* !! */ ;
                    }
                    if (var1_1 && this.ch == ']') {
                        this.next();
                        var5_12 /* !! */  = new NotNullSegement(var4_9, false);
                        while (this.ch == ' ') {
                            this.next();
                        }
                        if (this.ch == '&' || this.ch == '|') {
                            var5_12 /* !! */  = this.filterRest(var5_12 /* !! */ );
                        }
                        this.accept(')');
                        if (var2_2) {
                            this.accept(')');
                        }
                        if (var1_1) {
                            this.accept(']');
                        }
                        return var5_12 /* !! */ ;
                    }
                    var5_13 = false;
                    this.skipWhitespace();
                    if (this.ch == '(') {
                        this.next();
                        this.accept(')');
                        this.skipWhitespace();
                        var5_13 = true;
                    }
                    var6_15 /* !! */  = this.readOp();
                    this.skipWhitespace();
                    if (var6_15 /* !! */  == Operator.BETWEEN || var6_15 /* !! */  == Operator.NOT_BETWEEN) {
                        var7_18 = var6_15 /* !! */  == Operator.NOT_BETWEEN;
                        var8_28 = this.readValue();
                        var9_37 = this.readName();
                        if (!"and".equalsIgnoreCase(var9_37)) {
                            throw new JSONPathException(this.path);
                        }
                        var10_44 = this.readValue();
                        if (var8_28 == null || var10_44 == null) {
                            throw new JSONPathException(this.path);
                        }
                        if (JSONPath.isInt(var8_28.getClass()) && JSONPath.isInt(var10_44.getClass())) {
                            return new IntBetweenSegement(var4_9, var5_13, TypeUtils.longExtractValue((Number)var8_28), TypeUtils.longExtractValue((Number)var10_44), var7_18);
                        }
                        throw new JSONPathException(this.path);
                    }
                    if (var6_15 /* !! */  == Operator.IN || var6_15 /* !! */  == Operator.NOT_IN) {
                        var7_19 = var6_15 /* !! */  == Operator.NOT_IN;
                        this.accept('(');
                        var8_29 = new JSONArray();
                        var9_38 = this.readValue();
                        var8_29.add(var9_38);
                        while (true) {
                            this.skipWhitespace();
                            if (this.ch != ',') break;
                            this.next();
                            var9_38 = this.readValue();
                            var8_29.add(var9_38);
                        }
                        var9_39 = true;
                        var10_45 = true;
                        var6_16 = true;
                        for (E var12_52 : var8_29) {
                            if (var12_52 /* !! */  == null) {
                                if (!var9_39) continue;
                                var9_39 = false;
                                continue;
                            }
                            var3_4 = var12_52 /* !! */ .getClass();
                            if (var9_39 && var3_4 != Byte.class && var3_4 != Short.class && var3_4 != Integer.class && var3_4 != Long.class) {
                                var9_39 = false;
                                var10_45 = false;
                            }
                            if (!var6_16 || var3_4 == String.class) continue;
                            var6_16 = false;
                        }
                        if (var8_29.size() == 1 && var8_29.get(0) == null) {
                            var11_49 /* !! */  = var7_19 != false ? new NotNullSegement(var4_9, var5_13) : new NullSegement(var4_9, var5_13);
                            while (this.ch == ' ') {
                                this.next();
                            }
                            if (this.ch == '&' || this.ch == '|') {
                                var11_49 /* !! */  = this.filterRest((Filter)var11_49 /* !! */ );
                            }
                            this.accept(')');
                            if (var2_2) {
                                this.accept(')');
                            }
                            if (var1_1) {
                                this.accept(']');
                            }
                            return var11_49 /* !! */ ;
                        }
                        if (var9_39) {
                            if (var8_29.size() == 1) {
                                var11_50 = TypeUtils.longExtractValue((Number)var8_29.get(0));
                                var3_5 /* !! */  = var7_19 != false ? Operator.NE : Operator.EQ;
                                var3_5 /* !! */  = new IntOpSegement(var4_9, var5_13, var11_50, var3_5 /* !! */ );
                                while (this.ch == ' ') {
                                    this.next();
                                }
                                if (this.ch == '&' || this.ch == '|') {
                                    var3_5 /* !! */  = this.filterRest((Filter)var3_5 /* !! */ );
                                }
                                this.accept(')');
                                if (var2_2) {
                                    this.accept(')');
                                }
                                if (var1_1) {
                                    this.accept(']');
                                }
                                return var3_5 /* !! */ ;
                            }
                            var11_49 /* !! */  = new long[var8_29.size()];
                            for (var12_53 = 0; var12_53 < var11_49 /* !! */ .length; ++var12_53) {
                                var11_49 /* !! */ [var12_53] = TypeUtils.longExtractValue((Number)var8_29.get(var12_53));
                            }
                            var12_54 /* !! */  = new IntInSegement(var4_9, var5_13, var11_49 /* !! */ , var7_19);
                            while (this.ch == ' ') {
                                this.next();
                            }
                            if (this.ch == '&' || this.ch == '|') {
                                var12_54 /* !! */  = this.filterRest(var12_54 /* !! */ );
                            }
                            this.accept(')');
                            if (var2_2) {
                                this.accept(')');
                            }
                            if (var1_1) {
                                this.accept(']');
                            }
                            return var12_54 /* !! */ ;
                        }
                        if (var6_16) {
                            if (var8_29.size() == 1) {
                                var11_49 /* !! */  = (String)var8_29.get(0);
                                var12_52 /* !! */  = var7_19 != false ? Operator.NE : Operator.EQ;
                                var3_6 /* !! */  = new StringOpSegement(var4_9, var5_13, (String)var11_49 /* !! */ , (Operator)var12_52 /* !! */ );
                                while (this.ch == ' ') {
                                    this.next();
                                }
                                if (this.ch == '&' || this.ch == '|') {
                                    var3_6 /* !! */  = this.filterRest(var3_6 /* !! */ );
                                }
                                this.accept(')');
                                if (var2_2) {
                                    this.accept(')');
                                }
                                if (var1_1) {
                                    this.accept(']');
                                }
                                return var3_6 /* !! */ ;
                            }
                            var11_49 /* !! */  = new String[var8_29.size()];
                            var8_29.toArray(var11_49 /* !! */ );
                            var12_52 /* !! */  = new StringInSegement(var4_9, var5_13, (String[])var11_49 /* !! */ , var7_19);
                            while (this.ch == ' ') {
                                this.next();
                            }
                            if (this.ch == '&' || this.ch == '|') {
                                var12_52 /* !! */  = this.filterRest((Filter)var12_52 /* !! */ );
                            }
                            this.accept(')');
                            if (var2_2) {
                                this.accept(')');
                            }
                            if (var1_1) {
                                this.accept(']');
                            }
                            return var12_52 /* !! */ ;
                        }
                        if (var10_45) {
                            var11_49 /* !! */  = new Long[var8_29.size()];
                            for (var12_55 = 0; var12_55 < var11_49 /* !! */ .length; ++var12_55) {
                                var3_7 = (Number)var8_29.get(var12_55);
                                if (var3_7 == null) continue;
                                var11_49 /* !! */ [var12_55] = TypeUtils.longExtractValue(var3_7);
                            }
                            var12_56 /* !! */  = new IntObjInSegement(var4_9, var5_13, var11_49 /* !! */ , var7_19);
                            while (this.ch == ' ') {
                                this.next();
                            }
                            if (this.ch == '&' || this.ch == '|') {
                                var12_56 /* !! */  = this.filterRest(var12_56 /* !! */ );
                            }
                            this.accept(')');
                            if (var2_2) {
                                this.accept(')');
                            }
                            if (var1_1) {
                                this.accept(']');
                            }
                            return var12_56 /* !! */ ;
                        }
                        throw new UnsupportedOperationException();
                    }
                    if (this.ch == '\'' || this.ch == '\"') {
                        var7_20 = this.readString();
                        if (var6_15 /* !! */  == Operator.RLIKE) {
                            var8_30 /* !! */  = new RlikeSegement(var4_9, var5_13, var7_20, false);
                        } else if (var6_15 /* !! */  == Operator.NOT_RLIKE) {
                            var8_30 /* !! */  = new RlikeSegement(var4_9, var5_13, var7_20, true);
                        } else if (var6_15 /* !! */  == Operator.LIKE || var6_15 /* !! */  == Operator.NOT_LIKE) {
                            while (var7_20.indexOf("%%") != -1) {
                                var7_20 = var7_20.replaceAll("%%", "%");
                            }
                            var9_40 = var6_15 /* !! */  == Operator.NOT_LIKE;
                            var10_46 = var7_20.indexOf(37);
                            if (var10_46 == -1) {
                                var6_15 /* !! */  = var6_15 /* !! */  == Operator.LIKE ? Operator.EQ : Operator.NE;
                                var8_30 /* !! */  = new StringOpSegement(var4_9, var5_13, var7_20, (Operator)var6_15 /* !! */ );
                            } else {
                                var6_15 /* !! */  = var7_20.split("%");
                                var11_51 = null;
                                var12_57 = null;
                                var3_8 = null;
                                if (var10_46 == 0) {
                                    v0 = var7_20;
                                    if (v0.charAt(v0.length() - 1) == '%') {
                                        var3_8 = new String[var6_15 /* !! */ .length - 1];
                                        System.arraycopy(var6_15 /* !! */ , 1, var3_8, 0, var3_8.length);
                                    } else {
                                        var12_57 = var6_15 /* !! */ [var6_15 /* !! */ .length - 1];
                                        if (var6_15 /* !! */ .length > 2) {
                                            var3_8 = new String[var6_15 /* !! */ .length - 2];
                                            System.arraycopy(var6_15 /* !! */ , 1, var3_8, 0, var3_8.length);
                                        }
                                    }
                                } else {
                                    v1 = var7_20;
                                    if (v1.charAt(v1.length() - 1) == '%') {
                                        if (var6_15 /* !! */ .length == 1) {
                                            var11_51 = var6_15 /* !! */ [0];
                                        } else {
                                            var3_8 = var6_15 /* !! */ ;
                                        }
                                    } else if (var6_15 /* !! */ .length == 1) {
                                        var11_51 = var6_15 /* !! */ [0];
                                    } else if (var6_15 /* !! */ .length == 2) {
                                        var11_51 = var6_15 /* !! */ [0];
                                        var12_57 = var6_15 /* !! */ [1];
                                    } else {
                                        var11_51 = var6_15 /* !! */ [0];
                                        var12_57 = var6_15 /* !! */ [var6_15 /* !! */ .length - 1];
                                        var3_8 = new String[var6_15 /* !! */ .length - 2];
                                        System.arraycopy(var6_15 /* !! */ , 1, var3_8, 0, var3_8.length);
                                    }
                                }
                                var8_30 /* !! */  = new MatchSegement(var4_9, var5_13, var11_51, var12_57, var3_8, var9_40);
                            }
                        } else {
                            var8_30 /* !! */  = new StringOpSegement(var4_9, var5_13, var7_20, (Operator)var6_15 /* !! */ );
                        }
                        while (this.ch == ' ') {
                            this.next();
                        }
                        if (this.ch == '&' || this.ch == '|') {
                            var8_30 /* !! */  = this.filterRest(var8_30 /* !! */ );
                        }
                        if (var2_2) {
                            this.accept(')');
                        }
                        if (var1_1) {
                            this.accept(']');
                        }
                        return var8_30 /* !! */ ;
                    }
                    if (JSONPathParser.isDigitFirst(this.ch)) {
                        var7_21 = this.readLongValue();
                        var9_41 = 0.0;
                        if (this.ch == '.') {
                            var9_41 = this.readDoubleValue(var7_21);
                        }
                        var6_15 /* !! */  = var9_41 == 0.0 ? new IntOpSegement(var4_9, var5_13, var7_21, (Operator)var6_15 /* !! */ ) : new DoubleOpSegement(var4_9, var5_13, var9_41, (Operator)var6_15 /* !! */ );
                        while (this.ch == ' ') {
                            this.next();
                        }
                        if (var3_3 > 1 && this.ch == ')') {
                            this.next();
                        }
                        if (this.ch == '&' || this.ch == '|') {
                            var6_15 /* !! */  = this.filterRest((Filter)var6_15 /* !! */ );
                        }
                        if (var2_2) {
                            this.accept(')');
                        }
                        if (var1_1) {
                            this.accept(']');
                        }
                        return var6_15 /* !! */ ;
                    }
                    if (this.ch == '$') {
                        var7_22 = this.readSegement();
                        var8_31 = new RefOpSegement(var4_9, var5_13, var7_22, (Operator)var6_15 /* !! */ );
                        this.hasRefSegment = true;
                        while (this.ch == ' ') {
                            this.next();
                        }
                        if (var2_2) {
                            this.accept(')');
                        }
                        if (var1_1) {
                            this.accept(']');
                        }
                        return var8_31;
                    }
                    if (this.ch == '/') {
                        var7_23 = 0;
                        var8_32 = new StringBuilder();
                        while (true) {
                            this.next();
                            if (this.ch == '/') {
                                this.next();
                                if (this.ch != 'i') break;
                                this.next();
                                var7_23 = 2;
                                break;
                            }
                            if (this.ch == '\\') {
                                this.next();
                                var8_32.append(this.ch);
                                continue;
                            }
                            var8_32.append(this.ch);
                        }
                        var9_42 = Pattern.compile(var8_32.toString(), var7_23);
                        var10_47 = new RegMatchSegement(var4_9, var5_13, var9_42, (Operator)var6_15 /* !! */ );
                        if (var2_2) {
                            this.accept(')');
                        }
                        if (var1_1) {
                            this.accept(']');
                        }
                        return var10_47;
                    }
                    if (this.ch == 'n') {
                        var7_24 = this.readName();
                        if ("null".equals(var7_24)) {
                            var8_33 /* !! */  = null;
                            if (var6_15 /* !! */  == Operator.EQ) {
                                var8_33 /* !! */  = new NullSegement(var4_9, var5_13);
                            } else if (var6_15 /* !! */  == Operator.NE) {
                                var8_33 /* !! */  = new NotNullSegement(var4_9, var5_13);
                            }
                            if (var8_33 /* !! */  != null) {
                                while (this.ch == ' ') {
                                    this.next();
                                }
                                if (this.ch == '&' || this.ch == '|') {
                                    var8_33 /* !! */  = this.filterRest(var8_33 /* !! */ );
                                }
                            }
                            if (var2_2) {
                                this.accept(')');
                            }
                            this.accept(']');
                            if (var8_33 /* !! */  != null) {
                                return var8_33 /* !! */ ;
                            }
                            throw new UnsupportedOperationException();
                        }
                    } else if (this.ch == 't') {
                        var7_25 = this.readName();
                        if ("true".equals(var7_25)) {
                            var8_34 /* !! */  = null;
                            if (var6_15 /* !! */  == Operator.EQ) {
                                var8_34 /* !! */  = new ValueSegment(var4_9, var5_13, Boolean.TRUE, true);
                            } else if (var6_15 /* !! */  == Operator.NE) {
                                var8_34 /* !! */  = new ValueSegment(var4_9, var5_13, Boolean.TRUE, false);
                            }
                            if (var8_34 /* !! */  != null) {
                                while (this.ch == ' ') {
                                    this.next();
                                }
                                if (this.ch == '&' || this.ch == '|') {
                                    var8_34 /* !! */  = this.filterRest(var8_34 /* !! */ );
                                }
                            }
                            if (var2_2) {
                                this.accept(')');
                            }
                            this.accept(']');
                            if (var8_34 /* !! */  != null) {
                                return var8_34 /* !! */ ;
                            }
                            throw new UnsupportedOperationException();
                        }
                    } else if (this.ch == 'f' && "false".equals(var7_26 = this.readName())) {
                        var8_35 /* !! */  = null;
                        if (var6_15 /* !! */  == Operator.EQ) {
                            var8_35 /* !! */  = new ValueSegment(var4_9, var5_13, Boolean.FALSE, true);
                        } else if (var6_15 /* !! */  == Operator.NE) {
                            var8_35 /* !! */  = new ValueSegment(var4_9, var5_13, Boolean.FALSE, false);
                        }
                        if (var8_35 /* !! */  != null) {
                            while (this.ch == ' ') {
                                this.next();
                            }
                            if (this.ch == '&' || this.ch == '|') {
                                var8_35 /* !! */  = this.filterRest(var8_35 /* !! */ );
                            }
                        }
                        if (var2_2) {
                            this.accept(')');
                        }
                        this.accept(']');
                        if (var8_35 /* !! */  != null) {
                            return var8_35 /* !! */ ;
                        }
                        throw new UnsupportedOperationException();
                    }
                    throw new UnsupportedOperationException();
                }
                var3_3 = this.pos - 1;
                var4_10 = this.ch;
                while (this.ch != ']' && this.ch != '/' && !this.isEOF() && (this.ch != '.' || var2_2 || var2_2 || var4_10 == '\'')) {
                    if (this.ch == '\\') {
                        this.next();
                    }
                    this.next();
                }
                var5_14 = var1_1 != false ? this.pos - 1 : (this.ch == '/' || this.ch == '.' ? this.pos - 1 : this.pos);
                var6_17 = this.path.substring(var3_3, var5_14);
                if (var6_17.indexOf(92) != 0) {
                    var7_27 = new StringBuilder(var6_17.length());
                    for (var8_36 = 0; var8_36 < var6_17.length(); ++var8_36) {
                        var9_43 = var6_17.charAt(var8_36);
                        if (var9_43 == '\\' && var8_36 < var6_17.length() - 1 && ((var10_48 = var6_17.charAt(var8_36 + 1)) == '@' || var9_43 == '\\' || var9_43 == '\"')) {
                            var7_27.append(var10_48);
                            ++var8_36;
                            continue;
                        }
                        var7_27.append(var9_43);
                    }
                    var6_17 = var7_27.toString();
                }
                if (var6_17.indexOf("\\.") == -1) break block141;
                if (var4_10 != '\'' || var6_17.length() <= 2) ** GOTO lbl-1000
                v2 = var6_17;
                if (v2.charAt(v2.length() - 1) == var4_10) {
                    var7_27 = var6_17.substring(1, var6_17.length() - 1);
                } else if ((var7_27 = var6_17.replaceAll("\\\\\\.", "\\.")).indexOf("\\-") != -1) {
                    var7_27 = var7_27.replaceAll("\\\\-", "-");
                }
                if (var2_2) {
                    this.accept(')');
                }
                return new PropertySegment((String)var7_27, false);
            }
            var7_27 = this.buildArraySegement(var6_17);
            if (var1_1 && !this.isEOF()) {
                this.accept(']');
            }
            return var7_27;
        }

        Filter filterRest(Filter filter) {
            boolean bl;
            boolean bl2 = bl = this.ch == '&';
            if (this.ch == '&' && this.getNextChar() == '&' || this.ch == '|' && this.getNextChar() == '|') {
                this.next();
                this.next();
                boolean bl3 = false;
                if (this.ch == '(') {
                    bl3 = true;
                    this.next();
                }
                while (this.ch == ' ') {
                    this.next();
                }
                Filter filter2 = (Filter)this.parseArrayAccessFilter(false);
                filter = new FilterGroup(filter, filter2, bl);
                if (bl3 && this.ch == ')') {
                    this.next();
                }
            }
            return filter;
        }

        /*
         * Handled impossible loop by adding 'first' condition
         * Enabled aggressive block sorting
         */
        protected long readLongValue() {
            int n = this.pos - 1;
            boolean bl = true;
            do {
                if (bl && !(bl = false) && this.ch != '+' && this.ch != '-') continue;
                this.next();
            } while (this.ch >= '0' && this.ch <= '9');
            int n2 = this.pos - 1;
            return Long.parseLong(this.path.substring(n, n2));
        }

        protected double readDoubleValue(long l) {
            int n = this.pos - 1;
            this.next();
            while (this.ch >= '0' && this.ch <= '9') {
                this.next();
            }
            int n2 = this.pos - 1;
            return Double.parseDouble(this.path.substring(n, n2)) + (double)l;
        }

        protected Object readValue() {
            this.skipWhitespace();
            if (JSONPathParser.isDigitFirst(this.ch)) {
                return this.readLongValue();
            }
            if (this.ch == '\"' || this.ch == '\'') {
                return this.readString();
            }
            if (this.ch == 'n') {
                String string = this.readName();
                if ("null".equals(string)) {
                    return null;
                }
                throw new JSONPathException(this.path);
            }
            throw new UnsupportedOperationException();
        }

        static boolean isDigitFirst(char c) {
            return c == '-' || c == '+' || c >= '0' && c <= '9';
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected Operator readOp() {
            void var1_22;
            void var1_10;
            Object var1_1 = null;
            if (this.ch == '=') {
                this.next();
                if (this.ch == '~') {
                    this.next();
                    Operator operator = Operator.REG_MATCH;
                } else if (this.ch == '=') {
                    this.next();
                    Operator operator = Operator.EQ;
                } else {
                    Operator operator = Operator.EQ;
                }
            } else if (this.ch == '!') {
                this.next();
                this.accept('=');
                Operator operator = Operator.NE;
            } else if (this.ch == '<') {
                this.next();
                if (this.ch == '=') {
                    this.next();
                    Operator operator = Operator.LE;
                } else {
                    Operator operator = Operator.LT;
                }
            } else if (this.ch == '>') {
                this.next();
                if (this.ch == '=') {
                    this.next();
                    Operator operator = Operator.GE;
                } else {
                    Operator operator = Operator.GT;
                }
            }
            if (var1_10 != null) return var1_22;
            String string = this.readName();
            if ("not".equalsIgnoreCase(string)) {
                this.skipWhitespace();
                String string2 = this.readName();
                if ("like".equalsIgnoreCase(string2)) {
                    Operator operator = Operator.NOT_LIKE;
                    return var1_22;
                } else if ("rlike".equalsIgnoreCase(string2)) {
                    Operator operator = Operator.NOT_RLIKE;
                    return var1_22;
                } else if ("in".equalsIgnoreCase(string2)) {
                    Operator operator = Operator.NOT_IN;
                    return var1_22;
                } else {
                    if (!"between".equalsIgnoreCase(string2)) throw new UnsupportedOperationException();
                    Operator operator = Operator.NOT_BETWEEN;
                }
                return var1_22;
            } else if ("nin".equalsIgnoreCase(string)) {
                Operator operator = Operator.NOT_IN;
                return var1_22;
            } else if ("like".equalsIgnoreCase(string)) {
                Operator operator = Operator.LIKE;
                return var1_22;
            } else if ("rlike".equalsIgnoreCase(string)) {
                Operator operator = Operator.RLIKE;
                return var1_22;
            } else if ("in".equalsIgnoreCase(string)) {
                Operator operator = Operator.IN;
                return var1_22;
            } else {
                if (!"between".equalsIgnoreCase(string)) throw new UnsupportedOperationException();
                Operator operator = Operator.BETWEEN;
            }
            return var1_22;
        }

        String readName() {
            this.skipWhitespace();
            if (this.ch != '\\' && !Character.isJavaIdentifierStart(this.ch)) {
                throw new JSONPathException("illeal jsonpath syntax. " + this.path);
            }
            StringBuilder stringBuilder = new StringBuilder();
            while (!this.isEOF()) {
                if (this.ch == '\\') {
                    this.next();
                    stringBuilder.append(this.ch);
                    if (this.isEOF()) {
                        return stringBuilder.toString();
                    }
                    this.next();
                    continue;
                }
                if (!Character.isJavaIdentifierPart(this.ch)) break;
                stringBuilder.append(this.ch);
                this.next();
            }
            if (this.isEOF() && Character.isJavaIdentifierPart(this.ch)) {
                stringBuilder.append(this.ch);
            }
            return stringBuilder.toString();
        }

        String readString() {
            char c = this.ch;
            this.next();
            int n = this.pos - 1;
            while (this.ch != c && !this.isEOF()) {
                this.next();
            }
            String string = this.path.substring(n, this.isEOF() ? this.pos : this.pos - 1);
            this.accept(c);
            return string;
        }

        void accept(char c) {
            if (this.ch == ' ') {
                this.next();
            }
            if (this.ch != c) {
                throw new JSONPathException("expect '" + c + ", but '" + this.ch + "'");
            }
            if (!this.isEOF()) {
                this.next();
            }
        }

        public Segment[] explain() {
            Segment[] segmentArray;
            if (this.path == null || this.path.length() == 0) {
                throw new IllegalArgumentException();
            }
            Segment[] segmentArray2 = new Segment[8];
            while ((segmentArray = this.readSegement()) != null) {
                Segment[] segmentArray3;
                if (segmentArray instanceof PropertySegment && !((PropertySegment)(segmentArray3 = (Segment[])segmentArray)).deep && ((PropertySegment)segmentArray3).propertyName.equals("*")) continue;
                if (this.level == segmentArray2.length) {
                    segmentArray3 = new Segment[this.level * 3 / 2];
                    System.arraycopy(segmentArray2, 0, segmentArray3, 0, this.level);
                    segmentArray2 = segmentArray3;
                }
                segmentArray2[this.level++] = segmentArray;
            }
            if (this.level == segmentArray2.length) {
                return segmentArray2;
            }
            segmentArray = new Segment[this.level];
            System.arraycopy(segmentArray2, 0, segmentArray, 0, this.level);
            return segmentArray;
        }

        Segment buildArraySegement(String object) {
            int n = ((String)object).length();
            int n2 = ((String)object).charAt(0);
            int n3 = ((String)object).charAt(n - 1);
            int n4 = ((String)object).indexOf(44);
            if (((String)object).length() > 2 && n2 == 39 && n3 == 39) {
                String[] stringArray = ((String)object).substring(1, n - 1);
                if (n4 == -1 || !strArrayPatternx.matcher((CharSequence)object).find()) {
                    return new PropertySegment((String)stringArray, false);
                }
                stringArray = stringArray.split(strArrayRegex);
                return new MultiPropertySegment(stringArray);
            }
            n = ((String)object).indexOf(58);
            if (n4 == -1 && n == -1) {
                if (TypeUtils.isNumber((String)object)) {
                    try {
                        n = Integer.parseInt((String)object);
                        return new ArrayAccessSegment(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return new PropertySegment((String)object, false);
                    }
                }
                if (((String)object).charAt(0) == '\"') {
                    Object object2 = object;
                    if (((String)object2).charAt(((String)object2).length() - 1) == '\"') {
                        object = ((String)object).substring(1, ((String)object).length() - 1);
                    }
                }
                return new PropertySegment((String)object, false);
            }
            if (n4 != -1) {
                String[] stringArray = ((String)object).split(",");
                object = new int[stringArray.length];
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    object[n2] = Integer.parseInt(stringArray[n2]);
                }
                return new MultiIndexSegment((int[])object);
            }
            if (n != -1) {
                String[] stringArray = ((String)object).split(":");
                object = new int[stringArray.length];
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    String string = stringArray[n2];
                    if (string.length() == 0) {
                        if (n2 == 0) {
                            object[n2] = false;
                            continue;
                        }
                        throw new UnsupportedOperationException();
                    }
                    object[n2] = Integer.parseInt(string);
                }
                n2 = (int)object[0];
                n3 = ((Object)object).length > 1 ? (int)object[1] : -1;
                int n5 = ((Object)object).length == 3 ? object[2] : true;
                if (n3 >= 0 && n3 < n2) {
                    throw new UnsupportedOperationException("end must greater than or equals start. start " + n2 + ",  end " + n3);
                }
                if (n5 <= 0) {
                    throw new UnsupportedOperationException("step must greater than zero : ".concat(String.valueOf(n5)));
                }
                return new RangeSegment(n2, n3, n5);
            }
            throw new UnsupportedOperationException();
        }
    }

    static class Context {
        final Context parent;
        final boolean eval;
        Object object;

        public Context(Context context, boolean bl) {
            this.parent = context;
            this.eval = bl;
        }
    }
}

