/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization;

import com.tradplus.ads.common.serialization.JSONException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public abstract class JSONValidator
implements Closeable,
Cloneable {
    protected boolean eof;
    protected int pos = -1;
    protected char ch;
    protected Type type;
    protected int count = 0;
    protected boolean supportMultiValue = true;

    public static JSONValidator fromUtf8(byte[] byArray) {
        return new UTF8Validator(byArray);
    }

    public static JSONValidator fromUtf8(InputStream inputStream) {
        return new UTF8InputStreamValidator(inputStream);
    }

    public static JSONValidator from(String string) {
        return new UTF16Validator(string);
    }

    public static JSONValidator from(Reader reader) {
        return new ReaderValidator(reader);
    }

    public boolean isSupportMultiValue() {
        return this.supportMultiValue;
    }

    public void setSupportMultiValue(boolean bl) {
        this.supportMultiValue = bl;
    }

    public Type getType() {
        if (this.type == null) {
            this.validate();
        }
        return this.type;
    }

    abstract void next();

    public boolean validate() {
        block4: {
            block3: {
                do {
                    if (!this.any()) {
                        return false;
                    }
                    ++this.count;
                    if (this.eof) {
                        return true;
                    }
                    if (!this.supportMultiValue) break block3;
                    this.skipWhiteSpace();
                } while (!this.eof);
                break block4;
            }
            return false;
        }
        return true;
    }

    @Override
    public void close() {
    }

    private boolean any() {
        switch (this.ch) {
            case '{': {
                do {
                    this.next();
                } while (JSONValidator.isWhiteSpace(this.ch));
                if (this.ch == '}') {
                    this.next();
                    this.type = Type.Object;
                    return true;
                }
                while (true) {
                    if (this.ch != '\"') {
                        return false;
                    }
                    this.fieldName();
                    this.skipWhiteSpace();
                    if (this.ch != ':') {
                        return false;
                    }
                    this.next();
                    this.skipWhiteSpace();
                    if (!this.any()) {
                        return false;
                    }
                    this.skipWhiteSpace();
                    if (this.ch == ',') {
                        this.next();
                        this.skipWhiteSpace();
                        continue;
                    }
                    if (this.ch == '}') break;
                }
                this.next();
                this.type = Type.Object;
                return true;
            }
            case '[': {
                this.next();
                this.skipWhiteSpace();
                if (this.ch == ']') {
                    this.next();
                    this.type = Type.Array;
                    return true;
                }
                while (true) {
                    if (!this.any()) {
                        return false;
                    }
                    this.skipWhiteSpace();
                    if (this.ch != ',') break;
                    this.next();
                    this.skipWhiteSpace();
                }
                if (this.ch == ']') {
                    this.next();
                    this.type = Type.Array;
                    return true;
                }
                return false;
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                if (this.ch == '-' || this.ch == '+') {
                    this.next();
                    this.skipWhiteSpace();
                    if (this.ch < '0' || this.ch > '9') {
                        return false;
                    }
                }
                do {
                    this.next();
                } while (this.ch >= '0' && this.ch <= '9');
                if (this.ch == '.') {
                    this.next();
                    if (this.ch < '0' || this.ch > '9') {
                        return false;
                    }
                    while (this.ch >= '0' && this.ch <= '9') {
                        this.next();
                    }
                }
                if (this.ch == 'e' || this.ch == 'E') {
                    this.next();
                    if (this.ch == '-' || this.ch == '+') {
                        this.next();
                    }
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.next();
                    } else {
                        return false;
                    }
                    while (this.ch >= '0' && this.ch <= '9') {
                        this.next();
                    }
                }
                this.type = Type.Value;
                break;
            }
            case '\"': {
                block15: while (true) {
                    this.next();
                    while (true) {
                        if (this.eof) {
                            return false;
                        }
                        if (this.ch == '\\') {
                            this.next();
                            if (this.ch == 'u') {
                                this.next();
                                this.next();
                                this.next();
                                this.next();
                                continue block15;
                            }
                            this.next();
                            continue;
                        }
                        if (this.ch == '\"') {
                            this.next();
                            this.type = Type.Value;
                            return true;
                        }
                        this.next();
                    }
                    break;
                }
            }
            case 't': {
                this.next();
                if (this.ch != 'r') {
                    return false;
                }
                this.next();
                if (this.ch != 'u') {
                    return false;
                }
                this.next();
                if (this.ch != 'e') {
                    return false;
                }
                this.next();
                if (JSONValidator.isWhiteSpace(this.ch) || this.ch == ',' || this.ch == ']' || this.ch == '}' || this.ch == '\u0000') {
                    this.type = Type.Value;
                    return true;
                }
                return false;
            }
            case 'f': {
                this.next();
                if (this.ch != 'a') {
                    return false;
                }
                this.next();
                if (this.ch != 'l') {
                    return false;
                }
                this.next();
                if (this.ch != 's') {
                    return false;
                }
                this.next();
                if (this.ch != 'e') {
                    return false;
                }
                this.next();
                if (JSONValidator.isWhiteSpace(this.ch) || this.ch == ',' || this.ch == ']' || this.ch == '}' || this.ch == '\u0000') {
                    this.type = Type.Value;
                    return true;
                }
                return false;
            }
            case 'n': {
                this.next();
                if (this.ch != 'u') {
                    return false;
                }
                this.next();
                if (this.ch != 'l') {
                    return false;
                }
                this.next();
                if (this.ch != 'l') {
                    return false;
                }
                this.next();
                if (JSONValidator.isWhiteSpace(this.ch) || this.ch == ',' || this.ch == ']' || this.ch == '}' || this.ch == '\u0000') {
                    this.type = Type.Value;
                    return true;
                }
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected void fieldName() {
        this.next();
        while (true) {
            if (this.ch == '\\') {
                this.next();
                if (this.ch == 'u') {
                    this.next();
                    this.next();
                    this.next();
                    this.next();
                    this.next();
                    continue;
                }
                this.next();
                continue;
            }
            if (this.ch == '\"') {
                this.next();
                return;
            }
            this.next();
        }
    }

    protected boolean string() {
        this.next();
        while (!this.eof) {
            if (this.ch == '\\') {
                this.next();
                if (this.ch == 'u') {
                    this.next();
                    this.next();
                    this.next();
                    this.next();
                    this.next();
                    continue;
                }
                this.next();
                continue;
            }
            if (this.ch == '\"') {
                this.next();
                return true;
            }
            this.next();
        }
        return false;
    }

    void skipWhiteSpace() {
        while (JSONValidator.isWhiteSpace(this.ch)) {
            this.next();
        }
    }

    static final boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\f' || c == '\b';
    }

    static class ReaderValidator
    extends JSONValidator {
        private static final ThreadLocal<char[]> bufLocal = new ThreadLocal();
        final Reader r;
        private char[] buf;
        private int end = -1;
        private int readCount = 0;

        ReaderValidator(Reader reader) {
            this.r = reader;
            this.buf = bufLocal.get();
            if (this.buf != null) {
                bufLocal.set(null);
            } else {
                this.buf = new char[8192];
            }
            this.next();
            this.skipWhiteSpace();
        }

        @Override
        void next() {
            if (this.pos < this.end) {
                this.ch = this.buf[++this.pos];
                return;
            }
            if (!this.eof) {
                int n;
                try {
                    n = this.r.read(this.buf, 0, this.buf.length);
                    ++this.readCount;
                }
                catch (IOException iOException) {
                    throw new JSONException("read error");
                }
                if (n > 0) {
                    this.ch = this.buf[0];
                    this.pos = 0;
                    this.end = n - 1;
                    return;
                }
                if (n == -1) {
                    this.pos = 0;
                    this.end = 0;
                    this.buf = null;
                    this.ch = '\u0000';
                    this.eof = true;
                    return;
                }
                this.pos = 0;
                this.end = 0;
                this.buf = null;
                this.ch = '\u0000';
                this.eof = true;
                throw new JSONException("read error");
            }
        }

        @Override
        public void close() {
            bufLocal.set(this.buf);
            this.r.close();
        }
    }

    static class UTF16Validator
    extends JSONValidator {
        private final String str;

        public UTF16Validator(String string) {
            this.str = string;
            this.next();
            this.skipWhiteSpace();
        }

        @Override
        void next() {
            ++this.pos;
            if (this.pos >= this.str.length()) {
                this.ch = '\u0000';
                this.eof = true;
                return;
            }
            this.ch = this.str.charAt(this.pos);
        }

        @Override
        protected final void fieldName() {
            char c;
            for (int i = this.pos + 1; i < this.str.length() && (c = this.str.charAt(i)) != '\\'; ++i) {
                if (c != '\"') continue;
                this.ch = this.str.charAt(i + 1);
                this.pos = i + 1;
                return;
            }
            block1: while (true) {
                this.next();
                while (true) {
                    if (this.ch == '\\') {
                        this.next();
                        if (this.ch == 'u') {
                            this.next();
                            this.next();
                            this.next();
                            this.next();
                            continue block1;
                        }
                        this.next();
                        continue;
                    }
                    if (this.ch == '\"') {
                        this.next();
                        return;
                    }
                    this.next();
                }
                break;
            }
        }

        @Override
        final void skipWhiteSpace() {
            if (this.ch > '\r') {
                return;
            }
            while (UTF16Validator.isWhiteSpace(this.ch)) {
                this.next();
            }
        }
    }

    static class UTF8InputStreamValidator
    extends JSONValidator {
        private static final ThreadLocal<byte[]> bufLocal = new ThreadLocal();
        private final InputStream is;
        private byte[] buf;
        private int end = -1;
        private int readCount = 0;

        public UTF8InputStreamValidator(InputStream inputStream) {
            this.is = inputStream;
            this.buf = bufLocal.get();
            if (this.buf != null) {
                bufLocal.set(null);
            } else {
                this.buf = new byte[8192];
            }
            this.next();
            this.skipWhiteSpace();
        }

        @Override
        void next() {
            if (this.pos < this.end) {
                this.ch = (char)this.buf[++this.pos];
                return;
            }
            if (!this.eof) {
                int n;
                try {
                    n = this.is.read(this.buf, 0, this.buf.length);
                    ++this.readCount;
                }
                catch (IOException iOException) {
                    throw new JSONException("read error");
                }
                if (n > 0) {
                    this.ch = (char)this.buf[0];
                    this.pos = 0;
                    this.end = n - 1;
                    return;
                }
                if (n == -1) {
                    this.pos = 0;
                    this.end = 0;
                    this.buf = null;
                    this.ch = '\u0000';
                    this.eof = true;
                    return;
                }
                this.pos = 0;
                this.end = 0;
                this.buf = null;
                this.ch = '\u0000';
                this.eof = true;
                throw new JSONException("read error");
            }
        }

        @Override
        public void close() {
            bufLocal.set(this.buf);
            this.is.close();
        }
    }

    static class UTF8Validator
    extends JSONValidator {
        private final byte[] bytes;

        public UTF8Validator(byte[] byArray) {
            this.bytes = byArray;
            this.next();
            this.skipWhiteSpace();
        }

        @Override
        void next() {
            ++this.pos;
            if (this.pos >= this.bytes.length) {
                this.ch = '\u0000';
                this.eof = true;
                return;
            }
            this.ch = (char)this.bytes[this.pos];
        }
    }

    public static enum Type {
        Object,
        Array,
        Value;

    }
}

