/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.asm;

import com.tradplus.ads.common.serialization.asm.MethodCollector;
import com.tradplus.ads.common.serialization.asm.TypeCollector;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class ClassReader {
    public final byte[] b;
    private final int[] items;
    private final String[] strings;
    private final int maxStringLength;
    public final int header;
    private boolean readAnnotations;

    public ClassReader(InputStream inputStream, boolean bl) {
        int n;
        this.readAnnotations = bl;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            if (n <= 0) continue;
            byteArrayOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        this.b = byteArrayOutputStream.toByteArray();
        this.items = new int[this.readUnsignedShort(8)];
        int n2 = this.items.length;
        this.strings = new String[n2];
        int n3 = 0;
        n = 10;
        for (int i = 1; i < n2; ++i) {
            int n4;
            this.items[i] = n + 1;
            switch (this.b[n]) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    n4 = 5;
                    break;
                }
                case 5: 
                case 6: {
                    n4 = 9;
                    ++i;
                    break;
                }
                case 15: {
                    n4 = 4;
                    break;
                }
                case 1: {
                    n4 = 3 + this.readUnsignedShort(n + 1);
                    if (n4 <= n3) break;
                    n3 = n4;
                    break;
                }
                default: {
                    n4 = 3;
                }
            }
            n += n4;
        }
        this.maxStringLength = n3;
        this.header = n;
    }

    public void accept(TypeCollector typeCollector) {
        int n;
        int n2;
        char[] cArray = new char[this.maxStringLength];
        int n3 = 0;
        if (this.readAnnotations) {
            n2 = this.getAttributes();
            for (n = this.readUnsignedShort(n2); n > 0; --n) {
                String string = this.readUTF8(n2 + 2, cArray);
                if ("RuntimeVisibleAnnotations".equals(string)) {
                    n3 = n2 + 8;
                    break;
                }
                n2 += 6 + this.readInt(n2 + 4);
            }
        }
        n2 = this.header;
        this.readUnsignedShort(n2 + 4);
        int n4 = this.readUnsignedShort(n2 + 6);
        n2 += 8;
        for (n = 0; n < n4; ++n) {
            n2 += 2;
        }
        int n5 = n2;
        n = this.readUnsignedShort(n5);
        n5 += 2;
        while (n > 0) {
            n4 = this.readUnsignedShort(n5 + 6);
            n5 += 8;
            while (n4 > 0) {
                n5 += 6 + this.readInt(n5 + 2);
                --n4;
            }
            --n;
        }
        n = this.readUnsignedShort(n5);
        n5 += 2;
        while (n > 0) {
            n4 = this.readUnsignedShort(n5 + 6);
            n5 += 8;
            while (n4 > 0) {
                n5 += 6 + this.readInt(n5 + 2);
                --n4;
            }
            --n;
        }
        n = this.readUnsignedShort(n5);
        n5 += 2;
        while (n > 0) {
            n5 += 6 + this.readInt(n5 + 2);
            --n;
        }
        if (n3 != 0) {
            n5 = n3 + 2;
            for (n = this.readUnsignedShort(n3); n > 0; --n) {
                String string = this.readUTF8(n5, cArray);
                typeCollector.visitAnnotation(string);
            }
        }
        n = this.readUnsignedShort(n2);
        n2 += 2;
        while (n > 0) {
            int n6 = this.readUnsignedShort(n2 + 6);
            n2 += 8;
            while (n6 > 0) {
                n2 += 6 + this.readInt(n2 + 2);
                --n6;
            }
            --n;
        }
        n = this.readUnsignedShort(n2);
        n2 += 2;
        while (n > 0) {
            n2 = this.readMethod(typeCollector, cArray, n2);
            --n;
        }
    }

    private int getAttributes() {
        int n;
        int n2;
        ClassReader classReader = this;
        int n3 = this.header + 8 + classReader.readUnsignedShort(classReader.header + 6) * 2;
        for (n2 = this.readUnsignedShort(n3); n2 > 0; --n2) {
            for (n = this.readUnsignedShort(n3 + 8); n > 0; --n) {
                n3 += 6 + this.readInt(n3 + 12);
            }
            n3 += 8;
        }
        for (n2 = this.readUnsignedShort(n3 += 2); n2 > 0; --n2) {
            for (n = this.readUnsignedShort(n3 + 8); n > 0; --n) {
                n3 += 6 + this.readInt(n3 + 12);
            }
            n3 += 8;
        }
        return n3 + 2;
    }

    private int readMethod(TypeCollector typeCollector, char[] cArray, int n) {
        String string;
        int n2 = this.readUnsignedShort(n);
        String string2 = this.readUTF8(n + 2, cArray);
        String string3 = this.readUTF8(n + 4, cArray);
        int n3 = 0;
        int n4 = this.readUnsignedShort(n + 6);
        n += 8;
        while (n4 > 0) {
            string = this.readUTF8(n, cArray);
            int n5 = this.readInt(n + 2);
            n += 6;
            if (string.equals("Code")) {
                n3 = n;
            }
            n += n5;
            --n4;
        }
        MethodCollector methodCollector = typeCollector.visitMethod(n2, string2, string3);
        if (methodCollector != null && n3 != 0) {
            int n6 = this.readInt(n3 + 4);
            n3 += 8;
            n3 += 2;
            for (n4 = this.readUnsignedShort(n3 += n6); n4 > 0; --n4) {
                n3 += 8;
            }
            n2 = 0;
            n6 = 0;
            n4 = this.readUnsignedShort(n3);
            n3 += 2;
            while (n4 > 0) {
                string = this.readUTF8(n3, cArray);
                if (string.equals("LocalVariableTable")) {
                    n2 = n3 + 6;
                } else if (string.equals("LocalVariableTypeTable")) {
                    n6 = n3 + 6;
                }
                n3 += 6 + this.readInt(n3 + 2);
                --n4;
            }
            if (n2 != 0) {
                if (n6 != 0) {
                    n3 = this.readUnsignedShort(n6) * 3;
                    n6 += 2;
                    int[] nArray = new int[n3];
                    while (n3 > 0) {
                        nArray[--n3] = n6 + 6;
                        nArray[--n3] = this.readUnsignedShort(n6 + 8);
                        nArray[--n3] = this.readUnsignedShort(n6);
                        n6 += 10;
                    }
                }
                n6 = n2 + 2;
                for (n3 = this.readUnsignedShort(n2); n3 > 0; --n3) {
                    int n7 = this.readUnsignedShort(n6 + 8);
                    methodCollector.visitLocalVariable(this.readUTF8(n6 + 4, cArray), n7);
                    n6 += 10;
                }
            }
        }
        return n;
    }

    private int readUnsignedShort(int n) {
        byte[] byArray = this.b;
        return (this.b[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    private int readInt(int n) {
        byte[] byArray = this.b;
        return (this.b[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    private String readUTF8(int n, char[] cArray) {
        int n2 = this.readUnsignedShort(n);
        String string = this.strings[n2];
        if (string != null) {
            return string;
        }
        int n3 = this.items[n2];
        this.strings[n2] = this.readUTF(n3 + 2, this.readUnsignedShort(n3), cArray);
        return this.strings[n2];
    }

    private String readUTF(int n, int n2, char[] cArray) {
        n2 = n + n2;
        byte[] byArray = this.b;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n < n2) {
            int n6 = byArray[n++];
            switch (n4) {
                case 0: {
                    if ((n6 &= 0xFF) < 128) {
                        cArray[n3++] = (char)n6;
                        break;
                    }
                    if (n6 < 224 && n6 > 191) {
                        n5 = (char)(n6 & 0x1F);
                        n4 = 1;
                        break;
                    }
                    n5 = (char)(n6 & 0xF);
                    n4 = 2;
                    break;
                }
                case 1: {
                    cArray[n3++] = (char)(n5 << 6 | n6 & 0x3F);
                    n4 = 0;
                    break;
                }
                case 2: {
                    n5 = (char)(n5 << 6 | n6 & 0x3F);
                    n4 = 1;
                }
            }
        }
        return new String(cArray, 0, n3);
    }
}

