/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.asm;

import com.tradplus.ads.common.serialization.asm.ByteVector;
import com.tradplus.ads.common.serialization.asm.FieldWriter;
import com.tradplus.ads.common.serialization.asm.Item;
import com.tradplus.ads.common.serialization.asm.MethodWriter;
import com.tradplus.ads.common.serialization.asm.Type;

public class ClassWriter {
    int version;
    int index = 1;
    final ByteVector pool = new ByteVector();
    Item[] items = new Item[256];
    int threshold = (int)(0.75 * (double)this.items.length);
    final Item key = new Item();
    final Item key2 = new Item();
    final Item key3 = new Item();
    Item[] typeTable;
    private int access;
    private int name;
    String thisName;
    private int superName;
    private int interfaceCount;
    private int[] interfaces;
    FieldWriter firstField;
    FieldWriter lastField;
    MethodWriter firstMethod;
    MethodWriter lastMethod;

    public ClassWriter() {
        this(0);
    }

    private ClassWriter(int n) {
    }

    public void visit(int n, int n2, String string, String string2, String[] stringArray) {
        this.version = n;
        this.access = n2;
        this.name = this.newClassItem((String)string).index;
        this.thisName = string;
        int n3 = this.superName = string2 == null ? 0 : this.newClassItem((String)string2).index;
        if (stringArray != null && stringArray.length > 0) {
            this.interfaceCount = stringArray.length;
            this.interfaces = new int[this.interfaceCount];
            for (n = 0; n < this.interfaceCount; ++n) {
                this.interfaces[n] = this.newClassItem((String)stringArray[n]).index;
            }
        }
    }

    public byte[] toByteArray() {
        int n = 24 + 2 * this.interfaceCount;
        int n2 = 0;
        Object object = this.firstField;
        while (object != null) {
            ++n2;
            n += ((FieldWriter)object).getSize();
            object = ((FieldWriter)object).next;
        }
        int n3 = 0;
        object = this.firstMethod;
        while (object != null) {
            ++n3;
            n += ((MethodWriter)object).getSize();
            object = ((MethodWriter)object).next;
        }
        ByteVector byteVector = new ByteVector(n += this.pool.length);
        byteVector.putInt(-889275714).putInt(this.version);
        byteVector.putShort(this.index).putByteArray(this.pool.data, 0, this.pool.length);
        byteVector.putShort(this.access & 0xFFF9FFFF).putShort(this.name).putShort(this.superName);
        byteVector.putShort(this.interfaceCount);
        for (int i = 0; i < this.interfaceCount; ++i) {
            byteVector.putShort(this.interfaces[i]);
        }
        byteVector.putShort(n2);
        Object object2 = this.firstField;
        while (object2 != null) {
            ((FieldWriter)object2).put(byteVector);
            object2 = ((FieldWriter)object2).next;
        }
        byteVector.putShort(n3);
        object2 = this.firstMethod;
        while (object2 != null) {
            ((MethodWriter)object2).put(byteVector);
            object2 = ((MethodWriter)object2).next;
        }
        byteVector.putShort(0);
        return byteVector.data;
    }

    Item newConstItem(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            this.key.set(n);
            ClassWriter classWriter = this;
            Item item = classWriter.get(classWriter.key);
            if (item == null) {
                this.pool.putByte(3).putInt(n);
                item = new Item(this.index++, this.key);
                this.put(item);
            }
            return item;
        }
        if (object instanceof String) {
            return this.newString((String)object);
        }
        if (object instanceof Type) {
            object = (Type)object;
            return this.newClassItem(((Type)object).sort == 10 ? ((Type)object).getInternalName() : ((Type)object).getDescriptor());
        }
        throw new IllegalArgumentException("value ".concat(String.valueOf(object)));
    }

    public int newUTF8(String string) {
        this.key.set(1, string, null, null);
        ClassWriter classWriter = this;
        Item item = classWriter.get(classWriter.key);
        if (item == null) {
            this.pool.putByte(1).putUTF8(string);
            item = new Item(this.index++, this.key);
            this.put(item);
        }
        return item.index;
    }

    public Item newClassItem(String string) {
        this.key2.set(7, string, null, null);
        ClassWriter classWriter = this;
        Item item = classWriter.get(classWriter.key2);
        if (item == null) {
            this.pool.put12(7, this.newUTF8(string));
            item = new Item(this.index++, this.key2);
            this.put(item);
        }
        return item;
    }

    Item newFieldItem(String string, String string2, String string3) {
        this.key3.set(9, string, string2, string3);
        ClassWriter classWriter = this;
        Item item = classWriter.get(classWriter.key3);
        if (item == null) {
            int n = this.newClassItem((String)string).index;
            int n2 = this.newNameTypeItem((String)string2, (String)string3).index;
            this.pool.put12(9, n).putShort(n2);
            item = new Item(this.index++, this.key3);
            this.put(item);
        }
        return item;
    }

    Item newMethodItem(String string, String string2, String string3, boolean bl) {
        int n = bl ? 11 : 10;
        this.key3.set(n, string, string2, string3);
        ClassWriter classWriter = this;
        Item item = classWriter.get(classWriter.key3);
        if (item == null) {
            int n2 = this.newClassItem((String)string).index;
            int n22 = this.newNameTypeItem((String)string2, (String)string3).index;
            this.pool.put12(n, n2).putShort(n22);
            item = new Item(this.index++, this.key3);
            this.put(item);
        }
        return item;
    }

    private Item newString(String string) {
        this.key2.set(8, string, null, null);
        ClassWriter classWriter = this;
        Item item = classWriter.get(classWriter.key2);
        if (item == null) {
            this.pool.put12(8, this.newUTF8(string));
            item = new Item(this.index++, this.key2);
            this.put(item);
        }
        return item;
    }

    public Item newNameTypeItem(String string, String string2) {
        this.key2.set(12, string, string2, null);
        ClassWriter classWriter = this;
        Item item = classWriter.get(classWriter.key2);
        if (item == null) {
            int n = this.newUTF8(string);
            int n2 = this.newUTF8(string2);
            this.pool.put12(12, n).putShort(n2);
            item = new Item(this.index++, this.key2);
            this.put(item);
        }
        return item;
    }

    private Item get(Item item) {
        Item item2 = this.items[item.hashCode % this.items.length];
        while (!(item2 == null || item2.type == item.type && item.isEqualTo(item2))) {
            item2 = item2.next;
        }
        return item2;
    }

    private void put(Item item) {
        int n;
        if (this.index > this.threshold) {
            n = this.items.length;
            int n2 = n * 2 + 1;
            Item[] itemArray = new Item[n2];
            --n;
            while (n >= 0) {
                Item item2 = this.items[n];
                while (item2 != null) {
                    int n3 = item2.hashCode % n2;
                    Item item3 = item2.next;
                    item2.next = itemArray[n3];
                    itemArray[n3] = item2;
                    item2 = item3;
                }
                --n;
            }
            this.items = itemArray;
            this.threshold = (int)((double)n2 * 0.75);
        }
        n = item.hashCode % this.items.length;
        item.next = this.items[n];
        this.items[n] = item;
    }
}

