/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.asm;

import com.tradplus.ads.common.serialization.asm.ByteVector;
import com.tradplus.ads.common.serialization.asm.ClassWriter;
import com.tradplus.ads.common.serialization.asm.Item;
import com.tradplus.ads.common.serialization.asm.Label;
import com.tradplus.ads.common.serialization.asm.MethodVisitor;
import com.tradplus.ads.common.serialization.asm.Type;

public class MethodWriter
implements MethodVisitor {
    MethodWriter next;
    final ClassWriter cw;
    private int access;
    private final int name;
    private final int desc;
    int exceptionCount;
    int[] exceptions;
    private ByteVector code = new ByteVector();
    private int maxStack;
    private int maxLocals;

    public MethodWriter(ClassWriter classWriter, int n, String string, String string2, String string3, String[] stringArray) {
        if (classWriter.firstMethod == null) {
            classWriter.firstMethod = this;
        } else {
            classWriter.lastMethod.next = this;
        }
        classWriter.lastMethod = this;
        this.cw = classWriter;
        this.access = n;
        this.name = classWriter.newUTF8(string);
        this.desc = classWriter.newUTF8(string2);
        if (stringArray != null && stringArray.length > 0) {
            this.exceptionCount = stringArray.length;
            this.exceptions = new int[this.exceptionCount];
            for (n = 0; n < this.exceptionCount; ++n) {
                this.exceptions[n] = classWriter.newClassItem((String)stringArray[n]).index;
            }
        }
    }

    @Override
    public void visitInsn(int n) {
        this.code.putByte(n);
    }

    @Override
    public void visitIntInsn(int n, int n2) {
        this.code.put11(n, n2);
    }

    @Override
    public void visitVarInsn(int n, int n2) {
        if (n2 < 4 && n != 169) {
            n = n < 54 ? 26 + (n - 21 << 2) + n2 : 59 + (n - 54 << 2) + n2;
            this.code.putByte(n);
            return;
        }
        if (n2 >= 256) {
            this.code.putByte(196).put12(n, n2);
            return;
        }
        this.code.put11(n, n2);
    }

    @Override
    public void visitTypeInsn(int n, String object) {
        object = this.cw.newClassItem((String)object);
        this.code.put12(n, ((Item)object).index);
    }

    @Override
    public void visitFieldInsn(int n, String object, String string, String string2) {
        object = this.cw.newFieldItem((String)object, string, string2);
        this.code.put12(n, ((Item)object).index);
    }

    @Override
    public void visitMethodInsn(int n, String object, String string, String string2) {
        boolean bl = n == 185;
        object = this.cw.newMethodItem((String)object, string, string2, bl);
        int n2 = ((Item)object).intVal;
        if (bl) {
            if (n2 == 0) {
                ((Item)object).intVal = n2 = Type.getArgumentsAndReturnSizes(string2);
            }
            this.code.put12(185, ((Item)object).index).put11(n2 >> 2, 0);
            return;
        }
        this.code.put12(n, ((Item)object).index);
    }

    @Override
    public void visitJumpInsn(int n, Label label) {
        if ((label.status & 2) != 0 && label.position - this.code.length < Short.MIN_VALUE) {
            throw new UnsupportedOperationException();
        }
        this.code.putByte(n);
        MethodWriter methodWriter = this;
        label.put(methodWriter, methodWriter.code, this.code.length - 1, n == 200);
    }

    @Override
    public void visitLabel(Label label) {
        MethodWriter methodWriter = this;
        label.resolve(methodWriter, methodWriter.code.length, this.code.data);
    }

    @Override
    public void visitLdcInsn(Object object) {
        object = this.cw.newConstItem(object);
        int n = ((Item)object).index;
        if (((Item)object).type == 5 || ((Item)object).type == 6) {
            this.code.put12(20, n);
            return;
        }
        if (n >= 256) {
            this.code.put12(19, n);
            return;
        }
        this.code.put11(18, n);
    }

    @Override
    public void visitIincInsn(int n, int n2) {
        this.code.putByte(132).put11(n, n2);
    }

    @Override
    public void visitMaxs(int n, int n2) {
        this.maxStack = n;
        this.maxLocals = n2;
    }

    @Override
    public void visitEnd() {
    }

    final int getSize() {
        int n = 8;
        if (this.code.length > 0) {
            this.cw.newUTF8("Code");
            n = 8 + (18 + this.code.length + 0);
        }
        if (this.exceptionCount > 0) {
            this.cw.newUTF8("Exceptions");
            n += 8 + 2 * this.exceptionCount;
        }
        return n;
    }

    final void put(ByteVector byteVector) {
        byteVector.putShort(this.access & 0xFFF9FFFF).putShort(this.name).putShort(this.desc);
        int n = 0;
        if (this.code.length > 0) {
            ++n;
        }
        if (this.exceptionCount > 0) {
            ++n;
        }
        byteVector.putShort(n);
        if (this.code.length > 0) {
            n = 12 + this.code.length + 0;
            byteVector.putShort(this.cw.newUTF8("Code")).putInt(n);
            byteVector.putShort(this.maxStack).putShort(this.maxLocals);
            byteVector.putInt(this.code.length).putByteArray(this.code.data, 0, this.code.length);
            byteVector.putShort(0);
            byteVector.putShort(0);
        }
        if (this.exceptionCount > 0) {
            byteVector.putShort(this.cw.newUTF8("Exceptions")).putInt(2 * this.exceptionCount + 2);
            byteVector.putShort(this.exceptionCount);
            for (n = 0; n < this.exceptionCount; ++n) {
                byteVector.putShort(this.exceptions[n]);
            }
        }
    }
}

