/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.asm;

import com.tradplus.ads.common.serialization.annotation.JSONType;
import com.tradplus.ads.common.serialization.asm.MethodCollector;
import com.tradplus.ads.common.serialization.asm.Type;
import com.tradplus.ads.common.serialization.util.ASMUtils;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class TypeCollector {
    private static String JSONType = ASMUtils.desc(JSONType.class);
    private static final Map<String, String> primitives = new HashMap<String, String>(){
        {
            this.put("int", "I");
            this.put("boolean", "Z");
            this.put("byte", "B");
            this.put("char", "C");
            this.put("short", "S");
            this.put("float", "F");
            this.put("long", "J");
            this.put("double", "D");
        }
    };
    private final String methodName;
    private final Class<?>[] parameterTypes;
    protected MethodCollector collector;
    protected boolean jsonType;

    public TypeCollector(String string, Class<?>[] classArray) {
        this.methodName = string;
        this.parameterTypes = classArray;
        this.collector = null;
    }

    protected MethodCollector visitMethod(int n, String typeArray, String string) {
        if (this.collector != null) {
            return null;
        }
        if (!typeArray.equals(this.methodName)) {
            return null;
        }
        typeArray = Type.getArgumentTypes(string);
        int n2 = 0;
        Type[] typeArray2 = typeArray;
        int n3 = typeArray.length;
        for (int i = 0; i < n3; ++i) {
            String string2 = typeArray2[i].getClassName();
            if (!string2.equals("long") && !string2.equals("double")) continue;
            ++n2;
        }
        if (typeArray.length != this.parameterTypes.length) {
            return null;
        }
        for (int i = 0; i < typeArray.length; ++i) {
            if (this.correctTypeName(typeArray[i], this.parameterTypes[i].getName())) continue;
            return null;
        }
        this.collector = new MethodCollector(Modifier.isStatic(n) ? 0 : 1, typeArray.length + n2);
        return this.collector;
    }

    public void visitAnnotation(String string) {
        if (JSONType.equals(string)) {
            this.jsonType = true;
        }
    }

    private boolean correctTypeName(Type object, String string) {
        object = ((Type)object).getClassName();
        StringBuilder stringBuilder = new StringBuilder();
        while (((String)object).endsWith("[]")) {
            stringBuilder.append('[');
            object = ((String)object).substring(0, ((String)object).length() - 2);
        }
        if (stringBuilder.length() != 0) {
            object = primitives.containsKey(object) ? stringBuilder.append(primitives.get(object)).toString() : stringBuilder.append('L').append((String)object).append(';').toString();
        }
        return ((String)object).equals(string);
    }

    public String[] getParameterNamesForMethod() {
        if (this.collector == null || !this.collector.debugInfoPresent) {
            return new String[0];
        }
        return this.collector.getResult().split(",");
    }

    public boolean matched() {
        return this.collector != null;
    }

    public boolean hasJsonType() {
        return this.jsonType;
    }
}

