/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.JSONScanner;
import com.tradplus.ads.common.serialization.parser.JSONToken;
import com.tradplus.ads.common.serialization.parser.SymbolTable;
import com.tradplus.ads.common.serialization.util.IOUtils;
import java.io.Closeable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;

public abstract class JSONLexerBase
implements JSONLexer,
Closeable {
    protected int token;
    protected int pos;
    protected int features;
    protected char ch;
    protected int bp;
    protected int eofPos;
    protected char[] sbuf;
    protected int sp;
    protected int np;
    protected boolean hasSpecial;
    protected Calendar calendar = null;
    protected TimeZone timeZone = JSON.defaultTimeZone;
    protected Locale locale = JSON.defaultLocale;
    public int matchStat = 0;
    private static final ThreadLocal<char[]> SBUF_LOCAL = new ThreadLocal();
    protected String stringDefaultValue = null;
    protected int nanos = 0;
    protected static final char[] typeFieldName = ("\"" + JSON.DEFAULT_TYPE_KEY + "\":\"").toCharArray();
    protected static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    protected static final int INT_MULTMIN_RADIX_TEN = -214748364;
    protected static final int[] digits = new int[103];

    protected void lexError(String string, Object ... objectArray) {
        this.token = 1;
    }

    public JSONLexerBase(int n) {
        this.features = n;
        if ((n & Feature.InitStringFieldAsEmpty.mask) != 0) {
            this.stringDefaultValue = "";
        }
        this.sbuf = SBUF_LOCAL.get();
        if (this.sbuf == null) {
            this.sbuf = new char[512];
        }
    }

    public final int matchStat() {
        return this.matchStat;
    }

    public void setToken(int n) {
        this.token = n;
    }

    @Override
    public final void nextToken() {
        this.sp = 0;
        block19: while (true) {
            this.pos = this.bp;
            if (this.ch == '/') {
                this.skipComment();
                continue;
            }
            if (this.ch == '\"') {
                this.scanString();
                return;
            }
            if (this.ch == ',') {
                this.next();
                this.token = 16;
                return;
            }
            if (this.ch >= '0' && this.ch <= '9') {
                this.scanNumber();
                return;
            }
            if (this.ch == '-') {
                this.scanNumber();
                return;
            }
            switch (this.ch) {
                case '\'': {
                    if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                        throw new JSONException("Feature.AllowSingleQuotes is false");
                    }
                    this.scanStringSingleQuote();
                    return;
                }
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    this.next();
                    continue block19;
                }
                case 't': {
                    this.scanTrue();
                    return;
                }
                case 'f': {
                    this.scanFalse();
                    return;
                }
                case 'n': {
                    this.scanNullOrNew();
                    return;
                }
                case 'N': 
                case 'S': 
                case 'T': 
                case 'u': {
                    this.scanIdent();
                    return;
                }
                case '(': {
                    this.next();
                    this.token = 10;
                    return;
                }
                case ')': {
                    this.next();
                    this.token = 11;
                    return;
                }
                case '[': {
                    this.next();
                    this.token = 14;
                    return;
                }
                case ']': {
                    this.next();
                    this.token = 15;
                    return;
                }
                case '{': {
                    this.next();
                    this.token = 12;
                    return;
                }
                case '}': {
                    this.next();
                    this.token = 13;
                    return;
                }
                case ':': {
                    this.next();
                    this.token = 17;
                    return;
                }
                case ';': {
                    this.next();
                    this.token = 24;
                    return;
                }
                case '.': {
                    this.next();
                    this.token = 25;
                    return;
                }
                case '+': {
                    this.next();
                    this.scanNumber();
                    return;
                }
                case 'x': {
                    this.scanHex();
                    return;
                }
            }
            if (this.isEOF()) {
                if (this.token == 20) {
                    throw new JSONException("EOF error");
                }
                this.token = 20;
                JSONLexerBase jSONLexerBase = this;
                jSONLexerBase.eofPos = jSONLexerBase.pos = this.bp;
                return;
            }
            if (this.ch > '\u001f' && this.ch != '\u007f') break;
            this.next();
        }
        this.lexError("illegal.char", String.valueOf((int)this.ch));
        this.next();
    }

    @Override
    public final void nextToken(int n) {
        this.sp = 0;
        while (true) {
            switch (n) {
                case 12: {
                    if (this.ch == '{') {
                        this.token = 12;
                        this.next();
                        return;
                    }
                    if (this.ch != '[') break;
                    this.token = 14;
                    this.next();
                    return;
                }
                case 16: {
                    if (this.ch == ',') {
                        this.token = 16;
                        this.next();
                        return;
                    }
                    if (this.ch == '}') {
                        this.token = 13;
                        this.next();
                        return;
                    }
                    if (this.ch == ']') {
                        this.token = 15;
                        this.next();
                        return;
                    }
                    if (this.ch == '\u001a') {
                        this.token = 20;
                        return;
                    }
                    if (this.ch != 'n') break;
                    this.scanNullOrNew(false);
                    return;
                }
                case 2: {
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '\"') {
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 4: {
                    if (this.ch == '\"') {
                        this.pos = this.bp;
                        this.scanString();
                        return;
                    }
                    if (this.ch >= '0' && this.ch <= '9') {
                        this.pos = this.bp;
                        this.scanNumber();
                        return;
                    }
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 14: {
                    if (this.ch == '[') {
                        this.token = 14;
                        this.next();
                        return;
                    }
                    if (this.ch != '{') break;
                    this.token = 12;
                    this.next();
                    return;
                }
                case 15: {
                    if (this.ch == ']') {
                        this.token = 15;
                        this.next();
                        return;
                    }
                }
                case 20: {
                    if (this.ch != '\u001a') break;
                    this.token = 20;
                    return;
                }
                case 18: {
                    this.nextIdent();
                    return;
                }
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.next();
        }
        this.nextToken();
    }

    public final void nextIdent() {
        while (JSONLexerBase.isWhitespace(this.ch)) {
            this.next();
        }
        if (this.ch == '_' || this.ch == '$' || Character.isLetter(this.ch)) {
            this.scanIdent();
            return;
        }
        this.nextToken();
    }

    @Override
    public final void nextTokenWithColon() {
        this.nextTokenWithChar(':');
    }

    public final void nextTokenWithChar(char c) {
        this.sp = 0;
        while (true) {
            if (this.ch == c) {
                this.next();
                this.nextToken();
                return;
            }
            if (this.ch != ' ' && this.ch != '\n' && this.ch != '\r' && this.ch != '\t' && this.ch != '\f' && this.ch != '\b') break;
            this.next();
        }
        throw new JSONException("not match " + c + " - " + this.ch + ", info : " + this.info());
    }

    @Override
    public final int token() {
        return this.token;
    }

    @Override
    public final String tokenName() {
        return JSONToken.name(this.token);
    }

    @Override
    public final int pos() {
        return this.pos;
    }

    public final String stringDefaultValue() {
        return this.stringDefaultValue;
    }

    @Override
    public final Number integerValue() {
        long l;
        long l2 = 0L;
        boolean bl = false;
        if (this.np == -1) {
            this.np = 0;
        }
        int n = this.np;
        int n2 = this.np + this.sp;
        int n3 = 32;
        switch (this.charAt(n2 - 1)) {
            case 'L': {
                --n2;
                n3 = 76;
                break;
            }
            case 'S': {
                --n2;
                n3 = 83;
                break;
            }
            case 'B': {
                --n2;
                n3 = 66;
            }
        }
        JSONLexerBase jSONLexerBase = this;
        if (jSONLexerBase.charAt(jSONLexerBase.np) == '-') {
            bl = true;
            l = Long.MIN_VALUE;
            ++n;
        } else {
            l = -9223372036854775807L;
        }
        if (n < n2) {
            l2 = -(this.charAt(n++) - 48);
        }
        while (n < n2) {
            int n4 = this.charAt(n++) - 48;
            if (l2 < -922337203685477580L) {
                return new BigInteger(this.numberString(), 10);
            }
            if ((l2 *= 10L) < l + (long)n4) {
                return new BigInteger(this.numberString(), 10);
            }
            l2 -= (long)n4;
        }
        if (bl) {
            if (n > this.np + 1) {
                if (l2 >= Integer.MIN_VALUE && n3 != 76) {
                    if (n3 == 83) {
                        return (short)l2;
                    }
                    if (n3 == 66) {
                        return (byte)l2;
                    }
                    return (int)l2;
                }
                return l2;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((l2 = -l2) <= Integer.MAX_VALUE && n3 != 76) {
            if (n3 == 83) {
                return (short)l2;
            }
            if (n3 == 66) {
                return (byte)l2;
            }
            return (int)l2;
        }
        return l2;
    }

    @Override
    public final void nextTokenWithColon(int n) {
        this.nextTokenWithChar(':');
    }

    @Override
    public float floatValue() {
        char c;
        String string = this.numberString();
        float f = Float.parseFloat(string);
        if ((f == 0.0f || f == Float.POSITIVE_INFINITY) && (c = string.charAt(0)) > '0' && c <= '9') {
            throw new JSONException("float overflow : ".concat(String.valueOf(string)));
        }
        return f;
    }

    public double doubleValue() {
        return Double.parseDouble(this.numberString());
    }

    @Override
    public void jsonCfg(Feature feature, boolean bl) {
        this.features = Feature.jsonCfg(this.features, feature, bl);
        if ((this.features & Feature.InitStringFieldAsEmpty.mask) != 0) {
            this.stringDefaultValue = "";
        }
    }

    @Override
    public final boolean isEnabled(Feature feature) {
        return this.isEnabled(feature.mask);
    }

    @Override
    public final boolean isEnabled(int n) {
        return (this.features & n) != 0;
    }

    public final boolean isEnabled(int n, int n2) {
        return (this.features & n2) != 0 || (n & n2) != 0;
    }

    @Override
    public abstract String numberString();

    public abstract boolean isEOF();

    @Override
    public final char getCurrent() {
        return this.ch;
    }

    public abstract char charAt(int var1);

    @Override
    public abstract char next();

    protected void skipComment() {
        this.next();
        if (this.ch == '/') {
            do {
                this.next();
                if (this.ch != '\n') continue;
                this.next();
                return;
            } while (this.ch != '\u001a');
            return;
        }
        if (this.ch == '*') {
            this.next();
            while (this.ch != '\u001a') {
                if (this.ch == '*') {
                    this.next();
                    if (this.ch != '/') continue;
                    this.next();
                    return;
                }
                this.next();
            }
        } else {
            throw new JSONException("invalid comment");
        }
    }

    @Override
    public final String scanSymbol(SymbolTable symbolTable) {
        this.skipWhitespace();
        if (this.ch == '\"') {
            return this.scanSymbol(symbolTable, '\"');
        }
        if (this.ch == '\'') {
            if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                throw new JSONException("syntax error");
            }
            return this.scanSymbol(symbolTable, '\'');
        }
        if (this.ch == '}') {
            this.next();
            this.token = 13;
            return null;
        }
        if (this.ch == ',') {
            this.next();
            this.token = 16;
            return null;
        }
        if (this.ch == '\u001a') {
            this.token = 20;
            return null;
        }
        if (!this.isEnabled(Feature.AllowUnQuotedFieldNames)) {
            throw new JSONException("syntax error");
        }
        return this.scanSymbolUnQuoted(symbolTable);
    }

    protected abstract void arrayCopy(int var1, char[] var2, int var3, int var4);

    /*
     * WARNING - void declaration
     */
    @Override
    public final String scanSymbol(SymbolTable symbolTable, char c) {
        void var5_8;
        char c2;
        int n = 0;
        this.np = this.bp;
        this.sp = 0;
        boolean bl = false;
        block22: while ((c2 = this.next()) != c) {
            if (c2 == '\u001a') {
                throw new JSONException("unclosed.str");
            }
            if (c2 == '\\') {
                if (!bl) {
                    bl = true;
                    if (this.sp >= this.sbuf.length) {
                        c2 = this.sbuf.length * 2;
                        if (this.sp > c2) {
                            c2 = this.sp;
                        }
                        char[] c4 = new char[c2];
                        System.arraycopy(this.sbuf, 0, c4, 0, this.sbuf.length);
                        this.sbuf = c4;
                    }
                    JSONLexerBase jSONLexerBase = this;
                    jSONLexerBase.arrayCopy(jSONLexerBase.np + 1, this.sbuf, 0, this.sp);
                }
                c2 = this.next();
                switch (c2) {
                    case '0': {
                        n = 31 * n + c2;
                        this.putChar('\u0000');
                        continue block22;
                    }
                    case '1': {
                        n = 31 * n + c2;
                        this.putChar('\u0001');
                        continue block22;
                    }
                    case '2': {
                        n = 31 * n + c2;
                        this.putChar('\u0002');
                        continue block22;
                    }
                    case '3': {
                        n = 31 * n + c2;
                        this.putChar('\u0003');
                        continue block22;
                    }
                    case '4': {
                        n = 31 * n + c2;
                        this.putChar('\u0004');
                        continue block22;
                    }
                    case '5': {
                        n = 31 * n + c2;
                        this.putChar('\u0005');
                        continue block22;
                    }
                    case '6': {
                        n = 31 * n + c2;
                        this.putChar('\u0006');
                        continue block22;
                    }
                    case '7': {
                        n = 31 * n + c2;
                        this.putChar('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        n = 31 * n + 8;
                        this.putChar('\b');
                        continue block22;
                    }
                    case 't': {
                        n = 31 * n + 9;
                        this.putChar('\t');
                        continue block22;
                    }
                    case 'n': {
                        n = 31 * n + 10;
                        this.putChar('\n');
                        continue block22;
                    }
                    case 'v': {
                        n = 31 * n + 11;
                        this.putChar('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        n = 31 * n + 12;
                        this.putChar('\f');
                        continue block22;
                    }
                    case 'r': {
                        n = 31 * n + 13;
                        this.putChar('\r');
                        continue block22;
                    }
                    case '\"': {
                        n = 31 * n + 34;
                        this.putChar('\"');
                        continue block22;
                    }
                    case '\'': {
                        n = 31 * n + 39;
                        this.putChar('\'');
                        continue block22;
                    }
                    case '/': {
                        n = 31 * n + 47;
                        this.putChar('/');
                        continue block22;
                    }
                    case '\\': {
                        n = 31 * n + 92;
                        this.putChar('\\');
                        continue block22;
                    }
                    case 'x': {
                        c2 = this.ch = this.next();
                        char n2 = this.ch = this.next();
                        c2 = (char)(digits[c2] * 16 + digits[n2]);
                        n = 31 * n + c2;
                        this.putChar(c2);
                        continue block22;
                    }
                    case 'u': {
                        c2 = this.next();
                        char c3 = this.next();
                        char c4 = this.next();
                        char c5 = this.next();
                        c2 = Integer.parseInt(new String(new char[]{c2, c3, c4, c5}), 16);
                        n = 31 * n + c2;
                        this.putChar(c2);
                        continue block22;
                    }
                }
                this.ch = c2;
                throw new JSONException("unclosed.str.lit");
            }
            n = 31 * n + c2;
            if (!bl) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(c2);
                continue;
            }
            this.sbuf[this.sp++] = c2;
        }
        this.token = 4;
        if (!bl) {
            int n2 = this.np == -1 ? 0 : this.np + 1;
            String string = this.addSymbol(n2, this.sp, n, symbolTable);
        } else {
            String string = symbolTable.addSymbol(this.sbuf, 0, this.sp, n);
        }
        this.sp = 0;
        this.next();
        return var5_8;
    }

    @Override
    public final void resetStringPosition() {
        this.sp = 0;
    }

    @Override
    public String info() {
        return "";
    }

    @Override
    public final String scanSymbolUnQuoted(SymbolTable symbolTable) {
        char c;
        if (this.token == 1 && this.pos == 0 && this.bp == 1) {
            this.bp = 0;
        }
        boolean[] blArray = IOUtils.firstIdentifierFlags;
        int n = this.ch;
        if (!(this.ch >= blArray.length || blArray[n])) {
            throw new JSONException("illegal identifier : " + this.ch + this.info());
        }
        blArray = IOUtils.identifierFlags;
        this.np = this.bp;
        this.sp = 1;
        while ((c = this.next()) >= blArray.length || blArray[c]) {
            n = 31 * n + c;
            ++this.sp;
        }
        this.ch = this.charAt(this.bp);
        this.token = 18;
        if (this.sp == 4 && n == 3392903) {
            JSONLexerBase jSONLexerBase = this;
            if (jSONLexerBase.charAt(jSONLexerBase.np) == 'n') {
                JSONLexerBase jSONLexerBase2 = this;
                if (jSONLexerBase2.charAt(jSONLexerBase2.np + 1) == 'u') {
                    JSONLexerBase jSONLexerBase3 = this;
                    if (jSONLexerBase3.charAt(jSONLexerBase3.np + 2) == 'l') {
                        JSONLexerBase jSONLexerBase4 = this;
                        if (jSONLexerBase4.charAt(jSONLexerBase4.np + 3) == 'l') {
                            return null;
                        }
                    }
                }
            }
        }
        if (symbolTable == null) {
            JSONLexerBase jSONLexerBase = this;
            return jSONLexerBase.subString(jSONLexerBase.np, this.sp);
        }
        JSONLexerBase jSONLexerBase = this;
        return jSONLexerBase.addSymbol(jSONLexerBase.np, this.sp, n, symbolTable);
    }

    protected abstract void copyTo(int var1, int var2, char[] var3);

    @Override
    public final void scanString() {
        char c;
        this.np = this.bp;
        this.hasSpecial = false;
        block22: while ((c = this.next()) != '\"') {
            if (c == '\u001a') {
                if (!this.isEOF()) {
                    this.putChar('\u001a');
                    continue;
                }
                throw new JSONException("unclosed string : ".concat(String.valueOf(c)));
            }
            if (c == '\\') {
                if (!this.hasSpecial) {
                    this.hasSpecial = true;
                    if (this.sp >= this.sbuf.length) {
                        c = this.sbuf.length * 2;
                        if (this.sp > c) {
                            c = this.sp;
                        }
                        char[] cArray = new char[c];
                        System.arraycopy(this.sbuf, 0, cArray, 0, this.sbuf.length);
                        this.sbuf = cArray;
                    }
                    JSONLexerBase jSONLexerBase = this;
                    jSONLexerBase.copyTo(jSONLexerBase.np + 1, this.sp, this.sbuf);
                }
                c = this.next();
                switch (c) {
                    case '0': {
                        this.putChar('\u0000');
                        continue block22;
                    }
                    case '1': {
                        this.putChar('\u0001');
                        continue block22;
                    }
                    case '2': {
                        this.putChar('\u0002');
                        continue block22;
                    }
                    case '3': {
                        this.putChar('\u0003');
                        continue block22;
                    }
                    case '4': {
                        this.putChar('\u0004');
                        continue block22;
                    }
                    case '5': {
                        this.putChar('\u0005');
                        continue block22;
                    }
                    case '6': {
                        this.putChar('\u0006');
                        continue block22;
                    }
                    case '7': {
                        this.putChar('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block22;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block22;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block22;
                    }
                    case 'v': {
                        this.putChar('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block22;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block22;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block22;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block22;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block22;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block22;
                    }
                    case 'x': {
                        char c2;
                        c = this.next();
                        char c3 = this.next();
                        char c4 = c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' ? (char)'\u0001' : '\u0000';
                        char c5 = c2 = c3 >= '0' && c3 <= '9' || c3 >= 'a' && c3 <= 'f' || c3 >= 'A' && c3 <= 'F' ? (char)'\u0001' : '\u0000';
                        if (c4 == '\u0000' || c2 == '\u0000') {
                            throw new JSONException("invalid escape character \\x" + c + c3);
                        }
                        c = (char)(digits[c] * 16 + digits[c3]);
                        this.putChar(c);
                        continue block22;
                    }
                    case 'u': {
                        c = this.next();
                        char c6 = this.next();
                        char c4 = this.next();
                        char c2 = this.next();
                        c = Integer.parseInt(new String(new char[]{c, c6, c4, c2}), 16);
                        this.putChar(c);
                        continue block22;
                    }
                }
                this.ch = c;
                throw new JSONException("unclosed string : ".concat(String.valueOf(c)));
            }
            if (!this.hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(c);
                continue;
            }
            this.sbuf[this.sp++] = c;
        }
        this.token = 4;
        this.ch = this.next();
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public final int intValue() {
        int n;
        int n2;
        if (this.np == -1) {
            this.np = 0;
        }
        int n3 = 0;
        boolean bl = false;
        int n4 = this.np;
        int n5 = this.np + this.sp;
        JSONLexerBase jSONLexerBase = this;
        if (jSONLexerBase.charAt(jSONLexerBase.np) == '-') {
            bl = true;
            n2 = Integer.MIN_VALUE;
            ++n4;
        } else {
            n2 = -2147483647;
        }
        if (n4 < n5) {
            n3 = -(this.charAt(n4++) - 48);
        }
        while (n4 < n5 && (n = this.charAt(n4++)) != 76 && n != 83 && n != 66) {
            n -= 48;
            if ((long)n3 < -214748364L) {
                throw new NumberFormatException(this.numberString());
            }
            if ((n3 *= 10) < n2 + n) {
                throw new NumberFormatException(this.numberString());
            }
            n3 -= n;
        }
        if (bl) {
            if (n4 > this.np + 1) {
                return n3;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -n3;
    }

    @Override
    public abstract byte[] bytesValue();

    @Override
    public void close() {
        if (this.sbuf.length <= 8192) {
            SBUF_LOCAL.set(this.sbuf);
        }
        this.sbuf = null;
    }

    @Override
    public final boolean isRef() {
        if (this.sp != 4) {
            return false;
        }
        JSONLexerBase jSONLexerBase = this;
        if (jSONLexerBase.charAt(jSONLexerBase.np + 1) == '$') {
            JSONLexerBase jSONLexerBase2 = this;
            if (jSONLexerBase2.charAt(jSONLexerBase2.np + 2) == 'r') {
                JSONLexerBase jSONLexerBase3 = this;
                if (jSONLexerBase3.charAt(jSONLexerBase3.np + 3) == 'e') {
                    JSONLexerBase jSONLexerBase4 = this;
                    if (jSONLexerBase4.charAt(jSONLexerBase4.np + 4) == 'f') {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public String scanTypeName(SymbolTable symbolTable) {
        return null;
    }

    public final int scanType(String string) {
        this.matchStat = 0;
        if (!this.charArrayCompare(typeFieldName)) {
            return -2;
        }
        int n = this.bp + typeFieldName.length;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) == this.charAt(n + i)) continue;
            return -1;
        }
        if (this.charAt(n += n2) != '\"') {
            return -1;
        }
        this.ch = this.charAt(++n);
        if (this.ch == ',') {
            this.ch = this.charAt(++n);
            this.bp = n;
            this.token = 16;
            return 3;
        }
        if (this.ch == '}') {
            this.ch = this.charAt(++n);
            if (this.ch == ',') {
                this.token = 16;
                this.ch = this.charAt(++n);
            } else if (this.ch == ']') {
                this.token = 15;
                this.ch = this.charAt(++n);
            } else if (this.ch == '}') {
                this.token = 13;
                this.ch = this.charAt(++n);
            } else if (this.ch == '\u001a') {
                this.token = 20;
            } else {
                return -1;
            }
            this.matchStat = 4;
        }
        this.bp = n;
        return this.matchStat;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean matchField(char[] cArray) {
        while (!this.charArrayCompare(cArray)) {
            if (!JSONLexerBase.isWhitespace(this.ch)) return false;
            this.next();
        }
        this.bp += cArray.length;
        this.ch = this.charAt(this.bp);
        if (this.ch == '{') {
            this.next();
            this.token = 12;
            return true;
        }
        if (this.ch == '[') {
            this.next();
            this.token = 14;
            return true;
        }
        if (this.ch == 'S') {
            JSONLexerBase jSONLexerBase = this;
            if (jSONLexerBase.charAt(jSONLexerBase.bp + 1) == 'e') {
                JSONLexerBase jSONLexerBase2 = this;
                if (jSONLexerBase2.charAt(jSONLexerBase2.bp + 2) == 't') {
                    JSONLexerBase jSONLexerBase3 = this;
                    if (jSONLexerBase3.charAt(jSONLexerBase3.bp + 3) == '[') {
                        this.bp += 3;
                        this.ch = this.charAt(this.bp);
                        this.token = 21;
                        return true;
                    }
                }
            }
        }
        this.nextToken();
        return true;
    }

    public int matchField(long l) {
        throw new UnsupportedOperationException();
    }

    public boolean seekArrayToItem(int n) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToField(long l, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToField(long[] lArray) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToFieldDeepScan(long l) {
        throw new UnsupportedOperationException();
    }

    public void skipObject() {
        throw new UnsupportedOperationException();
    }

    public void skipObject(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void skipArray() {
        throw new UnsupportedOperationException();
    }

    public abstract int indexOf(char var1, int var2);

    public abstract String addSymbol(int var1, int var2, int var3, SymbolTable var4);

    /*
     * Enabled aggressive block sorting
     */
    public String scanFieldString(char[] object) {
        this.matchStat = 0;
        if (!this.charArrayCompare((char[])object)) {
            this.matchStat = -2;
            return this.stringDefaultValue();
        }
        int n = ((char[])object).length;
        JSONLexerBase jSONLexerBase = this;
        if (jSONLexerBase.charAt(jSONLexerBase.bp + n++) != '\"') {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        int n2 = this.bp + ((char[])object).length + 1;
        if ((n2 = this.indexOf('\"', n2)) == -1) {
            throw new JSONException("unclosed str");
        }
        int n3 = this.bp + ((char[])object).length + 1;
        String string = this.subString(n3, n2 - n3);
        if (string.indexOf(92) != -1) {
            int n4;
            while (true) {
                n4 = 0;
                for (int i = n2 - 1; i >= 0 && this.charAt(i) == '\\'; ++n4, --i) {
                }
                if (n4 % 2 == 0) break;
                n2 = this.indexOf('\"', n2 + 1);
            }
            n4 = n2 - (this.bp + ((char[])object).length + 1);
            JSONLexerBase jSONLexerBase2 = this;
            string = JSONLexerBase.readString(jSONLexerBase2.sub_chars(jSONLexerBase2.bp + ((char[])object).length + 1, n4), n4);
        }
        n += n2 - (this.bp + ((char[])object).length + 1) + 1;
        JSONLexerBase jSONLexerBase3 = this;
        n2 = jSONLexerBase3.charAt(jSONLexerBase3.bp + n++);
        String string2 = string;
        if (n2 == 44) {
            this.bp += n;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return string2;
        }
        if (n2 != 125) {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        JSONLexerBase jSONLexerBase4 = this;
        char c = jSONLexerBase4.charAt(jSONLexerBase4.bp + n++);
        n2 = c;
        if (c == ',') {
            this.token = 16;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (n2 == 93) {
            this.token = 15;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (n2 == 125) {
            this.token = 13;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else {
            if (n2 != 26) {
                this.matchStat = -1;
                return this.stringDefaultValue();
            }
            this.token = 20;
            this.bp += n - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return string2;
    }

    @Override
    public String scanString(char c) {
        String string;
        char c2;
        int n;
        block14: {
            block15: {
                block17: {
                    block16: {
                        this.matchStat = 0;
                        n = 0;
                        JSONLexerBase jSONLexerBase = this;
                        ++n;
                        c2 = jSONLexerBase.charAt(jSONLexerBase.bp + 0);
                        if (c2 != 'n') break block15;
                        JSONLexerBase jSONLexerBase2 = this;
                        if (jSONLexerBase2.charAt(jSONLexerBase2.bp + 1) != 'u') break block16;
                        JSONLexerBase jSONLexerBase3 = this;
                        if (jSONLexerBase3.charAt(jSONLexerBase3.bp + 1 + 1) != 'l') break block16;
                        JSONLexerBase jSONLexerBase4 = this;
                        if (jSONLexerBase4.charAt(jSONLexerBase4.bp + 1 + 2) == 'l') break block17;
                    }
                    this.matchStat = -1;
                    return null;
                }
                JSONLexerBase jSONLexerBase = this;
                c2 = jSONLexerBase.charAt(jSONLexerBase.bp + 4);
                if (c2 == c) {
                    this.bp += 5;
                    this.ch = this.charAt(this.bp);
                    this.matchStat = 3;
                    return null;
                }
                this.matchStat = -1;
                return null;
            }
            while (true) {
                if (c2 == '\"') {
                    c2 = this.bp + n;
                    int n2 = this.indexOf('\"', c2);
                    if (n2 == -1) {
                        throw new JSONException("unclosed str");
                    }
                    JSONLexerBase jSONLexerBase = this;
                    string = jSONLexerBase.subString(jSONLexerBase.bp + n, n2 - c2);
                    if (string.indexOf(92) != -1) {
                        int n3;
                        while (true) {
                            n3 = 0;
                            for (int i = n2 - 1; i >= 0 && this.charAt(i) == '\\'; --i) {
                                ++n3;
                            }
                            if (n3 % 2 == 0) break;
                            n2 = this.indexOf('\"', n2 + 1);
                        }
                        n3 = n2 - c2;
                        JSONLexerBase jSONLexerBase5 = this;
                        string = JSONLexerBase.readString(jSONLexerBase5.sub_chars(jSONLexerBase5.bp + 1, n3), n3);
                    }
                    n += n2 - c2 + 1;
                    break block14;
                }
                if (!JSONLexerBase.isWhitespace(c2)) break;
                JSONLexerBase jSONLexerBase = this;
                c2 = jSONLexerBase.charAt(jSONLexerBase.bp + n++);
            }
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        JSONLexerBase jSONLexerBase = this;
        c2 = jSONLexerBase.charAt(jSONLexerBase.bp + n++);
        String string2 = string;
        while (true) {
            if (c2 == c) {
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                return string2;
            }
            if (!JSONLexerBase.isWhitespace(c2)) break;
            JSONLexerBase jSONLexerBase6 = this;
            c2 = jSONLexerBase6.charAt(jSONLexerBase6.bp + n++);
        }
        if (c2 == ']') {
            this.bp += n;
            this.ch = this.charAt(this.bp);
            this.matchStat = -1;
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanFieldSymbol(char[] cArray) {
        char c;
        long l;
        int n;
        block12: {
            block13: {
                this.matchStat = 0;
                if (!this.charArrayCompare(cArray)) {
                    this.matchStat = -2;
                    return 0L;
                }
                n = cArray.length;
                JSONLexerBase jSONLexerBase = this;
                if (jSONLexerBase.charAt(jSONLexerBase.bp + n++) != '\"') {
                    this.matchStat = -1;
                    return 0L;
                }
                l = -3750763034362895579L;
                do {
                    JSONLexerBase jSONLexerBase2 = this;
                    if ((c = jSONLexerBase2.charAt(jSONLexerBase2.bp + n++)) == '\"') {
                        JSONLexerBase jSONLexerBase3 = this;
                        if ((c = jSONLexerBase3.charAt(jSONLexerBase3.bp + n++)) != ',') break block12;
                        break block13;
                    }
                    l = (l ^ (long)c) * 1099511628211L;
                } while (c != '\\');
                this.matchStat = -1;
                return 0L;
            }
            this.bp += n;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return l;
        }
        if (c != '}') {
            this.matchStat = -1;
            return 0L;
        }
        JSONLexerBase jSONLexerBase = this;
        if ((c = jSONLexerBase.charAt(jSONLexerBase.bp + n++)) == ',') {
            this.token = 16;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c == ']') {
            this.token = 15;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c == '}') {
            this.token = 13;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else {
            if (c != '\u001a') {
                this.matchStat = -1;
                return 0L;
            }
            this.token = 20;
            this.bp += n - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanEnumSymbol(char[] cArray) {
        int n;
        long l;
        int n2;
        block12: {
            block13: {
                this.matchStat = 0;
                if (!this.charArrayCompare(cArray)) {
                    this.matchStat = -2;
                    return 0L;
                }
                n2 = cArray.length;
                JSONLexerBase jSONLexerBase = this;
                if (jSONLexerBase.charAt(jSONLexerBase.bp + n2++) != '\"') {
                    this.matchStat = -1;
                    return 0L;
                }
                l = -3750763034362895579L;
                do {
                    JSONLexerBase jSONLexerBase2 = this;
                    if ((n = jSONLexerBase2.charAt(jSONLexerBase2.bp + n2++)) == 34) {
                        JSONLexerBase jSONLexerBase3 = this;
                        if ((n = jSONLexerBase3.charAt(jSONLexerBase3.bp + n2++)) != 44) break block12;
                        break block13;
                    }
                    l = (l ^ (long)(n >= 65 && n <= 90 ? n + 32 : n)) * 1099511628211L;
                } while (n != 92);
                this.matchStat = -1;
                return 0L;
            }
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return l;
        }
        if (n != 125) {
            this.matchStat = -1;
            return 0L;
        }
        JSONLexerBase jSONLexerBase = this;
        char c = jSONLexerBase.charAt(jSONLexerBase.bp + n2++);
        n = c;
        if (c == ',') {
            this.token = 16;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (n == 93) {
            this.token = 15;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (n == 125) {
            this.token = 13;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else {
            if (n != 26) {
                this.matchStat = -1;
                return 0L;
            }
            this.token = 20;
            this.bp += n2 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return l;
    }

    @Override
    public Enum<?> scanEnum(Class<?> clazz, SymbolTable object, char c) {
        if ((object = this.scanSymbolWithSeperator((SymbolTable)object, c)) == null) {
            return null;
        }
        return Enum.valueOf(clazz, (String)object);
    }

    @Override
    public String scanSymbolWithSeperator(SymbolTable object, char c) {
        int n;
        char c2;
        int n2;
        block8: {
            block9: {
                block11: {
                    block10: {
                        this.matchStat = 0;
                        n2 = 0;
                        JSONLexerBase jSONLexerBase = this;
                        ++n2;
                        c2 = jSONLexerBase.charAt(jSONLexerBase.bp + 0);
                        if (c2 != 'n') break block9;
                        JSONLexerBase jSONLexerBase2 = this;
                        if (jSONLexerBase2.charAt(jSONLexerBase2.bp + 1) != 'u') break block10;
                        JSONLexerBase jSONLexerBase3 = this;
                        if (jSONLexerBase3.charAt(jSONLexerBase3.bp + 1 + 1) != 'l') break block10;
                        JSONLexerBase jSONLexerBase4 = this;
                        if (jSONLexerBase4.charAt(jSONLexerBase4.bp + 1 + 2) == 'l') break block11;
                    }
                    this.matchStat = -1;
                    return null;
                }
                JSONLexerBase jSONLexerBase = this;
                c2 = jSONLexerBase.charAt(jSONLexerBase.bp + 4);
                if (c2 == c) {
                    this.bp += 5;
                    this.ch = this.charAt(this.bp);
                    this.matchStat = 3;
                    return null;
                }
                this.matchStat = -1;
                return null;
            }
            if (c2 != '\"') {
                this.matchStat = -1;
                return null;
            }
            n = 0;
            do {
                JSONLexerBase jSONLexerBase = this;
                if ((c2 = jSONLexerBase.charAt(jSONLexerBase.bp + n2++)) == '\"') break block8;
                n = 31 * n + c2;
            } while (c2 != '\\');
            this.matchStat = -1;
            return null;
        }
        c2 = this.bp + 0 + 1;
        int n3 = this.bp + n2 - c2 - 1;
        object = this.addSymbol(c2, n3, n, (SymbolTable)object);
        JSONLexerBase jSONLexerBase = this;
        c2 = jSONLexerBase.charAt(jSONLexerBase.bp + n2++);
        while (true) {
            if (c2 == c) {
                this.bp += n2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                return object;
            }
            if (!JSONLexerBase.isWhitespace(c2)) break;
            JSONLexerBase jSONLexerBase5 = this;
            c2 = jSONLexerBase5.charAt(jSONLexerBase5.bp + n2++);
        }
        this.matchStat = -1;
        return object;
    }

    public Collection<String> newCollectionByType(Class<?> clazz) {
        if (clazz.isAssignableFrom(HashSet.class)) {
            return new HashSet<String>();
        }
        if (clazz.isAssignableFrom(ArrayList.class)) {
            return new ArrayList<String>();
        }
        if (clazz.isAssignableFrom(LinkedList.class)) {
            return new LinkedList<String>();
        }
        try {
            return (Collection)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new JSONException(exception.getMessage(), exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Collection<String> scanFieldStringArray(char[] cArray, Class<?> collection) {
        int n;
        int n2;
        block20: {
            this.matchStat = 0;
            if (!this.charArrayCompare(cArray)) {
                this.matchStat = -2;
                return null;
            }
            collection = this.newCollectionByType((Class<?>)((Object)collection));
            n2 = cArray.length;
            JSONLexerBase jSONLexerBase = this;
            if (jSONLexerBase.charAt(jSONLexerBase.bp + n2++) != '[') {
                this.matchStat = -1;
                return null;
            }
            do {
                String string;
                block22: {
                    int n3;
                    block23: {
                        block21: {
                            JSONLexerBase jSONLexerBase2 = this;
                            if ((n = jSONLexerBase2.charAt(jSONLexerBase2.bp + n2++)) != 34) break block21;
                            n = this.bp + n2;
                            if ((n = this.indexOf('\"', n)) == -1) {
                                throw new JSONException("unclosed str");
                            }
                            int n4 = this.bp + n2;
                            string = this.subString(n4, n - n4);
                            if (string.indexOf(92) == -1) break block22;
                            break block23;
                        }
                        if (n == 110) {
                            JSONLexerBase jSONLexerBase3 = this;
                            if (jSONLexerBase3.charAt(jSONLexerBase3.bp + n2) == 'u') {
                                JSONLexerBase jSONLexerBase4 = this;
                                if (jSONLexerBase4.charAt(jSONLexerBase4.bp + n2 + 1) == 'l') {
                                    JSONLexerBase jSONLexerBase5 = this;
                                    if (jSONLexerBase5.charAt(jSONLexerBase5.bp + n2 + 2) == 'l') {
                                        n2 += 3;
                                        JSONLexerBase jSONLexerBase6 = this;
                                        n = jSONLexerBase6.charAt(jSONLexerBase6.bp + n2++);
                                        collection.add(null);
                                        continue;
                                    }
                                }
                            }
                        }
                        if (n != 93) throw new JSONException("illega str");
                        if (collection.size() != 0) throw new JSONException("illega str");
                        JSONLexerBase jSONLexerBase7 = this;
                        n = jSONLexerBase7.charAt(jSONLexerBase7.bp + n2++);
                        break block20;
                    }
                    while (true) {
                        n3 = 0;
                        for (int i = n - 1; i >= 0 && this.charAt(i) == '\\'; ++n3, --i) {
                        }
                        if (n3 % 2 == 0) break;
                        n = this.indexOf('\"', n + 1);
                    }
                    n3 = n - (this.bp + n2);
                    JSONLexerBase jSONLexerBase8 = this;
                    string = JSONLexerBase.readString(jSONLexerBase8.sub_chars(jSONLexerBase8.bp + n2, n3), n3);
                }
                n2 += n - (this.bp + n2) + 1;
                JSONLexerBase jSONLexerBase9 = this;
                n = jSONLexerBase9.charAt(jSONLexerBase9.bp + n2++);
                collection.add(string);
            } while (n == 44);
            if (n != 93) {
                this.matchStat = -1;
                return null;
            }
            JSONLexerBase jSONLexerBase10 = this;
            n = jSONLexerBase10.charAt(jSONLexerBase10.bp + n2++);
        }
        if (n == 44) {
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return collection;
        }
        if (n != 125) {
            this.matchStat = -1;
            return null;
        }
        JSONLexerBase jSONLexerBase = this;
        char c = jSONLexerBase.charAt(jSONLexerBase.bp + n2++);
        n = c;
        if (c == ',') {
            this.token = 16;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (n == 93) {
            this.token = 15;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (n == 125) {
            this.token = 13;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else {
            if (n != 26) {
                this.matchStat = -1;
                return null;
            }
            this.bp += n2 - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return collection;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void scanStringArray(Collection<String> var1_1, char var2_2) {
        block18: {
            this.matchStat = 0;
            var3_3 = 0;
            v0 = this;
            ++var3_3;
            var4_4 = v0.charAt(v0.bp + 0);
            if (var4_4 == 110) {
                v1 = this;
                if (v1.charAt(v1.bp + 1) == 'u') {
                    v2 = this;
                    if (v2.charAt(v2.bp + 1 + 1) == 'l') {
                        v3 = this;
                        if (v3.charAt(v3.bp + 1 + 2) == 'l') {
                            v4 = this;
                            if (v4.charAt(v4.bp + 1 + 3) == var2_2) {
                                this.bp += 5;
                                this.ch = this.charAt(this.bp);
                                this.matchStat = 5;
                                return;
                            }
                        }
                    }
                }
            }
            if (var4_4 != 91) {
                this.matchStat = -1;
                return;
            }
            v5 = this;
            ++var3_3;
            var4_4 = v5.charAt(v5.bp + 1);
            while (true) {
                if (var4_4 != 110) ** GOTO lbl-1000
                v6 = this;
                if (v6.charAt(v6.bp + var3_3) != 'u') ** GOTO lbl-1000
                v7 = this;
                if (v7.charAt(v7.bp + var3_3 + 1) != 'l') ** GOTO lbl-1000
                v8 = this;
                if (v8.charAt(v8.bp + var3_3 + 2) == 'l') {
                    var3_3 += 3;
                    v9 = this;
                    var4_4 = v9.charAt(v9.bp + var3_3++);
                    var1_1.add(null);
                } else lbl-1000:
                // 4 sources

                {
                    if (var4_4 == 93 && var1_1.size() == 0) {
                        v10 = this;
                        var4_4 = v10.charAt(v10.bp + var3_3++);
                        break block18;
                    }
                    if (var4_4 != 34) {
                        this.matchStat = -1;
                        return;
                    }
                    var4_4 = this.bp + var3_3;
                    var5_5 = this.indexOf('\"', var4_4);
                    if (var5_5 == -1) {
                        throw new JSONException("unclosed str");
                    }
                    v11 = this;
                    var6_6 = v11.subString(v11.bp + var3_3, var5_5 - var4_4);
                    if (var6_6.indexOf(92) != -1) {
                        while (true) {
                            var6_8 = 0;
                            for (var7_9 = var5_5 - 1; var7_9 >= 0 && this.charAt(var7_9) == '\\'; --var7_9) {
                                ++var6_8;
                            }
                            if (var6_8 % 2 == 0) break;
                            var5_5 = this.indexOf('\"', var5_5 + 1);
                        }
                        var6_8 = var5_5 - var4_4;
                        v12 = this;
                        var6_6 = JSONLexerBase.readString(v12.sub_chars(v12.bp + var3_3, var6_8), var6_8);
                    }
                    var3_3 += var5_5 - (this.bp + var3_3) + 1;
                    v13 = this;
                    var4_4 = v13.charAt(v13.bp + var3_3++);
                    var1_1.add(var6_6);
                }
                if (var4_4 != 44) break;
                v14 = this;
                var4_4 = v14.charAt(v14.bp + var3_3++);
            }
            if (var4_4 == 93) {
                v15 = this;
                var4_4 = v15.charAt(v15.bp + var3_3++);
            } else {
                this.matchStat = -1;
                return;
            }
        }
        if (var4_4 == var2_2) {
            this.bp += var3_3;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return;
        }
        this.matchStat = -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int scanFieldInt(char[] cArray) {
        int n;
        char c;
        boolean bl;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return 0;
        }
        int n2 = cArray.length;
        JSONLexerBase jSONLexerBase = this;
        if (bl = (c = jSONLexerBase.charAt(jSONLexerBase.bp + n2++)) == '-') {
            JSONLexerBase jSONLexerBase2 = this;
            c = jSONLexerBase2.charAt(jSONLexerBase2.bp + n2++);
        }
        if (c >= '0' && c <= '9') {
            n = c - 48;
            while (true) {
                JSONLexerBase jSONLexerBase3 = this;
                if ((c = jSONLexerBase3.charAt(jSONLexerBase3.bp + n2++)) < '0' || c > '9') break;
                n = n * 10 + (c - 48);
            }
            if (c == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (!(n >= 0 && n2 <= 14 + cArray.length || n == Integer.MIN_VALUE && n2 == 17 && bl)) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            this.matchStat = -1;
            return 0;
        }
        if (c == ',') {
            this.bp += n2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            if (bl) {
                return -n;
            }
            return n;
        }
        if (c != '}') {
            this.matchStat = -1;
            return 0;
        }
        JSONLexerBase jSONLexerBase4 = this;
        if ((c = jSONLexerBase4.charAt(jSONLexerBase4.bp + n2++)) == ',') {
            this.token = 16;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c == ']') {
            this.token = 15;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else if (c == '}') {
            this.token = 13;
            this.bp += n2;
            this.ch = this.charAt(this.bp);
        } else {
            if (c != '\u001a') {
                this.matchStat = -1;
                return 0;
            }
            this.token = 20;
            this.bp += n2 - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        if (!bl) {
            return n;
        }
        return -n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int[] scanFieldIntArray(char[] cArray) {
        int n;
        int[] nArray;
        char c;
        int n2;
        block20: {
            block19: {
                this.matchStat = 0;
                if (!this.charArrayCompare(cArray)) {
                    this.matchStat = -2;
                    return null;
                }
                n2 = cArray.length;
                JSONLexerBase jSONLexerBase = this;
                if (jSONLexerBase.charAt(jSONLexerBase.bp + n2++) != '[') {
                    this.matchStat = -2;
                    return null;
                }
                JSONLexerBase jSONLexerBase2 = this;
                c = jSONLexerBase2.charAt(jSONLexerBase2.bp + n2++);
                nArray = new int[16];
                n = 0;
                if (c == ']') {
                    JSONLexerBase jSONLexerBase3 = this;
                    c = jSONLexerBase3.charAt(jSONLexerBase3.bp + n2++);
                } else {
                    while (true) {
                        boolean bl = false;
                        if (c == '-') {
                            JSONLexerBase jSONLexerBase4 = this;
                            c = jSONLexerBase4.charAt(jSONLexerBase4.bp + n2++);
                            bl = true;
                        }
                        if (c < '0' || c > '9') break block19;
                        int n3 = c - 48;
                        while (true) {
                            JSONLexerBase jSONLexerBase5 = this;
                            if ((c = jSONLexerBase5.charAt(jSONLexerBase5.bp + n2++)) < '0' || c > '9') break;
                            n3 = n3 * 10 + (c - 48);
                        }
                        if (n >= nArray.length) {
                            int[] nArray2 = new int[nArray.length * 3 / 2];
                            System.arraycopy(nArray, 0, nArray2, 0, n);
                            nArray = nArray2;
                        }
                        int n4 = nArray[n++] = bl ? -n3 : n3;
                        if (c == ',') {
                            JSONLexerBase jSONLexerBase6 = this;
                            c = jSONLexerBase6.charAt(jSONLexerBase6.bp + n2++);
                            continue;
                        }
                        if (c == ']') break;
                    }
                    JSONLexerBase jSONLexerBase7 = this;
                    c = jSONLexerBase7.charAt(jSONLexerBase7.bp + n2++);
                }
                break block20;
            }
            this.matchStat = -1;
            return null;
        }
        if (n != nArray.length) {
            int[] nArray3 = new int[n];
            System.arraycopy(nArray, 0, nArray3, 0, n);
            nArray = nArray3;
        }
        if (c == ',') {
            this.bp += n2 - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return nArray;
        }
        if (c != '}') {
            this.matchStat = -1;
            return null;
        }
        JSONLexerBase jSONLexerBase = this;
        if ((c = jSONLexerBase.charAt(jSONLexerBase.bp + n2++)) == ',') {
            this.token = 16;
            this.bp += n2 - 1;
            this.next();
        } else if (c == ']') {
            this.token = 15;
            this.bp += n2 - 1;
            this.next();
        } else if (c == '}') {
            this.token = 13;
            this.bp += n2 - 1;
            this.next();
        } else {
            if (c != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.bp += n2 - 1;
            this.token = 20;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return nArray;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean scanBoolean(char var1_1) {
        block9: {
            block7: {
                block8: {
                    this.matchStat = 0;
                    var2_2 = 0;
                    v0 = this;
                    ++var2_2;
                    var3_3 = v0.charAt(v0.bp + 0);
                    var4_4 = false;
                    if (var3_3 != 't') break block7;
                    v1 = this;
                    if (v1.charAt(v1.bp + 1) != 'r') break block8;
                    v2 = this;
                    if (v2.charAt(v2.bp + 1 + 1) != 'u') break block8;
                    v3 = this;
                    if (v3.charAt(v3.bp + 1 + 2) != 'e') break block8;
                    var2_2 += 3;
                    v4 = this;
                    ++var2_2;
                    var3_3 = v4.charAt(v4.bp + 4);
                    var4_4 = true;
                    break block9;
                }
                this.matchStat = -1;
                return false;
            }
            if (var3_3 != 'f') ** GOTO lbl41
            v5 = this;
            if (v5.charAt(v5.bp + 1) != 'a') ** GOTO lbl-1000
            v6 = this;
            if (v6.charAt(v6.bp + 1 + 1) != 'l') ** GOTO lbl-1000
            v7 = this;
            if (v7.charAt(v7.bp + 1 + 2) != 's') ** GOTO lbl-1000
            v8 = this;
            if (v8.charAt(v8.bp + 1 + 3) == 'e') {
                var2_2 += 4;
                v9 = this;
                ++var2_2;
                var3_3 = v9.charAt(v9.bp + 5);
                var4_4 = false;
            } else lbl-1000:
            // 4 sources

            {
                this.matchStat = -1;
                return false;
lbl41:
                // 1 sources

                if (var3_3 == '1') {
                    v10 = this;
                    ++var2_2;
                    var3_3 = v10.charAt(v10.bp + 1);
                    var4_4 = true;
                } else if (var3_3 == '0') {
                    v11 = this;
                    ++var2_2;
                    var3_3 = v11.charAt(v11.bp + 1);
                    var4_4 = false;
                }
            }
        }
        while (true) {
            if (var3_3 == var1_1) {
                this.bp += var2_2;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                return var4_4;
            }
            if (!JSONLexerBase.isWhitespace(var3_3)) break;
            v12 = this;
            var3_3 = v12.charAt(v12.bp + var2_2++);
        }
        this.matchStat = -1;
        return var4_4;
    }

    @Override
    public int scanInt(char c) {
        boolean bl;
        this.matchStat = 0;
        int n = 0;
        JSONLexerBase jSONLexerBase = this;
        ++n;
        char c2 = jSONLexerBase.charAt(jSONLexerBase.bp + 0);
        int n2 = c2 == '\"' ? 1 : 0;
        if (n2 != 0) {
            JSONLexerBase jSONLexerBase2 = this;
            ++n;
            c2 = jSONLexerBase2.charAt(jSONLexerBase2.bp + 1);
        }
        if (bl = c2 == '-') {
            JSONLexerBase jSONLexerBase3 = this;
            c2 = jSONLexerBase3.charAt(jSONLexerBase3.bp + n++);
        }
        if (c2 >= '0' && c2 <= '9') {
            n2 = c2 - 48;
            while (true) {
                JSONLexerBase jSONLexerBase4 = this;
                if ((c2 = jSONLexerBase4.charAt(jSONLexerBase4.bp + n++)) < '0' || c2 > '9') break;
                n2 = n2 * 10 + (c2 - 48);
            }
            if (c2 == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (n2 < 0) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            if (c2 == 'n') {
                JSONLexerBase jSONLexerBase5 = this;
                if (jSONLexerBase5.charAt(jSONLexerBase5.bp + n) == 'u') {
                    JSONLexerBase jSONLexerBase6 = this;
                    if (jSONLexerBase6.charAt(jSONLexerBase6.bp + n + 1) == 'l') {
                        JSONLexerBase jSONLexerBase7 = this;
                        if (jSONLexerBase7.charAt(jSONLexerBase7.bp + n + 2) == 'l') {
                            this.matchStat = 5;
                            n += 3;
                            JSONLexerBase jSONLexerBase8 = this;
                            c2 = jSONLexerBase8.charAt(jSONLexerBase8.bp + n++);
                            if (n2 != 0 && c2 == '\"') {
                                JSONLexerBase jSONLexerBase9 = this;
                                c2 = jSONLexerBase9.charAt(jSONLexerBase9.bp + n++);
                            }
                            while (true) {
                                if (c2 == ',') {
                                    this.bp += n;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 16;
                                    return 0;
                                }
                                if (c2 == ']') {
                                    this.bp += n;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 15;
                                    return 0;
                                }
                                if (!JSONLexerBase.isWhitespace(c2)) break;
                                JSONLexerBase jSONLexerBase10 = this;
                                c2 = jSONLexerBase10.charAt(jSONLexerBase10.bp + n++);
                            }
                            this.matchStat = -1;
                            return 0;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return 0;
        }
        while (true) {
            if (c2 == c) {
                this.bp += n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                if (bl) {
                    return -n2;
                }
                return n2;
            }
            if (!JSONLexerBase.isWhitespace(c2)) break;
            JSONLexerBase jSONLexerBase11 = this;
            c2 = jSONLexerBase11.charAt(jSONLexerBase11.bp + n++);
        }
        this.matchStat = -1;
        if (bl) {
            return -n2;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean scanFieldBoolean(char[] cArray) {
        boolean bl;
        char c;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return false;
        }
        int n = cArray.length;
        JSONLexerBase jSONLexerBase = this;
        if ((c = jSONLexerBase.charAt(jSONLexerBase.bp + n++)) == 't') {
            JSONLexerBase jSONLexerBase2 = this;
            if (jSONLexerBase2.charAt(jSONLexerBase2.bp + n++) != 'r') {
                this.matchStat = -1;
                return false;
            }
            JSONLexerBase jSONLexerBase3 = this;
            if (jSONLexerBase3.charAt(jSONLexerBase3.bp + n++) != 'u') {
                this.matchStat = -1;
                return false;
            }
            JSONLexerBase jSONLexerBase4 = this;
            if (jSONLexerBase4.charAt(jSONLexerBase4.bp + n++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            bl = true;
        } else {
            if (c != 'f') {
                this.matchStat = -1;
                return false;
            }
            JSONLexerBase jSONLexerBase5 = this;
            if (jSONLexerBase5.charAt(jSONLexerBase5.bp + n++) != 'a') {
                this.matchStat = -1;
                return false;
            }
            JSONLexerBase jSONLexerBase6 = this;
            if (jSONLexerBase6.charAt(jSONLexerBase6.bp + n++) != 'l') {
                this.matchStat = -1;
                return false;
            }
            JSONLexerBase jSONLexerBase7 = this;
            if (jSONLexerBase7.charAt(jSONLexerBase7.bp + n++) != 's') {
                this.matchStat = -1;
                return false;
            }
            JSONLexerBase jSONLexerBase8 = this;
            if (jSONLexerBase8.charAt(jSONLexerBase8.bp + n++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            bl = false;
        }
        JSONLexerBase jSONLexerBase9 = this;
        c = jSONLexerBase9.charAt(jSONLexerBase9.bp + n++);
        if (c == ',') {
            this.bp += n;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return bl;
        }
        if (c != '}') {
            this.matchStat = -1;
            return false;
        }
        JSONLexerBase jSONLexerBase10 = this;
        if ((c = jSONLexerBase10.charAt(jSONLexerBase10.bp + n++)) == ',') {
            this.token = 16;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c == ']') {
            this.token = 15;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c == '}') {
            this.token = 13;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else {
            if (c != '\u001a') {
                this.matchStat = -1;
                return false;
            }
            this.token = 20;
            this.bp += n - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanFieldLong(char[] cArray) {
        long l;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return 0L;
        }
        int n = cArray.length;
        JSONLexerBase jSONLexerBase = this;
        char c = jSONLexerBase.charAt(jSONLexerBase.bp + n++);
        boolean bl = false;
        if (c == '-') {
            JSONLexerBase jSONLexerBase2 = this;
            c = jSONLexerBase2.charAt(jSONLexerBase2.bp + n++);
            bl = true;
        }
        if (c >= '0' && c <= '9') {
            l = c - 48;
            while (true) {
                JSONLexerBase jSONLexerBase3 = this;
                if ((c = jSONLexerBase3.charAt(jSONLexerBase3.bp + n++)) < '0' || c > '9') break;
                l = l * 10L + (long)(c - 48);
            }
            if (c == '.') {
                this.matchStat = -1;
                return 0L;
            }
            if (!(n - cArray.length < 21 && (l >= 0L || l == Long.MIN_VALUE && bl))) {
                this.matchStat = -1;
                return 0L;
            }
        } else {
            this.matchStat = -1;
            return 0L;
        }
        if (c == ',') {
            this.bp += n;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            if (bl) {
                return -l;
            }
            return l;
        }
        if (c != '}') {
            this.matchStat = -1;
            return 0L;
        }
        JSONLexerBase jSONLexerBase4 = this;
        if ((c = jSONLexerBase4.charAt(jSONLexerBase4.bp + n++)) == ',') {
            this.token = 16;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c == ']') {
            this.token = 15;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c == '}') {
            this.token = 13;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else {
            if (c != '\u001a') {
                this.matchStat = -1;
                return 0L;
            }
            this.token = 20;
            this.bp += n - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        if (!bl) {
            return l;
        }
        return -l;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long scanLong(char var1_1) {
        this.matchStat = 0;
        var2_3 = 0;
        v0 = this;
        ++var2_3;
        var3_4 = v0.charAt(v0.bp + 0);
        var4_5 = var3_4 == '\"';
        if (var4_5) {
            v1 = this;
            ++var2_3;
            var3_4 = v1.charAt(v1.bp + 1);
        }
        if (var5_6 = var3_4 == '-') {
            v2 = this;
            var3_4 = v2.charAt(v2.bp + var2_3++);
        }
        if (var3_4 >= '0' && var3_4 <= '9') {
            var6_7 = var3_4 - 48;
            while (true) {
                v3 = this;
                if ((var3_4 = v3.charAt(v3.bp + var2_3++)) < '0' || var3_4 > '9') break;
                var6_7 = var6_7 * 10L + (long)(var3_4 - 48);
            }
            if (var3_4 == '.') {
                this.matchStat = -1;
                return 0L;
            }
            if (!(var6_7 >= 0L || var6_7 == -9223372036854775808L && var5_6 != false)) {
                v4 = this;
                var1_2 = v4.subString(v4.bp, var2_3 - 1);
                throw new NumberFormatException(var1_2);
            }
        } else {
            if (var3_4 == 'n') {
                v5 = this;
                if (v5.charAt(v5.bp + var2_3) == 'u') {
                    v6 = this;
                    if (v6.charAt(v6.bp + var2_3 + 1) == 'l') {
                        v7 = this;
                        if (v7.charAt(v7.bp + var2_3 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_3 += 3;
                            v8 = this;
                            var3_4 = v8.charAt(v8.bp + var2_3++);
                            if (var4_5 && var3_4 == '\"') {
                                v9 = this;
                                var3_4 = v9.charAt(v9.bp + var2_3++);
                            }
                            while (true) {
                                if (var3_4 == ',') {
                                    this.bp += var2_3;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 16;
                                    return 0L;
                                }
                                if (var3_4 == ']') {
                                    this.bp += var2_3;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 15;
                                    return 0L;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_4)) break;
                                v10 = this;
                                var3_4 = v10.charAt(v10.bp + var2_3++);
                            }
                            this.matchStat = -1;
                            return 0L;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return 0L;
        }
        if (!var4_5) ** GOTO lbl71
        if (var3_4 != '\"') {
            this.matchStat = -1;
            return 0L;
        }
        do {
            v11 = this;
            var3_4 = v11.charAt(v11.bp + var2_3++);
lbl71:
            // 2 sources

            if (var3_4 != var1_1) continue;
            this.bp += var2_3;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            if (var5_6) {
                return -var6_7;
            }
            return var6_7;
        } while (JSONLexerBase.isWhitespace(var3_4));
        this.matchStat = -1;
        return var6_7;
    }

    /*
     * Unable to fully structure code
     */
    public final float scanFieldFloat(char[] var1_1) {
        block35: {
            block33: {
                block34: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(var1_1)) {
                        this.matchStat = -2;
                        return 0.0f;
                    }
                    var2_4 = var1_1.length;
                    v0 = this;
                    if ((var4_6 = (var3_5 = v0.charAt(v0.bp + var2_4++)) == '\"' ? 1 : 0) != 0) {
                        v1 = this;
                        var3_5 = v1.charAt(v1.bp + var2_4++);
                    }
                    if (var5_7 = var3_5 == '-') {
                        v2 = this;
                        var3_5 = v2.charAt(v2.bp + var2_4++);
                    }
                    if (var3_5 < '0' || var3_5 > '9') break block33;
                    var7_8 = var3_5 - 48;
                    while (true) {
                        v3 = this;
                        if ((var3_5 = v3.charAt(v3.bp + var2_4++)) < '0' || var3_5 > '9') break;
                        var7_8 = var7_8 * 10L + (long)(var3_5 - 48);
                    }
                    var9_9 = 1L;
                    if (var3_5 == '.') {
                        v4 = this;
                        if ((var3_5 = v4.charAt(v4.bp + var2_4++)) >= '0' && var3_5 <= '9') {
                            var7_8 = var7_8 * 10L + (long)(var3_5 - 48);
                            var9_9 = 10L;
                            while (true) {
                                v5 = this;
                                if ((var3_5 = v5.charAt(v5.bp + var2_4++)) >= '0' && var3_5 <= '9') {
                                    var7_8 = var7_8 * 10L + (long)(var3_5 - 48);
                                    var9_9 *= 10L;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                    if (!(var6_10 = var3_5 == 'e' || var3_5 == 'E')) break block34;
                    v6 = this;
                    if ((var3_5 = v6.charAt(v6.bp + var2_4++)) != '+' && var3_5 != '-') ** GOTO lbl41
                    do {
                        v7 = this;
                        var3_5 = v7.charAt(v7.bp + var2_4++);
lbl41:
                        // 2 sources

                    } while (var3_5 >= '0' && var3_5 <= '9');
                }
                if (var4_6 != 0) {
                    if (var3_5 != '\"') {
                        this.matchStat = -1;
                        return 0.0f;
                    }
                    v8 = this;
                    var3_5 = v8.charAt(v8.bp + var2_4++);
                    var1_2 = this.bp + var1_1.length + 1;
                    var4_6 = this.bp + var2_4 - var1_2 - 2;
                } else {
                    var1_2 = this.bp + var1_1.length;
                    var4_6 = this.bp + var2_4 - var1_2 - 1;
                }
                if (!var6_10 && var4_6 < 17) {
                    var1_3 = (float)((double)var7_8 / (double)var9_9);
                    if (var5_7) {
                        var1_3 = -var1_3;
                    }
                } else {
                    var1_3 = Float.parseFloat(this.subString(var1_2, var4_6));
                }
                break block35;
            }
            if (var3_5 == 'n') {
                v9 = this;
                if (v9.charAt(v9.bp + var2_4) == 'u') {
                    v10 = this;
                    if (v10.charAt(v10.bp + var2_4 + 1) == 'l') {
                        v11 = this;
                        if (v11.charAt(v11.bp + var2_4 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_4 += 3;
                            v12 = this;
                            var3_5 = v12.charAt(v12.bp + var2_4++);
                            if (var4_6 != 0 && var3_5 == '\"') {
                                v13 = this;
                                var3_5 = v13.charAt(v13.bp + var2_4++);
                            }
                            while (true) {
                                if (var3_5 == ',') {
                                    this.bp += var2_4;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 16;
                                    return 0.0f;
                                }
                                if (var3_5 == '}') {
                                    this.bp += var2_4;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 13;
                                    return 0.0f;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_5)) break;
                                v14 = this;
                                var3_5 = v14.charAt(v14.bp + var2_4++);
                            }
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return 0.0f;
        }
        if (var3_5 == ',') {
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return var1_3;
        }
        if (var3_5 != '}') ** GOTO lbl128
        v15 = this;
        if ((var3_5 = v15.charAt(v15.bp + var2_4++)) == ',') {
            this.token = 16;
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
        } else if (var3_5 == ']') {
            this.token = 15;
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
        } else if (var3_5 == '}') {
            this.token = 13;
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
        } else if (var3_5 == '\u001a') {
            this.bp += var2_4 - 1;
            this.token = 20;
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return 0.0f;
lbl128:
            // 1 sources

            this.matchStat = -1;
            return 0.0f;
        }
        this.matchStat = 4;
        return var1_3;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final float scanFloat(char var1_1) {
        block26: {
            block24: {
                block25: {
                    this.matchStat = 0;
                    var2_2 = 0;
                    v0 = this;
                    ++var2_2;
                    var3_3 = v0.charAt(v0.bp + 0);
                    var4_4 = var3_3 == '\"' ? 1 : 0;
                    if (var4_4 != 0) {
                        v1 = this;
                        ++var2_2;
                        var3_3 = v1.charAt(v1.bp + 1);
                    }
                    if (var5_6 = var3_3 == '-') {
                        v2 = this;
                        var3_3 = v2.charAt(v2.bp + var2_2++);
                    }
                    if (var3_3 < '0' || var3_3 > '9') break block24;
                    var7_7 = var3_3 - 48;
                    while (true) {
                        v3 = this;
                        if ((var3_3 = v3.charAt(v3.bp + var2_2++)) < '0' || var3_3 > '9') break;
                        var7_7 = var7_7 * 10L + (long)(var3_3 - 48);
                    }
                    var9_8 = 1L;
                    if (var3_3 == '.') {
                        v4 = this;
                        if ((var3_3 = v4.charAt(v4.bp + var2_2++)) >= '0' && var3_3 <= '9') {
                            var7_7 = var7_7 * 10L + (long)(var3_3 - 48);
                            var9_8 = 10L;
                            while (true) {
                                v5 = this;
                                if ((var3_3 = v5.charAt(v5.bp + var2_2++)) >= '0' && var3_3 <= '9') {
                                    var7_7 = var7_7 * 10L + (long)(var3_3 - 48);
                                    var9_8 *= 10L;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                    if (!(var6_9 = var3_3 == 'e' || var3_3 == 'E')) break block25;
                    v6 = this;
                    if ((var3_3 = v6.charAt(v6.bp + var2_2++)) != '+' && var3_3 != '-') ** GOTO lbl42
                    do {
                        v7 = this;
                        var3_3 = v7.charAt(v7.bp + var2_2++);
lbl42:
                        // 2 sources

                    } while (var3_3 >= '0' && var3_3 <= '9');
                }
                if (var4_4 != 0) {
                    if (var3_3 != '\"') {
                        this.matchStat = -1;
                        return 0.0f;
                    }
                    v8 = this;
                    var3_3 = v8.charAt(v8.bp + var2_2++);
                    var4_4 = this.bp + 1;
                    var11_10 = this.bp + var2_2 - var4_4 - 2;
                } else {
                    var4_4 = this.bp;
                    var11_10 = this.bp + var2_2 - var4_4 - 1;
                }
                if (!var6_9 && var11_10 < 17) {
                    var4_5 = (float)((double)var7_7 / (double)var9_8);
                    if (var5_6) {
                        var4_5 = -var4_5;
                    }
                } else {
                    var4_5 = Float.parseFloat(this.subString(var4_4, var11_10));
                }
                break block26;
            }
            if (var3_3 == 'n') {
                v9 = this;
                if (v9.charAt(v9.bp + var2_2) == 'u') {
                    v10 = this;
                    if (v10.charAt(v10.bp + var2_2 + 1) == 'l') {
                        v11 = this;
                        if (v11.charAt(v11.bp + var2_2 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_2 += 3;
                            v12 = this;
                            var3_3 = v12.charAt(v12.bp + var2_2++);
                            if (var4_4 != 0 && var3_3 == '\"') {
                                v13 = this;
                                var3_3 = v13.charAt(v13.bp + var2_2++);
                            }
                            while (true) {
                                if (var3_3 == ',') {
                                    this.bp += var2_2;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 16;
                                    return 0.0f;
                                }
                                if (var3_3 == ']') {
                                    this.bp += var2_2;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 15;
                                    return 0.0f;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_3)) break;
                                v14 = this;
                                var3_3 = v14.charAt(v14.bp + var2_2++);
                            }
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return 0.0f;
        }
        if (var3_3 == var1_1) {
            this.bp += var2_2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return var4_5;
        }
        this.matchStat = -1;
        return var4_5;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public double scanDouble(char var1_1) {
        block26: {
            block24: {
                block25: {
                    this.matchStat = 0;
                    var2_2 = 0;
                    v0 = this;
                    ++var2_2;
                    var3_3 = v0.charAt(v0.bp + 0);
                    var4_4 = var3_3 == '\"' ? 1 : 0;
                    if (var4_4 != 0) {
                        v1 = this;
                        ++var2_2;
                        var3_3 = v1.charAt(v1.bp + 1);
                    }
                    if (var5_5 = var3_3 == '-') {
                        v2 = this;
                        var3_3 = v2.charAt(v2.bp + var2_2++);
                    }
                    if (var3_3 < '0' || var3_3 > '9') break block24;
                    var8_6 = var3_3 - 48;
                    while (true) {
                        v3 = this;
                        if ((var3_3 = v3.charAt(v3.bp + var2_2++)) < '0' || var3_3 > '9') break;
                        var8_6 = var8_6 * 10L + (long)(var3_3 - 48);
                    }
                    var10_7 = 1L;
                    if (var3_3 == '.') {
                        v4 = this;
                        if ((var3_3 = v4.charAt(v4.bp + var2_2++)) >= '0' && var3_3 <= '9') {
                            var8_6 = var8_6 * 10L + (long)(var3_3 - 48);
                            var10_7 = 10L;
                            while (true) {
                                v5 = this;
                                if ((var3_3 = v5.charAt(v5.bp + var2_2++)) >= '0' && var3_3 <= '9') {
                                    var8_6 = var8_6 * 10L + (long)(var3_3 - 48);
                                    var10_7 *= 10L;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                    if (!(var6_8 = var3_3 == 'e' || var3_3 == 'E')) break block25;
                    v6 = this;
                    if ((var3_3 = v6.charAt(v6.bp + var2_2++)) != '+' && var3_3 != '-') ** GOTO lbl42
                    do {
                        v7 = this;
                        var3_3 = v7.charAt(v7.bp + var2_2++);
lbl42:
                        // 2 sources

                    } while (var3_3 >= '0' && var3_3 <= '9');
                }
                if (var4_4 != 0) {
                    if (var3_3 != '\"') {
                        this.matchStat = -1;
                        return 0.0;
                    }
                    v8 = this;
                    var3_3 = v8.charAt(v8.bp + var2_2++);
                    var4_4 = this.bp + 1;
                    var7_10 = this.bp + var2_2 - var4_4 - 2;
                } else {
                    var4_4 = this.bp;
                    var7_10 = this.bp + var2_2 - var4_4 - 1;
                }
                if (!var6_8 && var7_10 < 17) {
                    var6_9 = (double)var8_6 / (double)var10_7;
                    if (var5_5) {
                        var6_9 = -var6_9;
                    }
                } else {
                    var6_9 = Double.parseDouble(this.subString(var4_4, var7_10));
                }
                break block26;
            }
            if (var3_3 == 'n') {
                v9 = this;
                if (v9.charAt(v9.bp + var2_2) == 'u') {
                    v10 = this;
                    if (v10.charAt(v10.bp + var2_2 + 1) == 'l') {
                        v11 = this;
                        if (v11.charAt(v11.bp + var2_2 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_2 += 3;
                            v12 = this;
                            var3_3 = v12.charAt(v12.bp + var2_2++);
                            if (var4_4 != 0 && var3_3 == '\"') {
                                v13 = this;
                                var3_3 = v13.charAt(v13.bp + var2_2++);
                            }
                            while (true) {
                                if (var3_3 == ',') {
                                    this.bp += var2_2;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 16;
                                    return 0.0;
                                }
                                if (var3_3 == ']') {
                                    this.bp += var2_2;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 15;
                                    return 0.0;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_3)) break;
                                v14 = this;
                                var3_3 = v14.charAt(v14.bp + var2_2++);
                            }
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return 0.0;
        }
        if (var3_3 == var1_1) {
            this.bp += var2_2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return var6_9;
        }
        this.matchStat = -1;
        return var6_9;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public BigDecimal scanDecimal(char var1_1) {
        block32: {
            block30: {
                block31: {
                    this.matchStat = 0;
                    var1_1 = '\u0000';
                    v0 = this;
                    var1_1 = (char)(var1_1 + 1);
                    var2_2 = v0.charAt(v0.bp + 0);
                    var3_3 = var2_2 == '\"' ? 1 : 0;
                    if (var3_3 != 0) {
                        v1 = this;
                        var1_1 = (char)(var1_1 + 1);
                        var2_2 = v1.charAt(v1.bp + 1);
                    }
                    if (var2_2 == '-') {
                        v2 = this;
                        v3 = var1_1;
                        var1_1 = (char)(var1_1 + 1);
                        var2_2 = v2.charAt(v2.bp + v3);
                    }
                    if (var2_2 < '0' || var2_2 > '9') break block30;
                    do {
                        v4 = this;
                        v5 = var1_1;
                        var1_1 = (char)(var1_1 + 1);
                    } while ((var2_2 = v4.charAt(v4.bp + v5)) >= '0' && var2_2 <= '9');
                    if (var2_2 == '.') {
                        v6 = this;
                        v7 = var1_1;
                        var1_1 = (char)(var1_1 + 1);
                        var2_2 = v6.charAt(v6.bp + v7);
                        if (var2_2 >= '0' && var2_2 <= '9') {
                            while (true) {
                                v8 = this;
                                v9 = var1_1;
                                var1_1 = (char)(var1_1 + 1);
                                var2_2 = v8.charAt(v8.bp + v9);
                                if (var2_2 >= '0' && var2_2 <= '9') {
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return null;
                        }
                    }
                    if (!(var2_2 == 'e' || var2_2 == 'E')) break block31;
                    v10 = this;
                    v11 = var1_1;
                    var1_1 = (char)(var1_1 + 1);
                    var2_2 = v10.charAt(v10.bp + v11);
                    if (var2_2 != '+' && var2_2 != '-') ** GOTO lbl49
                    do {
                        v12 = this;
                        v13 = var1_1;
                        var1_1 = (char)(var1_1 + 1);
                        var2_2 = v12.charAt(v12.bp + v13);
lbl49:
                        // 2 sources

                    } while (var2_2 >= '0' && var2_2 <= '9');
                }
                if (var3_3 != 0) {
                    if (var2_2 != '\"') {
                        this.matchStat = -1;
                        return null;
                    }
                    v14 = this;
                    v15 = var1_1;
                    var1_1 = (char)(var1_1 + 1);
                    var2_2 = v14.charAt(v14.bp + v15);
                    var3_3 = this.bp + 1;
                    var4_5 = this.bp + var1_1 - var3_3 - 2;
                } else {
                    var3_3 = this.bp;
                    var4_5 = this.bp + var1_1 - var3_3 - 1;
                }
                if (var4_5 > 65535) {
                    throw new JSONException("decimal overflow");
                }
                break block32;
            }
            if (var2_2 == 'n') {
                v16 = this;
                if (v16.charAt(v16.bp + var1_1) == 'u') {
                    v17 = this;
                    if (v17.charAt(v17.bp + var1_1 + 1) == 'l') {
                        v18 = this;
                        if (v18.charAt(v18.bp + var1_1 + 2) == 'l') {
                            this.matchStat = 5;
                            var1_1 = (char)(var1_1 + 3);
                            v19 = this;
                            v20 = var1_1;
                            var1_1 = (char)(var1_1 + 1);
                            var2_2 = v19.charAt(v19.bp + v20);
                            if (var3_3 != 0 && var2_2 == '\"') {
                                v21 = this;
                                v22 = var1_1;
                                var1_1 = (char)(var1_1 + 1);
                                var2_2 = v21.charAt(v21.bp + v22);
                            }
                            while (true) {
                                if (var2_2 == ',') {
                                    this.bp += var1_1;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 16;
                                    return null;
                                }
                                if (var2_2 == '}') {
                                    this.bp += var1_1;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 13;
                                    return null;
                                }
                                if (!JSONLexerBase.isWhitespace(var2_2)) break;
                                v23 = this;
                                v24 = var1_1;
                                var1_1 = (char)(var1_1 + 1);
                                var2_2 = v23.charAt(v23.bp + v24);
                            }
                            this.matchStat = -1;
                            return null;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return null;
        }
        var3_4 /* !! */  = this.sub_chars(var3_3, var4_5);
        var3_4 /* !! */  = (char[])new BigDecimal(var3_4 /* !! */ , 0, var3_4 /* !! */ .length, MathContext.UNLIMITED);
        if (var2_2 == ',') {
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return var3_4 /* !! */ ;
        }
        if (var2_2 != ']') ** GOTO lbl145
        v25 = this;
        v26 = var1_1;
        var1_1 = (char)(var1_1 + 1);
        var2_2 = v25.charAt(v25.bp + v26);
        if (var2_2 == ',') {
            this.token = 16;
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
        } else if (var2_2 == ']') {
            this.token = 15;
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
        } else if (var2_2 == '}') {
            this.token = 13;
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
        } else if (var2_2 == '\u001a') {
            this.token = 20;
            this.bp += var1_1 - '\u0001';
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl145:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var3_4 /* !! */ ;
    }

    /*
     * Unable to fully structure code
     */
    public final float[] scanFieldFloatArray(char[] var1_1) {
        block28: {
            block26: {
                this.matchStat = 0;
                if (!this.charArrayCompare(var1_1)) {
                    this.matchStat = -2;
                    return null;
                }
                var1_2 = var1_1.length;
                v0 = this;
                if (v0.charAt(v0.bp + var1_2++) != '[') {
                    this.matchStat = -2;
                    return null;
                }
                v1 = this;
                var2_3 = v1.charAt(v1.bp + var1_2++);
                var3_4 = new float[16];
                var4_5 = 0;
                while (true) {
                    block27: {
                        var5_7 = this.bp + var1_2 - 1;
                        var6_9 = var2_3 == '-';
                        if (var6_9) {
                            v2 = this;
                            var2_3 = v2.charAt(v2.bp + var1_2++);
                        }
                        if (var2_3 < '0' || var2_3 > '9') break block26;
                        var7_11 = var2_3 - 48;
                        while (true) {
                            v3 = this;
                            if ((var2_3 = v3.charAt(v3.bp + var1_2++)) < '0' || var2_3 > '9') break;
                            var7_11 = var7_11 * 10 + (var2_3 - 48);
                        }
                        var8_12 = 1;
                        if (var2_3 == '.') {
                            v4 = this;
                            var2_3 = v4.charAt(v4.bp + var1_2++);
                            var8_12 = 10;
                            if (var2_3 >= '0' && var2_3 <= '9') {
                                var7_11 = var7_11 * 10 + (var2_3 - 48);
                                while (true) {
                                    v5 = this;
                                    if ((var2_3 = v5.charAt(v5.bp + var1_2++)) >= '0' && var2_3 <= '9') {
                                        var7_11 = var7_11 * 10 + (var2_3 - 48);
                                        var8_12 *= 10;
                                        continue;
                                    }
                                    break;
                                }
                            } else {
                                this.matchStat = -1;
                                return null;
                            }
                        }
                        if (!(var9_13 = var2_3 == 'e' || var2_3 == 'E')) break block27;
                        v6 = this;
                        if ((var2_3 = v6.charAt(v6.bp + var1_2++)) != '+' && var2_3 != '-') ** GOTO lbl49
                        do {
                            v7 = this;
                            var2_3 = v7.charAt(v7.bp + var1_2++);
lbl49:
                            // 2 sources

                        } while (var2_3 >= '0' && var2_3 <= '9');
                    }
                    var10_14 = this.bp + var1_2 - var5_7 - 1;
                    if (!var9_13 && var10_14 < 10) {
                        var5_6 = (float)var7_11 / (float)var8_12;
                        if (var6_9) {
                            var5_6 = -var5_6;
                        }
                    } else {
                        var5_6 = Float.parseFloat(this.subString(var5_7, var10_14));
                    }
                    if (var4_5 >= var3_4.length) {
                        var6_10 = new float[var3_4.length * 3 / 2];
                        System.arraycopy(var3_4, 0, var6_10, 0, var4_5);
                        var3_4 = var6_10;
                    }
                    var3_4[var4_5++] = var5_6;
                    if (var2_3 == ',') {
                        v8 = this;
                        var2_3 = v8.charAt(v8.bp + var1_2++);
                        continue;
                    }
                    if (var2_3 == ']') break;
                }
                break block28;
            }
            this.matchStat = -1;
            return null;
        }
        v9 = this;
        var2_3 = v9.charAt(v9.bp + var1_2++);
        if (var4_5 != var3_4.length) {
            var5_8 = new float[var4_5];
            System.arraycopy(var3_4, 0, var5_8, 0, var4_5);
            var3_4 = var5_8;
        }
        if (var2_3 == ',') {
            this.bp += var1_2 - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return var3_4;
        }
        if (var2_3 != '}') ** GOTO lbl114
        v10 = this;
        if ((var2_3 = v10.charAt(v10.bp + var1_2++)) == ',') {
            this.token = 16;
            this.bp += var1_2 - 1;
            this.next();
        } else if (var2_3 == ']') {
            this.token = 15;
            this.bp += var1_2 - 1;
            this.next();
        } else if (var2_3 == '}') {
            this.token = 13;
            this.bp += var1_2 - 1;
            this.next();
        } else if (var2_3 == '\u001a') {
            this.bp += var1_2 - 1;
            this.token = 20;
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl114:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var3_4;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final float[][] scanFieldFloatArray2(char[] var1_1) {
        this.matchStat = 0;
        if (!this.charArrayCompare(var1_1)) {
            this.matchStat = -2;
            return null;
        }
        var1_2 = var1_1.length;
        v0 = this;
        if (v0.charAt(v0.bp + var1_2++) != '[') {
            this.matchStat = -2;
            return null;
        }
        v1 = this;
        var2_3 = v1.charAt(v1.bp + var1_2++);
        var3_4 = new float[16][];
        var4_5 = 0;
        while (var2_3 == '[') {
            block32: {
                block30: {
                    v2 = this;
                    var2_3 = v2.charAt(v2.bp + var1_2++);
                    var5_6 /* !! */  = (float[][])new float[16];
                    var6_7 = 0;
                    while (true) {
                        block31: {
                            var7_8 = this.bp + var1_2 - 1;
                            var8_12 = var2_3 == '-';
                            if (var8_12) {
                                v3 = this;
                                var2_3 = v3.charAt(v3.bp + var1_2++);
                            }
                            if (var2_3 < '0' || var2_3 > '9') break block30;
                            var9_14 = var2_3 - 48;
                            while (true) {
                                v4 = this;
                                if ((var2_3 = v4.charAt(v4.bp + var1_2++)) < '0' || var2_3 > '9') break;
                                var9_14 = var9_14 * 10 + (var2_3 - 48);
                            }
                            var10_15 = 1;
                            if (var2_3 == '.') {
                                v5 = this;
                                if ((var2_3 = v5.charAt(v5.bp + var1_2++)) >= '0' && var2_3 <= '9') {
                                    var9_14 = var9_14 * 10 + (var2_3 - 48);
                                    var10_15 = 10;
                                    while (true) {
                                        v6 = this;
                                        if ((var2_3 = v6.charAt(v6.bp + var1_2++)) >= '0' && var2_3 <= '9') {
                                            var9_14 = var9_14 * 10 + (var2_3 - 48);
                                            var10_15 *= 10;
                                            continue;
                                        }
                                        break;
                                    }
                                } else {
                                    this.matchStat = -1;
                                    return null;
                                }
                            }
                            if (!(var11_16 = var2_3 == 'e' || var2_3 == 'E')) break block31;
                            v7 = this;
                            if ((var2_3 = v7.charAt(v7.bp + var1_2++)) != '+' && var2_3 != '-') ** GOTO lbl53
                            do {
                                v8 = this;
                                var2_3 = v8.charAt(v8.bp + var1_2++);
lbl53:
                                // 2 sources

                            } while (var2_3 >= '0' && var2_3 <= '9');
                        }
                        var12_17 = this.bp + var1_2 - var7_8 - 1;
                        if (!var11_16 && var12_17 < 10) {
                            var7_9 = (float)var9_14 / (float)var10_15;
                            if (var8_12) {
                                var7_9 = -var7_9;
                            }
                        } else {
                            var7_9 = Float.parseFloat(this.subString(var7_8, var12_17));
                        }
                        if (var6_7 >= var5_6 /* !! */ .length) {
                            var8_13 = new float[var5_6 /* !! */ .length * 3 / 2];
                            System.arraycopy(var5_6 /* !! */ , 0, var8_13, 0, var6_7);
                            var5_6 /* !! */  = (float[][])var8_13;
                        }
                        var5_6 /* !! */ [var6_7++] = (float[])var7_9;
                        if (var2_3 == ',') {
                            v9 = this;
                            var2_3 = v9.charAt(v9.bp + var1_2++);
                            continue;
                        }
                        if (var2_3 == ']') break;
                    }
                    break block32;
                }
                this.matchStat = -1;
                return null;
            }
            v10 = this;
            var2_3 = v10.charAt(v10.bp + var1_2++);
            if (var6_7 != var5_6 /* !! */ .length) {
                var7_10 = new float[var6_7];
                System.arraycopy(var5_6 /* !! */ , 0, var7_10, 0, var6_7);
                var5_6 /* !! */  = (float[][])var7_10;
            }
            if (var4_5 >= var3_4.length) {
                var7_11 = new float[var3_4.length * 3 / 2][];
                System.arraycopy(var5_6 /* !! */ , 0, var7_11, 0, var6_7);
                var3_4 = var7_11;
            }
            var3_4[var4_5++] = (float[])var5_6 /* !! */ ;
            if (var2_3 == ',') {
                v11 = this;
                var2_3 = v11.charAt(v11.bp + var1_2++);
                continue;
            }
            if (var2_3 != ']') continue;
            v12 = this;
            var2_3 = v12.charAt(v12.bp + var1_2++);
            break;
        }
        if (var4_5 != var3_4.length) {
            var5_6 /* !! */  = new float[var4_5][];
            System.arraycopy(var3_4, 0, var5_6 /* !! */ , 0, var4_5);
            var3_4 = var5_6 /* !! */ ;
        }
        if (var2_3 == ',') {
            this.bp += var1_2 - 1;
            this.next();
            this.matchStat = 3;
            this.token = 16;
            return var3_4;
        }
        if (var2_3 != '}') ** GOTO lbl135
        v13 = this;
        if ((var2_3 = v13.charAt(v13.bp + var1_2++)) == ',') {
            this.token = 16;
            this.bp += var1_2 - 1;
            this.next();
        } else if (var2_3 == ']') {
            this.token = 15;
            this.bp += var1_2 - 1;
            this.next();
        } else if (var2_3 == '}') {
            this.token = 13;
            this.bp += var1_2 - 1;
            this.next();
        } else if (var2_3 == '\u001a') {
            this.bp += var1_2 - 1;
            this.token = 20;
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl135:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var3_4;
    }

    /*
     * Unable to fully structure code
     */
    public final double scanFieldDouble(char[] var1_1) {
        block35: {
            block33: {
                block34: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(var1_1)) {
                        this.matchStat = -2;
                        return 0.0;
                    }
                    var2_3 = var1_1.length;
                    v0 = this;
                    if ((var4_5 = (var3_4 = v0.charAt(v0.bp + var2_3++)) == '\"' ? 1 : 0) != 0) {
                        v1 = this;
                        var3_4 = v1.charAt(v1.bp + var2_3++);
                    }
                    if (var5_6 = var3_4 == '-') {
                        v2 = this;
                        var3_4 = v2.charAt(v2.bp + var2_3++);
                    }
                    if (var3_4 < '0' || var3_4 > '9') break block33;
                    var8_7 = var3_4 - 48;
                    while (true) {
                        v3 = this;
                        if ((var3_4 = v3.charAt(v3.bp + var2_3++)) < '0' || var3_4 > '9') break;
                        var8_7 = var8_7 * 10L + (long)(var3_4 - 48);
                    }
                    var10_8 = 1L;
                    if (var3_4 == '.') {
                        v4 = this;
                        if ((var3_4 = v4.charAt(v4.bp + var2_3++)) >= '0' && var3_4 <= '9') {
                            var8_7 = var8_7 * 10L + (long)(var3_4 - 48);
                            var10_8 = 10L;
                            while (true) {
                                v5 = this;
                                if ((var3_4 = v5.charAt(v5.bp + var2_3++)) >= '0' && var3_4 <= '9') {
                                    var8_7 = var8_7 * 10L + (long)(var3_4 - 48);
                                    var10_8 *= 10L;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                    if (!(var6_9 = var3_4 == 'e' || var3_4 == 'E')) break block34;
                    v6 = this;
                    if ((var3_4 = v6.charAt(v6.bp + var2_3++)) != '+' && var3_4 != '-') ** GOTO lbl41
                    do {
                        v7 = this;
                        var3_4 = v7.charAt(v7.bp + var2_3++);
lbl41:
                        // 2 sources

                    } while (var3_4 >= '0' && var3_4 <= '9');
                }
                if (var4_5 != 0) {
                    if (var3_4 != '\"') {
                        this.matchStat = -1;
                        return 0.0;
                    }
                    v8 = this;
                    var3_4 = v8.charAt(v8.bp + var2_3++);
                    var1_2 = this.bp + var1_1.length + 1;
                    var4_5 = this.bp + var2_3 - var1_2 - 2;
                } else {
                    var1_2 = this.bp + var1_1.length;
                    var4_5 = this.bp + var2_3 - var1_2 - 1;
                }
                if (!var6_9 && var4_5 < 17) {
                    var6_10 = (double)var8_7 / (double)var10_8;
                    if (var5_6) {
                        var6_10 = -var6_10;
                    }
                } else {
                    var6_10 = Double.parseDouble(this.subString(var1_2, var4_5));
                }
                break block35;
            }
            if (var3_4 == 'n') {
                v9 = this;
                if (v9.charAt(v9.bp + var2_3) == 'u') {
                    v10 = this;
                    if (v10.charAt(v10.bp + var2_3 + 1) == 'l') {
                        v11 = this;
                        if (v11.charAt(v11.bp + var2_3 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_3 += 3;
                            v12 = this;
                            var3_4 = v12.charAt(v12.bp + var2_3++);
                            if (var4_5 != 0 && var3_4 == '\"') {
                                v13 = this;
                                var3_4 = v13.charAt(v13.bp + var2_3++);
                            }
                            while (true) {
                                if (var3_4 == ',') {
                                    this.bp += var2_3;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 16;
                                    return 0.0;
                                }
                                if (var3_4 == '}') {
                                    this.bp += var2_3;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 13;
                                    return 0.0;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_4)) break;
                                v14 = this;
                                var3_4 = v14.charAt(v14.bp + var2_3++);
                            }
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return 0.0;
        }
        if (var3_4 == ',') {
            this.bp += var2_3;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return var6_10;
        }
        if (var3_4 != '}') ** GOTO lbl128
        v15 = this;
        if ((var3_4 = v15.charAt(v15.bp + var2_3++)) == ',') {
            this.token = 16;
            this.bp += var2_3;
            this.ch = this.charAt(this.bp);
        } else if (var3_4 == ']') {
            this.token = 15;
            this.bp += var2_3;
            this.ch = this.charAt(this.bp);
        } else if (var3_4 == '}') {
            this.token = 13;
            this.bp += var2_3;
            this.ch = this.charAt(this.bp);
        } else if (var3_4 == '\u001a') {
            this.token = 20;
            this.bp += var2_3 - 1;
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return 0.0;
lbl128:
            // 1 sources

            this.matchStat = -1;
            return 0.0;
        }
        this.matchStat = 4;
        return var6_10;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public BigDecimal scanFieldDecimal(char[] var1_1) {
        block33: {
            block31: {
                block32: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(var1_1)) {
                        this.matchStat = -2;
                        return null;
                    }
                    var2_4 = var1_1.length;
                    v0 = this;
                    if ((var4_6 = (var3_5 = v0.charAt(v0.bp + var2_4++)) == '\"' ? 1 : 0) != 0) {
                        v1 = this;
                        var3_5 = v1.charAt(v1.bp + var2_4++);
                    }
                    if (var3_5 == '-') {
                        v2 = this;
                        var3_5 = v2.charAt(v2.bp + var2_4++);
                    }
                    if (var3_5 < '0' || var3_5 > '9') break block31;
                    do {
                        v3 = this;
                    } while ((var3_5 = v3.charAt(v3.bp + var2_4++)) >= '0' && var3_5 <= '9');
                    if (var3_5 == '.') {
                        v4 = this;
                        if ((var3_5 = v4.charAt(v4.bp + var2_4++)) >= '0' && var3_5 <= '9') {
                            while (true) {
                                v5 = this;
                                if ((var3_5 = v5.charAt(v5.bp + var2_4++)) >= '0' && var3_5 <= '9') {
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return null;
                        }
                    }
                    if (!(var3_5 == 'e' || var3_5 == 'E')) break block32;
                    v6 = this;
                    if ((var3_5 = v6.charAt(v6.bp + var2_4++)) != '+' && var3_5 != '-') ** GOTO lbl33
                    do {
                        v7 = this;
                        var3_5 = v7.charAt(v7.bp + var2_4++);
lbl33:
                        // 2 sources

                    } while (var3_5 >= '0' && var3_5 <= '9');
                }
                if (var4_6 != 0) {
                    if (var3_5 != '\"') {
                        this.matchStat = -1;
                        return null;
                    }
                    v8 = this;
                    var3_5 = v8.charAt(v8.bp + var2_4++);
                    var1_2 = this.bp + var1_1.length + 1;
                    var4_6 = this.bp + var2_4 - var1_2 - 2;
                } else {
                    var1_2 = this.bp + var1_1.length;
                    var4_6 = this.bp + var2_4 - var1_2 - 1;
                }
                if (var4_6 > 65535) {
                    throw new JSONException("scan decimal overflow");
                }
                break block33;
            }
            if (var3_5 == 'n') {
                v9 = this;
                if (v9.charAt(v9.bp + var2_4) == 'u') {
                    v10 = this;
                    if (v10.charAt(v10.bp + var2_4 + 1) == 'l') {
                        v11 = this;
                        if (v11.charAt(v11.bp + var2_4 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_4 += 3;
                            v12 = this;
                            var3_5 = v12.charAt(v12.bp + var2_4++);
                            if (var4_6 != 0 && var3_5 == '\"') {
                                v13 = this;
                                var3_5 = v13.charAt(v13.bp + var2_4++);
                            }
                            while (true) {
                                if (var3_5 == ',') {
                                    this.bp += var2_4;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 16;
                                    return null;
                                }
                                if (var3_5 == '}') {
                                    this.bp += var2_4;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 13;
                                    return null;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_5)) break;
                                v14 = this;
                                var3_5 = v14.charAt(v14.bp + var2_4++);
                            }
                            this.matchStat = -1;
                            return null;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return null;
        }
        var1_3 /* !! */  = this.sub_chars(var1_2, var4_6);
        var1_3 /* !! */  = (char[])new BigDecimal(var1_3 /* !! */ , 0, var1_3 /* !! */ .length, MathContext.UNLIMITED);
        if (var3_5 == ',') {
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return var1_3 /* !! */ ;
        }
        if (var3_5 != '}') ** GOTO lbl118
        v15 = this;
        if ((var3_5 = v15.charAt(v15.bp + var2_4++)) == ',') {
            this.token = 16;
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
        } else if (var3_5 == ']') {
            this.token = 15;
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
        } else if (var3_5 == '}') {
            this.token = 13;
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
        } else if (var3_5 == '\u001a') {
            this.token = 20;
            this.bp += var2_4 - 1;
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl118:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var1_3 /* !! */ ;
    }

    /*
     * Unable to fully structure code
     */
    public BigInteger scanFieldBigInteger(char[] var1_1) {
        this.matchStat = 0;
        if (!this.charArrayCompare(var1_1)) {
            this.matchStat = -2;
            return null;
        }
        var2_4 = var1_1.length;
        v0 = this;
        if ((var4_6 = (var3_5 = v0.charAt(v0.bp + var2_4++)) == '\"' ? 1 : 0) != 0) {
            v1 = this;
            var3_5 = v1.charAt(v1.bp + var2_4++);
        }
        if (var5_7 = var3_5 == '-') {
            v2 = this;
            var3_5 = v2.charAt(v2.bp + var2_4++);
        }
        if (var3_5 >= '0' && var3_5 <= '9') {
            var7_8 = var3_5 - 48;
            var6_9 = false;
            while (true) {
                v3 = this;
                if ((var3_5 = v3.charAt(v3.bp + var2_4++)) < '0' || var3_5 > '9') break;
                var9_10 = var7_8 * 10L + (long)(var3_5 - 48);
                if (var9_10 < var7_8) {
                    var6_9 = true;
                    break;
                }
                var7_8 = var9_10;
            }
            if (var4_6 != 0) {
                if (var3_5 != '\"') {
                    this.matchStat = -1;
                    return null;
                }
                v4 = this;
                var3_5 = v4.charAt(v4.bp + var2_4++);
                var1_2 = this.bp + var1_1.length + 1;
                var4_6 = this.bp + var2_4 - var1_2 - 2;
            } else {
                var1_2 = this.bp + var1_1.length;
                var4_6 = this.bp + var2_4 - var1_2 - 1;
            }
            if (!var6_9 && (var4_6 < 20 || var5_7 && var4_6 < 21)) {
                var1_3 = BigInteger.valueOf(var5_7 != false ? -var7_8 : var7_8);
            } else {
                if (var4_6 > 65535) {
                    throw new JSONException("scanInteger overflow");
                }
                var1_3 = this.subString(var1_2, var4_6);
                var1_3 = new BigInteger((String)var1_3, 10);
            }
        } else {
            if (var3_5 == 'n') {
                v5 = this;
                if (v5.charAt(v5.bp + var2_4) == 'u') {
                    v6 = this;
                    if (v6.charAt(v6.bp + var2_4 + 1) == 'l') {
                        v7 = this;
                        if (v7.charAt(v7.bp + var2_4 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_4 += 3;
                            v8 = this;
                            var3_5 = v8.charAt(v8.bp + var2_4++);
                            if (var4_6 != 0 && var3_5 == '\"') {
                                v9 = this;
                                var3_5 = v9.charAt(v9.bp + var2_4++);
                            }
                            while (true) {
                                if (var3_5 == ',') {
                                    this.bp += var2_4;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 16;
                                    return null;
                                }
                                if (var3_5 == '}') {
                                    this.bp += var2_4;
                                    this.ch = this.charAt(this.bp);
                                    this.matchStat = 5;
                                    this.token = 13;
                                    return null;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_5)) break;
                                v10 = this;
                                var3_5 = v10.charAt(v10.bp + var2_4++);
                            }
                            this.matchStat = -1;
                            return null;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return null;
        }
        if (var3_5 == ',') {
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return var1_3;
        }
        if (var3_5 != '}') ** GOTO lbl109
        v11 = this;
        if ((var3_5 = v11.charAt(v11.bp + var2_4++)) == ',') {
            this.token = 16;
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
        } else if (var3_5 == ']') {
            this.token = 15;
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
        } else if (var3_5 == '}') {
            this.token = 13;
            this.bp += var2_4;
            this.ch = this.charAt(this.bp);
        } else if (var3_5 == '\u001a') {
            this.token = 20;
            this.bp += var2_4 - 1;
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl109:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var1_3;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date scanFieldDate(char[] object) {
        void var1_5;
        char c;
        int n;
        block24: {
            Object object2;
            int n2;
            block26: {
                int n3;
                int n4;
                block27: {
                    block25: {
                        this.matchStat = 0;
                        if (!this.charArrayCompare((char[])object)) {
                            this.matchStat = -2;
                            return null;
                        }
                        n = ((char[])object).length;
                        JSONLexerBase jSONLexerBase = this;
                        if ((c = jSONLexerBase.charAt(jSONLexerBase.bp + n++)) != '\"') break block25;
                        n4 = this.bp + ((char[])object).length + 1;
                        n2 = this.indexOf('\"', n4);
                        if (n2 == -1) {
                            throw new JSONException("unclosed str");
                        }
                        int n5 = this.bp + ((char[])object).length + 1;
                        object2 = this.subString(n5, n2 - n5);
                        if (((String)object2).indexOf(92) == -1) break block26;
                        break block27;
                    }
                    if (c == '-' || c >= '0' && c <= '9') {
                        long l = 0L;
                        boolean bl = false;
                        if (c == '-') {
                            JSONLexerBase jSONLexerBase = this;
                            c = jSONLexerBase.charAt(jSONLexerBase.bp + n++);
                            bl = true;
                        }
                        if (c >= '0' && c <= '9') {
                            l = c - 48;
                            while (true) {
                                JSONLexerBase jSONLexerBase = this;
                                if ((c = jSONLexerBase.charAt(jSONLexerBase.bp + n++)) < '0' || c > '9') break;
                                l = l * 10L + (long)(c - 48);
                            }
                        }
                        if (l < 0L) {
                            this.matchStat = -1;
                            return null;
                        }
                        if (bl) {
                            l = -l;
                        }
                        Date date = new Date(l);
                        break block24;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                while (true) {
                    n3 = 0;
                    for (n4 = n2 - 1; n4 >= 0 && this.charAt(n4) == '\\'; ++n3, --n4) {
                    }
                    if (n3 % 2 == 0) break;
                    n2 = this.indexOf('\"', n2 + 1);
                }
                n3 = n2 - (this.bp + ((char[])object).length + 1);
                JSONLexerBase jSONLexerBase = this;
                object2 = JSONLexerBase.readString(jSONLexerBase.sub_chars(jSONLexerBase.bp + ((char[])object).length + 1, n3), n3);
            }
            n += n2 - (this.bp + ((char[])object).length + 1) + 1;
            JSONLexerBase jSONLexerBase = this;
            c = jSONLexerBase.charAt(jSONLexerBase.bp + n++);
            object2 = new JSONScanner((String)object2);
            try {
                if (!((JSONScanner)object2).scanISO8601DateIfMatch(false)) {
                    this.matchStat = -1;
                    return null;
                }
                Date date = ((JSONLexerBase)object2).getCalendar().getTime();
            }
            finally {
                ((JSONLexerBase)object2).close();
            }
        }
        if (c == ',') {
            this.bp += n;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return var1_5;
        }
        if (c != '}') {
            this.matchStat = -1;
            return null;
        }
        JSONLexerBase jSONLexerBase = this;
        if ((c = jSONLexerBase.charAt(jSONLexerBase.bp + n++)) == ',') {
            this.token = 16;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c == ']') {
            this.token = 15;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else if (c == '}') {
            this.token = 13;
            this.bp += n;
            this.ch = this.charAt(this.bp);
        } else {
            if (c != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.token = 20;
            this.bp += n - 1;
            this.ch = (char)26;
        }
        this.matchStat = 4;
        return var1_5;
    }

    /*
     * Unable to fully structure code
     */
    public Date scanDate(char var1_1) {
        block25: {
            block26: {
                this.matchStat = 0;
                var1_1 = '\u0000';
                v0 = this;
                var1_1 = (char)(var1_1 + 1);
                var2_3 = v0.charAt(v0.bp + 0);
                if (var2_3 == '\"') {
                    var5_4 = this.bp + 1;
                    var6_6 = this.indexOf('\"', var5_4);
                    if (var6_6 == -1) {
                        throw new JSONException("unclosed str");
                    }
                    var3_7 = this.bp + 1;
                    var3_8 = this.subString(var3_7, var6_6 - var3_7);
                    if (var3_8.indexOf(92) != -1) {
                        while (true) {
                            var4_11 = 0;
                            for (var3_9 = var6_6 - 1; var3_9 >= 0 && this.charAt(var3_9) == '\\'; --var3_9) {
                                ++var4_11;
                            }
                            if (var4_11 % 2 == 0) break;
                            var6_6 = this.indexOf('\"', var6_6 + 1);
                        }
                        var4_11 = var6_6 - (this.bp + 1);
                        v1 = this;
                        var3_8 = JSONLexerBase.readString(v1.sub_chars(v1.bp + 1, var4_11), var4_11);
                    }
                    var1_1 = (char)(1 + (var6_6 - (this.bp + 1) + 1));
                    v2 = this;
                    v3 = var1_1;
                    var1_1 = (char)(var1_1 + 1);
                    var2_3 = v2.charAt(v2.bp + v3);
                    var4_12 = new JSONScanner((String)var3_8);
                    try {
                        if (var4_12.scanISO8601DateIfMatch(false)) {
                            var3_8 = var4_12.getCalendar().getTime();
                            break block25;
                        }
                        this.matchStat = -1;
                        return null;
                    }
                    finally {
                        var4_12.close();
                    }
                }
                if (var2_3 != '-' && (var2_3 < '0' || var2_3 > '9')) break block26;
                var5_5 = 0L;
                var3_10 = false;
                if (var2_3 == '-') {
                    v4 = this;
                    var1_1 = (char)(var1_1 + 1);
                    var2_3 = v4.charAt(v4.bp + 1);
                    var3_10 = true;
                }
                if (var2_3 >= '0' && var2_3 <= '9') {
                    var5_5 = var2_3 - 48;
                    while (true) {
                        v5 = this;
                        v6 = var1_1;
                        var1_1 = (char)(var1_1 + 1);
                        var2_3 = v5.charAt(v5.bp + v6);
                        if (var2_3 < '0' || var2_3 > '9') break;
                        var5_5 = var5_5 * 10L + (long)(var2_3 - 48);
                    }
                }
                if (var5_5 < 0L) {
                    this.matchStat = -1;
                    return null;
                }
                if (var3_10) {
                    var5_5 = -var5_5;
                }
                var3_8 = new Date(var5_5);
                break block25;
            }
            if (var2_3 != 'n') ** GOTO lbl-1000
            v7 = this;
            if (v7.charAt(v7.bp + 1) != 'u') ** GOTO lbl-1000
            v8 = this;
            if (v8.charAt(v8.bp + 1 + 1) != 'l') ** GOTO lbl-1000
            v9 = this;
            if (v9.charAt(v9.bp + 1 + 2) == 'l') {
                this.matchStat = 5;
                var3_8 = null;
                var1_1 = (char)(var1_1 + 3);
                v10 = this;
                var1_1 = (char)(var1_1 + 1);
                var2_3 = v10.charAt(v10.bp + 4);
            } else lbl-1000:
            // 4 sources

            {
                this.matchStat = -1;
                return null;
            }
        }
        if (var2_3 == ',') {
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return var3_8;
        }
        if (var2_3 != ']') ** GOTO lbl116
        v11 = this;
        v12 = var1_1;
        var1_1 = (char)(var1_1 + 1);
        var2_3 = v11.charAt(v11.bp + v12);
        if (var2_3 == ',') {
            this.token = 16;
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
        } else if (var2_3 == ']') {
            this.token = 15;
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
        } else if (var2_3 == '}') {
            this.token = 13;
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
        } else if (var2_3 == '\u001a') {
            this.token = 20;
            this.bp += var1_1 - '\u0001';
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl116:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var3_8;
    }

    /*
     * Unable to fully structure code
     */
    public UUID scanFieldUUID(char[] var1_1) {
        block64: {
            block62: {
                block65: {
                    block63: {
                        this.matchStat = 0;
                        if (!this.charArrayCompare(var1_1)) {
                            this.matchStat = -2;
                            return null;
                        }
                        var2_2 = var1_1.length;
                        v0 = this;
                        if ((var3_3 = v0.charAt(v0.bp + var2_2++)) != 34) break block62;
                        var3_3 = this.bp + var1_1.length + 1;
                        if ((var3_3 = this.indexOf('\"', var3_3)) == -1) {
                            throw new JSONException("unclosed str");
                        }
                        var4_4 = this.bp + var1_1.length + 1;
                        var5_6 = var3_3 - var4_4;
                        if (var5_6 != 36) break block63;
                        var7_7 = 0L;
                        var9_9 = 0L;
                        for (var5_6 = 0; var5_6 < 8; ++var5_6) {
                            var6_11 = this.charAt(var4_4 + var5_6);
                            if (var6_11 >= 48 && var6_11 <= 57) {
                                var6_11 -= 48;
                            } else if (var6_11 >= 97 && var6_11 <= 102) {
                                var6_11 = 10 + (var6_11 - 97);
                            } else if (var6_11 >= 65 && var6_11 <= 70) {
                                var6_11 = 10 + (var6_11 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var7_7 = var7_7 << 4 | (long)var6_11;
                        }
                        for (var5_6 = 9; var5_6 < 13; ++var5_6) {
                            var6_11 = this.charAt(var4_4 + var5_6);
                            if (var6_11 >= 48 && var6_11 <= 57) {
                                var6_11 -= 48;
                            } else if (var6_11 >= 97 && var6_11 <= 102) {
                                var6_11 = 10 + (var6_11 - 97);
                            } else if (var6_11 >= 65 && var6_11 <= 70) {
                                var6_11 = 10 + (var6_11 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var7_7 = var7_7 << 4 | (long)var6_11;
                        }
                        for (var5_6 = 14; var5_6 < 18; ++var5_6) {
                            v1 = this.charAt(var4_4 + var5_6);
                            var6_11 = v1;
                            if (v1 >= '0' && var6_11 <= 57) {
                                var6_11 -= 48;
                            } else if (var6_11 >= 97 && var6_11 <= 102) {
                                var6_11 = 10 + (var6_11 - 97);
                            } else if (var6_11 >= 65 && var6_11 <= 70) {
                                var6_11 = 10 + (var6_11 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var7_7 = var7_7 << 4 | (long)var6_11;
                        }
                        for (var5_6 = 19; var5_6 < 23; ++var5_6) {
                            v2 = this.charAt(var4_4 + var5_6);
                            var6_11 = v2;
                            if (v2 >= '0' && var6_11 <= 57) {
                                var6_11 -= 48;
                            } else if (var6_11 >= 97 && var6_11 <= 102) {
                                var6_11 = 10 + (var6_11 - 97);
                            } else if (var6_11 >= 65 && var6_11 <= 70) {
                                var6_11 = 10 + (var6_11 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var9_9 = var9_9 << 4 | (long)var6_11;
                        }
                        for (var5_6 = 24; var5_6 < 36; ++var5_6) {
                            v3 = this.charAt(var4_4 + var5_6);
                            var6_11 = v3;
                            if (v3 >= '0' && var6_11 <= 57) {
                                var6_11 -= 48;
                            } else if (var6_11 >= 97 && var6_11 <= 102) {
                                var6_11 = 10 + (var6_11 - 97);
                            } else if (var6_11 >= 65 && var6_11 <= 70) {
                                var6_11 = 10 + (var6_11 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var9_9 = var9_9 << 4 | (long)var6_11;
                        }
                        var4_5 = new UUID(var7_7, var9_9);
                        var2_2 += var3_3 - (this.bp + var1_1.length + 1) + 1;
                        v4 = this;
                        var3_3 = v4.charAt(v4.bp + var2_2++);
                        break block64;
                    }
                    if (var5_6 != 32) break block65;
                    var7_8 = 0L;
                    var9_10 = 0L;
                    for (var5_6 = 0; var5_6 < 16; ++var5_6) {
                        var6_12 = this.charAt(var4_4 + var5_6);
                        if (var6_12 >= 48 && var6_12 <= 57) {
                            var6_12 -= 48;
                        } else if (var6_12 >= 97 && var6_12 <= 102) {
                            var6_12 = 10 + (var6_12 - 97);
                        } else if (var6_12 >= 65 && var6_12 <= 70) {
                            var6_12 = 10 + (var6_12 - 65);
                        } else {
                            this.matchStat = -2;
                            return null;
                        }
                        var7_8 = var7_8 << 4 | (long)var6_12;
                    }
                    for (var5_6 = 16; var5_6 < 32; ++var5_6) {
                        var6_12 = this.charAt(var4_4 + var5_6);
                        if (var6_12 >= 48 && var6_12 <= 57) {
                            var6_12 -= 48;
                        } else if (var6_12 >= 97 && var6_12 <= 102) {
                            var6_12 = 10 + (var6_12 - 97);
                        } else if (var6_12 >= 65 && var6_12 <= 70) {
                            var6_12 = 10 + (var6_12 - 65);
                        } else {
                            this.matchStat = -2;
                            return null;
                        }
                        var9_10 = var9_10 << 4 | (long)var6_12;
                    }
                    var4_5 = new UUID(var7_8, var9_10);
                    var2_2 += var3_3 - (this.bp + var1_1.length + 1) + 1;
                    v5 = this;
                    var3_3 = v5.charAt(v5.bp + var2_2++);
                    break block64;
                }
                this.matchStat = -1;
                return null;
            }
            if (var3_3 != 110) ** GOTO lbl-1000
            v6 = this;
            if (v6.charAt(v6.bp + var2_2++) != 'u') ** GOTO lbl-1000
            v7 = this;
            if (v7.charAt(v7.bp + var2_2++) != 'l') ** GOTO lbl-1000
            v8 = this;
            if (v8.charAt(v8.bp + var2_2++) == 'l') {
                var4_5 = null;
                v9 = this;
                var3_3 = v9.charAt(v9.bp + var2_2++);
            } else lbl-1000:
            // 4 sources

            {
                this.matchStat = -1;
                return null;
            }
        }
        if (var3_3 == 44) {
            this.bp += var2_2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return var4_5;
        }
        if (var3_3 != 125) ** GOTO lbl187
        v10 = this;
        v11 = v10.charAt(v10.bp + var2_2++);
        var3_3 = v11;
        if (v11 == ',') {
            this.token = 16;
            this.bp += var2_2;
            this.ch = this.charAt(this.bp);
        } else if (var3_3 == 93) {
            this.token = 15;
            this.bp += var2_2;
            this.ch = this.charAt(this.bp);
        } else if (var3_3 == 125) {
            this.token = 13;
            this.bp += var2_2;
            this.ch = this.charAt(this.bp);
        } else if (var3_3 == 26) {
            this.token = 20;
            this.bp += var2_2 - 1;
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl187:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var4_5;
    }

    /*
     * Unable to fully structure code
     */
    public UUID scanUUID(char var1_1) {
        block63: {
            block61: {
                block64: {
                    block62: {
                        this.matchStat = 0;
                        var1_1 = '\u0000';
                        v0 = this;
                        var1_1 = (char)(var1_1 + 1);
                        var2_2 = v0.charAt(v0.bp + 0);
                        if (var2_2 != 34) break block61;
                        var1_1 = (char)(this.bp + 1);
                        v1 = this.indexOf('\"', var1_1);
                        var1_1 = (char)v1;
                        if (v1 == -1) {
                            throw new JSONException("unclosed str");
                        }
                        var2_2 = this.bp + 1;
                        var3_3 = var1_1 - var2_2;
                        if (var3_3 != 36) break block62;
                        var5_5 = 0L;
                        var7_7 = 0L;
                        for (var3_3 = 0; var3_3 < 8; ++var3_3) {
                            var4_9 = this.charAt(var2_2 + var3_3);
                            if (var4_9 >= 48 && var4_9 <= 57) {
                                var4_9 -= 48;
                            } else if (var4_9 >= 97 && var4_9 <= 102) {
                                var4_9 = 10 + (var4_9 - 97);
                            } else if (var4_9 >= 65 && var4_9 <= 70) {
                                var4_9 = 10 + (var4_9 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var5_5 = var5_5 << 4 | (long)var4_9;
                        }
                        for (var3_3 = 9; var3_3 < 13; ++var3_3) {
                            var4_9 = this.charAt(var2_2 + var3_3);
                            if (var4_9 >= 48 && var4_9 <= 57) {
                                var4_9 -= 48;
                            } else if (var4_9 >= 97 && var4_9 <= 102) {
                                var4_9 = 10 + (var4_9 - 97);
                            } else if (var4_9 >= 65 && var4_9 <= 70) {
                                var4_9 = 10 + (var4_9 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var5_5 = var5_5 << 4 | (long)var4_9;
                        }
                        for (var3_3 = 14; var3_3 < 18; ++var3_3) {
                            v2 = this.charAt(var2_2 + var3_3);
                            var4_9 = v2;
                            if (v2 >= '0' && var4_9 <= 57) {
                                var4_9 -= 48;
                            } else if (var4_9 >= 97 && var4_9 <= 102) {
                                var4_9 = 10 + (var4_9 - 97);
                            } else if (var4_9 >= 65 && var4_9 <= 70) {
                                var4_9 = 10 + (var4_9 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var5_5 = var5_5 << 4 | (long)var4_9;
                        }
                        for (var3_3 = 19; var3_3 < 23; ++var3_3) {
                            v3 = this.charAt(var2_2 + var3_3);
                            var4_9 = v3;
                            if (v3 >= '0' && var4_9 <= 57) {
                                var4_9 -= 48;
                            } else if (var4_9 >= 97 && var4_9 <= 102) {
                                var4_9 = 10 + (var4_9 - 97);
                            } else if (var4_9 >= 65 && var4_9 <= 70) {
                                var4_9 = 10 + (var4_9 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var7_7 = var7_7 << 4 | (long)var4_9;
                        }
                        for (var3_3 = 24; var3_3 < 36; ++var3_3) {
                            v4 = this.charAt(var2_2 + var3_3);
                            var4_9 = v4;
                            if (v4 >= '0' && var4_9 <= 57) {
                                var4_9 -= 48;
                            } else if (var4_9 >= 97 && var4_9 <= 102) {
                                var4_9 = 10 + (var4_9 - 97);
                            } else if (var4_9 >= 65 && var4_9 <= 70) {
                                var4_9 = 10 + (var4_9 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var7_7 = var7_7 << 4 | (long)var4_9;
                        }
                        var3_4 = new UUID(var5_5, var7_7);
                        var1_1 = (char)(1 + (var1_1 - (this.bp + 1) + 1));
                        v5 = this;
                        v6 = var1_1;
                        var1_1 = (char)(var1_1 + 1);
                        var2_2 = v5.charAt(v5.bp + v6);
                        break block63;
                    }
                    if (var3_3 != 32) break block64;
                    var5_6 = 0L;
                    var7_8 = 0L;
                    for (var3_3 = 0; var3_3 < 16; ++var3_3) {
                        var4_10 = this.charAt(var2_2 + var3_3);
                        if (var4_10 >= 48 && var4_10 <= 57) {
                            var4_10 -= 48;
                        } else if (var4_10 >= 97 && var4_10 <= 102) {
                            var4_10 = 10 + (var4_10 - 97);
                        } else if (var4_10 >= 65 && var4_10 <= 70) {
                            var4_10 = 10 + (var4_10 - 65);
                        } else {
                            this.matchStat = -2;
                            return null;
                        }
                        var5_6 = var5_6 << 4 | (long)var4_10;
                    }
                    for (var3_3 = 16; var3_3 < 32; ++var3_3) {
                        var4_10 = this.charAt(var2_2 + var3_3);
                        if (var4_10 >= 48 && var4_10 <= 57) {
                            var4_10 -= 48;
                        } else if (var4_10 >= 97 && var4_10 <= 102) {
                            var4_10 = 10 + (var4_10 - 97);
                        } else if (var4_10 >= 65 && var4_10 <= 70) {
                            var4_10 = 10 + (var4_10 - 65);
                        } else {
                            this.matchStat = -2;
                            return null;
                        }
                        var7_8 = var7_8 << 4 | (long)var4_10;
                    }
                    var3_4 = new UUID(var5_6, var7_8);
                    var1_1 = (char)(1 + (var1_1 - (this.bp + 1) + 1));
                    v7 = this;
                    v8 = var1_1;
                    var1_1 = (char)(var1_1 + 1);
                    var2_2 = v7.charAt(v7.bp + v8);
                    break block63;
                }
                this.matchStat = -1;
                return null;
            }
            if (var2_2 != 110) ** GOTO lbl-1000
            v9 = this;
            var1_1 = (char)(var1_1 + 1);
            if (v9.charAt(v9.bp + 1) != 'u') ** GOTO lbl-1000
            v10 = this;
            var1_1 = (char)(var1_1 + 1);
            if (v10.charAt(v10.bp + 2) != 'l') ** GOTO lbl-1000
            v11 = this;
            var1_1 = (char)(var1_1 + 1);
            if (v11.charAt(v11.bp + 3) == 'l') {
                var3_4 = null;
                v12 = this;
                var1_1 = (char)(var1_1 + 1);
                var2_2 = v12.charAt(v12.bp + 4);
            } else lbl-1000:
            // 4 sources

            {
                this.matchStat = -1;
                return null;
            }
        }
        if (var2_2 == 44) {
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            return var3_4;
        }
        if (var2_2 != 93) ** GOTO lbl198
        v13 = this;
        v14 = var1_1;
        var1_1 = (char)(var1_1 + 1);
        v15 = v13.charAt(v13.bp + v14);
        var2_2 = v15;
        if (v15 == ',') {
            this.token = 16;
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
        } else if (var2_2 == 93) {
            this.token = 15;
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
        } else if (var2_2 == 125) {
            this.token = 13;
            this.bp += var1_1;
            this.ch = this.charAt(this.bp);
        } else if (var2_2 == 26) {
            this.token = 20;
            this.bp += var1_1 - '\u0001';
            this.ch = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl198:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var3_4;
    }

    public final void scanTrue() {
        if (this.ch != 't') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'r') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'u') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.ch == ' ' || this.ch == ',' || this.ch == '}' || this.ch == ']' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\u001a' || this.ch == '\f' || this.ch == '\b' || this.ch == ':' || this.ch == '/') {
            this.token = 6;
            return;
        }
        throw new JSONException("scan true error");
    }

    public final void scanNullOrNew() {
        this.scanNullOrNew(true);
    }

    public final void scanNullOrNew(boolean bl) {
        if (this.ch != 'n') {
            throw new JSONException("error parse null or new");
        }
        this.next();
        if (this.ch == 'u') {
            this.next();
            if (this.ch != 'l') {
                throw new JSONException("error parse null");
            }
            this.next();
            if (this.ch != 'l') {
                throw new JSONException("error parse null");
            }
            this.next();
            if (this.ch == ' ' || this.ch == ',' || this.ch == '}' || this.ch == ']' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\u001a' || this.ch == ':' && bl || this.ch == '\f' || this.ch == '\b') {
                this.token = 8;
                return;
            }
            throw new JSONException("scan null error");
        }
        if (this.ch != 'e') {
            throw new JSONException("error parse new");
        }
        this.next();
        if (this.ch != 'w') {
            throw new JSONException("error parse new");
        }
        this.next();
        if (this.ch == ' ' || this.ch == ',' || this.ch == '}' || this.ch == ']' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\u001a' || this.ch == '\f' || this.ch == '\b') {
            this.token = 9;
            return;
        }
        throw new JSONException("scan new error");
    }

    public final void scanFalse() {
        if (this.ch != 'f') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'a') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'l') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 's') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch != 'e') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.ch == ' ' || this.ch == ',' || this.ch == '}' || this.ch == ']' || this.ch == '\n' || this.ch == '\r' || this.ch == '\t' || this.ch == '\u001a' || this.ch == '\f' || this.ch == '\b' || this.ch == ':' || this.ch == '/') {
            this.token = 7;
            return;
        }
        throw new JSONException("scan false error");
    }

    public final void scanIdent() {
        this.np = this.bp - 1;
        this.hasSpecial = false;
        do {
            ++this.sp;
            this.next();
        } while (Character.isLetterOrDigit(this.ch));
        String string = this.stringVal();
        if ("null".equalsIgnoreCase(string)) {
            this.token = 8;
            return;
        }
        if ("new".equals(string)) {
            this.token = 9;
            return;
        }
        if ("true".equals(string)) {
            this.token = 6;
            return;
        }
        if ("false".equals(string)) {
            this.token = 7;
            return;
        }
        if ("undefined".equals(string)) {
            this.token = 23;
            return;
        }
        if ("Set".equals(string)) {
            this.token = 21;
            return;
        }
        if ("TreeSet".equals(string)) {
            this.token = 22;
            return;
        }
        this.token = 18;
    }

    @Override
    public abstract String stringVal();

    public abstract String subString(int var1, int var2);

    protected abstract char[] sub_chars(int var1, int var2);

    public static String readString(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        int n2 = 0;
        block22: for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c != '\\') {
                cArray2[n2++] = c;
                continue;
            }
            switch (cArray[++i]) {
                case '0': {
                    cArray2[n2++] = '\u0000';
                    continue block22;
                }
                case '1': {
                    cArray2[n2++] = '\u0001';
                    continue block22;
                }
                case '2': {
                    cArray2[n2++] = 2;
                    continue block22;
                }
                case '3': {
                    cArray2[n2++] = 3;
                    continue block22;
                }
                case '4': {
                    cArray2[n2++] = 4;
                    continue block22;
                }
                case '5': {
                    cArray2[n2++] = 5;
                    continue block22;
                }
                case '6': {
                    cArray2[n2++] = 6;
                    continue block22;
                }
                case '7': {
                    cArray2[n2++] = 7;
                    continue block22;
                }
                case 'b': {
                    cArray2[n2++] = 8;
                    continue block22;
                }
                case 't': {
                    cArray2[n2++] = 9;
                    continue block22;
                }
                case 'n': {
                    cArray2[n2++] = 10;
                    continue block22;
                }
                case 'v': {
                    cArray2[n2++] = 11;
                    continue block22;
                }
                case 'F': 
                case 'f': {
                    cArray2[n2++] = 12;
                    continue block22;
                }
                case 'r': {
                    cArray2[n2++] = 13;
                    continue block22;
                }
                case '\"': {
                    cArray2[n2++] = 34;
                    continue block22;
                }
                case '\'': {
                    cArray2[n2++] = 39;
                    continue block22;
                }
                case '/': {
                    cArray2[n2++] = 47;
                    continue block22;
                }
                case '\\': {
                    cArray2[n2++] = 92;
                    continue block22;
                }
                case 'x': {
                    cArray2[n2++] = (char)(digits[cArray[++i]] * 16 + digits[cArray[++i]]);
                    continue block22;
                }
                case 'u': {
                    cArray2[n2++] = (char)Integer.parseInt(new String(new char[]{cArray[++i], cArray[++i], cArray[++i], cArray[++i]}), 16);
                    continue block22;
                }
                default: {
                    throw new JSONException("unclosed.str.lit");
                }
            }
        }
        return new String(cArray2, 0, n2);
    }

    protected abstract boolean charArrayCompare(char[] var1);

    @Override
    public boolean isBlankInput() {
        int n = 0;
        while (true) {
            char c;
            if ((c = this.charAt(n)) == '\u001a') break;
            if (!JSONLexerBase.isWhitespace(c)) {
                return false;
            }
            ++n;
        }
        this.token = 20;
        return true;
    }

    @Override
    public final void skipWhitespace() {
        while (this.ch <= '/') {
            if (this.ch == ' ' || this.ch == '\r' || this.ch == '\n' || this.ch == '\t' || this.ch == '\f' || this.ch == '\b') {
                this.next();
                continue;
            }
            if (this.ch != '/') break;
            this.skipComment();
        }
    }

    private void scanStringSingleQuote() {
        char c;
        this.np = this.bp;
        this.hasSpecial = false;
        block22: while ((c = this.next()) != '\'') {
            if (c == '\u001a') {
                if (!this.isEOF()) {
                    this.putChar('\u001a');
                    continue;
                }
                throw new JSONException("unclosed single-quote string");
            }
            if (c == '\\') {
                if (!this.hasSpecial) {
                    this.hasSpecial = true;
                    if (this.sp > this.sbuf.length) {
                        char[] cArray = new char[this.sp * 2];
                        System.arraycopy(this.sbuf, 0, cArray, 0, this.sbuf.length);
                        this.sbuf = cArray;
                    }
                    JSONLexerBase jSONLexerBase = this;
                    jSONLexerBase.copyTo(jSONLexerBase.np + 1, this.sp, this.sbuf);
                }
                c = this.next();
                switch (c) {
                    case '0': {
                        this.putChar('\u0000');
                        continue block22;
                    }
                    case '1': {
                        this.putChar('\u0001');
                        continue block22;
                    }
                    case '2': {
                        this.putChar('\u0002');
                        continue block22;
                    }
                    case '3': {
                        this.putChar('\u0003');
                        continue block22;
                    }
                    case '4': {
                        this.putChar('\u0004');
                        continue block22;
                    }
                    case '5': {
                        this.putChar('\u0005');
                        continue block22;
                    }
                    case '6': {
                        this.putChar('\u0006');
                        continue block22;
                    }
                    case '7': {
                        this.putChar('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block22;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block22;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block22;
                    }
                    case 'v': {
                        this.putChar('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block22;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block22;
                    }
                    case '\"': {
                        this.putChar('\"');
                        continue block22;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block22;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block22;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block22;
                    }
                    case 'x': {
                        boolean bl;
                        c = this.next();
                        char c2 = this.next();
                        boolean bl2 = c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
                        boolean bl3 = bl = c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F';
                        if (!bl2 || !bl) {
                            throw new JSONException("invalid escape character \\x" + c + c2);
                        }
                        this.putChar((char)(digits[c] * 16 + digits[c2]));
                        continue block22;
                    }
                    case 'u': {
                        this.putChar((char)Integer.parseInt(new String(new char[]{this.next(), this.next(), this.next(), this.next()}), 16));
                        continue block22;
                    }
                }
                this.ch = c;
                throw new JSONException("unclosed single-quote string");
            }
            if (!this.hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(c);
                continue;
            }
            this.sbuf[this.sp++] = c;
        }
        this.token = 4;
        this.next();
    }

    protected final void putChar(char c) {
        if (this.sp == this.sbuf.length) {
            char[] cArray = new char[this.sbuf.length * 2];
            System.arraycopy(this.sbuf, 0, cArray, 0, this.sbuf.length);
            this.sbuf = cArray;
        }
        this.sbuf[this.sp++] = c;
    }

    public final void scanHex() {
        char c;
        if (this.ch != 'x') {
            throw new JSONException("illegal state. " + this.ch);
        }
        this.next();
        if (this.ch != '\'') {
            throw new JSONException("illegal state. " + this.ch);
        }
        this.np = this.bp;
        this.next();
        if (this.ch == '\'') {
            this.next();
            this.token = 26;
            return;
        }
        while ((c = this.next()) >= '0' && c <= '9' || c >= 'A' && c <= 'F') {
            ++this.sp;
        }
        if (c == '\'') {
            ++this.sp;
        } else {
            throw new JSONException("illegal state. ".concat(String.valueOf(c)));
        }
        this.next();
        this.token = 26;
    }

    @Override
    public final void scanNumber() {
        boolean bl;
        block13: {
            block17: {
                block18: {
                    block16: {
                        block15: {
                            block14: {
                                block12: {
                                    this.np = this.bp;
                                    if (this.ch == '-') {
                                        ++this.sp;
                                        this.next();
                                    }
                                    while (this.ch >= '0' && this.ch <= '9') {
                                        ++this.sp;
                                        this.next();
                                    }
                                    bl = false;
                                    if (this.ch == '.') {
                                        ++this.sp;
                                        this.next();
                                        bl = true;
                                        while (this.ch >= '0' && this.ch <= '9') {
                                            ++this.sp;
                                            this.next();
                                        }
                                    }
                                    if (this.sp > 65535) {
                                        throw new JSONException("scanNumber overflow");
                                    }
                                    if (this.ch != 'L') break block12;
                                    ++this.sp;
                                    this.next();
                                    break block13;
                                }
                                if (this.ch != 'S') break block14;
                                ++this.sp;
                                this.next();
                                break block13;
                            }
                            if (this.ch != 'B') break block15;
                            ++this.sp;
                            this.next();
                            break block13;
                        }
                        if (this.ch != 'F') break block16;
                        ++this.sp;
                        this.next();
                        break block17;
                    }
                    if (this.ch != 'D') break block18;
                    ++this.sp;
                    this.next();
                    break block17;
                }
                if (this.ch != 'e' && this.ch != 'E') break block13;
                ++this.sp;
                this.next();
                if (this.ch == '+' || this.ch == '-') {
                    ++this.sp;
                    this.next();
                }
                while (this.ch >= '0' && this.ch <= '9') {
                    ++this.sp;
                    this.next();
                }
                if (this.ch == 'D' || this.ch == 'F') {
                    ++this.sp;
                    this.next();
                }
            }
            bl = true;
        }
        if (bl) {
            this.token = 3;
            return;
        }
        this.token = 2;
    }

    @Override
    public final long longValue() {
        int n;
        long l;
        long l2 = 0L;
        boolean bl = false;
        if (this.np == -1) {
            this.np = 0;
        }
        int n2 = this.np;
        int n3 = this.np + this.sp;
        JSONLexerBase jSONLexerBase = this;
        if (jSONLexerBase.charAt(jSONLexerBase.np) == '-') {
            bl = true;
            l = Long.MIN_VALUE;
            ++n2;
        } else {
            l = -9223372036854775807L;
        }
        if (n2 < n3) {
            l2 = -(this.charAt(n2++) - 48);
        }
        while (n2 < n3 && (n = this.charAt(n2++)) != 76 && n != 83 && n != 66) {
            n -= 48;
            if (l2 < -922337203685477580L) {
                throw new NumberFormatException(this.numberString());
            }
            if ((l2 *= 10L) < l + (long)n) {
                throw new NumberFormatException(this.numberString());
            }
            l2 -= (long)n;
        }
        if (bl) {
            if (n2 > this.np + 1) {
                return l2;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -l2;
    }

    @Override
    public final Number decimalValue(boolean bl) {
        JSONLexerBase jSONLexerBase = this;
        char c = jSONLexerBase.charAt(jSONLexerBase.np + this.sp - 1);
        try {
            if (c == 'F') {
                return Float.valueOf(Float.parseFloat(this.numberString()));
            }
            if (c == 'D') {
                return Double.parseDouble(this.numberString());
            }
            if (bl) {
                return this.decimalValue();
            }
            return this.doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new JSONException(numberFormatException.getMessage() + ", " + this.info());
        }
    }

    @Override
    public abstract BigDecimal decimalValue();

    public static boolean isWhitespace(char c) {
        return c <= ' ' && (c == ' ' || c == '\n' || c == '\r' || c == '\t' || c == '\f' || c == '\b');
    }

    public String[] scanFieldStringArray(char[] cArray, int n, SymbolTable symbolTable) {
        throw new UnsupportedOperationException();
    }

    public boolean matchField2(char[] cArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFeatures() {
        return this.features;
    }

    @Override
    public void setFeatures(int n) {
        this.features = n;
    }

    static {
        int n = 48;
        while (n <= 57) {
            int n2 = n++;
            JSONLexerBase.digits[n2] = n2 - 48;
        }
        n = 97;
        while (n <= 102) {
            int n3 = n++;
            JSONLexerBase.digits[n3] = n3 - 97 + 10;
        }
        n = 65;
        while (n <= 70) {
            int n4 = n++;
            JSONLexerBase.digits[n4] = n4 - 65 + 10;
        }
    }
}

