/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.JSONLexerBase;
import com.tradplus.ads.common.serialization.parser.SymbolTable;
import com.tradplus.ads.common.serialization.util.IOUtils;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.MathContext;

public final class JSONReaderScanner
extends JSONLexerBase {
    private static final ThreadLocal<char[]> BUF_LOCAL = new ThreadLocal();
    private Reader reader;
    private char[] buf;
    private int bufLength;

    public JSONReaderScanner(String string) {
        this(string, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONReaderScanner(String string, int n) {
        this(new StringReader(string), n);
    }

    public JSONReaderScanner(char[] cArray, int n) {
        this(cArray, n, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONReaderScanner(Reader reader) {
        this(reader, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONReaderScanner(Reader reader, int n) {
        super(n);
        this.reader = reader;
        this.buf = BUF_LOCAL.get();
        if (this.buf != null) {
            BUF_LOCAL.set(null);
        }
        if (this.buf == null) {
            this.buf = new char[16384];
        }
        try {
            this.bufLength = reader.read(this.buf);
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
        this.bp = -1;
        this.next();
        if (this.ch == '\ufeff') {
            this.next();
        }
    }

    public JSONReaderScanner(char[] cArray, int n, int n2) {
        this(new CharArrayReader(cArray, 0, n), n2);
    }

    @Override
    public final char charAt(int n) {
        if (n >= this.bufLength) {
            if (this.bufLength == -1) {
                if (n < this.sp) {
                    return this.buf[n];
                }
                return '\u001a';
            }
            if (this.bp == 0) {
                char[] cArray = new char[this.buf.length * 3 / 2];
                System.arraycopy(this.buf, this.bp, cArray, 0, this.bufLength);
                int n2 = cArray.length - this.bufLength;
                try {
                    n2 = this.reader.read(cArray, this.bufLength, n2);
                    this.bufLength += n2;
                    this.buf = cArray;
                }
                catch (IOException iOException) {
                    throw new JSONException(iOException.getMessage(), iOException);
                }
            }
            int n3 = this.bufLength - this.bp;
            if (n3 > 0) {
                System.arraycopy(this.buf, this.bp, this.buf, 0, n3);
            }
            try {
                this.bufLength = this.reader.read(this.buf, n3, this.buf.length - n3);
            }
            catch (IOException iOException) {
                throw new JSONException(iOException.getMessage(), iOException);
            }
            if (this.bufLength == 0) {
                throw new JSONException("illegal state, textLength is zero");
            }
            if (this.bufLength == -1) {
                return '\u001a';
            }
            this.bufLength += n3;
            n -= this.bp;
            this.np -= this.bp;
            this.bp = 0;
        }
        return this.buf[n];
    }

    @Override
    public final int indexOf(char c, int n) {
        n -= this.bp;
        while (true) {
            int n2 = this.bp + n;
            if (c == (n2 = (int)this.charAt(n2))) {
                return n + this.bp;
            }
            if (n2 == 26) {
                return -1;
            }
            ++n;
        }
    }

    @Override
    public final String addSymbol(int n, int n2, int n3, SymbolTable symbolTable) {
        return symbolTable.addSymbol(this.buf, n, n2, n3);
    }

    @Override
    public final char next() {
        int n = ++this.bp;
        if (this.bp >= this.bufLength) {
            int n2;
            if (this.bufLength == -1) {
                return '\u001a';
            }
            if (this.sp > 0) {
                n2 = this.bufLength - this.sp;
                if (this.ch == '\"' && n2 > 0) {
                    --n2;
                }
                System.arraycopy(this.buf, n2, this.buf, 0, this.sp);
            }
            this.np = -1;
            n = this.bp = this.sp;
            try {
                n2 = this.bp;
                int n3 = this.buf.length - n2;
                if (n3 == 0) {
                    char[] cArray = new char[this.buf.length * 2];
                    System.arraycopy(this.buf, 0, cArray, 0, this.buf.length);
                    this.buf = cArray;
                    n3 = this.buf.length - n2;
                }
                this.bufLength = this.reader.read(this.buf, this.bp, n3);
            }
            catch (IOException iOException) {
                throw new JSONException(iOException.getMessage(), iOException);
            }
            if (this.bufLength == 0) {
                throw new JSONException("illegal stat, textLength is zero");
            }
            if (this.bufLength == -1) {
                this.ch = '\u001a';
                return '\u001a';
            }
            this.bufLength += this.bp;
        }
        this.ch = this.buf[n];
        return this.ch;
    }

    @Override
    protected final void copyTo(int n, int n2, char[] cArray) {
        System.arraycopy(this.buf, n, cArray, 0, n2);
    }

    @Override
    public final boolean charArrayCompare(char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            JSONReaderScanner jSONReaderScanner = this;
            if (jSONReaderScanner.charAt(jSONReaderScanner.bp + i) == cArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final byte[] bytesValue() {
        if (this.token == 26) {
            throw new JSONException("TODO");
        }
        return IOUtils.ddb(this.buf, this.np + 1, this.sp);
    }

    @Override
    protected final void arrayCopy(int n, char[] cArray, int n2, int n3) {
        System.arraycopy(this.buf, n, cArray, n2, n3);
    }

    @Override
    public final String stringVal() {
        if (!this.hasSpecial) {
            int n = this.np + 1;
            if (n < 0) {
                throw new IllegalStateException();
            }
            if (n > this.buf.length - this.sp) {
                throw new IllegalStateException();
            }
            return new String(this.buf, n, this.sp);
        }
        return new String(this.sbuf, 0, this.sp);
    }

    @Override
    public final String subString(int n, int n2) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        return new String(this.buf, n, n2);
    }

    @Override
    public final char[] sub_chars(int n, int n2) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n == 0) {
            return this.buf;
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.buf, n, cArray, 0, n2);
        return cArray;
    }

    @Override
    public final String numberString() {
        int n = this.np;
        if (n == -1) {
            n = 0;
        }
        char c = this.charAt(n + this.sp - 1);
        int n2 = this.sp;
        if (c == 'L' || c == 'S' || c == 'B' || c == 'F' || c == 'D') {
            --n2;
        }
        return new String(this.buf, n, n2);
    }

    @Override
    public final BigDecimal decimalValue() {
        int n = this.np;
        if (n == -1) {
            n = 0;
        }
        char c = this.charAt(n + this.sp - 1);
        int n2 = this.sp;
        if (c == 'L' || c == 'S' || c == 'B' || c == 'F' || c == 'D') {
            --n2;
        }
        if (n2 > 65535) {
            throw new JSONException("decimal overflow");
        }
        return new BigDecimal(this.buf, n, n2, MathContext.UNLIMITED);
    }

    @Override
    public final void close() {
        super.close();
        if (this.buf.length <= 65536) {
            BUF_LOCAL.set(this.buf);
        }
        this.buf = null;
        IOUtils.close(this.reader);
    }

    @Override
    public final boolean isEOF() {
        return this.bufLength == -1 || this.bp == this.buf.length || this.ch == '\u001a' && this.bp + 1 >= this.buf.length;
    }

    @Override
    public final boolean isBlankInput() {
        int n = 0;
        while (true) {
            char c;
            if ((c = this.buf[n]) == '\u001a') break;
            if (!JSONReaderScanner.isWhitespace(c)) {
                return false;
            }
            ++n;
        }
        this.token = 20;
        return true;
    }
}

