/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.JSONLexerBase;
import com.tradplus.ads.common.serialization.parser.JSONToken;
import com.tradplus.ads.common.serialization.parser.SymbolTable;
import com.tradplus.ads.common.serialization.util.ASMUtils;
import com.tradplus.ads.common.serialization.util.IOUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public final class JSONScanner
extends JSONLexerBase {
    private final String text;
    private final int len;

    public JSONScanner(String string) {
        this(string, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONScanner(String string, int n) {
        super(n);
        this.text = string;
        this.len = this.text.length();
        this.bp = -1;
        this.next();
        if (this.ch == '\ufeff') {
            this.next();
        }
    }

    @Override
    public final char charAt(int n) {
        if (n >= this.len) {
            return '\u001a';
        }
        return this.text.charAt(n);
    }

    @Override
    public final char next() {
        int n;
        char c = (n = ++this.bp) >= this.len ? (char)'\u001a' : (char)this.text.charAt(n);
        this.ch = c;
        return c;
    }

    public JSONScanner(char[] cArray, int n) {
        this(cArray, n, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONScanner(char[] cArray, int n, int n2) {
        this(new String(cArray, 0, n), n2);
    }

    @Override
    protected final void copyTo(int n, int n2, char[] cArray) {
        int n3 = n;
        this.text.getChars(n3, n3 + n2, cArray, 0);
    }

    static boolean charArrayCompare(String string, int n, char[] cArray) {
        int n2 = cArray.length;
        if (n2 + n > string.length()) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (cArray[i] == string.charAt(n + i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean charArrayCompare(char[] cArray) {
        return JSONScanner.charArrayCompare(this.text, this.bp, cArray);
    }

    @Override
    public final int indexOf(char c, int n) {
        return this.text.indexOf(c, n);
    }

    @Override
    public final String addSymbol(int n, int n2, int n3, SymbolTable symbolTable) {
        return symbolTable.addSymbol(this.text, n, n2, n3);
    }

    @Override
    public final byte[] bytesValue() {
        if (this.token == 26) {
            int n = this.np + 1;
            int n2 = this.sp;
            if (n2 % 2 != 0) {
                throw new JSONException("illegal state. ".concat(String.valueOf(n2)));
            }
            byte[] byArray = new byte[n2 / 2];
            for (int i = 0; i < byArray.length; ++i) {
                int n3 = this.text.charAt(n + i * 2);
                int n4 = this.text.charAt(n + i * 2 + 1);
                int n5 = n3;
                n3 = n5 - (n5 <= 57 ? 48 : 55);
                int n6 = n4;
                n4 = n6 - (n6 <= 57 ? 48 : 55);
                byArray[i] = (byte)(n3 << 4 | n4);
            }
            return byArray;
        }
        if (!this.hasSpecial) {
            return IOUtils.ddb(this.text, this.np + 1, this.sp);
        }
        return IOUtils.ddb(new String(this.sbuf, 0, this.sp));
    }

    @Override
    public final String stringVal() {
        if (!this.hasSpecial) {
            JSONScanner jSONScanner = this;
            return jSONScanner.subString(jSONScanner.np + 1, this.sp);
        }
        return new String(this.sbuf, 0, this.sp);
    }

    @Override
    public final String subString(int n, int n2) {
        if (ASMUtils.IS_ANDROID) {
            if (n2 < this.sbuf.length) {
                int n3 = n;
                this.text.getChars(n3, n3 + n2, this.sbuf, 0);
                return new String(this.sbuf, 0, n2);
            }
            char[] cArray = new char[n2];
            int n4 = n;
            this.text.getChars(n4, n4 + n2, cArray, 0);
            return new String(cArray);
        }
        int n5 = n;
        return this.text.substring(n5, n5 + n2);
    }

    @Override
    public final char[] sub_chars(int n, int n2) {
        if (ASMUtils.IS_ANDROID && n2 < this.sbuf.length) {
            int n3 = n;
            this.text.getChars(n3, n3 + n2, this.sbuf, 0);
            return this.sbuf;
        }
        char[] cArray = new char[n2];
        int n4 = n;
        this.text.getChars(n4, n4 + n2, cArray, 0);
        return cArray;
    }

    @Override
    public final String numberString() {
        JSONScanner jSONScanner = this;
        char c = jSONScanner.charAt(jSONScanner.np + this.sp - 1);
        int n = this.sp;
        if (c == 'L' || c == 'S' || c == 'B' || c == 'F' || c == 'D') {
            --n;
        }
        JSONScanner jSONScanner2 = this;
        return jSONScanner2.subString(jSONScanner2.np, n);
    }

    @Override
    public final BigDecimal decimalValue() {
        JSONScanner jSONScanner = this;
        int n = jSONScanner.charAt(jSONScanner.np + this.sp - 1);
        int n2 = this.sp;
        if (n == 76 || n == 83 || n == 66 || n == 70 || n == 68) {
            --n2;
        }
        if (n2 > 65535) {
            throw new JSONException("decimal overflow");
        }
        n = this.np;
        if (n2 < this.sbuf.length) {
            int n3 = n;
            this.text.getChars(n3, n3 + n2, this.sbuf, 0);
            return new BigDecimal(this.sbuf, 0, n2, MathContext.UNLIMITED);
        }
        char[] cArray = new char[n2];
        int n4 = n;
        this.text.getChars(n4, n4 + n2, cArray, 0);
        return new BigDecimal(cArray, 0, cArray.length, MathContext.UNLIMITED);
    }

    public final boolean scanISO8601DateIfMatch() {
        return this.scanISO8601DateIfMatch(true);
    }

    public final boolean scanISO8601DateIfMatch(boolean bl) {
        int n = this.len - this.bp;
        return this.scanISO8601DateIfMatch(bl, n);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean scanISO8601DateIfMatch(boolean var1_1, int var2_3) {
        block90: {
            block85: {
                block87: {
                    block89: {
                        block88: {
                            block86: {
                                block80: {
                                    block81: {
                                        block82: {
                                            block84: {
                                                block83: {
                                                    block79: {
                                                        block71: {
                                                            block75: {
                                                                block78: {
                                                                    block77: {
                                                                        block76: {
                                                                            block74: {
                                                                                block73: {
                                                                                    block72: {
                                                                                        block70: {
                                                                                            block66: {
                                                                                                block69: {
                                                                                                    block67: {
                                                                                                        block68: {
                                                                                                            block64: {
                                                                                                                block65: {
                                                                                                                    if (var2_3 < 8) {
                                                                                                                        return false;
                                                                                                                    }
                                                                                                                    v0 = this;
                                                                                                                    var3_4 = v0.charAt(v0.bp);
                                                                                                                    v1 = this;
                                                                                                                    var4_6 = v1.charAt(v1.bp + 1);
                                                                                                                    v2 = this;
                                                                                                                    var5_7 = v2.charAt(v2.bp + 2);
                                                                                                                    v3 = this;
                                                                                                                    var6_8 = v3.charAt(v3.bp + 3);
                                                                                                                    v4 = this;
                                                                                                                    var7_9 = v4.charAt(v4.bp + 4);
                                                                                                                    v5 = this;
                                                                                                                    var8_12 = v5.charAt(v5.bp + 5);
                                                                                                                    v6 = this;
                                                                                                                    var9_13 = v6.charAt(v6.bp + 6);
                                                                                                                    v7 = this;
                                                                                                                    var10_15 = v7.charAt(v7.bp + 7);
                                                                                                                    if (var1_1 == 0 && var2_3 > 13) {
                                                                                                                        v8 = this;
                                                                                                                        var11_16 = v8.charAt(v8.bp + var2_3 - 1);
                                                                                                                        v9 = this;
                                                                                                                        var12_17 = v9.charAt(v9.bp + var2_3 - 2);
                                                                                                                        if (var3_4 == 47 && var4_6 == 68 && var5_7 == 97 && var6_8 == 116 && var7_9 == 101 && var8_12 == 40 && var11_16 == 47 && var12_17 == 41) {
                                                                                                                            var11_16 = -1;
                                                                                                                            for (var13_18 = 6; var13_18 < var2_3; ++var13_18) {
                                                                                                                                v10 = this;
                                                                                                                                v11 = v10.charAt(v10.bp + var13_18);
                                                                                                                                var3_4 = v11;
                                                                                                                                if (v11 == '+') {
                                                                                                                                    var11_16 = var13_18;
                                                                                                                                    continue;
                                                                                                                                }
                                                                                                                                if (var3_4 < 48 || var3_4 > 57) break;
                                                                                                                            }
                                                                                                                            if (var11_16 == -1) {
                                                                                                                                return false;
                                                                                                                            }
                                                                                                                            var13_18 = this.bp + 6;
                                                                                                                            var16_20 = Long.parseLong(this.subString(var13_18, this.bp + var11_16 - var13_18));
                                                                                                                            this.calendar = Calendar.getInstance(this.timeZone, this.locale);
                                                                                                                            this.calendar.setTimeInMillis(var16_20);
                                                                                                                            this.token = 5;
                                                                                                                            return true;
                                                                                                                        }
                                                                                                                    }
                                                                                                                    if (var2_3 == 8 || var2_3 == 14) break block64;
                                                                                                                    if (var2_3 != 16) break block65;
                                                                                                                    v12 = this;
                                                                                                                    var11_16 = v12.charAt(v12.bp + 10);
                                                                                                                    if (var11_16 == 84 || var11_16 == 32) break block64;
                                                                                                                }
                                                                                                                if (var2_3 != 17) break block66;
                                                                                                                v13 = this;
                                                                                                                if (v13.charAt(v13.bp + 6) == '-') break block66;
                                                                                                            }
                                                                                                            if (var1_1 != 0) {
                                                                                                                return false;
                                                                                                            }
                                                                                                            v14 = this;
                                                                                                            var18_23 = v14.charAt(v14.bp + 8);
                                                                                                            var19_25 = var7_9 == 45 && var10_15 == 45;
                                                                                                            var20_27 = var19_25 != false && var2_3 == 16;
                                                                                                            var12_17 = var19_25 != false && var2_3 == 17 ? 1 : 0;
                                                                                                            if (var12_17 != 0 || var20_27) {
                                                                                                                var16_21 = var8_12;
                                                                                                                var17_29 = var9_13;
                                                                                                                var14_31 = var18_23;
                                                                                                                v15 = this;
                                                                                                                var15_33 = v15.charAt(v15.bp + 9);
                                                                                                            } else if (var7_9 == 45 && var9_13 == 45) {
                                                                                                                var16_21 = 48;
                                                                                                                var17_29 = var8_12;
                                                                                                                var14_31 = 48;
                                                                                                                var15_33 = var10_15;
                                                                                                            } else {
                                                                                                                var16_21 = var7_9;
                                                                                                                var17_29 = var8_12;
                                                                                                                var14_31 = var9_13;
                                                                                                                var15_33 = var10_15;
                                                                                                            }
                                                                                                            if (!JSONScanner.checkDate(var3_4, var4_6, var5_7, (char)var6_8, var16_21, var17_29, var14_31, var15_33)) {
                                                                                                                return false;
                                                                                                            }
                                                                                                            this.setCalendar(var3_4, var4_6, var5_7, (char)var6_8, var16_21, var17_29, var14_31, var15_33);
                                                                                                            if (var2_3 == 8) break block67;
                                                                                                            v16 = this;
                                                                                                            var6_8 = v16.charAt(v16.bp + 9);
                                                                                                            v17 = this;
                                                                                                            var11_16 = v17.charAt(v17.bp + 10);
                                                                                                            v18 = this;
                                                                                                            var7_9 = v18.charAt(v18.bp + 11);
                                                                                                            v19 = this;
                                                                                                            var1_1 = v19.charAt(v19.bp + 12);
                                                                                                            v20 = this;
                                                                                                            var3_4 = v20.charAt(v20.bp + 13);
                                                                                                            if (var12_17 == 0 || var11_16 != 84 || var3_4 != 58) break block68;
                                                                                                            v21 = this;
                                                                                                            if (v21.charAt(v21.bp + 16) == 'Z') ** GOTO lbl-1000
                                                                                                        }
                                                                                                        if (var20_27 && (var11_16 == 32 || var11_16 == 84) && var3_4 == 58) lbl-1000:
                                                                                                        // 2 sources

                                                                                                        {
                                                                                                            var4_6 = var7_9;
                                                                                                            var6_8 = var1_1;
                                                                                                            v22 = this;
                                                                                                            var8_12 = v22.charAt(v22.bp + 14);
                                                                                                            v23 = this;
                                                                                                            var7_9 = v23.charAt(v23.bp + 15);
                                                                                                            var9_13 = 48;
                                                                                                            var10_15 = 48;
                                                                                                        } else {
                                                                                                            var4_6 = var18_23;
                                                                                                            var8_12 = var11_16;
                                                                                                            var9_13 = (int)var1_1;
                                                                                                            var10_15 = var3_4;
                                                                                                        }
                                                                                                        if (!this.checkTime(var4_6, (char)var6_8, var8_12, var7_9, var9_13, var10_15)) {
                                                                                                            return false;
                                                                                                        }
                                                                                                        if (var2_3 == 17 && var12_17 == 0) {
                                                                                                            v24 = this;
                                                                                                            var1_1 = v24.charAt(v24.bp + 14);
                                                                                                            v25 = this;
                                                                                                            var2_3 = v25.charAt(v25.bp + 15);
                                                                                                            v26 = this;
                                                                                                            var3_4 = v26.charAt(v26.bp + 16);
                                                                                                            if (var1_1 < 48 || var1_1 > 57) {
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (var2_3 < 48 || var2_3 > 57) {
                                                                                                                return false;
                                                                                                            }
                                                                                                            if (var3_4 < 48 || var3_4 > 57) {
                                                                                                                return false;
                                                                                                            }
                                                                                                            var5_7 = (var1_1 - 48) * 100 + (var2_3 - 48) * 10 + (var3_4 - 48);
                                                                                                        } else {
                                                                                                            var5_7 = 0;
                                                                                                        }
                                                                                                        var1_1 = (var4_6 - 48) * 10 + (var6_8 - 48);
                                                                                                        var3_4 = (var8_12 - 48) * 10 + (var7_9 - 48);
                                                                                                        var4_6 = (var9_13 - 48) * 10 + (var10_15 - 48);
                                                                                                        break block69;
                                                                                                    }
                                                                                                    var1_1 = 0;
                                                                                                    var3_4 = 0;
                                                                                                    var4_6 = 0;
                                                                                                    var5_7 = 0;
                                                                                                }
                                                                                                this.calendar.set(11, var1_1);
                                                                                                this.calendar.set(12, var3_4);
                                                                                                this.calendar.set(13, var4_6);
                                                                                                this.calendar.set(14, var5_7);
                                                                                                this.token = 5;
                                                                                                return true;
                                                                                            }
                                                                                            if (var2_3 < 9) {
                                                                                                return false;
                                                                                            }
                                                                                            v27 = this;
                                                                                            var12_17 = v27.charAt(v27.bp + 8);
                                                                                            v28 = this;
                                                                                            var11_16 = v28.charAt(v28.bp + 9);
                                                                                            var13_19 = 10;
                                                                                            if ((var7_9 != 45 || var10_15 != 45) && (var7_9 != 47 || var10_15 != 47)) break block70;
                                                                                            var16_22 = var4_6;
                                                                                            var17_30 = var5_7;
                                                                                            var14_32 = var6_8;
                                                                                            var15_34 = var8_12;
                                                                                            var18_24 = var9_13;
                                                                                            if (var11_16 == 32) {
                                                                                                var19_26 = 48;
                                                                                                var20_28 = var12_17;
                                                                                                var13_19 = 9;
                                                                                            } else {
                                                                                                var19_26 = var12_17;
                                                                                                var20_28 = var11_16;
                                                                                            }
                                                                                            break block71;
                                                                                        }
                                                                                        if (var7_9 != 45 || var9_13 != 45) break block72;
                                                                                        var16_22 = var4_6;
                                                                                        var17_30 = var5_7;
                                                                                        var14_32 = var6_8;
                                                                                        var15_34 = 48;
                                                                                        var18_24 = var8_12;
                                                                                        if (var12_17 == 32) {
                                                                                            var19_26 = 48;
                                                                                            var20_28 = var10_15;
                                                                                            var13_19 = 8;
                                                                                        } else {
                                                                                            var19_26 = var10_15;
                                                                                            var20_28 = var12_17;
                                                                                            var13_19 = 9;
                                                                                        }
                                                                                        break block71;
                                                                                    }
                                                                                    if ((var5_7 != 46 || var8_12 != 46) && (var5_7 != 45 || var8_12 != 45)) break block73;
                                                                                    var19_26 = var3_4;
                                                                                    var20_28 = var4_6;
                                                                                    var15_34 = (int)var6_8;
                                                                                    var18_24 = var7_9;
                                                                                    var3_4 = var9_13;
                                                                                    var16_22 = var10_15;
                                                                                    var17_30 = var12_17;
                                                                                    var14_32 = var11_16;
                                                                                    break block71;
                                                                                }
                                                                                if (var12_17 != 84) break block74;
                                                                                var16_22 = var4_6;
                                                                                var17_30 = var5_7;
                                                                                var14_32 = var6_8;
                                                                                var15_34 = var7_9;
                                                                                var18_24 = var8_12;
                                                                                var19_26 = var9_13;
                                                                                var20_28 = var10_15;
                                                                                var13_19 = 8;
                                                                                break block71;
                                                                            }
                                                                            if (var7_9 != 24180 && var7_9 != 45380) ** GOTO lbl241
                                                                            var16_22 = var4_6;
                                                                            var17_30 = var5_7;
                                                                            var14_32 = var6_8;
                                                                            if (var10_15 != 26376 && var10_15 != 50900) break block75;
                                                                            var15_34 = var8_12;
                                                                            var18_24 = var9_13;
                                                                            if (var11_16 != 26085 && var11_16 != 51068) break block76;
                                                                            var19_26 = 48;
                                                                            var20_28 = var12_17;
                                                                            break block71;
                                                                        }
                                                                        v29 = this;
                                                                        if (v29.charAt(v29.bp + 10) == '\u65e5') break block77;
                                                                        v30 = this;
                                                                        if (v30.charAt(v30.bp + 10) != '\uc77c') break block78;
                                                                    }
                                                                    var19_26 = var12_17;
                                                                    var20_28 = var11_16;
                                                                    var13_19 = 11;
                                                                    break block71;
                                                                }
                                                                return false;
                                                            }
                                                            if (var9_13 != 26376 && var9_13 != 50900) ** GOTO lbl240
                                                            var15_34 = 48;
                                                            var18_24 = var8_12;
                                                            if (var12_17 == 26085 || var12_17 == 51068) {
                                                                var19_26 = 48;
                                                                var20_28 = var10_15;
                                                            } else if (var11_16 == 26085 || var11_16 == 51068) {
                                                                var19_26 = var10_15;
                                                                var20_28 = var12_17;
                                                            } else {
                                                                return false;
lbl240:
                                                                // 1 sources

                                                                return false;
lbl241:
                                                                // 1 sources

                                                                return false;
                                                            }
                                                        }
                                                        if (!JSONScanner.checkDate(var3_4, var16_22, var17_30, var14_32, var15_34, var18_24, var19_26, var20_28)) {
                                                            return false;
                                                        }
                                                        this.setCalendar(var3_4, var16_22, var17_30, var14_32, var15_34, var18_24, (char)var19_26, var20_28);
                                                        v31 = this;
                                                        var12_17 = v31.charAt(v31.bp + var13_19);
                                                        if (var12_17 == 84 && var2_3 == 16 && var13_19 == 8) {
                                                            v32 = this;
                                                            if (v32.charAt(v32.bp + 15) == 'Z') {
                                                                v33 = this;
                                                                var1_1 = v33.charAt(v33.bp + var13_19 + 1);
                                                                v34 = this;
                                                                var3_4 = v34.charAt(v34.bp + var13_19 + 2);
                                                                v35 = this;
                                                                var4_6 = v35.charAt(v35.bp + var13_19 + 3);
                                                                v36 = this;
                                                                var5_7 = v36.charAt(v36.bp + var13_19 + 4);
                                                                v37 = this;
                                                                var6_8 = v37.charAt(v37.bp + var13_19 + 5);
                                                                v38 = this;
                                                                var7_9 = v38.charAt(v38.bp + var13_19 + 6);
                                                                if (!this.checkTime((char)var1_1, var3_4, var4_6, var5_7, (char)var6_8, var7_9)) {
                                                                    return false;
                                                                }
                                                                this.setTime((char)var1_1, var3_4, var4_6, var5_7, (char)var6_8, var7_9);
                                                                this.calendar.set(14, 0);
                                                                if (this.calendar.getTimeZone().getRawOffset() != 0 && (var1_2 = TimeZone.getAvailableIDs(0)).length > 0) {
                                                                    var3_5 = TimeZone.getTimeZone(var1_2[0]);
                                                                    this.calendar.setTimeZone(var3_5);
                                                                }
                                                                this.token = 5;
                                                                return true;
                                                            }
                                                        }
                                                        if (var12_17 != 84 && (var12_17 != 32 || var1_1 != 0)) break block79;
                                                        if (var2_3 < var13_19 + 9) {
                                                            return false;
                                                        }
                                                        break block80;
                                                    }
                                                    if (var12_17 == 34 || var12_17 == 26 || var12_17 == 26085 || var12_17 == 51068) {
                                                        this.calendar.set(11, 0);
                                                        this.calendar.set(12, 0);
                                                        this.calendar.set(13, 0);
                                                        this.calendar.set(14, 0);
                                                        this.ch = this.charAt(this.bp += var13_19);
                                                        this.token = 5;
                                                        return true;
                                                    }
                                                    if (var12_17 != 43 && var12_17 != 45) break block81;
                                                    if (this.len != var13_19 + 6) break block82;
                                                    v39 = this;
                                                    if (v39.charAt(v39.bp + var13_19 + 3) != ':') break block83;
                                                    v40 = this;
                                                    if (v40.charAt(v40.bp + var13_19 + 4) != '0') break block83;
                                                    v41 = this;
                                                    if (v41.charAt(v41.bp + var13_19 + 5) == '0') break block84;
                                                }
                                                return false;
                                            }
                                            this.setTime('0', '0', '0', '0', '0', '0');
                                            this.calendar.set(14, 0);
                                            v42 = this;
                                            v43 = this;
                                            this.setTimeZone(var12_17, v42.charAt(v42.bp + var13_19 + 1), v43.charAt(v43.bp + var13_19 + 2));
                                            return true;
                                        }
                                        return false;
                                    }
                                    return false;
                                }
                                v44 = this;
                                if (v44.charAt(v44.bp + var13_19 + 3) != ':') {
                                    return false;
                                }
                                v45 = this;
                                if (v45.charAt(v45.bp + var13_19 + 6) != ':') {
                                    return false;
                                }
                                v46 = this;
                                var1_1 = v46.charAt(v46.bp + var13_19 + 1);
                                v47 = this;
                                var3_4 = v47.charAt(v47.bp + var13_19 + 2);
                                v48 = this;
                                var4_6 = v48.charAt(v48.bp + var13_19 + 4);
                                v49 = this;
                                var5_7 = v49.charAt(v49.bp + var13_19 + 5);
                                v50 = this;
                                var6_8 = v50.charAt(v50.bp + var13_19 + 7);
                                v51 = this;
                                var7_9 = v51.charAt(v51.bp + var13_19 + 8);
                                if (!this.checkTime((char)var1_1, var3_4, var4_6, var5_7, (char)var6_8, var7_9)) {
                                    return false;
                                }
                                this.setTime((char)var1_1, var3_4, var4_6, var5_7, (char)var6_8, var7_9);
                                v52 = this;
                                var1_1 = v52.charAt(v52.bp + var13_19 + 9);
                                var3_4 = -1;
                                var4_6 = 0;
                                if (var1_1 == 46) {
                                    if (var2_3 < var13_19 + 11) {
                                        return false;
                                    }
                                    v53 = this;
                                    var6_8 = v53.charAt(v53.bp + var13_19 + 10);
                                    if (var6_8 < 48 || var6_8 > 57) {
                                        return false;
                                    }
                                    var4_6 = var6_8 - 48;
                                    var3_4 = 1;
                                    if (var2_3 > var13_19 + 11) {
                                        v54 = this;
                                        v55 = v54.charAt(v54.bp + var13_19 + 11);
                                        var8_12 = v55;
                                        if (v55 >= '0' && var8_12 <= 57) {
                                            var4_6 = var4_6 * 10 + (var8_12 - 48);
                                            var3_4 = 2;
                                        }
                                    }
                                    if (var3_4 == 2) {
                                        v56 = this;
                                        v57 = v56.charAt(v56.bp + var13_19 + 12);
                                        var8_12 = v57;
                                        if (v57 >= '0' && var8_12 <= 57) {
                                            var4_6 = var4_6 * 10 + (var8_12 - 48);
                                            var3_4 = 3;
                                        }
                                    }
                                }
                                this.calendar.set(14, var4_6);
                                var6_8 = 0;
                                v58 = this;
                                v59 = v58.charAt(v58.bp + var13_19 + 10 + var3_4);
                                var8_12 = v59;
                                if (v59 == ' ') {
                                    v60 = this;
                                    var8_12 = v60.charAt(v60.bp + var13_19 + 10 + ++var3_4);
                                }
                                if (var8_12 != 43 && var8_12 != 45) break block85;
                                v61 = this;
                                v62 = v61.charAt(v61.bp + var13_19 + 10 + var3_4 + 1);
                                var7_9 = v62;
                                if (v62 < '0' || var7_9 > 49) {
                                    return false;
                                }
                                v63 = this;
                                v64 = v63.charAt(v63.bp + var13_19 + 10 + var3_4 + 2);
                                var9_13 = v64;
                                if (v64 < '0' || var9_13 > 57) {
                                    return false;
                                }
                                v65 = this;
                                var10_15 = v65.charAt(v65.bp + var13_19 + 10 + var3_4 + 3);
                                var1_1 = 48;
                                var2_3 = 48;
                                if (var10_15 != 58) break block86;
                                v66 = this;
                                var1_1 = v66.charAt(v66.bp + var13_19 + 10 + var3_4 + 4);
                                v67 = this;
                                var2_3 = v67.charAt(v67.bp + var13_19 + 10 + var3_4 + 5);
                                if (var1_1 == 52 && var2_3 == 53) {
                                    if ((var7_9 != 49 || var9_13 != 50 && var9_13 != 51) && (var7_9 != 48 || var9_13 != 53 && var9_13 != 56)) {
                                        return false;
                                    }
                                } else {
                                    if (var1_1 != 48 && var1_1 != 51) {
                                        return false;
                                    }
                                    if (var2_3 != 48) {
                                        return false;
                                    }
                                }
                                var6_8 = 6;
                                break block87;
                            }
                            if (var10_15 != 48) break block88;
                            v68 = this;
                            v69 = v68.charAt(v68.bp + var13_19 + 10 + var3_4 + 4);
                            var1_1 = v69;
                            if (v69 != '0' && var1_1 != 51) {
                                return false;
                            }
                            var6_8 = 5;
                            break block87;
                        }
                        if (var10_15 != 51) break block89;
                        v70 = this;
                        if (v70.charAt(v70.bp + var13_19 + 10 + var3_4 + 4) != '0') break block89;
                        var1_1 = 51;
                        var2_3 = (int)48;
                        var6_8 = 5;
                        break block87;
                    }
                    if (var10_15 != 52) ** GOTO lbl-1000
                    v71 = this;
                    if (v71.charAt(v71.bp + var13_19 + 10 + var3_4 + 4) == '5') {
                        var1_1 = 52;
                        var2_3 = (int)53;
                        var6_8 = 5;
                    } else lbl-1000:
                    // 2 sources

                    {
                        var6_8 = 3;
                    }
                }
                this.setTimeZone(var8_12, var7_9, var9_13, (char)var1_1, var2_3);
                break block90;
            }
            if (var8_12 == 90) {
                var6_8 = 1;
                if (this.calendar.getTimeZone().getRawOffset() != 0 && (var7_10 = TimeZone.getAvailableIDs(0)).length > 0) {
                    var9_14 = TimeZone.getTimeZone(var7_10[0]);
                    this.calendar.setTimeZone(var9_14);
                }
            }
        }
        v72 = this;
        var7_11 = v72.charAt(v72.bp + (var13_19 + 10 + var3_4 + var6_8));
        if (var7_11 != '\u001a' && var7_11 != '\"') {
            return false;
        }
        this.ch = this.charAt(this.bp += var13_19 + 10 + var3_4 + var6_8);
        this.token = 5;
        return true;
    }

    protected final void setTime(char c, char c2, char c3, char c4, char c5, char c6) {
        c = (char)((c - 48) * 10 + (c2 - 48));
        c2 = (char)((c3 - 48) * 10 + (c4 - 48));
        c3 = (char)((c5 - 48) * 10 + (c6 - 48));
        this.calendar.set(11, c);
        this.calendar.set(12, c2);
        this.calendar.set(13, c3);
    }

    protected final void setTimeZone(char c, char c2, char c3) {
        this.setTimeZone(c, c2, c3, '0', '0');
    }

    protected final void setTimeZone(char c, char c2, char c3, char c4, char c5) {
        c2 = (char)(((c2 - 48) * 10 + (c3 - 48)) * 3600 * 1000 + ((c4 - 48) * 10 + (c5 - 48)) * 60 * 1000);
        if (c == '-') {
            c2 = -c2;
        }
        if (this.calendar.getTimeZone().getRawOffset() != c2) {
            char c6 = c2;
            this.calendar.setTimeZone(new SimpleTimeZone(c6, Integer.toString(c6)));
        }
    }

    private boolean checkTime(char c, char c2, char c3, char c4, char c5, char c6) {
        if (c == '0') {
            if (c2 < '0' || c2 > '9') {
                return false;
            }
        } else if (c == '1') {
            if (c2 < '0' || c2 > '9') {
                return false;
            }
        } else if (c == '2') {
            if (c2 < '0' || c2 > '4') {
                return false;
            }
        } else {
            return false;
        }
        if (c3 >= '0' && c3 <= '5') {
            if (c4 < '0' || c4 > '9') {
                return false;
            }
        } else if (c3 == '6') {
            if (c4 != '0') {
                return false;
            }
        } else {
            return false;
        }
        if (c5 >= '0' && c5 <= '5') {
            if (c6 < '0' || c6 > '9') {
                return false;
            }
        } else if (c5 == '6') {
            if (c6 != '0') {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void setCalendar(char c, char c2, char c3, char c4, char c5, char c6, char c7, char c8) {
        this.calendar = Calendar.getInstance(this.timeZone, this.locale);
        c = (char)((c - 48) * 1000 + (c2 - 48) * 100 + (c3 - 48) * 10 + (c4 - 48));
        c2 = (char)((c5 - 48) * 10 + (c6 - 48) - 1);
        c3 = (char)((c7 - 48) * 10 + (c8 - 48));
        this.calendar.set(1, c);
        this.calendar.set(2, c2);
        this.calendar.set(5, c3);
    }

    static boolean checkDate(char c, char c2, char c3, char c4, char c5, char c6, int n, int n2) {
        if (c < '0' || c > '9') {
            return false;
        }
        if (c2 < '0' || c2 > '9') {
            return false;
        }
        if (c3 < '0' || c3 > '9') {
            return false;
        }
        if (c4 < '0' || c4 > '9') {
            return false;
        }
        if (c5 == '0') {
            if (c6 < '1' || c6 > '9') {
                return false;
            }
        } else if (c5 == '1') {
            if (c6 != '0' && c6 != '1' && c6 != '2') {
                return false;
            }
        } else {
            return false;
        }
        if (n == 48) {
            if (n2 < 49 || n2 > 57) {
                return false;
            }
        } else if (n == 49 || n == 50) {
            if (n2 < 48 || n2 > 57) {
                return false;
            }
        } else if (n == 51) {
            if (n2 != 48 && n2 != 49) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public final boolean isEOF() {
        return this.bp == this.len || this.ch == '\u001a' && this.bp + 1 >= this.len;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    @Override
    public final int scanFieldInt(char[] cArray) {
        int n;
        boolean bl;
        char c;
        int n2;
        char c2;
        int n3;
        block21: {
            block22: {
                boolean bl2;
                this.matchStat = 0;
                n3 = this.bp;
                c2 = this.ch;
                if (!JSONScanner.charArrayCompare(this.text, this.bp, cArray)) {
                    this.matchStat = -2;
                    return 0;
                }
                n2 = this.bp + cArray.length;
                if (bl2 = (c = this.charAt(n2++)) == '\"') {
                    c = this.charAt(n2++);
                }
                if (bl = c == '-') {
                    c = this.charAt(n2++);
                }
                if (c >= '0' && c <= '9') {
                    n = c - 48;
                } else {
                    this.matchStat = -1;
                    return 0;
                }
                while ((c = this.charAt(n2++)) >= '0' && c <= '9') {
                    int n4 = n * 10;
                    if (n4 < n) {
                        this.matchStat = -1;
                        return 0;
                    }
                    n = n4 + (c - 48);
                }
                if (c == '.') {
                    this.matchStat = -1;
                    return 0;
                }
                if (n < 0) {
                    this.matchStat = -1;
                    return 0;
                }
                boolean bl3 = true;
                do {
                    block24: {
                        block23: {
                            if (!bl3 || (bl3 = false)) break block23;
                            if (!bl2) break block24;
                            if (c != '\"') {
                                this.matchStat = -1;
                                return 0;
                            }
                        }
                        c = this.charAt(n2++);
                    }
                    if (c != ',' && c != '}') continue;
                    this.bp = n2 - 1;
                    if (c != ',') break block21;
                    break block22;
                } while (JSONScanner.isWhitespace(c));
                this.matchStat = -1;
                return 0;
            }
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            this.token = 16;
            if (bl) {
                return -n;
            }
            return n;
        }
        if (c == '}') {
            this.bp = n2 - 1;
            JSONScanner jSONScanner = this;
            c = jSONScanner.charAt(++jSONScanner.bp);
            while (true) {
                if (c == ',') {
                    this.token = 16;
                    this.ch = this.charAt(++this.bp);
                    break;
                }
                if (c == ']') {
                    this.token = 15;
                    this.ch = this.charAt(++this.bp);
                    break;
                }
                if (c == '}') {
                    this.token = 13;
                    this.ch = this.charAt(++this.bp);
                    break;
                }
                if (c == '\u001a') {
                    this.token = 20;
                    break;
                }
                if (!JSONScanner.isWhitespace(c)) {
                    this.bp = n3;
                    this.ch = c2;
                    this.matchStat = -1;
                    return 0;
                }
                JSONScanner jSONScanner2 = this;
                c = jSONScanner2.charAt(++jSONScanner2.bp);
            }
            this.matchStat = 4;
        }
        if (bl) {
            return -n;
        }
        return n;
    }

    @Override
    public final String scanFieldString(char[] object) {
        String string;
        int n;
        char c;
        char c2;
        int n2;
        block21: {
            this.matchStat = 0;
            n2 = this.bp;
            c2 = this.ch;
            while (!JSONScanner.charArrayCompare(this.text, this.bp, object)) {
                if (JSONScanner.isWhitespace(this.ch)) {
                    this.next();
                    while (JSONScanner.isWhitespace(this.ch)) {
                        this.next();
                    }
                    continue;
                }
                this.matchStat = -2;
                return this.stringDefaultValue();
            }
            int n3 = this.bp + ((char[])object).length;
            int n4 = 0;
            if ((c = this.charAt(n3++)) != '\"') {
                while (JSONScanner.isWhitespace(c)) {
                    ++n4;
                    c = this.charAt(n3++);
                }
                if (c != '\"') {
                    this.matchStat = -1;
                    return this.stringDefaultValue();
                }
            }
            if ((n = this.indexOf('\"', n3)) == -1) {
                throw new JSONException("unclosed str");
            }
            string = this.subString(n3, n - n3);
            if (string.indexOf(92) != -1) {
                int n5;
                while (true) {
                    n5 = 0;
                    for (c = n - 1; c >= '\u0000' && this.charAt(c) == '\\'; --c) {
                        ++n5;
                    }
                    if (n5 % 2 == 0) break;
                    n = this.indexOf('\"', n + 1);
                }
                n5 = n - (this.bp + ((char[])object).length + 1 + n4);
                JSONScanner jSONScanner = this;
                string = JSONScanner.readString(jSONScanner.sub_chars(jSONScanner.bp + ((char[])object).length + 1 + n4, n5), n5);
            }
            if ((this.features & Feature.TrimStringFieldValue.mask) != 0) {
                string = string.trim();
            }
            while (true) {
                char c3 = this.charAt(n + 1);
                c = c3;
                if (c3 == ',' || c == '}') break block21;
                if (!JSONScanner.isWhitespace(c)) break;
                ++n;
            }
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        this.bp = n + 1;
        this.ch = c;
        object = string;
        if (c == ',') {
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            return object;
        }
        JSONScanner jSONScanner = this;
        if ((c = jSONScanner.charAt(++jSONScanner.bp)) == ',') {
            this.token = 16;
            this.ch = this.charAt(++this.bp);
        } else if (c == ']') {
            this.token = 15;
            this.ch = this.charAt(++this.bp);
        } else if (c == '}') {
            this.token = 13;
            this.ch = this.charAt(++this.bp);
        } else if (c == '\u001a') {
            this.token = 20;
        } else {
            this.bp = n2;
            this.ch = c2;
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        this.matchStat = 4;
        return object;
    }

    @Override
    public final Date scanFieldDate(char[] cArray) {
        Date date;
        char c;
        char c2;
        int n;
        block23: {
            this.matchStat = 0;
            n = this.bp;
            c2 = this.ch;
            if (!JSONScanner.charArrayCompare(this.text, this.bp, cArray)) {
                this.matchStat = -2;
                return null;
            }
            int n2 = this.bp + cArray.length;
            if ((c = this.charAt(n2++)) == '\"') {
                int n3 = this.indexOf('\"', n2);
                if (n3 == -1) {
                    throw new JSONException("unclosed str");
                }
                int n4 = n3 - n2;
                this.bp = n2;
                if (!this.scanISO8601DateIfMatch(false, n4)) {
                    this.bp = n;
                    this.matchStat = -1;
                    return null;
                }
                date = this.calendar.getTime();
                c = this.charAt(n3 + 1);
                this.bp = n;
                while (true) {
                    if (c == ',' || c == '}') {
                        this.bp = n3 + 1;
                        this.ch = c;
                        break block23;
                    }
                    if (!JSONScanner.isWhitespace(c)) break;
                    c = this.charAt(++n3 + 1);
                }
                this.matchStat = -1;
                return null;
            }
            if (c == '-' || c >= '0' && c <= '9') {
                long l = 0L;
                boolean bl = false;
                if (c == '-') {
                    c = this.charAt(n2++);
                    bl = true;
                }
                if (c >= '0' && c <= '9') {
                    l = c - 48;
                    while ((c = this.charAt(n2++)) >= '0' && c <= '9') {
                        l = l * 10L + (long)(c - 48);
                    }
                    if (c == ',' || c == '}') {
                        this.bp = n2 - 1;
                    }
                }
                if (l < 0L) {
                    this.matchStat = -1;
                    return null;
                }
                if (bl) {
                    l = -l;
                }
                date = new Date(l);
            } else {
                this.matchStat = -1;
                return null;
            }
        }
        if (c == ',') {
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            this.token = 16;
            return date;
        }
        JSONScanner jSONScanner = this;
        if ((c = jSONScanner.charAt(++jSONScanner.bp)) == ',') {
            this.token = 16;
            this.ch = this.charAt(++this.bp);
        } else if (c == ']') {
            this.token = 15;
            this.ch = this.charAt(++this.bp);
        } else if (c == '}') {
            this.token = 13;
            this.ch = this.charAt(++this.bp);
        } else if (c == '\u001a') {
            this.token = 20;
        } else {
            this.bp = n;
            this.ch = c2;
            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return date;
    }

    @Override
    public final long scanFieldSymbol(char[] cArray) {
        long l;
        block15: {
            char c;
            this.matchStat = 0;
            while (!JSONScanner.charArrayCompare(this.text, this.bp, cArray)) {
                if (JSONScanner.isWhitespace(this.ch)) {
                    this.next();
                    while (JSONScanner.isWhitespace(this.ch)) {
                        this.next();
                    }
                    continue;
                }
                this.matchStat = -2;
                return 0L;
            }
            int n = this.bp + cArray.length;
            if ((c = this.charAt(n++)) != '\"') {
                while (JSONScanner.isWhitespace(c)) {
                    c = this.charAt(n++);
                }
                if (c != '\"') {
                    this.matchStat = -1;
                    return 0L;
                }
            }
            l = -3750763034362895579L;
            while (true) {
                if ((c = this.charAt(n++)) == '\"') break;
                if (n > this.len) {
                    this.matchStat = -1;
                    return 0L;
                }
                l = (l ^ (long)c) * 1099511628211L;
            }
            this.bp = n;
            this.ch = c = this.charAt(this.bp);
            while (true) {
                if (c == ',') {
                    this.ch = this.charAt(++this.bp);
                    this.matchStat = 3;
                    return l;
                }
                if (c == '}') {
                    this.next();
                    this.skipWhitespace();
                    c = this.getCurrent();
                    if (c == ',') {
                        this.token = 16;
                        this.ch = this.charAt(++this.bp);
                        break block15;
                    }
                    if (c == ']') {
                        this.token = 15;
                        this.ch = this.charAt(++this.bp);
                        break block15;
                    }
                    if (c == '}') {
                        this.token = 13;
                        this.ch = this.charAt(++this.bp);
                        break block15;
                    }
                    if (c == '\u001a') {
                        this.token = 20;
                        break block15;
                    }
                    this.matchStat = -1;
                    return 0L;
                }
                if (!JSONScanner.isWhitespace(c)) break;
                JSONScanner jSONScanner = this;
                c = jSONScanner.charAt(++jSONScanner.bp);
            }
            this.matchStat = -1;
            return 0L;
        }
        this.matchStat = 4;
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final Collection<String> scanFieldStringArray(char[] cArray, Class<?> clazz) {
        Collection<String> collection;
        block22: {
            int n;
            int n2;
            int n3;
            char c;
            int n4;
            block21: {
                block23: {
                    this.matchStat = 0;
                    while (this.ch == '\n' || this.ch == ' ') {
                        int n5;
                        this.ch = (char)((n5 = ++this.bp) >= this.len ? 26 : (int)this.text.charAt(n5));
                    }
                    if (!JSONScanner.charArrayCompare(this.text, this.bp, cArray)) {
                        this.matchStat = -2;
                        return null;
                    }
                    collection = this.newCollectionByType(clazz);
                    n4 = this.bp;
                    c = this.ch;
                    n3 = this.bp + cArray.length;
                    if (this.charAt(n3++) == '[') break block23;
                    if (!this.text.startsWith("ull", n3)) {
                        this.matchStat = -1;
                        return null;
                    }
                    n3 += 3;
                    n2 = this.charAt(n3++);
                    collection = null;
                    break block21;
                }
                n2 = this.charAt(n3++);
                while (true) {
                    block27: {
                        String string;
                        block25: {
                            block26: {
                                block24: {
                                    if (n2 != 34) break block24;
                                    n = n3;
                                    if ((n3 = this.indexOf('\"', n)) == -1) {
                                        throw new JSONException("unclosed str");
                                    }
                                    string = this.subString(n, n3 - n);
                                    if (string.indexOf(92) == -1) break block25;
                                    break block26;
                                }
                                if (n2 == 110 && this.text.startsWith("ull", n3)) {
                                    n3 += 3;
                                    n2 = this.charAt(n3++);
                                    collection.add(null);
                                    break block27;
                                } else if (n2 == 93 && collection.size() == 0) {
                                    n2 = this.charAt(n3++);
                                    break block21;
                                } else {
                                    this.matchStat = -1;
                                    return null;
                                }
                            }
                            while (true) {
                                n2 = 0;
                                for (int i = n3 - 1; i >= 0 && this.charAt(i) == '\\'; ++n2, --i) {
                                }
                                if (n2 % 2 == 0) break;
                                n3 = this.indexOf('\"', n3 + 1);
                            }
                            n2 = n3 - n;
                            string = JSONScanner.readString(this.sub_chars(n, n2), n2);
                        }
                        int n6 = ++n3;
                        ++n3;
                        n2 = this.charAt(n6);
                        collection.add(string);
                    }
                    if (n2 != 44) break;
                    n2 = this.charAt(n3++);
                }
                if (n2 != 93) {
                    this.matchStat = -1;
                    return null;
                }
                n2 = this.charAt(n3++);
                while (JSONScanner.isWhitespace((char)n2)) {
                    n2 = this.charAt(n3++);
                }
            }
            this.bp = n3;
            if (n2 == 44) {
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                return collection;
            }
            if (n2 != 125) {
                this.ch = c;
                this.bp = n4;
                this.matchStat = -1;
                return null;
            }
            JSONScanner jSONScanner = this;
            n2 = jSONScanner.charAt(jSONScanner.bp);
            do {
                if (n2 == 44) {
                    this.token = 16;
                    this.ch = this.charAt(++this.bp);
                    break block22;
                }
                if (n2 == 93) {
                    this.token = 15;
                    this.ch = this.charAt(++this.bp);
                    break block22;
                }
                if (n2 == 125) {
                    this.token = 13;
                    this.ch = this.charAt(++this.bp);
                    break block22;
                }
                if (n2 == 26) {
                    this.token = 20;
                    this.ch = (char)n2;
                    break block22;
                }
                n = 0;
                while (JSONScanner.isWhitespace((char)n2)) {
                    n2 = this.charAt(n3++);
                    this.bp = n3;
                    n = 1;
                }
            } while (n != 0);
            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return collection;
    }

    @Override
    public final long scanFieldLong(char[] cArray) {
        long l;
        boolean bl;
        block21: {
            char c;
            boolean bl2;
            this.matchStat = 0;
            int n = this.bp;
            char c2 = this.ch;
            if (!JSONScanner.charArrayCompare(this.text, this.bp, cArray)) {
                this.matchStat = -2;
                return 0L;
            }
            int n2 = this.bp + cArray.length;
            if (bl2 = (c = this.charAt(n2++)) == '\"') {
                c = this.charAt(n2++);
            }
            bl = false;
            if (c == '-') {
                c = this.charAt(n2++);
                bl = true;
            }
            if (c >= '0' && c <= '9') {
                l = c - 48;
                while ((c = this.charAt(n2++)) >= '0' && c <= '9') {
                    l = l * 10L + (long)(c - 48);
                }
                if (c == '.') {
                    this.matchStat = -1;
                    return 0L;
                }
                if (bl2) {
                    if (c != '\"') {
                        this.matchStat = -1;
                        return 0L;
                    }
                    c = this.charAt(n2++);
                }
                if (c == ',' || c == '}') {
                    this.bp = n2 - 1;
                }
                if (!(l >= 0L || l == Long.MIN_VALUE && bl)) {
                    this.bp = n;
                    this.ch = c2;
                    this.matchStat = -1;
                    return 0L;
                }
            } else {
                this.bp = n;
                this.ch = c2;
                this.matchStat = -1;
                return 0L;
            }
            while (true) {
                if (c == ',') {
                    this.ch = this.charAt(++this.bp);
                    this.matchStat = 3;
                    this.token = 16;
                    if (bl) {
                        return -l;
                    }
                    return l;
                }
                if (c == '}') {
                    JSONScanner jSONScanner = this;
                    c = jSONScanner.charAt(++jSONScanner.bp);
                    while (true) {
                        if (c == ',') {
                            this.token = 16;
                            this.ch = this.charAt(++this.bp);
                            break block21;
                        }
                        if (c == ']') {
                            this.token = 15;
                            this.ch = this.charAt(++this.bp);
                            break block21;
                        }
                        if (c == '}') {
                            this.token = 13;
                            this.ch = this.charAt(++this.bp);
                            break block21;
                        }
                        if (c == '\u001a') {
                            this.token = 20;
                            break block21;
                        }
                        if (!JSONScanner.isWhitespace(c)) break;
                        JSONScanner jSONScanner2 = this;
                        c = jSONScanner2.charAt(++jSONScanner2.bp);
                    }
                    this.bp = n;
                    this.ch = c2;
                    this.matchStat = -1;
                    return 0L;
                }
                if (!JSONScanner.isWhitespace(c)) break;
                this.bp = n2;
                c = this.charAt(n2++);
            }
            this.matchStat = -1;
            return 0L;
        }
        this.matchStat = 4;
        if (bl) {
            return -l;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean scanFieldBoolean(char[] cArray) {
        void var1_20;
        block33: {
            void var1_4;
            void var1_3;
            this.matchStat = 0;
            if (!JSONScanner.charArrayCompare(this.text, this.bp, cArray)) {
                this.matchStat = -2;
                return false;
            }
            int n = this.bp;
            int bl = this.bp + cArray.length;
            ++var1_3;
            char c = this.charAt(bl);
            boolean bl2 = c == '\"';
            if (bl2) {
                ++var1_4;
                c = this.charAt((int)var1_3);
            }
            if (c == 't') {
                void var1_8;
                void var1_7;
                void var1_6;
                void var1_5;
                ++var1_5;
                if (this.charAt((int)var1_4) != 'r') {
                    this.matchStat = -1;
                    return false;
                }
                ++var1_6;
                if (this.charAt((int)var1_5) != 'u') {
                    this.matchStat = -1;
                    return false;
                }
                ++var1_7;
                if (this.charAt((int)var1_6) != 'e') {
                    this.matchStat = -1;
                    return false;
                }
                if (bl2) {
                    ++var1_8;
                    if (this.charAt((int)var1_7) != '\"') {
                        this.matchStat = -1;
                        return false;
                    }
                }
                this.bp = var1_8;
                JSONScanner jSONScanner = this;
                c = jSONScanner.charAt(jSONScanner.bp);
                boolean bl3 = true;
            } else if (c == 'f') {
                void var1_14;
                void var1_13;
                void var1_12;
                void var1_11;
                void var1_10;
                ++var1_10;
                if (this.charAt((int)var1_4) != 'a') {
                    this.matchStat = -1;
                    return false;
                }
                ++var1_11;
                if (this.charAt((int)var1_10) != 'l') {
                    this.matchStat = -1;
                    return false;
                }
                ++var1_12;
                if (this.charAt((int)var1_11) != 's') {
                    this.matchStat = -1;
                    return false;
                }
                ++var1_13;
                if (this.charAt((int)var1_12) != 'e') {
                    this.matchStat = -1;
                    return false;
                }
                if (bl2) {
                    ++var1_14;
                    if (this.charAt((int)var1_13) != '\"') {
                        this.matchStat = -1;
                        return false;
                    }
                }
                this.bp = var1_14;
                JSONScanner jSONScanner = this;
                c = jSONScanner.charAt(jSONScanner.bp);
                boolean bl4 = false;
            } else if (c == '1') {
                void var1_16;
                if (bl2) {
                    ++var1_16;
                    if (this.charAt((int)var1_4) != '\"') {
                        this.matchStat = -1;
                        return false;
                    }
                }
                this.bp = var1_16;
                JSONScanner jSONScanner = this;
                c = jSONScanner.charAt(jSONScanner.bp);
                boolean bl5 = true;
            } else if (c == '0') {
                void var1_18;
                if (bl2) {
                    ++var1_18;
                    if (this.charAt((int)var1_4) != '\"') {
                        this.matchStat = -1;
                        return false;
                    }
                }
                this.bp = var1_18;
                JSONScanner jSONScanner = this;
                c = jSONScanner.charAt(jSONScanner.bp);
                boolean bl6 = false;
            } else {
                this.matchStat = -1;
                return false;
            }
            while (true) {
                if (c == ',') {
                    this.ch = this.charAt(++this.bp);
                    this.matchStat = 3;
                    this.token = 16;
                    break block33;
                }
                if (c == '}') {
                    block34: {
                        JSONScanner jSONScanner = this;
                        c = jSONScanner.charAt(++jSONScanner.bp);
                        while (true) {
                            if (c == ',') {
                                this.token = 16;
                                this.ch = this.charAt(++this.bp);
                                break block34;
                            }
                            if (c == ']') {
                                this.token = 15;
                                this.ch = this.charAt(++this.bp);
                                break block34;
                            }
                            if (c == '}') {
                                this.token = 13;
                                this.ch = this.charAt(++this.bp);
                                break block34;
                            }
                            if (c == '\u001a') {
                                this.token = 20;
                                break block34;
                            }
                            if (!JSONScanner.isWhitespace(c)) break;
                            JSONScanner jSONScanner2 = this;
                            c = jSONScanner2.charAt(++jSONScanner2.bp);
                        }
                        this.matchStat = -1;
                        return false;
                    }
                    this.matchStat = 4;
                    break block33;
                }
                if (!JSONScanner.isWhitespace(c)) break;
                JSONScanner jSONScanner = this;
                c = jSONScanner.charAt(++jSONScanner.bp);
            }
            this.bp = n;
            JSONScanner jSONScanner = this;
            jSONScanner.charAt(jSONScanner.bp);
            this.matchStat = -1;
            return false;
        }
        return (boolean)var1_20;
    }

    @Override
    public final int scanInt(char c) {
        int n;
        boolean bl;
        this.matchStat = 0;
        int n2 = this.bp;
        int n3 = this.bp;
        char c2 = this.charAt(n3++);
        while (JSONScanner.isWhitespace(c2)) {
            c2 = this.charAt(n3++);
        }
        boolean bl2 = c2 == '\"';
        if (bl2) {
            c2 = this.charAt(n3++);
        }
        if (bl = c2 == '-') {
            c2 = this.charAt(n3++);
        }
        if (c2 >= '0' && c2 <= '9') {
            n = c2 - 48;
            while ((c2 = this.charAt(n3++)) >= '0' && c2 <= '9') {
                int n4 = n * 10;
                if (n4 < n) {
                    throw new JSONException("parseInt error : " + this.subString(n2, n3 - 1));
                }
                n = n4 + (c2 - 48);
            }
            if (c2 == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (bl2) {
                if (c2 != '\"') {
                    this.matchStat = -1;
                    return 0;
                }
                c2 = this.charAt(n3++);
            }
            if (n < 0) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            if (c2 == 'n' && this.charAt(n3++) == 'u' && this.charAt(n3++) == 'l' && this.charAt(n3++) == 'l') {
                this.matchStat = 5;
                c2 = this.charAt(n3++);
                if (bl2 && c2 == '\"') {
                    c2 = this.charAt(n3++);
                }
                while (true) {
                    if (c2 == ',') {
                        this.bp = n3;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 16;
                        return 0;
                    }
                    if (c2 == ']') {
                        this.bp = n3;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 15;
                        return 0;
                    }
                    if (!JSONScanner.isWhitespace(c2)) break;
                    c2 = this.charAt(n3++);
                }
                this.matchStat = -1;
                return 0;
            }
            this.matchStat = -1;
            return 0;
        }
        while (true) {
            if (c2 == c) {
                this.bp = n3;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                if (bl) {
                    return -n;
                }
                return n;
            }
            if (!JSONScanner.isWhitespace(c2)) break;
            c2 = this.charAt(n3++);
        }
        this.matchStat = -1;
        if (bl) {
            return -n;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final double scanDouble(char var1_1) {
        block22: {
            block20: {
                block21: {
                    this.matchStat = 0;
                    var2_2 = this.bp;
                    if ((var4_4 = (var3_3 = this.charAt(var2_2++)) == '\"' ? 1 : 0) != 0) {
                        var3_3 = this.charAt(var2_2++);
                    }
                    if (var5_5 = var3_3 == '-') {
                        var3_3 = this.charAt(var2_2++);
                    }
                    if (var3_3 < '0' || var3_3 > '9') break block20;
                    var8_6 = var3_3 - 48;
                    while ((var3_3 = this.charAt(var2_2++)) >= '0' && var3_3 <= '9') {
                        var8_6 = var8_6 * 10L + (long)(var3_3 - 48);
                    }
                    var10_7 = 1L;
                    if (var3_3 == '.') {
                        if ((var3_3 = this.charAt(var2_2++)) >= '0' && var3_3 <= '9') {
                            var8_6 = var8_6 * 10L + (long)(var3_3 - 48);
                            var10_7 = 10L;
                            while ((var3_3 = this.charAt(var2_2++)) >= '0' && var3_3 <= '9') {
                                var8_6 = var8_6 * 10L + (long)(var3_3 - 48);
                                var10_7 *= 10L;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                    if (!(var6_8 = var3_3 == 'e' || var3_3 == 'E')) break block21;
                    if ((var3_3 = this.charAt(var2_2++)) != '+' && var3_3 != '-') ** GOTO lbl28
                    do {
                        var3_3 = this.charAt(var2_2++);
lbl28:
                        // 2 sources

                    } while (var3_3 >= '0' && var3_3 <= '9');
                }
                if (var4_4 != 0) {
                    if (var3_3 != '\"') {
                        this.matchStat = -1;
                        return 0.0;
                    }
                    var3_3 = this.charAt(var2_2++);
                    var4_4 = this.bp + 1;
                    var7_10 = var2_2 - var4_4 - 2;
                } else {
                    var4_4 = this.bp;
                    var7_10 = var2_2 - var4_4 - 1;
                }
                if (!var6_8 && var7_10 < 18) {
                    var6_9 = (double)var8_6 / (double)var10_7;
                    if (var5_5) {
                        var6_9 = -var6_9;
                    }
                } else {
                    var6_9 = Double.parseDouble(this.subString(var4_4, var7_10));
                }
                break block22;
            }
            if (var3_3 == 'n' && this.charAt(var2_2++) == 'u' && this.charAt(var2_2++) == 'l' && this.charAt(var2_2++) == 'l') {
                this.matchStat = 5;
                var3_3 = this.charAt(var2_2++);
                if (var4_4 != 0 && var3_3 == '\"') {
                    var3_3 = this.charAt(var2_2++);
                }
                while (true) {
                    if (var3_3 == ',') {
                        this.bp = var2_2;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 16;
                        return 0.0;
                    }
                    if (var3_3 == ']') {
                        this.bp = var2_2;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 15;
                        return 0.0;
                    }
                    if (!JSONScanner.isWhitespace(var3_3)) break;
                    var3_3 = this.charAt(var2_2++);
                }
                this.matchStat = -1;
                return 0.0;
            }
            this.matchStat = -1;
            return 0.0;
        }
        if (var3_3 == var1_1) {
            this.bp = var2_2;
            this.ch = this.charAt(this.bp);
            this.matchStat = 3;
            this.token = 16;
            return var6_9;
        }
        this.matchStat = -1;
        return var6_9;
    }

    @Override
    public final long scanLong(char c) {
        long l;
        boolean bl;
        char c2;
        boolean bl2;
        this.matchStat = 0;
        int n = this.bp;
        if (bl2 = (c2 = this.charAt(n++)) == '\"') {
            c2 = this.charAt(n++);
        }
        if (bl = c2 == '-') {
            c2 = this.charAt(n++);
        }
        if (c2 >= '0' && c2 <= '9') {
            l = c2 - 48;
            while ((c2 = this.charAt(n++)) >= '0' && c2 <= '9') {
                l = l * 10L + (long)(c2 - 48);
            }
            if (c2 == '.') {
                this.matchStat = -1;
                return 0L;
            }
            if (bl2) {
                if (c2 != '\"') {
                    this.matchStat = -1;
                    return 0L;
                }
                c2 = this.charAt(n++);
            }
            if (!(l >= 0L || l == Long.MIN_VALUE && bl)) {
                this.matchStat = -1;
                return 0L;
            }
        } else {
            if (c2 == 'n' && this.charAt(n++) == 'u' && this.charAt(n++) == 'l' && this.charAt(n++) == 'l') {
                this.matchStat = 5;
                c2 = this.charAt(n++);
                if (bl2 && c2 == '\"') {
                    c2 = this.charAt(n++);
                }
                while (true) {
                    if (c2 == ',') {
                        this.bp = n;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 16;
                        return 0L;
                    }
                    if (c2 == ']') {
                        this.bp = n;
                        this.ch = this.charAt(this.bp);
                        this.matchStat = 5;
                        this.token = 15;
                        return 0L;
                    }
                    if (!JSONScanner.isWhitespace(c2)) break;
                    c2 = this.charAt(n++);
                }
                this.matchStat = -1;
                return 0L;
            }
            this.matchStat = -1;
            return 0L;
        }
        while (true) {
            if (c2 == c) {
                this.bp = n;
                this.ch = this.charAt(this.bp);
                this.matchStat = 3;
                this.token = 16;
                if (bl) {
                    return -l;
                }
                return l;
            }
            if (!JSONScanner.isWhitespace(c2)) break;
            c2 = this.charAt(n++);
        }
        this.matchStat = -1;
        return l;
    }

    @Override
    public final Date scanDate(char c) {
        Date date;
        char c2;
        char c3;
        block24: {
            this.matchStat = 0;
            c = (char)this.bp;
            c3 = this.ch;
            int n = this.bp;
            if ((c2 = this.charAt(n++)) == '\"') {
                int n2 = this.indexOf('\"', n);
                if (n2 == -1) {
                    throw new JSONException("unclosed str");
                }
                int n3 = n2 - n;
                this.bp = n;
                if (!this.scanISO8601DateIfMatch(false, n3)) {
                    this.bp = c;
                    this.ch = c3;
                    this.matchStat = -1;
                    return null;
                }
                date = this.calendar.getTime();
                c2 = this.charAt(n2 + 1);
                this.bp = c;
                while (true) {
                    if (c2 == ',' || c2 == ']') {
                        this.bp = n2 + 1;
                        this.ch = c2;
                        break block24;
                    }
                    if (!JSONScanner.isWhitespace(c2)) break;
                    c2 = this.charAt(++n2 + 1);
                }
                this.bp = c;
                this.ch = c3;
                this.matchStat = -1;
                return null;
            }
            if (c2 == '-' || c2 >= '0' && c2 <= '9') {
                long l = 0L;
                boolean bl = false;
                if (c2 == '-') {
                    c2 = this.charAt(n++);
                    bl = true;
                }
                if (c2 >= '0' && c2 <= '9') {
                    l = c2 - 48;
                    while ((c2 = this.charAt(n++)) >= '0' && c2 <= '9') {
                        l = l * 10L + (long)(c2 - 48);
                    }
                    if (c2 == ',' || c2 == ']') {
                        this.bp = n - 1;
                    }
                }
                if (l < 0L) {
                    this.bp = c;
                    this.ch = c3;
                    this.matchStat = -1;
                    return null;
                }
                if (bl) {
                    l = -l;
                }
                date = new Date(l);
            } else if (c2 == 'n' && this.charAt(n++) == 'u' && this.charAt(n++) == 'l' && this.charAt(n++) == 'l') {
                date = null;
                c2 = this.charAt(n);
                this.bp = n;
            } else {
                this.bp = c;
                this.ch = c3;
                this.matchStat = -1;
                return null;
            }
        }
        if (c2 == ',') {
            this.ch = this.charAt(++this.bp);
            this.matchStat = 3;
            return date;
        }
        JSONScanner jSONScanner = this;
        if ((c2 = jSONScanner.charAt(++jSONScanner.bp)) == ',') {
            this.token = 16;
            this.ch = this.charAt(++this.bp);
        } else if (c2 == ']') {
            this.token = 15;
            this.ch = this.charAt(++this.bp);
        } else if (c2 == '}') {
            this.token = 13;
            this.ch = this.charAt(++this.bp);
        } else if (c2 == '\u001a') {
            this.ch = (char)26;
            this.token = 20;
        } else {
            this.bp = c;
            this.ch = c3;
            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return date;
    }

    @Override
    protected final void arrayCopy(int n, char[] cArray, int n2, int n3) {
        int n4 = n;
        this.text.getChars(n4, n4 + n3, cArray, n2);
    }

    @Override
    public final String info() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 1;
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.bp) {
            if (this.text.charAt(n3) == '\n') {
                n2 = 1;
                ++n;
            }
            ++n3;
            ++n2;
        }
        stringBuilder.append("pos ").append(this.bp).append(", line ").append(n).append(", column ").append(n2);
        if (this.text.length() < 65535) {
            stringBuilder.append(this.text);
        } else {
            stringBuilder.append(this.text.substring(0, 65535));
        }
        return stringBuilder.toString();
    }

    @Override
    public final String[] scanFieldStringArray(char[] cArray, int n, SymbolTable symbolTable) {
        String[] stringArray;
        char c;
        int n2;
        int n3 = this.bp;
        char c2 = this.ch;
        while (JSONScanner.isWhitespace(this.ch)) {
            this.next();
        }
        if (cArray != null) {
            this.matchStat = 0;
            if (!this.charArrayCompare(cArray)) {
                this.matchStat = -2;
                return null;
            }
            n2 = this.bp + cArray.length;
            c = this.text.charAt(n2++);
            while (JSONScanner.isWhitespace(c)) {
                c = this.text.charAt(n2++);
            }
            if (c == ':') {
                c = this.text.charAt(n2++);
            } else {
                this.matchStat = -1;
                return null;
            }
            while (JSONScanner.isWhitespace(c)) {
                c = this.text.charAt(n2++);
            }
        } else {
            n2 = this.bp + 1;
            c = this.ch;
        }
        if (c != '[') {
            if (c == 'n' && this.text.startsWith("ull", this.bp + 1)) {
                this.bp += 4;
                this.ch = this.text.charAt(this.bp);
                return null;
            }
            this.matchStat = -1;
            return null;
        }
        this.bp = n2;
        this.ch = this.text.charAt(this.bp);
        String[] stringArray2 = n >= 0 ? new String[n] : new String[4];
        n = 0;
        while (true) {
            if (JSONScanner.isWhitespace(this.ch)) {
                this.next();
                continue;
            }
            if (this.ch != '\"') {
                this.bp = n3;
                this.ch = c2;
                this.matchStat = -1;
                return null;
            }
            stringArray = this.scanSymbol(symbolTable, '\"');
            if (n == stringArray2.length) {
                String[] stringArray3 = new String[stringArray2.length + (stringArray2.length >> 1) + 1];
                System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
                stringArray2 = stringArray3;
            }
            stringArray2[n++] = stringArray;
            while (JSONScanner.isWhitespace(this.ch)) {
                this.next();
            }
            if (this.ch != ',') break;
            this.next();
        }
        if (stringArray2.length != n) {
            stringArray = new String[n];
            System.arraycopy(stringArray2, 0, stringArray, 0, n);
            stringArray2 = stringArray;
        }
        while (JSONScanner.isWhitespace(this.ch)) {
            this.next();
        }
        if (this.ch != ']') {
            this.bp = n3;
            this.ch = c2;
            this.matchStat = -1;
            return null;
        }
        this.next();
        return stringArray2;
    }

    @Override
    public final boolean matchField2(char[] cArray) {
        while (JSONScanner.isWhitespace(this.ch)) {
            this.next();
        }
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return false;
        }
        int n = this.bp + cArray.length;
        char c = this.text.charAt(n++);
        while (JSONScanner.isWhitespace(c)) {
            c = this.text.charAt(n++);
        }
        if (c == ':') {
            this.bp = n;
            this.ch = this.charAt(this.bp);
            return true;
        }
        this.matchStat = -2;
        return false;
    }

    @Override
    public final void skipObject() {
        this.skipObject(false);
    }

    @Override
    public final void skipObject(boolean n) {
        int n2;
        int n3;
        n = 0;
        int n4 = 0;
        for (n3 = this.bp; n3 < this.text.length(); ++n3) {
            n2 = this.text.charAt(n3);
            if (n2 == 92) {
                if (n3 < this.len - 1) {
                    ++n3;
                    continue;
                }
                this.ch = (char)n2;
                this.bp = n3;
                throw new JSONException("illegal str, " + this.info());
            }
            if (n2 == 34) {
                n = n == 0 ? 1 : 0;
                continue;
            }
            if (n2 == 123) {
                if (n != 0) continue;
                ++n4;
                continue;
            }
            if (n2 != 125 || n != 0 || --n4 != -1) continue;
            this.bp = n3 + 1;
            if (this.bp == this.text.length()) {
                this.ch = (char)26;
                this.token = 20;
                return;
            }
            this.ch = this.text.charAt(this.bp);
            if (this.ch == ',') {
                this.token = 16;
                this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                return;
            }
            if (this.ch == '}') {
                this.token = 13;
                this.next();
                return;
            }
            if (this.ch == ']') {
                this.token = 15;
                this.next();
                return;
            }
            this.nextToken(16);
            return;
        }
        for (n2 = 0; n2 < this.bp; ++n2) {
            if (n2 >= this.text.length() || this.text.charAt(n2) != ' ') continue;
            ++n3;
        }
        if (n3 == this.text.length()) {
            throw new JSONException("illegal str, " + this.info());
        }
    }

    @Override
    public final void skipArray() {
        this.skipArray(false);
    }

    public final void skipArray(boolean bl) {
        int n;
        boolean bl2 = false;
        int n2 = 0;
        for (n = this.bp; n < this.text.length(); ++n) {
            int n3 = this.text.charAt(n);
            if (n3 == 92) {
                if (n < this.len - 1) {
                    ++n;
                    continue;
                }
                this.ch = n3;
                this.bp = n;
                throw new JSONException("illegal str, " + this.info());
            }
            if (n3 == 34) {
                bl2 = !bl2;
                continue;
            }
            if (n3 == 91) {
                if (bl2) continue;
                ++n2;
                continue;
            }
            if (n3 == 123 && bl) {
                this.ch = (char)((n3 = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n3));
                this.skipObject(bl);
                continue;
            }
            if (n3 != 93 || bl2 || --n2 != -1) continue;
            this.bp = n + 1;
            if (this.bp == this.text.length()) {
                this.ch = (char)26;
                this.token = 20;
                return;
            }
            this.ch = this.text.charAt(this.bp);
            this.nextToken(16);
            return;
        }
        if (n == this.text.length()) {
            throw new JSONException("illegal str, " + this.info());
        }
    }

    public final void skipString() {
        if (this.ch == '\"') {
            for (int i = this.bp + 1; i < this.text.length(); ++i) {
                char c = this.text.charAt(i);
                if (c == '\\') {
                    if (i >= this.len - 1) continue;
                    ++i;
                    continue;
                }
                if (c != '\"') continue;
                this.bp = i + 1;
                this.ch = this.text.charAt(this.bp);
                return;
            }
            throw new JSONException("unclosed str");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean seekArrayToItem(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index must > 0, but ".concat(String.valueOf(n)));
        }
        if (this.token == 20) {
            return false;
        }
        if (this.token != 14) {
            throw new UnsupportedOperationException();
        }
        for (int i = 0; i < n; ++i) {
            this.skipWhitespace();
            if (this.ch == '\"' || this.ch == '\'') {
                this.skipString();
                if (this.ch == ',') {
                    this.next();
                    continue;
                }
                if (this.ch == ']') {
                    this.next();
                    this.nextToken(16);
                    return false;
                }
                throw new JSONException("illegal json.");
            }
            if (this.ch == '{') {
                this.next();
                this.token = 12;
                this.skipObject(false);
            } else if (this.ch == '[') {
                this.next();
                this.token = 14;
                this.skipArray(false);
            } else {
                boolean bl = false;
                for (int j = this.bp + 1; j < this.text.length(); ++j) {
                    char c = this.text.charAt(j);
                    if (c == ',') {
                        bl = true;
                        this.bp = j + 1;
                        this.ch = this.charAt(this.bp);
                        break;
                    }
                    if (c != ']') continue;
                    this.bp = j + 1;
                    this.ch = this.charAt(this.bp);
                    this.nextToken();
                    return false;
                }
                if (bl) continue;
                throw new JSONException("illegal json.");
            }
            if (this.token == 16) continue;
            if (this.token == 15) {
                return false;
            }
            throw new UnsupportedOperationException();
        }
        this.nextToken();
        return true;
    }

    @Override
    public final int seekObjectToField(long l, boolean bl) {
        block57: {
            if (this.token == 20) {
                return -1;
            }
            if (this.token == 13 || this.token == 15) {
                this.nextToken();
                return -1;
            }
            if (this.token != 12 && this.token != 16) {
                throw new UnsupportedOperationException(JSONToken.name(this.token));
            }
            while (true) {
                int n;
                long l2;
                if (this.ch == '}') {
                    this.next();
                    this.nextToken();
                    return -1;
                }
                if (this.ch == '\u001a') {
                    return -1;
                }
                if (this.ch != '\"') {
                    this.skipWhitespace();
                }
                if (this.ch == '\"') {
                    l2 = -3750763034362895579L;
                    for (n = this.bp + 1; n < this.text.length(); ++n) {
                        char c = this.text.charAt(n);
                        if (c == '\\') {
                            if (++n == this.text.length()) {
                                throw new JSONException("unclosed str, " + this.info());
                            }
                            c = this.text.charAt(n);
                        }
                        if (c == '\"') {
                            this.bp = n + 1;
                            this.ch = (char)(this.bp >= this.text.length() ? 26 : (int)this.text.charAt(this.bp));
                            break;
                        }
                        l2 = (l2 ^ (long)c) * 1099511628211L;
                    }
                } else {
                    throw new UnsupportedOperationException();
                }
                if (l2 == l) {
                    if (this.ch != ':') {
                        this.skipWhitespace();
                    }
                    if (this.ch == ':') {
                        this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                        if (this.ch == ',') {
                            this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                            this.token = 16;
                        } else if (this.ch == ']') {
                            this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                            this.token = 15;
                        } else if (this.ch == '}') {
                            this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                            this.token = 13;
                        } else if (this.ch >= '0' && this.ch <= '9') {
                            this.sp = 0;
                            this.pos = this.bp;
                            this.scanNumber();
                        } else {
                            this.nextToken(2);
                        }
                    }
                    return 3;
                }
                if (this.ch != ':') {
                    this.skipWhitespace();
                }
                if (this.ch != ':') {
                    throw new JSONException("illegal json, " + this.info());
                }
                this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                if (this.ch != '\"' && this.ch != '\'' && this.ch != '{' && this.ch != '[' && this.ch != '0' && this.ch != '1' && this.ch != '2' && this.ch != '3' && this.ch != '4' && this.ch != '5' && this.ch != '6' && this.ch != '7' && this.ch != '8' && this.ch != '9' && this.ch != '+' && this.ch != '-') {
                    this.skipWhitespace();
                }
                if (this.ch == '-' || this.ch == '+' || this.ch >= '0' && this.ch <= '9') {
                    this.next();
                    while (this.ch >= '0' && this.ch <= '9') {
                        this.next();
                    }
                    if (this.ch == '.') {
                        this.next();
                        while (this.ch >= '0' && this.ch <= '9') {
                            this.next();
                        }
                    }
                    if (this.ch == 'E' || this.ch == 'e') {
                        this.next();
                        if (this.ch == '-' || this.ch == '+') {
                            this.next();
                        }
                        while (this.ch >= '0' && this.ch <= '9') {
                            this.next();
                        }
                    }
                    if (this.ch != ',') {
                        this.skipWhitespace();
                    }
                    if (this.ch != ',') continue;
                    this.next();
                    continue;
                }
                if (this.ch == '\"') {
                    this.skipString();
                    if (this.ch != ',' && this.ch != '}') {
                        this.skipWhitespace();
                    }
                    if (this.ch != ',') continue;
                    this.next();
                    continue;
                }
                if (this.ch == 't') {
                    this.next();
                    if (this.ch == 'r') {
                        this.next();
                        if (this.ch == 'u') {
                            this.next();
                            if (this.ch == 'e') {
                                this.next();
                            }
                        }
                    }
                    if (this.ch != ',' && this.ch != '}') {
                        this.skipWhitespace();
                    }
                    if (this.ch != ',') continue;
                    this.next();
                    continue;
                }
                if (this.ch == 'n') {
                    this.next();
                    if (this.ch == 'u') {
                        this.next();
                        if (this.ch == 'l') {
                            this.next();
                            if (this.ch == 'l') {
                                this.next();
                            }
                        }
                    }
                    if (this.ch != ',' && this.ch != '}') {
                        this.skipWhitespace();
                    }
                    if (this.ch != ',') continue;
                    this.next();
                    continue;
                }
                if (this.ch == 'f') {
                    this.next();
                    if (this.ch == 'a') {
                        this.next();
                        if (this.ch == 'l') {
                            this.next();
                            if (this.ch == 's') {
                                this.next();
                                if (this.ch == 'e') {
                                    this.next();
                                }
                            }
                        }
                    }
                    if (this.ch != ',' && this.ch != '}') {
                        this.skipWhitespace();
                    }
                    if (this.ch != ',') continue;
                    this.next();
                    continue;
                }
                if (this.ch == '{') {
                    this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                    if (bl) {
                        this.token = 12;
                        return 1;
                    }
                    this.skipObject(false);
                    if (this.token != 13) continue;
                    return -1;
                }
                if (this.ch != '[') break block57;
                this.next();
                if (bl) {
                    this.token = 14;
                    return 2;
                }
                this.skipArray(false);
                if (this.token == 13) break;
            }
            return -1;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final int seekObjectToField(long[] lArray) {
        if (this.token != 12 && this.token != 16) {
            throw new UnsupportedOperationException();
        }
        while (true) {
            int n;
            int n2;
            long l;
            if (this.ch == '}') {
                this.next();
                this.nextToken();
                this.matchStat = -1;
                return -1;
            }
            if (this.ch == '\u001a') {
                this.matchStat = -1;
                return -1;
            }
            if (this.ch != '\"') {
                this.skipWhitespace();
            }
            if (this.ch == '\"') {
                l = -3750763034362895579L;
                for (n2 = this.bp + 1; n2 < this.text.length(); ++n2) {
                    n = this.text.charAt(n2);
                    if (n == 92) {
                        if (++n2 == this.text.length()) {
                            throw new JSONException("unclosed str, " + this.info());
                        }
                        n = this.text.charAt(n2);
                    }
                    if (n == 34) {
                        this.bp = n2 + 1;
                        this.ch = (char)(this.bp >= this.text.length() ? 26 : (int)this.text.charAt(this.bp));
                        break;
                    }
                    l = (l ^ (long)n) * 1099511628211L;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            n2 = -1;
            for (n = 0; n < lArray.length; ++n) {
                if (l != lArray[n]) continue;
                n2 = n;
                break;
            }
            if (n2 != -1) {
                if (this.ch != ':') {
                    this.skipWhitespace();
                }
                if (this.ch == ':') {
                    this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                    if (this.ch == ',') {
                        this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                        this.token = 16;
                    } else if (this.ch == ']') {
                        this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                        this.token = 15;
                    } else if (this.ch == '}') {
                        this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                        this.token = 13;
                    } else if (this.ch >= '0' && this.ch <= '9') {
                        this.sp = 0;
                        this.pos = this.bp;
                        this.scanNumber();
                    } else {
                        this.nextToken(2);
                    }
                }
                this.matchStat = 3;
                return n2;
            }
            if (this.ch != ':') {
                this.skipWhitespace();
            }
            if (this.ch != ':') {
                throw new JSONException("illegal json, " + this.info());
            }
            this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
            if (this.ch != '\"' && this.ch != '\'' && this.ch != '{' && this.ch != '[' && this.ch != '0' && this.ch != '1' && this.ch != '2' && this.ch != '3' && this.ch != '4' && this.ch != '5' && this.ch != '6' && this.ch != '7' && this.ch != '8' && this.ch != '9' && this.ch != '+' && this.ch != '-') {
                this.skipWhitespace();
            }
            if (this.ch == '-' || this.ch == '+' || this.ch >= '0' && this.ch <= '9') {
                this.next();
                while (this.ch >= '0' && this.ch <= '9') {
                    this.next();
                }
                if (this.ch == '.') {
                    this.next();
                    while (this.ch >= '0' && this.ch <= '9') {
                        this.next();
                    }
                }
                if (this.ch == 'E' || this.ch == 'e') {
                    this.next();
                    if (this.ch == '-' || this.ch == '+') {
                        this.next();
                    }
                    while (this.ch >= '0' && this.ch <= '9') {
                        this.next();
                    }
                }
                if (this.ch != ',') {
                    this.skipWhitespace();
                }
                if (this.ch != ',') continue;
                this.next();
                continue;
            }
            if (this.ch == '\"') {
                this.skipString();
                if (this.ch != ',' && this.ch != '}') {
                    this.skipWhitespace();
                }
                if (this.ch != ',') continue;
                this.next();
                continue;
            }
            if (this.ch == '{') {
                this.ch = (char)((n = ++this.bp) >= this.text.length() ? 26 : (int)this.text.charAt(n));
                this.skipObject(false);
                continue;
            }
            if (this.ch != '[') break;
            this.next();
            this.skipArray(false);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final String scanTypeName(SymbolTable symbolTable) {
        int n;
        if (this.text.startsWith("\"@type\":\"", this.bp) && (n = this.text.indexOf(34, this.bp + 9)) != -1) {
            this.bp += 9;
            int n2 = 0;
            for (int i = this.bp; i < n; ++i) {
                n2 = 31 * n2 + this.text.charAt(i);
            }
            JSONScanner jSONScanner = this;
            String string = jSONScanner.addSymbol(jSONScanner.bp, n - this.bp, n2, symbolTable);
            char c = this.text.charAt(n + 1);
            if (c != ',' && c != ']') {
                return null;
            }
            this.bp = n + 2;
            this.ch = this.text.charAt(this.bp);
            return string;
        }
        return null;
    }
}

