/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONArray;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.JSONObject;
import com.tradplus.ads.common.serialization.JSONPObject;
import com.tradplus.ads.common.serialization.JSONPath;
import com.tradplus.ads.common.serialization.PropertyNamingStrategy;
import com.tradplus.ads.common.serialization.TypeReference;
import com.tradplus.ads.common.serialization.annotation.JSONCreator;
import com.tradplus.ads.common.serialization.annotation.JSONField;
import com.tradplus.ads.common.serialization.annotation.JSONType;
import com.tradplus.ads.common.serialization.asm.ClassReader;
import com.tradplus.ads.common.serialization.asm.TypeCollector;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.SymbolTable;
import com.tradplus.ads.common.serialization.parser.deserializer.ASMDeserializerFactory;
import com.tradplus.ads.common.serialization.parser.deserializer.ArrayListTypeFieldDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.AutowiredObjectDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.DefaultFieldDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.EnumCreatorDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.EnumDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.FieldDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.JSONPDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.JavaBeanDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.JavaObjectDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.Jdk8DateCodec;
import com.tradplus.ads.common.serialization.parser.deserializer.MapDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.NumberDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.OptionalCodec;
import com.tradplus.ads.common.serialization.parser.deserializer.PropertyProcessable;
import com.tradplus.ads.common.serialization.parser.deserializer.PropertyProcessableDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.SqlDateDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.StackTraceElementDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.ThrowableDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.TimeDeserializer;
import com.tradplus.ads.common.serialization.serializer.AtomicCodec;
import com.tradplus.ads.common.serialization.serializer.BigDecimalCodec;
import com.tradplus.ads.common.serialization.serializer.BigIntegerCodec;
import com.tradplus.ads.common.serialization.serializer.BooleanCodec;
import com.tradplus.ads.common.serialization.serializer.ByteBufferCodec;
import com.tradplus.ads.common.serialization.serializer.CalendarCodec;
import com.tradplus.ads.common.serialization.serializer.CharArrayCodec;
import com.tradplus.ads.common.serialization.serializer.CharacterCodec;
import com.tradplus.ads.common.serialization.serializer.CollectionCodec;
import com.tradplus.ads.common.serialization.serializer.DateCodec;
import com.tradplus.ads.common.serialization.serializer.FloatCodec;
import com.tradplus.ads.common.serialization.serializer.IntegerCodec;
import com.tradplus.ads.common.serialization.serializer.LongCodec;
import com.tradplus.ads.common.serialization.serializer.MiscCodec;
import com.tradplus.ads.common.serialization.serializer.ObjectArrayCodec;
import com.tradplus.ads.common.serialization.serializer.ReferenceCodec;
import com.tradplus.ads.common.serialization.serializer.StringCodec;
import com.tradplus.ads.common.serialization.spi.Module;
import com.tradplus.ads.common.serialization.util.ASMClassLoader;
import com.tradplus.ads.common.serialization.util.ASMUtils;
import com.tradplus.ads.common.serialization.util.FieldInfo;
import com.tradplus.ads.common.serialization.util.IOUtils;
import com.tradplus.ads.common.serialization.util.IdentityHashMap;
import com.tradplus.ads.common.serialization.util.JavaBeanInfo;
import com.tradplus.ads.common.serialization.util.ParameterizedTypeImpl;
import com.tradplus.ads.common.serialization.util.ServiceLoader;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.xml.datatype.XMLGregorianCalendar;

public class ParserConfig {
    public static final String DENY_PROPERTY_INTERNAL = "fastjson.parser.deny.internal";
    public static final String DENY_PROPERTY = "fastjson.parser.deny";
    public static final String AUTOTYPE_ACCEPT = "fastjson.parser.autoTypeAccept";
    public static final String AUTOTYPE_SUPPORT_PROPERTY = "fastjson.parser.autoTypeSupport";
    public static final String SAFE_MODE_PROPERTY = "fastjson.parser.safeMode";
    public static final String[] DENYS_INTERNAL = ParserConfig.splitItemsFormProperty(IOUtils.getStringProperty("fastjson.parser.deny.internal"));
    public static final String[] DENYS = ParserConfig.splitItemsFormProperty(IOUtils.getStringProperty("fastjson.parser.deny"));
    private static final String[] AUTO_TYPE_ACCEPT_LIST;
    public static final boolean AUTO_SUPPORT;
    public static final boolean SAFE_MODE;
    private static final long[] INTERNAL_WHITELIST_HASHCODES;
    public static ParserConfig global;
    private final IdentityHashMap<Type, ObjectDeserializer> deserializers = new IdentityHashMap();
    private final IdentityHashMap<Type, IdentityHashMap<Type, ObjectDeserializer>> mixInDeserializers = new IdentityHashMap(16);
    private final ConcurrentMap<String, Class<?>> typeMapping = new ConcurrentHashMap(16, 0.75f, 1);
    private boolean asmEnable = !ASMUtils.IS_ANDROID;
    public final SymbolTable symbolTable = new SymbolTable(4096);
    public PropertyNamingStrategy propertyNamingStrategy;
    protected ClassLoader defaultClassLoader;
    protected ASMDeserializerFactory asmFactory;
    private static boolean awtError;
    private static boolean jdk8Error;
    private static boolean jodaError;
    private static boolean guavaError;
    private boolean autoTypeSupport = AUTO_SUPPORT;
    private long[] internalDenyHashCodes;
    private long[] denyHashCodes;
    private long[] acceptHashCodes;
    public final boolean fieldBased;
    private boolean jacksonCompatible = false;
    public boolean compatibleWithJavaBean = TypeUtils.compatibleWithJavaBean;
    private List<Module> modules = new ArrayList<Module>();
    private volatile List<AutoTypeCheckHandler> autoTypeCheckHandlers;
    private boolean safeMode = SAFE_MODE;

    public static ParserConfig getGlobalInstance() {
        return global;
    }

    public ParserConfig() {
        this(false);
    }

    public ParserConfig(boolean bl) {
        this(null, null, bl);
    }

    public ParserConfig(ClassLoader classLoader) {
        this(null, classLoader, false);
    }

    public ParserConfig(ASMDeserializerFactory aSMDeserializerFactory) {
        this(aSMDeserializerFactory, null, false);
    }

    private ParserConfig(ASMDeserializerFactory aSMDeserializerFactory, ClassLoader classLoader, boolean bl) {
        this.denyHashCodes = new long[]{-9164606388214699518L, -8720046426850100497L, -8649961213709896794L, -8165637398350707645L, -8109300701639721088L, -7966123100503199569L, -7921218830998286408L, -7775351613326101303L, -7768608037458185275L, -7766605818834748097L, -6835437086156813536L, -6316154655839304624L, -6179589609550493385L, -6149093380703242441L, -6025144546313590215L, -5939269048541779808L, -5885964883385605994L, -5764804792063216819L, -5472097725414717105L, -5194641081268104286L, -5076846148177416215L, -4837536971810737970L, -4703320437989596122L, -4608341446948126581L, -4537258998789938600L, -4438775680185074100L, -4314457471973557243L, -4150995715611818742L, -4082057040235125754L, -3975378478825053783L, -3935185854875733362L, -3319207949486691020L, -3077205613010077203L, -3053747177772160511L, -2995060141064716555L, -2825378362173150292L, -2533039401923731906L, -2439930098895578154L, -2378990704010641148L, -2364987994247679115L, -2262244760619952081L, -2192804397019347313L, -2095516571388852610L, -1872417015366588117L, -1650485814983027158L, -1589194880214235129L, -965955008570215305L, -905177026366752536L, -831789045734283466L, -582813228520337988L, -254670111376247151L, -219577392946377768L, -190281065685395680L, -26639035867733124L, -9822483067882491L, 4750336058574309L, 33238344207745342L, 156405680656087946L, 218512992947536312L, 313864100207897507L, 386461436234701831L, 823641066473609950L, 1073634739308289776L, 1153291637701043748L, 1203232727967308606L, 1214780596910349029L, 1459860845934817624L, 1502845958873959152L, 1534439610567445754L, 1698504441317515818L, 1818089308493370394L, 2078113382421334967L, 2164696723069287854L, 2622551729063269307L, 2653453629929770569L, 2660670623866180977L, 2731823439467737506L, 2836431254737891113L, 2930861374593775110L, 3085473968517218653L, 3089451460101527857L, 3114862868117605599L, 3129395579983849527L, 3256258368248066264L, 3452379460455804429L, 3547627781654598988L, 3637939656440441093L, 3688179072722109200L, 3718352661124136681L, 3730752432285826863L, 3794316665763266033L, 4000049462512838776L, 4046190361520671643L, 4147696707147271408L, 4193204392725694463L, 4241163808635564644L, 4254584350247334433L, 4814658433570175913L, 4841947709850912914L, 4904007817188630457L, 5100336081510080343L, 5274044858141538265L, 5347909877633654828L, 5450448828334921485L, 5474268165959054640L, 5545425291794704408L, 5596129856135573697L, 5688200883751798389L, 5751393439502795295L, 5944107969236155580L, 6007332606592876737L, 6280357960959217660L, 6456855723474196908L, 6511035576063254270L, 6534946468240507089L, 6584624952928234050L, 6734240326434096246L, 6742705432718011780L, 6854854816081053523L, 7045245923763966215L, 7123326897294507060L, 7179336928365889465L, 7240293012336844478L, 7347653049056829645L, 7375862386996623731L, 7442624256860549330L, 7617522210483516279L, 7658177784286215602L, 8055461369741094911L, 8389032537095247355L, 8409640769019589119L, 8488266005336625107L, 8537233257283452655L, 8838294710098435315L, 9140390920032557669L, 9140416208800006522L};
        long[] lArray = new long[AUTO_TYPE_ACCEPT_LIST.length];
        for (int i = 0; i < AUTO_TYPE_ACCEPT_LIST.length; ++i) {
            lArray[i] = TypeUtils.fnv1a_64(AUTO_TYPE_ACCEPT_LIST[i]);
        }
        Arrays.sort(lArray);
        this.acceptHashCodes = lArray;
        this.fieldBased = bl;
        if (aSMDeserializerFactory == null && !ASMUtils.IS_ANDROID) {
            try {
                aSMDeserializerFactory = classLoader == null ? new ASMDeserializerFactory(new ASMClassLoader()) : new ASMDeserializerFactory(classLoader);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
            }
            catch (AccessControlException accessControlException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        this.asmFactory = aSMDeserializerFactory;
        if (aSMDeserializerFactory == null) {
            this.asmEnable = false;
        }
        this.initDeserializers();
        this.addItemsToDeny(DENYS);
        this.addItemsToDeny0(DENYS_INTERNAL);
        this.addItemsToAccept(AUTO_TYPE_ACCEPT_LIST);
    }

    private void initDeserializers() {
        this.deserializers.put((Type)((Object)SimpleDateFormat.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Timestamp.class), SqlDateDeserializer.instance_timestamp);
        this.deserializers.put((Type)((Object)java.sql.Date.class), SqlDateDeserializer.instance);
        this.deserializers.put((Type)((Object)Time.class), TimeDeserializer.instance);
        this.deserializers.put((Type)((Object)Date.class), DateCodec.instance);
        this.deserializers.put((Type)((Object)Calendar.class), CalendarCodec.instance);
        this.deserializers.put((Type)((Object)XMLGregorianCalendar.class), CalendarCodec.instance);
        this.deserializers.put((Type)((Object)JSONObject.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)JSONArray.class), CollectionCodec.instance);
        this.deserializers.put((Type)((Object)Map.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)HashMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)LinkedHashMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)TreeMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)ConcurrentMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)ConcurrentHashMap.class), MapDeserializer.instance);
        this.deserializers.put((Type)((Object)Collection.class), CollectionCodec.instance);
        this.deserializers.put((Type)((Object)List.class), CollectionCodec.instance);
        this.deserializers.put((Type)((Object)ArrayList.class), CollectionCodec.instance);
        this.deserializers.put((Type)((Object)Object.class), JavaObjectDeserializer.instance);
        this.deserializers.put((Type)((Object)String.class), StringCodec.instance);
        this.deserializers.put((Type)((Object)StringBuffer.class), StringCodec.instance);
        this.deserializers.put((Type)((Object)StringBuilder.class), StringCodec.instance);
        this.deserializers.put(Character.TYPE, CharacterCodec.instance);
        this.deserializers.put((Type)((Object)Character.class), CharacterCodec.instance);
        this.deserializers.put(Byte.TYPE, NumberDeserializer.instance);
        this.deserializers.put((Type)((Object)Byte.class), NumberDeserializer.instance);
        this.deserializers.put(Short.TYPE, NumberDeserializer.instance);
        this.deserializers.put((Type)((Object)Short.class), NumberDeserializer.instance);
        this.deserializers.put(Integer.TYPE, IntegerCodec.instance);
        this.deserializers.put((Type)((Object)Integer.class), IntegerCodec.instance);
        this.deserializers.put(Long.TYPE, LongCodec.instance);
        this.deserializers.put((Type)((Object)Long.class), LongCodec.instance);
        this.deserializers.put((Type)((Object)BigInteger.class), BigIntegerCodec.instance);
        this.deserializers.put((Type)((Object)BigDecimal.class), BigDecimalCodec.instance);
        this.deserializers.put(Float.TYPE, FloatCodec.instance);
        this.deserializers.put((Type)((Object)Float.class), FloatCodec.instance);
        this.deserializers.put(Double.TYPE, NumberDeserializer.instance);
        this.deserializers.put((Type)((Object)Double.class), NumberDeserializer.instance);
        this.deserializers.put(Boolean.TYPE, BooleanCodec.instance);
        this.deserializers.put((Type)((Object)Boolean.class), BooleanCodec.instance);
        this.deserializers.put((Type)((Object)Class.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)char[].class), new CharArrayCodec());
        this.deserializers.put((Type)((Object)AtomicBoolean.class), BooleanCodec.instance);
        this.deserializers.put((Type)((Object)AtomicInteger.class), IntegerCodec.instance);
        this.deserializers.put((Type)((Object)AtomicLong.class), LongCodec.instance);
        this.deserializers.put((Type)((Object)AtomicReference.class), ReferenceCodec.instance);
        this.deserializers.put((Type)((Object)WeakReference.class), ReferenceCodec.instance);
        this.deserializers.put((Type)((Object)SoftReference.class), ReferenceCodec.instance);
        this.deserializers.put((Type)((Object)UUID.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)TimeZone.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Locale.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Currency.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Inet4Address.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Inet6Address.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)InetSocketAddress.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)File.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)URI.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)URL.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Pattern.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Charset.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)JSONPath.class), MiscCodec.instance);
        this.deserializers.put((Type)((Object)Number.class), NumberDeserializer.instance);
        this.deserializers.put((Type)((Object)AtomicIntegerArray.class), AtomicCodec.instance);
        this.deserializers.put((Type)((Object)AtomicLongArray.class), AtomicCodec.instance);
        this.deserializers.put((Type)((Object)StackTraceElement.class), StackTraceElementDeserializer.instance);
        this.deserializers.put((Type)((Object)Serializable.class), JavaObjectDeserializer.instance);
        this.deserializers.put((Type)((Object)Cloneable.class), JavaObjectDeserializer.instance);
        this.deserializers.put((Type)((Object)Comparable.class), JavaObjectDeserializer.instance);
        this.deserializers.put((Type)((Object)Closeable.class), JavaObjectDeserializer.instance);
        this.deserializers.put((Type)((Object)JSONPObject.class), new JSONPDeserializer());
    }

    private static String[] splitItemsFormProperty(String string) {
        if (string != null && string.length() > 0) {
            return string.split(",");
        }
        return null;
    }

    public void cfgFromPropety(Properties properties) {
        Object object = ParserConfig.splitItemsFormProperty(properties.getProperty(DENY_PROPERTY));
        this.addItemsToDeny((String[])object);
        object = ParserConfig.splitItemsFormProperty(properties.getProperty(AUTOTYPE_ACCEPT));
        this.addItemsToAccept((String[])object);
        object = properties.getProperty(AUTOTYPE_SUPPORT_PROPERTY);
        if ("true".equals(object)) {
            this.autoTypeSupport = true;
            return;
        }
        if ("false".equals(object)) {
            this.autoTypeSupport = false;
        }
    }

    private void addItemsToDeny0(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.addDenyInternal(string);
        }
    }

    private void addItemsToDeny(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.addDeny(string);
        }
    }

    private void addItemsToAccept(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.addAccept(string);
        }
    }

    public boolean isSafeMode() {
        return this.safeMode;
    }

    public void setSafeMode(boolean bl) {
        this.safeMode = bl;
    }

    public boolean isAutoTypeSupport() {
        return this.autoTypeSupport;
    }

    public void setAutoTypeSupport(boolean bl) {
        this.autoTypeSupport = bl;
    }

    public boolean isAsmEnable() {
        return this.asmEnable;
    }

    public void setAsmEnable(boolean bl) {
        this.asmEnable = bl;
    }

    public IdentityHashMap<Type, ObjectDeserializer> getDerializers() {
        return this.deserializers;
    }

    public IdentityHashMap<Type, ObjectDeserializer> getDeserializers() {
        return this.deserializers;
    }

    public ObjectDeserializer getDeserializer(Type object) {
        Object object2 = this.get((Type)object);
        if (object2 != null) {
            return object2;
        }
        if (object instanceof Class) {
            return this.getDeserializer((Class)object, (Type)object);
        }
        if (object instanceof ParameterizedType) {
            object2 = ((ParameterizedType)object).getRawType();
            if (object2 instanceof Class) {
                return this.getDeserializer((Class)object2, (Type)object);
            }
            return this.getDeserializer((Type)object2);
        }
        if (object instanceof WildcardType && ((Type[])(object = ((WildcardType)object).getUpperBounds())).length == 1) {
            object = object[0];
            return this.getDeserializer((Type)object);
        }
        return JavaObjectDeserializer.instance;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectDeserializer getDeserializer(Class<?> clazz, Type clazz2) {
        int n;
        Object object;
        Object object2;
        Object object3 = this.get(clazz2);
        if (object3 == null && clazz2 instanceof ParameterizedTypeImpl) {
            object2 = TypeReference.intern((ParameterizedTypeImpl)((Object)clazz2));
            object3 = this.get((Type)object2);
        }
        if (object3 != null) {
            return object3;
        }
        if (clazz2 == null) {
            clazz2 = clazz;
        }
        if ((object3 = this.get(clazz2)) != null) {
            return object3;
        }
        object2 = TypeUtils.getAnnotation(clazz, JSONType.class);
        if (object2 != null && (object = object2.mappingTo()) != Void.class) {
            Class<?> clazz3 = object;
            return this.getDeserializer(clazz3, clazz3);
        }
        if (clazz2 instanceof WildcardType || clazz2 instanceof TypeVariable || clazz2 instanceof ParameterizedType) {
            object3 = this.get(clazz);
        }
        if (object3 != null) {
            return object3;
        }
        object2 = this.modules.iterator();
        while (object2.hasNext()) {
            object3 = object2.next().createDeserializer(this, clazz);
            if (object3 == null) continue;
            this.putDeserializer(clazz2, (ObjectDeserializer)object3);
            return object3;
        }
        object2 = clazz.getName().replace('$', '.');
        if (!jdk8Error) {
            try {
                if (((String)object2).startsWith("java.time.")) {
                    object = new String[]{"java.time.LocalDateTime", "java.time.LocalDate", "java.time.LocalTime", "java.time.ZonedDateTime", "java.time.OffsetDateTime", "java.time.OffsetTime", "java.time.ZoneOffset", "java.time.ZoneRegion", "java.time.ZoneId", "java.time.Period", "java.time.Duration", "java.time.Instant"};
                    for (n = 0; n < 12; ++n) {
                        String object4 = object[n];
                        if (!object4.equals(object2)) continue;
                        object3 = Jdk8DateCodec.instance;
                        this.putDeserializer(Class.forName(object4), (ObjectDeserializer)object3);
                        return object3;
                    }
                } else if (((String)object2).startsWith("java.util.Optional")) {
                    object = new String[]{"java.util.Optional", "java.util.OptionalDouble", "java.util.OptionalInt", "java.util.OptionalLong"};
                    for (n = 0; n < 4; ++n) {
                        String i = object[n];
                        if (!i.equals(object2)) continue;
                        object3 = OptionalCodec.instance;
                        this.putDeserializer(Class.forName(i), (ObjectDeserializer)object3);
                        return object3;
                    }
                }
            }
            catch (Throwable throwable) {
                jdk8Error = true;
            }
        }
        if (((String)object2).equals("java.nio.ByteBuffer")) {
            object3 = ByteBufferCodec.instance;
            this.putDeserializer(clazz, (ObjectDeserializer)object3);
        }
        if (((String)object2).equals("java.nio.file.Path")) {
            object3 = MiscCodec.instance;
            this.putDeserializer(clazz, (ObjectDeserializer)object3);
        }
        if (clazz == Map.Entry.class) {
            object3 = MiscCodec.instance;
            this.putDeserializer(clazz, (ObjectDeserializer)object3);
        }
        object = Thread.currentThread().getContextClassLoader();
        try {
            object = ServiceLoader.load(AutowiredObjectDeserializer.class, (ClassLoader)object).iterator();
            while (object.hasNext()) {
                object2 = object.next();
                for (Type type : object2.getAutowiredFor()) {
                    this.putDeserializer(type, (ObjectDeserializer)object2);
                }
            }
        }
        catch (Exception exception) {}
        if (object3 == null) {
            object3 = this.get(clazz2);
        }
        if (object3 != null) {
            return object3;
        }
        if (clazz.isEnum()) {
            void var7_19;
            JSONType jSONType;
            if (this.jacksonCompatible) {
                void var7_15;
                object2 = clazz.getMethods();
                n = ((Method[])object2).length;
                boolean bl = false;
                while (var7_15 < n) {
                    if (TypeUtils.isJacksonCreator(object2[var7_15])) {
                        object3 = this.createJavaBeanDeserializer(clazz, clazz2);
                        this.putDeserializer(clazz2, (ObjectDeserializer)object3);
                        return object3;
                    }
                    ++var7_15;
                }
            }
            if ((jSONType = TypeUtils.getAnnotation((object = (Class)JSON.getMixInAnnotations(clazz)) != null ? object : clazz, JSONType.class)) != null) {
                object2 = jSONType.deserializer();
                try {
                    object3 = (ObjectDeserializer)((Class)object2).newInstance();
                    this.putDeserializer(clazz, (ObjectDeserializer)object3);
                    return object3;
                }
                catch (Throwable throwable) {}
            }
            Object var7_16 = null;
            if (object != null) {
                object3 = ParserConfig.getEnumCreator((Class)object, clazz);
                if (object3 != null) {
                    try {
                        Method method = clazz.getMethod(((Method)object3).getName(), ((Method)object3).getParameterTypes());
                    }
                    catch (Exception exception) {}
                }
            } else {
                Class<PropertyProcessable> clazz4 = clazz;
                Method method = ParserConfig.getEnumCreator(clazz4, clazz4);
            }
            if (var7_19 != null) {
                object3 = new EnumCreatorDeserializer((Method)var7_19);
                this.putDeserializer(clazz, (ObjectDeserializer)object3);
                return object3;
            }
            object3 = this.getEnumDeserializer(clazz);
        } else {
            object3 = clazz.isArray() ? ObjectArrayCodec.instance : (clazz == Set.class || clazz == HashSet.class || clazz == Collection.class || clazz == List.class || clazz == ArrayList.class ? CollectionCodec.instance : (Collection.class.isAssignableFrom(clazz) ? CollectionCodec.instance : (Map.class.isAssignableFrom(clazz) ? MapDeserializer.instance : (Throwable.class.isAssignableFrom(clazz) ? new ThrowableDeserializer(this, clazz) : (PropertyProcessable.class.isAssignableFrom(clazz) ? new PropertyProcessableDeserializer(clazz) : (clazz == InetAddress.class ? MiscCodec.instance : this.createJavaBeanDeserializer(clazz, clazz2)))))));
        }
        this.putDeserializer(clazz2, (ObjectDeserializer)object3);
        return object3;
    }

    private static Method getEnumCreator(Class methodArray, Class clazz) {
        methodArray = methodArray.getMethods();
        Method method = null;
        for (Method method2 : methodArray) {
            if (!Modifier.isStatic(method2.getModifiers()) || method2.getReturnType() != clazz || method2.getParameterTypes().length != 1 || method2.getAnnotation(JSONCreator.class) == null) continue;
            method = method2;
            break;
        }
        return method;
    }

    protected ObjectDeserializer getEnumDeserializer(Class<?> clazz) {
        return new EnumDeserializer(clazz);
    }

    public void initJavaBeanDeserializers(Class<?> ... classArray) {
        if (classArray == null) {
            return;
        }
        for (Class<?> clazz : classArray) {
            if (clazz == null) continue;
            Class<?> clazz2 = clazz;
            ObjectDeserializer objectDeserializer = this.createJavaBeanDeserializer(clazz2, clazz2);
            this.putDeserializer(clazz, objectDeserializer);
        }
    }

    public ObjectDeserializer createJavaBeanDeserializer(Class<?> clazz, Type type) {
        Object object;
        Object object2;
        boolean bl = this.asmEnable & !this.fieldBased;
        if (bl) {
            object2 = TypeUtils.getAnnotation(clazz, JSONType.class);
            if (object2 != null) {
                object = object2.deserializer();
                if (object != Void.class) {
                    try {
                        object = object.newInstance();
                        if (object instanceof ObjectDeserializer) {
                            return (ObjectDeserializer)object;
                        }
                    }
                    catch (Throwable throwable) {}
                }
                boolean bl2 = bl = object2.asm() && object2.parseFeatures().length == 0;
            }
            if (bl) {
                object = JavaBeanInfo.getBuilderClass(clazz, (JSONType)object2);
                if (object == null) {
                    object = clazz;
                }
                do {
                    if (Modifier.isPublic(object.getModifiers())) continue;
                    bl = false;
                    break;
                } while ((object = object.getSuperclass()) != Object.class && object != null);
            }
        }
        if (clazz.getTypeParameters().length != 0) {
            bl = false;
        }
        if (bl && this.asmFactory != null && this.asmFactory.classLoader.isExternalClass(clazz)) {
            bl = false;
        }
        if (bl) {
            bl = ASMUtils.checkName(clazz.getSimpleName());
        }
        if (bl) {
            if (clazz.isInterface()) {
                bl = false;
            }
            object2 = JavaBeanInfo.build(clazz, type, this.propertyNamingStrategy, false, TypeUtils.compatibleWithJavaBean, this.jacksonCompatible);
            if (bl && ((JavaBeanInfo)object2).fields.length > 200) {
                bl = false;
            }
            object = ((JavaBeanInfo)object2).defaultConstructor;
            if (bl && object == null && !clazz.isInterface()) {
                bl = false;
            }
            object = ((JavaBeanInfo)object2).fields;
            int n = ((JavaBeanInfo)object2).fields.length;
            for (int i = 0; i < n; ++i) {
                FieldInfo fieldInfo = object[i];
                if (fieldInfo.getOnly) {
                    bl = false;
                    break;
                }
                Class<?> clazz2 = fieldInfo.fieldClass;
                if (!Modifier.isPublic(clazz2.getModifiers())) {
                    bl = false;
                    break;
                }
                if (clazz2.isMemberClass() && !Modifier.isStatic(clazz2.getModifiers())) {
                    bl = false;
                    break;
                }
                if (fieldInfo.getMember() != null && !ASMUtils.checkName(fieldInfo.getMember().getName())) {
                    bl = false;
                    break;
                }
                JSONField jSONField = fieldInfo.getAnnotation();
                if (jSONField != null && (!ASMUtils.checkName(jSONField.name()) || jSONField.format().length() != 0 || jSONField.deserializeUsing() != Void.class || jSONField.parseFeatures().length != 0 || jSONField.unwrapped()) || fieldInfo.method != null && fieldInfo.method.getParameterTypes().length > 1) {
                    bl = false;
                    break;
                }
                if (!clazz2.isEnum() || this.getDeserializer(clazz2) instanceof EnumDeserializer) continue;
                bl = false;
                break;
            }
        }
        if (bl && clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
            bl = false;
        }
        if (bl && TypeUtils.isXmlField(clazz)) {
            bl = false;
        }
        if (!bl) {
            return new JavaBeanDeserializer(this, clazz, type);
        }
        object2 = JavaBeanInfo.build(clazz, type, this.propertyNamingStrategy);
        try {
            return this.asmFactory.createJavaBeanDeserializer(this, (JavaBeanInfo)object2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return new JavaBeanDeserializer(this, clazz, type);
        }
        catch (JSONException jSONException) {
            return new JavaBeanDeserializer(this, (JavaBeanInfo)object2);
        }
        catch (Exception exception) {
            throw new JSONException("create asm deserializer error, " + clazz.getName(), exception);
        }
    }

    public FieldDeserializer createFieldDeserializer(ParserConfig parserConfig, JavaBeanInfo object, FieldInfo fieldInfo) {
        object = ((JavaBeanInfo)object).clazz;
        Class<?> clazz = fieldInfo.fieldClass;
        Class<?> clazz2 = null;
        JSONField jSONField = fieldInfo.getAnnotation();
        if (jSONField != null && (clazz2 = jSONField.deserializeUsing()) == Void.class) {
            clazz2 = null;
        }
        if (clazz2 == null && (clazz == List.class || clazz == ArrayList.class)) {
            return new ArrayListTypeFieldDeserializer(parserConfig, (Class<?>)object, fieldInfo);
        }
        return new DefaultFieldDeserializer(parserConfig, (Class<?>)object, fieldInfo);
    }

    public void putDeserializer(Type type, ObjectDeserializer objectDeserializer) {
        Type type2 = JSON.getMixInAnnotations(type);
        if (type2 != null) {
            IdentityHashMap<Type, ObjectDeserializer> identityHashMap = this.mixInDeserializers.get(type);
            if (identityHashMap == null) {
                identityHashMap = new IdentityHashMap(4);
                this.mixInDeserializers.put(type, identityHashMap);
            }
            identityHashMap.put(type2, objectDeserializer);
            return;
        }
        this.deserializers.put(type, objectDeserializer);
    }

    public ObjectDeserializer get(Type object) {
        Type type = JSON.getMixInAnnotations((Type)object);
        if (type == null) {
            return this.deserializers.get((Type)object);
        }
        if ((object = this.mixInDeserializers.get((Type)object)) == null) {
            return null;
        }
        return (ObjectDeserializer)((IdentityHashMap)object).get(type);
    }

    public ObjectDeserializer getDeserializer(FieldInfo fieldInfo) {
        return this.getDeserializer(fieldInfo.fieldClass, fieldInfo.fieldType);
    }

    public boolean isPrimitive(Class<?> clazz) {
        return ParserConfig.isPrimitive2(clazz);
    }

    public static boolean isPrimitive2(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == Boolean.class || clazz == Character.class || clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == BigInteger.class || clazz == BigDecimal.class || clazz == String.class || clazz == Date.class || clazz == java.sql.Date.class || clazz == Time.class || clazz == Timestamp.class || clazz.isEnum();
    }

    public static void parserAllFieldToCache(Class<?> clazz, Map<String, Field> map) {
        while (true) {
            for (Field field : clazz.getDeclaredFields()) {
                String string = field.getName();
                if (map.containsKey(string)) continue;
                map.put(string, field);
            }
            if (clazz.getSuperclass() == null || clazz.getSuperclass() == Object.class) break;
            clazz = clazz.getSuperclass();
        }
    }

    public static Field getFieldFromCache(String string, Map<String, Field> entry2) {
        Field field = entry2.get(string);
        if (field == null) {
            field = entry2.get("_".concat(String.valueOf(string)));
        }
        if (field == null) {
            field = entry2.get("m_".concat(String.valueOf(string)));
        }
        if (field == null) {
            char c = string.charAt(0);
            if (c >= 'a' && c <= 'z') {
                char[] cArray = string.toCharArray();
                Object object = cArray;
                cArray[0] = (char)(cArray[0] - 32);
                object = new String((char[])object);
                field = entry2.get(object);
            }
            if (string.length() > 2) {
                char c2 = string.charAt(1);
                if (string.length() > 2 && c >= 'a' && c <= 'z' && c2 >= 'A' && c2 <= 'Z') {
                    for (Map.Entry<String, Field> entry2 : entry2.entrySet()) {
                        if (!string.equalsIgnoreCase((String)entry2.getKey())) continue;
                        field = (Field)entry2.getValue();
                        break;
                    }
                }
            }
        }
        return field;
    }

    public ClassLoader getDefaultClassLoader() {
        return this.defaultClassLoader;
    }

    public void setDefaultClassLoader(ClassLoader classLoader) {
        this.defaultClassLoader = classLoader;
    }

    public void addDenyInternal(String object) {
        if (object == null || ((String)object).length() == 0) {
            return;
        }
        long l = TypeUtils.fnv1a_64((String)object);
        if (this.internalDenyHashCodes == null) {
            this.internalDenyHashCodes = new long[]{l};
            return;
        }
        if (Arrays.binarySearch(this.internalDenyHashCodes, l) >= 0) {
            return;
        }
        long[] lArray = new long[this.internalDenyHashCodes.length + 1];
        object = lArray;
        lArray[lArray.length - 1] = l;
        System.arraycopy(this.internalDenyHashCodes, 0, object, 0, this.internalDenyHashCodes.length);
        Arrays.sort((long[])object);
        this.internalDenyHashCodes = (long[])object;
    }

    public void addDeny(String object) {
        if (object == null || ((String)object).length() == 0) {
            return;
        }
        long l = TypeUtils.fnv1a_64((String)object);
        if (Arrays.binarySearch(this.denyHashCodes, l) >= 0) {
            return;
        }
        long[] lArray = new long[this.denyHashCodes.length + 1];
        object = lArray;
        lArray[lArray.length - 1] = l;
        System.arraycopy(this.denyHashCodes, 0, object, 0, this.denyHashCodes.length);
        Arrays.sort((long[])object);
        this.denyHashCodes = (long[])object;
    }

    public void addAccept(String object) {
        if (object == null || ((String)object).length() == 0) {
            return;
        }
        long l = TypeUtils.fnv1a_64((String)object);
        if (Arrays.binarySearch(this.acceptHashCodes, l) >= 0) {
            return;
        }
        long[] lArray = new long[this.acceptHashCodes.length + 1];
        object = lArray;
        lArray[lArray.length - 1] = l;
        System.arraycopy(this.acceptHashCodes, 0, object, 0, this.acceptHashCodes.length);
        Arrays.sort((long[])object);
        this.acceptHashCodes = (long[])object;
    }

    public Class<?> checkAutoType(Class clazz) {
        if (this.get(clazz) != null) {
            return clazz;
        }
        return this.checkAutoType(clazz.getName(), null, JSON.DEFAULT_PARSER_FEATURE);
    }

    public Class<?> checkAutoType(String string, Class<?> clazz) {
        return this.checkAutoType(string, clazz, JSON.DEFAULT_PARSER_FEATURE);
    }

    public Class<?> checkAutoType(String string, Class<?> clazz, int n) {
        InputStream inputStream;
        boolean bl;
        Class<?> clazz2;
        boolean bl2;
        block34: {
            int n2;
            long l;
            long l2;
            if (string == null) {
                return null;
            }
            if (this.autoTypeCheckHandlers != null) {
                Iterator<AutoTypeCheckHandler> iterator = this.autoTypeCheckHandlers.iterator();
                while (iterator.hasNext()) {
                    Class<?> clazz3 = iterator.next().handler(string, clazz, n);
                    if (clazz3 == null) continue;
                    return clazz3;
                }
            }
            int n3 = Feature.SafeMode.mask;
            if (this.safeMode || (n & n3) != 0 || (JSON.DEFAULT_PARSER_FEATURE & n3) != 0) {
                throw new JSONException("safeMode not support autoType : ".concat(String.valueOf(string)));
            }
            if (string.length() >= 192 || string.length() < 3) {
                throw new JSONException("autoType is not support. ".concat(String.valueOf(string)));
            }
            bl2 = clazz == null ? false : (l2 = TypeUtils.fnv1a_64(clazz.getName())) != -8024746738719829346L && l2 != 3247277300971823414L && l2 != -5811778396720452501L && l2 != -1368967840069965882L && l2 != 2980334044947851925L && l2 != 5183404141909004468L && l2 != 7222019943667248779L && l2 != -2027296626235911549L && l2 != -2114196234051346931L && l2 != -2939497380989775398L;
            String string2 = string.replace('$', '.');
            long l3 = (0xCBF29CE484222325L ^ (long)string2.charAt(0)) * 1099511628211L;
            if (l3 == -5808493101479473382L) {
                throw new JSONException("autoType is not support. ".concat(String.valueOf(string)));
            }
            String string3 = string2;
            if ((l3 ^ (long)string3.charAt(string3.length() - 1)) * 1099511628211L == 655701488918567152L) {
                throw new JSONException("autoType is not support. ".concat(String.valueOf(string)));
            }
            long l4 = (((0xCBF29CE484222325L ^ (long)string2.charAt(0)) * 1099511628211L ^ (long)string2.charAt(1)) * 1099511628211L ^ (long)string2.charAt(2)) * 1099511628211L;
            long l5 = TypeUtils.fnv1a_64(string2);
            int n4 = n3 = Arrays.binarySearch(INTERNAL_WHITELIST_HASHCODES, l5) >= 0 ? 1 : 0;
            if (this.internalDenyHashCodes != null) {
                l = l4;
                for (n2 = 3; n2 < string2.length(); ++n2) {
                    if (Arrays.binarySearch(this.internalDenyHashCodes, l = (l ^ (long)string2.charAt(n2)) * 1099511628211L) < 0) continue;
                    throw new JSONException("autoType is not support. ".concat(String.valueOf(string)));
                }
            }
            if (n3 == 0 && (this.autoTypeSupport || bl2)) {
                l = l4;
                for (n2 = 3; n2 < string2.length(); ++n2) {
                    if (Arrays.binarySearch(this.acceptHashCodes, l = (l ^ (long)string2.charAt(n2)) * 1099511628211L) >= 0 && (clazz2 = TypeUtils.loadClass(string, this.defaultClassLoader, true)) != null) {
                        return clazz2;
                    }
                    if (Arrays.binarySearch(this.denyHashCodes, l) < 0 || TypeUtils.getClassFromMapping(string) != null || Arrays.binarySearch(this.acceptHashCodes, l5) >= 0) continue;
                    throw new JSONException("autoType is not support. ".concat(String.valueOf(string)));
                }
            }
            if ((clazz2 = TypeUtils.getClassFromMapping(string)) == null) {
                clazz2 = this.deserializers.findClass(string);
            }
            if (clazz2 == null) {
                clazz2 = (Class)this.typeMapping.get(string);
            }
            if (n3 != 0) {
                clazz2 = TypeUtils.loadClass(string, this.defaultClassLoader, true);
            }
            if (clazz2 != null) {
                if (clazz != null && clazz2 != HashMap.class && !clazz.isAssignableFrom(clazz2)) {
                    throw new JSONException("type not match. " + string + " -> " + clazz.getName());
                }
                return clazz2;
            }
            if (!this.autoTypeSupport) {
                l = l4;
                for (n2 = 3; n2 < string2.length(); ++n2) {
                    n3 = string2.charAt(n2);
                    if (Arrays.binarySearch(this.denyHashCodes, l = (l ^ (long)n3) * 1099511628211L) >= 0) {
                        throw new JSONException("autoType is not support. ".concat(String.valueOf(string)));
                    }
                    if (Arrays.binarySearch(this.acceptHashCodes, l) < 0) continue;
                    clazz2 = TypeUtils.loadClass(string, this.defaultClassLoader, true);
                    if (clazz2 == null) {
                        return clazz;
                    }
                    if (clazz != null && clazz.isAssignableFrom(clazz2)) {
                        throw new JSONException("type not match. " + string + " -> " + clazz.getName());
                    }
                    return clazz2;
                }
            }
            bl = false;
            inputStream = null;
            try {
                Object object = string.replace('.', '/') + ".class";
                inputStream = this.defaultClassLoader != null ? this.defaultClassLoader.getResourceAsStream((String)object) : ParserConfig.class.getClassLoader().getResourceAsStream((String)object);
                if (inputStream == null) break block34;
                ClassReader classReader = new ClassReader(inputStream, true);
                object = new TypeCollector("<clinit>", new Class[0]);
                classReader.accept((TypeCollector)object);
                bl = ((TypeCollector)object).hasJsonType();
            }
            catch (Exception exception) {
                IOUtils.close(inputStream);
            }
            catch (Throwable throwable) {
                IOUtils.close(inputStream);
                throw throwable;
            }
        }
        IOUtils.close(inputStream);
        int n5 = Feature.SupportAutoType.mask;
        boolean bl3 = this.autoTypeSupport || (n & n5) != 0 || (JSON.DEFAULT_PARSER_FEATURE & n5) != 0;
        if (bl3 || bl || bl2) {
            n5 = bl3 || bl ? 1 : 0;
            clazz2 = TypeUtils.loadClass(string, this.defaultClassLoader, n5 != 0);
        }
        if (clazz2 != null) {
            if (bl) {
                TypeUtils.addMapping(string, clazz2);
                return clazz2;
            }
            if (ClassLoader.class.isAssignableFrom(clazz2) || DataSource.class.isAssignableFrom(clazz2) || RowSet.class.isAssignableFrom(clazz2)) {
                throw new JSONException("autoType is not support. ".concat(String.valueOf(string)));
            }
            if (clazz != null) {
                if (clazz.isAssignableFrom(clazz2)) {
                    TypeUtils.addMapping(string, clazz2);
                    return clazz2;
                }
                throw new JSONException("type not match. " + string + " -> " + clazz.getName());
            }
            Class<?> clazz4 = clazz2;
            if (JavaBeanInfo.build(clazz4, clazz4, (PropertyNamingStrategy)this.propertyNamingStrategy).creatorConstructor != null && bl3) {
                throw new JSONException("autoType is not support. ".concat(String.valueOf(string)));
            }
        }
        if (!bl3) {
            throw new JSONException("autoType is not support. ".concat(String.valueOf(string)));
        }
        if (clazz2 != null) {
            TypeUtils.addMapping(string, clazz2);
        }
        return clazz2;
    }

    public void clearDeserializers() {
        this.deserializers.clear();
        this.initDeserializers();
    }

    public boolean isJacksonCompatible() {
        return this.jacksonCompatible;
    }

    public void setJacksonCompatible(boolean bl) {
        this.jacksonCompatible = bl;
    }

    public void register(String string, Class clazz) {
        this.typeMapping.putIfAbsent(string, clazz);
    }

    public void register(Module module) {
        this.modules.add(module);
    }

    public void addAutoTypeCheckHandler(AutoTypeCheckHandler autoTypeCheckHandler) {
        List<AutoTypeCheckHandler> list = this.autoTypeCheckHandlers;
        if (list == null) {
            this.autoTypeCheckHandlers = list = new CopyOnWriteArrayList<AutoTypeCheckHandler>();
        }
        list.add(autoTypeCheckHandler);
    }

    static {
        String[] stringArray = IOUtils.getStringProperty(AUTOTYPE_SUPPORT_PROPERTY);
        AUTO_SUPPORT = "true".equals(stringArray);
        stringArray = IOUtils.getStringProperty(SAFE_MODE_PROPERTY);
        SAFE_MODE = "true".equals(stringArray);
        stringArray = ParserConfig.splitItemsFormProperty(IOUtils.getStringProperty(AUTOTYPE_ACCEPT));
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        AUTO_TYPE_ACCEPT_LIST = stringArray;
        INTERNAL_WHITELIST_HASHCODES = new long[]{-9013707057526259810L, -8773806119481270567L, -8421588593326113468L, -8070393259084821111L, -7858127399773263546L, -7043543676283957292L, -6976602508726000783L, -6293031534589903644L, -6081111809668363619L, -5779433778261875721L, -5399450433995651784L, -4540135604787511831L, -4207865850564917696L, -3950343444501679205L, -3714900953609113456L, -3393714734093696063L, -3378497329992063044L, -2631228350337215662L, -2551988546877734201L, -2473987886800209058L, -2265617974881722705L, -1759511109484434299L, -1477946458560579955L, -816725787720647462L, -520183782617964618L, 59775428743665658L, 484499585846206473L, 532945107123976213L, 711449177569584898L, 829148494126372070L, 956883420092542580L, 1233162291719202522L, 1696465274354442213L, 1863557081881630420L, 2238472697200138595L, 2380202963256720577L, 2643099543618286743L, 2793877891138577121L, 3804572268889088203L, 4567982875926242015L, 4784070066737926537L, 4960004821520561233L, 5348524593377618456L, 5454920836284873808L, 5695987590363189151L, 6073645722991901167L, 6114875255374330593L, 6137737446243999215L, 6160752908990493848L, 6939315124833099497L, 7048426940343117278L, 7267793227937552092L, 8331868837379820532L, 8357451534615459155L, 8890227807433646566L, 9166532985682478006L, 9215131087512669423L};
        global = new ParserConfig();
        awtError = false;
        jdk8Error = false;
        jodaError = false;
        guavaError = false;
    }

    public static interface AutoTypeCheckHandler {
        public Class<?> handler(String var1, Class<?> var2, int var3);
    }
}

