/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser.deserializer;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.JSONLexerBase;
import com.tradplus.ads.common.serialization.parser.JSONScanner;
import com.tradplus.ads.common.serialization.parser.deserializer.ContextObjectDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.BeanContext;
import com.tradplus.ads.common.serialization.serializer.ContextObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.TimeZone;

public class Jdk8DateCodec
extends ContextObjectDeserializer
implements ObjectDeserializer,
ContextObjectSerializer,
ObjectSerializer {
    public static final Jdk8DateCodec instance = new Jdk8DateCodec();
    private static final String defaultPatttern = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter defaultFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter defaultFormatter_23 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateTimeFormatter formatter_dt19_tw = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_cn = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_cn_1 = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 H\u65f6m\u5206s\u79d2");
    private static final DateTimeFormatter formatter_dt19_kr = DateTimeFormatter.ofPattern("yyyy\ub144M\uc6d4d\uc77c HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_us = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_eur = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_de = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
    private static final DateTimeFormatter formatter_dt19_in = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
    private static final DateTimeFormatter formatter_d8 = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter formatter_d10_tw = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    private static final DateTimeFormatter formatter_d10_cn = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5");
    private static final DateTimeFormatter formatter_d10_kr = DateTimeFormatter.ofPattern("yyyy\ub144M\uc6d4d\uc77c");
    private static final DateTimeFormatter formatter_d10_us = DateTimeFormatter.ofPattern("MM/dd/yyyy");
    private static final DateTimeFormatter formatter_d10_eur = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private static final DateTimeFormatter formatter_d10_de = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private static final DateTimeFormatter formatter_d10_in = DateTimeFormatter.ofPattern("dd-MM-yyyy");
    private static final DateTimeFormatter ISO_FIXED_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
    private static final String formatter_iso8601_pattern = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String formatter_iso8601_pattern_23 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String formatter_iso8601_pattern_29 = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS";
    private static final DateTimeFormatter formatter_iso8601 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object, String string, int n) {
        object = defaultJSONParser.lexer;
        if (object.token() == 8) {
            object.nextToken();
            return null;
        }
        if (object.token() == 4) {
            String string2 = object.stringVal();
            object.nextToken();
            DateTimeFormatter dateTimeFormatter = null;
            if (string != null) {
                dateTimeFormatter = defaultPatttern.equals(string) ? defaultFormatter : DateTimeFormatter.ofPattern(string);
            }
            if ("".equals(string2)) {
                return null;
            }
            if (type == LocalDateTime.class) {
                object = string2.length() == 10 || string2.length() == 8 ? LocalDateTime.of(this.parseLocalDate(string2, string, dateTimeFormatter), LocalTime.MIN) : this.parseDateTime(string2, dateTimeFormatter);
                return (T)object;
            }
            if (type == LocalDate.class) {
                if (string2.length() == 23) {
                    LocalDateTime localDateTime = LocalDateTime.parse(string2);
                    object = LocalDate.of(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth());
                } else {
                    object = this.parseLocalDate(string2, string, dateTimeFormatter);
                }
                return (T)object;
            }
            if (type == LocalTime.class) {
                if (string2.length() == 23) {
                    LocalDateTime localDateTime = LocalDateTime.parse(string2);
                    object = LocalTime.of(localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano());
                } else {
                    n = 1;
                    for (int i = 0; i < string2.length(); ++i) {
                        char c = string2.charAt(i);
                        if (c >= '0' && c <= '9') continue;
                        n = 0;
                        break;
                    }
                    object = n != 0 && string2.length() > 8 && string2.length() < 19 ? LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(string2)), JSON.defaultTimeZone.toZoneId()).toLocalTime() : LocalTime.parse(string2);
                }
                return (T)object;
            }
            if (type == ZonedDateTime.class) {
                if (dateTimeFormatter == defaultFormatter) {
                    dateTimeFormatter = ISO_FIXED_FORMAT;
                }
                if (dateTimeFormatter == null && string2.length() <= 19) {
                    object = new JSONScanner(string2);
                    TimeZone timeZone = defaultJSONParser.lexer.getTimeZone();
                    ((JSONLexerBase)object).setTimeZone(timeZone);
                    if (((JSONScanner)object).scanISO8601DateIfMatch(false)) {
                        return (T)ZonedDateTime.ofInstant(((JSONLexerBase)object).getCalendar().getTime().toInstant(), timeZone.toZoneId());
                    }
                }
                return (T)this.parseZonedDateTime(string2, dateTimeFormatter);
            }
            if (type == OffsetDateTime.class) {
                return (T)OffsetDateTime.parse(string2);
            }
            if (type == OffsetTime.class) {
                return (T)OffsetTime.parse(string2);
            }
            if (type == ZoneId.class) {
                return (T)ZoneId.of(string2);
            }
            if (type == Period.class) {
                return (T)Period.parse(string2);
            }
            if (type == Duration.class) {
                return (T)Duration.parse(string2);
            }
            if (type == Instant.class) {
                boolean bl = true;
                for (n = 0; n < string2.length(); ++n) {
                    char c = string2.charAt(n);
                    if (c >= '0' && c <= '9') continue;
                    bl = false;
                    break;
                }
                if (bl && string2.length() > 8 && string2.length() < 19) {
                    return (T)Instant.ofEpochMilli(Long.parseLong(string2));
                }
                return (T)Instant.parse(string2);
            }
        } else {
            if (object.token() == 2) {
                long l = object.longValue();
                object.nextToken();
                if ("unixtime".equals(string)) {
                    l *= 1000L;
                } else if ("yyyyMMddHHmmss".equals(string)) {
                    int n2 = (int)(l / 10000000000L);
                    n = (int)(l / 100000000L % 100L);
                    int n3 = (int)(l / 1000000L % 100L);
                    int n4 = (int)(l / 10000L % 100L);
                    int n5 = (int)(l / 100L % 100L);
                    int n6 = (int)(l % 100L);
                    if (type == LocalDateTime.class) {
                        return (T)LocalDateTime.of(n2, n, n3, n4, n5, n6);
                    }
                }
                if (type == LocalDateTime.class) {
                    return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(l), JSON.defaultTimeZone.toZoneId());
                }
                if (type == LocalDate.class) {
                    return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(l), JSON.defaultTimeZone.toZoneId()).toLocalDate();
                }
                if (type == LocalTime.class) {
                    return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(l), JSON.defaultTimeZone.toZoneId()).toLocalTime();
                }
                if (type == ZonedDateTime.class) {
                    return (T)ZonedDateTime.ofInstant(Instant.ofEpochMilli(l), JSON.defaultTimeZone.toZoneId());
                }
                if (type == Instant.class) {
                    return (T)Instant.ofEpochMilli(l);
                }
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
        return null;
    }

    protected LocalDateTime parseDateTime(String string, DateTimeFormatter dateTimeFormatter) {
        char c;
        int n;
        int n2;
        block19: {
            block21: {
                char c2;
                char c3;
                block20: {
                    block24: {
                        block25: {
                            String string2;
                            block27: {
                                block26: {
                                    int n3;
                                    block23: {
                                        block22: {
                                            if (dateTimeFormatter != null) break block19;
                                            if (string.length() != 19) break block20;
                                            n3 = string.charAt(4);
                                            n2 = string.charAt(7);
                                            n = string.charAt(10);
                                            c = string.charAt(13);
                                            c3 = string.charAt(16);
                                            if (c != ':' || c3 != ':') break block21;
                                            if (n3 != 45 || n2 != 45) break block22;
                                            if (n == 84) {
                                                dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
                                            } else if (n == 32) {
                                                dateTimeFormatter = defaultFormatter;
                                            }
                                            break block21;
                                        }
                                        if (n3 != 47 || n2 != 47) break block23;
                                        dateTimeFormatter = formatter_dt19_tw;
                                        break block21;
                                    }
                                    c2 = string.charAt(0);
                                    n2 = string.charAt(1);
                                    n = string.charAt(2);
                                    c = string.charAt(3);
                                    c3 = string.charAt(5);
                                    if (n != 47 || c3 != '/') break block24;
                                    n2 = (c2 - 48) * 10 + (n2 - 48);
                                    n3 = (c - 48) * 10 + (n3 - 48);
                                    if (n2 > 12) break block25;
                                    if (n3 <= 12) break block26;
                                    dateTimeFormatter = formatter_dt19_us;
                                    break block21;
                                }
                                string2 = Locale.getDefault().getCountry();
                                if (!string2.equals("US")) break block27;
                                dateTimeFormatter = formatter_dt19_us;
                                break block21;
                            }
                            if (!string2.equals("BR") && !string2.equals("AU")) break block21;
                        }
                        dateTimeFormatter = formatter_dt19_eur;
                        break block21;
                    }
                    if (n == 46 && c3 == '.') {
                        dateTimeFormatter = formatter_dt19_de;
                    } else if (n == 45 && c3 == '-') {
                        dateTimeFormatter = formatter_dt19_in;
                    }
                    break block21;
                }
                if (string.length() == 23) {
                    char c4 = string.charAt(4);
                    n2 = string.charAt(7);
                    n = string.charAt(10);
                    c = string.charAt(13);
                    c3 = string.charAt(16);
                    c2 = string.charAt(19);
                    if (c == ':' && c3 == ':' && c4 == '-' && n2 == 45 && n == 32 && c2 == '.') {
                        dateTimeFormatter = defaultFormatter_23;
                    }
                }
            }
            if (string.length() >= 17) {
                char c5 = string.charAt(4);
                if (c5 == '\u5e74') {
                    String string3 = string;
                    dateTimeFormatter = string3.charAt(string3.length() - 1) == '\u79d2' ? formatter_dt19_cn_1 : formatter_dt19_cn;
                } else if (c5 == '\ub144') {
                    dateTimeFormatter = formatter_dt19_kr;
                }
            }
        }
        if (dateTimeFormatter == null) {
            JSONScanner jSONScanner = new JSONScanner(string);
            if (jSONScanner.scanISO8601DateIfMatch(false)) {
                return LocalDateTime.ofInstant(jSONScanner.getCalendar().toInstant(), ZoneId.systemDefault());
            }
            n2 = 1;
            for (n = 0; n < string.length(); ++n) {
                c = string.charAt(n);
                if (c >= '0' && c <= '9') continue;
                n2 = 0;
                break;
            }
            if (n2 != 0 && string.length() > 8 && string.length() < 19) {
                return LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(string)), JSON.defaultTimeZone.toZoneId());
            }
        }
        if (dateTimeFormatter == null) {
            return LocalDateTime.parse(string);
        }
        return LocalDateTime.parse(string, dateTimeFormatter);
    }

    protected LocalDate parseLocalDate(String string, String string2, DateTimeFormatter dateTimeFormatter) {
        block14: {
            char c;
            int n;
            block15: {
                char c2;
                block16: {
                    block17: {
                        String string3;
                        block19: {
                            block18: {
                                if (dateTimeFormatter != null) break block14;
                                if (string.length() == 8) {
                                    dateTimeFormatter = formatter_d8;
                                }
                                if (string.length() != 10) break block15;
                                int n2 = string.charAt(4);
                                n = string.charAt(7);
                                if (n2 == 47 && n == 47) {
                                    dateTimeFormatter = formatter_d10_tw;
                                }
                                c = string.charAt(0);
                                int n3 = string.charAt(1);
                                n = string.charAt(2);
                                char c3 = string.charAt(3);
                                c2 = string.charAt(5);
                                if (n != 47 || c2 != '/') break block16;
                                n3 = (c - 48) * 10 + (n3 - 48);
                                n2 = (c3 - 48) * 10 + (n2 - 48);
                                if (n3 > 12) break block17;
                                if (n2 <= 12) break block18;
                                dateTimeFormatter = formatter_d10_us;
                                break block15;
                            }
                            string3 = Locale.getDefault().getCountry();
                            if (!string3.equals("US")) break block19;
                            dateTimeFormatter = formatter_d10_us;
                            break block15;
                        }
                        if (!string3.equals("BR") && !string3.equals("AU")) break block15;
                    }
                    dateTimeFormatter = formatter_d10_eur;
                    break block15;
                }
                if (n == 46 && c2 == '.') {
                    dateTimeFormatter = formatter_d10_de;
                } else if (n == 45 && c2 == '-') {
                    dateTimeFormatter = formatter_d10_in;
                }
            }
            if (string.length() >= 9) {
                char c4 = string.charAt(4);
                if (c4 == '\u5e74') {
                    dateTimeFormatter = formatter_d10_cn;
                } else if (c4 == '\ub144') {
                    dateTimeFormatter = formatter_d10_kr;
                }
            }
            boolean bl = true;
            for (n = 0; n < string.length(); ++n) {
                c = string.charAt(n);
                if (c >= '0' && c <= '9') continue;
                bl = false;
                break;
            }
            if (bl && string.length() > 8 && string.length() < 19) {
                return LocalDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(string)), JSON.defaultTimeZone.toZoneId()).toLocalDate();
            }
        }
        if (dateTimeFormatter == null) {
            return LocalDate.parse(string);
        }
        return LocalDate.parse(string, dateTimeFormatter);
    }

    protected ZonedDateTime parseZonedDateTime(String string, DateTimeFormatter dateTimeFormatter) {
        block15: {
            char c;
            int n;
            block16: {
                char c2;
                char c3;
                block19: {
                    block20: {
                        String string2;
                        block22: {
                            block21: {
                                char c4;
                                int n2;
                                block18: {
                                    block17: {
                                        if (dateTimeFormatter != null) break block15;
                                        if (string.length() != 19) break block16;
                                        n2 = string.charAt(4);
                                        n = string.charAt(7);
                                        c = string.charAt(10);
                                        c3 = string.charAt(13);
                                        c4 = string.charAt(16);
                                        if (c3 != ':' || c4 != ':') break block16;
                                        if (n2 != 45 || n != 45) break block17;
                                        if (c == 'T') {
                                            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
                                        } else if (c == ' ') {
                                            dateTimeFormatter = defaultFormatter;
                                        }
                                        break block16;
                                    }
                                    if (n2 != 47 || n != 47) break block18;
                                    dateTimeFormatter = formatter_dt19_tw;
                                    break block16;
                                }
                                n = string.charAt(0);
                                c = string.charAt(1);
                                c3 = string.charAt(2);
                                c4 = string.charAt(3);
                                c2 = string.charAt(5);
                                if (c3 != '/' || c2 != '/') break block19;
                                n = (n - 48) * 10 + (c - 48);
                                n2 = (c4 - 48) * 10 + (n2 - 48);
                                if (n > 12) break block20;
                                if (n2 <= 12) break block21;
                                dateTimeFormatter = formatter_dt19_us;
                                break block16;
                            }
                            string2 = Locale.getDefault().getCountry();
                            if (!string2.equals("US")) break block22;
                            dateTimeFormatter = formatter_dt19_us;
                            break block16;
                        }
                        if (!string2.equals("BR") && !string2.equals("AU")) break block16;
                    }
                    dateTimeFormatter = formatter_dt19_eur;
                    break block16;
                }
                if (c3 == '.' && c2 == '.') {
                    dateTimeFormatter = formatter_dt19_de;
                } else if (c3 == '-' && c2 == '-') {
                    dateTimeFormatter = formatter_dt19_in;
                }
            }
            if (string.length() >= 17) {
                char c5 = string.charAt(4);
                if (c5 == '\u5e74') {
                    String string3 = string;
                    dateTimeFormatter = string3.charAt(string3.length() - 1) == '\u79d2' ? formatter_dt19_cn_1 : formatter_dt19_cn;
                } else if (c5 == '\ub144') {
                    dateTimeFormatter = formatter_dt19_kr;
                }
            }
            boolean bl = true;
            for (n = 0; n < string.length(); ++n) {
                c = string.charAt(n);
                if (c >= '0' && c <= '9') continue;
                bl = false;
                break;
            }
            if (bl && string.length() > 8 && string.length() < 19) {
                return ZonedDateTime.ofInstant(Instant.ofEpochMilli(Long.parseLong(string)), JSON.defaultTimeZone.toZoneId());
            }
        }
        if (dateTimeFormatter == null) {
            return ZonedDateTime.parse(string);
        }
        return ZonedDateTime.parse(string, dateTimeFormatter);
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type clazz, int n) {
        object2 = jSONSerializer.out;
        if (object == null) {
            ((SerializeWriter)object2).writeNull();
            return;
        }
        if (clazz == null) {
            clazz = object.getClass();
        }
        if (clazz == LocalDateTime.class) {
            int n2 = SerializerFeature.UseISO8601DateFormat.getMask();
            object = (LocalDateTime)object;
            String string = jSONSerializer.getDateFormatPattern();
            if (string == null) {
                int n3;
                string = (n & n2) != 0 || jSONSerializer.isEnabled(SerializerFeature.UseISO8601DateFormat) ? formatter_iso8601_pattern : (jSONSerializer.isEnabled(SerializerFeature.WriteDateUseDateFormat) ? JSON.DEFFAULT_DATE_FORMAT : ((n3 = ((LocalDateTime)object).getNano()) == 0 ? formatter_iso8601_pattern : (n3 % 1000000 == 0 ? formatter_iso8601_pattern_23 : formatter_iso8601_pattern_29)));
            }
            if (string != null) {
                this.write((SerializeWriter)object2, (TemporalAccessor)object, string);
                return;
            }
            ((SerializeWriter)object2).writeLong(((LocalDateTime)object).atZone(JSON.defaultTimeZone.toZoneId()).toInstant().toEpochMilli());
            return;
        }
        ((SerializeWriter)object2).writeString(object.toString());
    }

    @Override
    public void write(JSONSerializer object, Object object2, BeanContext object3) {
        object = ((JSONSerializer)object).out;
        object3 = ((BeanContext)object3).getFormat();
        this.write((SerializeWriter)object, (TemporalAccessor)object2, (String)object3);
    }

    private void write(SerializeWriter serializeWriter, TemporalAccessor temporalAccessor, String object) {
        Object object2;
        if ("unixtime".equals(object)) {
            if (temporalAccessor instanceof ChronoZonedDateTime) {
                long l = ((ChronoZonedDateTime)temporalAccessor).toEpochSecond();
                serializeWriter.writeInt((int)l);
                return;
            }
            if (temporalAccessor instanceof LocalDateTime) {
                long l = ((LocalDateTime)temporalAccessor).atZone(JSON.defaultTimeZone.toZoneId()).toEpochSecond();
                serializeWriter.writeInt((int)l);
                return;
            }
        }
        if ("millis".equals(object)) {
            object2 = null;
            if (temporalAccessor instanceof ChronoZonedDateTime) {
                object2 = ((ChronoZonedDateTime)temporalAccessor).toInstant();
            } else if (temporalAccessor instanceof LocalDateTime) {
                object2 = ((LocalDateTime)temporalAccessor).atZone(JSON.defaultTimeZone.toZoneId()).toInstant();
            }
            if (object2 != null) {
                long l = ((Instant)object2).toEpochMilli();
                serializeWriter.writeLong(l);
                return;
            }
        }
        object = object == formatter_iso8601_pattern ? formatter_iso8601 : DateTimeFormatter.ofPattern((String)object);
        object2 = ((DateTimeFormatter)object).format(temporalAccessor);
        serializeWriter.writeString((String)object2);
    }

    public static Object castToLocalDateTime(Object object, String object2) {
        if (object == null) {
            return null;
        }
        if (object2 == null) {
            object2 = defaultPatttern;
        }
        object2 = DateTimeFormatter.ofPattern((String)object2);
        return LocalDateTime.parse(object.toString(), (DateTimeFormatter)object2);
    }
}

