/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser.deserializer;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;

public class NumberDeserializer
implements ObjectDeserializer {
    public static final NumberDeserializer instance = new NumberDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        if (jSONLexer.token() == 2) {
            if (type == Double.TYPE || type == Double.class) {
                String string = jSONLexer.numberString();
                jSONLexer.nextToken(16);
                return (T)Double.valueOf(Double.parseDouble(string));
            }
            long l = jSONLexer.longValue();
            jSONLexer.nextToken(16);
            if (type == Short.TYPE || type == Short.class) {
                if (l > 32767L || l < -32768L) {
                    throw new JSONException("short overflow : ".concat(String.valueOf(l)));
                }
                return (T)Short.valueOf((short)l);
            }
            if (type == Byte.TYPE || type == Byte.class) {
                if (l > 127L || l < -128L) {
                    throw new JSONException("short overflow : ".concat(String.valueOf(l)));
                }
                return (T)Byte.valueOf((byte)l);
            }
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                return (T)Integer.valueOf((int)l);
            }
            return (T)Long.valueOf(l);
        }
        if (jSONLexer.token() == 3) {
            if (type == Double.TYPE || type == Double.class) {
                String string = jSONLexer.numberString();
                jSONLexer.nextToken(16);
                return (T)Double.valueOf(Double.parseDouble(string));
            }
            if (type == Short.TYPE || type == Short.class) {
                BigDecimal bigDecimal = jSONLexer.decimalValue();
                jSONLexer.nextToken(16);
                return (T)Short.valueOf(TypeUtils.shortValue(bigDecimal));
            }
            if (type == Byte.TYPE || type == Byte.class) {
                BigDecimal bigDecimal = jSONLexer.decimalValue();
                jSONLexer.nextToken(16);
                return (T)Byte.valueOf(TypeUtils.byteValue(bigDecimal));
            }
            BigDecimal bigDecimal = jSONLexer.decimalValue();
            jSONLexer.nextToken(16);
            if (jSONLexer.isEnabled(Feature.UseBigDecimal)) {
                return (T)bigDecimal;
            }
            return (T)Double.valueOf(bigDecimal.doubleValue());
        }
        if (jSONLexer.token() == 18 && "NaN".equals(jSONLexer.stringVal())) {
            jSONLexer.nextToken();
            Number number = null;
            if (type == Double.class) {
                number = Double.NaN;
            } else if (type == Float.class) {
                number = Float.valueOf(Float.NaN);
            }
            return (T)number;
        }
        Object object2 = defaultJSONParser.parse();
        if (object2 == null) {
            return null;
        }
        if (type == Double.TYPE || type == Double.class) {
            try {
                return (T)TypeUtils.castToDouble(object2);
            }
            catch (Exception exception) {
                throw new JSONException("parseDouble error, field : ".concat(String.valueOf(object)), exception);
            }
        }
        if (type == Short.TYPE || type == Short.class) {
            try {
                return (T)TypeUtils.castToShort(object2);
            }
            catch (Exception exception) {
                throw new JSONException("parseShort error, field : ".concat(String.valueOf(object)), exception);
            }
        }
        if (type == Byte.TYPE || type == Byte.class) {
            try {
                return (T)TypeUtils.castToByte(object2);
            }
            catch (Exception exception) {
                throw new JSONException("parseByte error, field : ".concat(String.valueOf(object)), exception);
            }
        }
        return (T)TypeUtils.castToBigDecimal(object2);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

