/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser.deserializer;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class OptionalCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static OptionalCodec instance = new OptionalCodec();

    @Override
    public <T> T deserialze(DefaultJSONParser object, Type type, Object object2) {
        if (type == OptionalInt.class) {
            if ((object = TypeUtils.castToInt(((DefaultJSONParser)object).parseObject(Integer.class))) == null) {
                return (T)OptionalInt.empty();
            }
            return (T)OptionalInt.of((Integer)object);
        }
        if (type == OptionalLong.class) {
            if ((object = TypeUtils.castToLong(((DefaultJSONParser)object).parseObject(Long.class))) == null) {
                return (T)OptionalLong.empty();
            }
            return (T)OptionalLong.of((Long)object);
        }
        if (type == OptionalDouble.class) {
            if ((object = TypeUtils.castToDouble(((DefaultJSONParser)object).parseObject(Double.class))) == null) {
                return (T)OptionalDouble.empty();
            }
            return (T)OptionalDouble.of((Double)object);
        }
        if ((object = ((DefaultJSONParser)object).parseObject(type = TypeUtils.unwrapOptional(type))) == null) {
            return (T)Optional.empty();
        }
        return (T)Optional.of(object);
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n) {
        if (object == null) {
            jSONSerializer.writeNull();
            return;
        }
        if (object instanceof Optional) {
            Object var6_6 = ((Optional)(object = (Optional)object)).isPresent() ? ((Optional)object).get() : null;
            jSONSerializer.write((Object)var6_6);
            return;
        }
        if (object instanceof OptionalDouble) {
            if (((OptionalDouble)(object = (OptionalDouble)object)).isPresent()) {
                double d = ((OptionalDouble)object).getAsDouble();
                jSONSerializer.write(d);
                return;
            }
            jSONSerializer.writeNull();
            return;
        }
        if (object instanceof OptionalInt) {
            if (((OptionalInt)(object = (OptionalInt)object)).isPresent()) {
                int n2 = ((OptionalInt)object).getAsInt();
                jSONSerializer.out.writeInt(n2);
                return;
            }
            jSONSerializer.writeNull();
            return;
        }
        if (object instanceof OptionalLong) {
            if (((OptionalLong)(object = (OptionalLong)object)).isPresent()) {
                long l = ((OptionalLong)object).getAsLong();
                jSONSerializer.out.writeLong(l);
                return;
            }
            jSONSerializer.writeNull();
            return;
        }
        throw new JSONException("not support optional : " + object.getClass());
    }
}

