/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.annotation.JSONType;
import com.tradplus.ads.common.serialization.asm.ClassWriter;
import com.tradplus.ads.common.serialization.asm.FieldWriter;
import com.tradplus.ads.common.serialization.asm.Label;
import com.tradplus.ads.common.serialization.asm.MethodVisitor;
import com.tradplus.ads.common.serialization.asm.MethodWriter;
import com.tradplus.ads.common.serialization.asm.Opcodes;
import com.tradplus.ads.common.serialization.parser.ParserConfig;
import com.tradplus.ads.common.serialization.serializer.BeanContext;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.JavaBeanSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerialContext;
import com.tradplus.ads.common.serialization.serializer.SerializeBeanInfo;
import com.tradplus.ads.common.serialization.serializer.SerializeFilterable;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.ASMClassLoader;
import com.tradplus.ads.common.serialization.util.ASMUtils;
import com.tradplus.ads.common.serialization.util.FieldInfo;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class ASMSerializerFactory
implements Opcodes {
    protected final ASMClassLoader classLoader = new ASMClassLoader();
    private final AtomicLong seed = new AtomicLong();
    static final String JSONSerializer = ASMUtils.type(JSONSerializer.class);
    static final String ObjectSerializer = ASMUtils.type(ObjectSerializer.class);
    static final String ObjectSerializer_desc = "L" + ObjectSerializer + ";";
    static final String SerializeWriter = ASMUtils.type(SerializeWriter.class);
    static final String SerializeWriter_desc = "L" + SerializeWriter + ";";
    static final String JavaBeanSerializer = ASMUtils.type(JavaBeanSerializer.class);
    static final String JavaBeanSerializer_desc = "L" + ASMUtils.type(JavaBeanSerializer.class) + ";";
    static final String SerialContext_desc = ASMUtils.desc(SerialContext.class);
    static final String SerializeFilterable_desc = ASMUtils.desc(SerializeFilterable.class);

    public JavaBeanSerializer createJavaBeanSerializer(SerializeBeanInfo serializeBeanInfo) {
        Context context;
        int n;
        int n2;
        Object object;
        Object object2;
        int n3;
        Class<?> clazz = serializeBeanInfo.beanType;
        if (clazz.isPrimitive()) {
            throw new JSONException("unsupportd class " + clazz.getName());
        }
        JSONType jSONType = TypeUtils.getAnnotation(clazz, JSONType.class);
        FieldInfo[] fieldInfoArray = serializeBeanInfo.fields;
        for (FieldInfo fieldInfo : serializeBeanInfo.fields) {
            if (fieldInfo.field != null || fieldInfo.method == null || !fieldInfo.method.getDeclaringClass().isInterface()) continue;
            return new JavaBeanSerializer(serializeBeanInfo);
        }
        FieldInfo[] fieldInfoArray2 = serializeBeanInfo.sortedFields;
        int n4 = n3 = serializeBeanInfo.sortedFields == serializeBeanInfo.fields ? 1 : 0;
        if (fieldInfoArray2.length > 256) {
            return new JavaBeanSerializer(serializeBeanInfo);
        }
        Object object3 = fieldInfoArray2;
        int n5 = fieldInfoArray2.length;
        for (int i = 0; i < n5; ++i) {
            if (ASMUtils.checkName(object3[i].getMember().getName())) continue;
            return new JavaBeanSerializer(serializeBeanInfo);
        }
        object3 = "ASMSerializer_" + this.seed.incrementAndGet() + "_" + clazz.getSimpleName();
        Object object4 = ASMSerializerFactory.class.getPackage();
        if (object4 != null) {
            object4 = ((Package)object4).getName();
            object2 = ((String)object4).replace('.', '/') + "/" + (String)object3;
            object = (String)object4 + "." + (String)object3;
        } else {
            object2 = object3;
            object = object3;
        }
        object4 = new ClassWriter();
        ((ClassWriter)object4).visit(49, 33, (String)object2, JavaBeanSerializer, new String[]{ObjectSerializer});
        object3 = fieldInfoArray2;
        int n6 = fieldInfoArray2.length;
        for (n2 = 0; n2 < n6; ++n2) {
            FieldInfo fieldInfo = object3[n2];
            if (fieldInfo.fieldClass.isPrimitive() || fieldInfo.fieldClass == String.class) continue;
            new FieldWriter((ClassWriter)object4, 1, fieldInfo.name + "_asm_fieldType", "Ljava/lang/reflect/Type;").visitEnd();
            if (List.class.isAssignableFrom(fieldInfo.fieldClass)) {
                new FieldWriter((ClassWriter)object4, 1, fieldInfo.name + "_asm_list_item_ser_", ObjectSerializer_desc).visitEnd();
            }
            new FieldWriter((ClassWriter)object4, 1, fieldInfo.name + "_asm_ser_", ObjectSerializer_desc).visitEnd();
        }
        object3 = new MethodWriter((ClassWriter)object4, 1, "<init>", "(" + ASMUtils.desc(SerializeBeanInfo.class) + ")V", null, null);
        object3.visitVarInsn(25, 0);
        object3.visitVarInsn(25, 1);
        object3.visitMethodInsn(183, JavaBeanSerializer, "<init>", "(" + ASMUtils.desc(SerializeBeanInfo.class) + ")V");
        for (n6 = 0; n6 < fieldInfoArray2.length; ++n6) {
            FieldInfo fieldInfo = fieldInfoArray2[n6];
            if (fieldInfo.fieldClass.isPrimitive() || fieldInfo.fieldClass == String.class) continue;
            object3.visitVarInsn(25, 0);
            if (fieldInfo.method != null) {
                object3.visitLdcInsn(com.tradplus.ads.common.serialization.asm.Type.getType(ASMUtils.desc(fieldInfo.declaringClass)));
                object3.visitLdcInsn(fieldInfo.method.getName());
                object3.visitMethodInsn(184, ASMUtils.type(ASMUtils.class), "getMethodType", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/reflect/Type;");
            } else {
                object3.visitVarInsn(25, 0);
                object3.visitLdcInsn(n6);
                object3.visitMethodInsn(183, JavaBeanSerializer, "getFieldType", "(I)Ljava/lang/reflect/Type;");
            }
            object3.visitFieldInsn(181, (String)object2, fieldInfo.name + "_asm_fieldType", "Ljava/lang/reflect/Type;");
        }
        object3.visitInsn(177);
        object3.visitMaxs(4, 4);
        object3.visitEnd();
        n6 = 0;
        if (jSONType != null) {
            SerializerFeature[] serializerFeatureArray = jSONType.serialzeFeatures();
            int n7 = serializerFeatureArray.length;
            for (n = 0; n < n7; ++n) {
                if (serializerFeatureArray[n] != SerializerFeature.DisableCircularReferenceDetect) continue;
                n6 = 1;
                break;
            }
        }
        for (n2 = 0; n2 < 3; ++n2) {
            Object object5;
            n = n6;
            boolean bl = false;
            if (n2 == 0) {
                object5 = "write";
                bl = true;
            } else if (n2 == 1) {
                object5 = "writeNormal";
            } else {
                bl = true;
                n = 1;
                object5 = "writeDirectNonContext";
            }
            context = new Context(fieldInfoArray2, serializeBeanInfo, (String)object2, bl, n != 0);
            object3 = new MethodWriter((ClassWriter)object4, 1, (String)object5, "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V", null, new String[]{"java/io/IOException"});
            object5 = new Label();
            object3.visitVarInsn(25, 2);
            object3.visitJumpInsn(199, (Label)object5);
            object3.visitVarInsn(25, 1);
            object3.visitMethodInsn(182, JSONSerializer, "writeNull", "()V");
            object3.visitInsn(177);
            object3.visitLabel((Label)object5);
            object3.visitVarInsn(25, 1);
            object3.visitFieldInsn(180, JSONSerializer, "out", SerializeWriter_desc);
            object3.visitVarInsn(58, context.var("out"));
            if (n3 == 0 && !context.writeDirect && (jSONType == null || jSONType.alphabetic())) {
                object5 = new Label();
                object3.visitVarInsn(25, context.var("out"));
                object3.visitMethodInsn(182, SerializeWriter, "isSortField", "()Z");
                object3.visitJumpInsn(154, (Label)object5);
                object3.visitVarInsn(25, 0);
                object3.visitVarInsn(25, 1);
                object3.visitVarInsn(25, 2);
                object3.visitVarInsn(25, 3);
                object3.visitVarInsn(25, 4);
                object3.visitVarInsn(21, 5);
                object3.visitMethodInsn(182, (String)object2, "writeUnsorted", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
                object3.visitInsn(177);
                object3.visitLabel((Label)object5);
            }
            if (context.writeDirect && n == 0) {
                object5 = new Label();
                Label label = new Label();
                object3.visitVarInsn(25, 0);
                object3.visitVarInsn(25, 1);
                object3.visitMethodInsn(182, JavaBeanSerializer, "writeDirect", "(L" + JSONSerializer + ";)Z");
                object3.visitJumpInsn(154, label);
                object3.visitVarInsn(25, 0);
                object3.visitVarInsn(25, 1);
                object3.visitVarInsn(25, 2);
                object3.visitVarInsn(25, 3);
                object3.visitVarInsn(25, 4);
                object3.visitVarInsn(21, 5);
                object3.visitMethodInsn(182, (String)object2, "writeNormal", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
                object3.visitInsn(177);
                object3.visitLabel(label);
                object3.visitVarInsn(25, context.var("out"));
                object3.visitLdcInsn(SerializerFeature.DisableCircularReferenceDetect.mask);
                object3.visitMethodInsn(182, SerializeWriter, "isEnabled", "(I)Z");
                object3.visitJumpInsn(153, (Label)object5);
                object3.visitVarInsn(25, 0);
                object3.visitVarInsn(25, 1);
                object3.visitVarInsn(25, 2);
                object3.visitVarInsn(25, 3);
                object3.visitVarInsn(25, 4);
                object3.visitVarInsn(21, 5);
                object3.visitMethodInsn(182, (String)object2, "writeDirectNonContext", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
                object3.visitInsn(177);
                object3.visitLabel((Label)object5);
            }
            object3.visitVarInsn(25, 2);
            object3.visitTypeInsn(192, ASMUtils.type(clazz));
            object3.visitVarInsn(58, context.var("entity"));
            this.generateWriteMethod(clazz, (MethodVisitor)object3, fieldInfoArray2, context);
            object3.visitInsn(177);
            object3.visitMaxs(7, context.variantIndex + 2);
            object3.visitEnd();
        }
        if (n3 == 0) {
            Context context2 = new Context(fieldInfoArray2, serializeBeanInfo, (String)object2, false, n6 != 0);
            object3 = new MethodWriter((ClassWriter)object4, 1, "writeUnsorted", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V", null, new String[]{"java/io/IOException"});
            object3.visitVarInsn(25, 1);
            object3.visitFieldInsn(180, JSONSerializer, "out", SerializeWriter_desc);
            object3.visitVarInsn(58, context2.var("out"));
            object3.visitVarInsn(25, 2);
            object3.visitTypeInsn(192, ASMUtils.type(clazz));
            object3.visitVarInsn(58, context2.var("entity"));
            this.generateWriteMethod(clazz, (MethodVisitor)object3, fieldInfoArray, context2);
            object3.visitInsn(177);
            object3.visitMaxs(7, context2.variantIndex + 2);
            object3.visitEnd();
        }
        for (int i = 0; i < 3; ++i) {
            String string;
            n = n6;
            boolean bl = false;
            if (i == 0) {
                string = "writeAsArray";
                bl = true;
            } else if (i == 1) {
                string = "writeAsArrayNormal";
            } else {
                bl = true;
                n = 1;
                string = "writeAsArrayNonContext";
            }
            context = new Context(fieldInfoArray2, serializeBeanInfo, (String)object2, bl, n != 0);
            object3 = new MethodWriter((ClassWriter)object4, 1, string, "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V", null, new String[]{"java/io/IOException"});
            object3.visitVarInsn(25, 1);
            object3.visitFieldInsn(180, JSONSerializer, "out", SerializeWriter_desc);
            object3.visitVarInsn(58, context.var("out"));
            object3.visitVarInsn(25, 2);
            object3.visitTypeInsn(192, ASMUtils.type(clazz));
            object3.visitVarInsn(58, context.var("entity"));
            this.generateWriteAsArray(clazz, (MethodVisitor)object3, fieldInfoArray2, context);
            object3.visitInsn(177);
            object3.visitMaxs(7, context.variantIndex + 2);
            object3.visitEnd();
        }
        byte[] byArray = ((ClassWriter)object4).toByteArray();
        return (JavaBeanSerializer)this.classLoader.defineClassPublic((String)object, byArray, 0, byArray.length).getConstructor(SerializeBeanInfo.class).newInstance(serializeBeanInfo);
    }

    private void generateWriteAsArray(Class<?> object, MethodVisitor methodVisitor, FieldInfo[] fieldInfoArray, Context context) {
        object = new Label();
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, JSONSerializer, "hasPropertyFilters", "(" + SerializeFilterable_desc + ")Z");
        methodVisitor.visitJumpInsn(154, (Label)object);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(25, 3);
        methodVisitor.visitVarInsn(25, 4);
        methodVisitor.visitVarInsn(21, 5);
        methodVisitor.visitMethodInsn(183, JavaBeanSerializer, "writeNoneASM", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
        methodVisitor.visitInsn(177);
        methodVisitor.visitLabel((Label)object);
        methodVisitor.visitVarInsn(25, context.var("out"));
        methodVisitor.visitVarInsn(16, 91);
        methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
        int n = fieldInfoArray.length;
        if (n == 0) {
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitVarInsn(16, 93);
            methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
            return;
        }
        for (int i = 0; i < n; ++i) {
            Label label;
            Label label2;
            Label label3;
            Object object2;
            Object object3;
            Object object4;
            int n2 = i == n - 1 ? 93 : 44;
            FieldInfo fieldInfo = fieldInfoArray[i];
            Object object5 = fieldInfo.fieldClass;
            methodVisitor.visitLdcInsn(fieldInfo.name);
            methodVisitor.visitVarInsn(58, Context.fieldName);
            if (object5 == Byte.TYPE || object5 == Short.TYPE || object5 == Integer.TYPE) {
                methodVisitor.visitVarInsn(25, context.var("out"));
                methodVisitor.visitInsn(89);
                this._get(methodVisitor, context, fieldInfo);
                methodVisitor.visitMethodInsn(182, SerializeWriter, "writeInt", "(I)V");
                methodVisitor.visitVarInsn(16, n2);
                methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
                continue;
            }
            if (object5 == Long.TYPE) {
                methodVisitor.visitVarInsn(25, context.var("out"));
                methodVisitor.visitInsn(89);
                this._get(methodVisitor, context, fieldInfo);
                methodVisitor.visitMethodInsn(182, SerializeWriter, "writeLong", "(J)V");
                methodVisitor.visitVarInsn(16, n2);
                methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
                continue;
            }
            if (object5 == Float.TYPE) {
                methodVisitor.visitVarInsn(25, context.var("out"));
                methodVisitor.visitInsn(89);
                this._get(methodVisitor, context, fieldInfo);
                methodVisitor.visitInsn(4);
                methodVisitor.visitMethodInsn(182, SerializeWriter, "writeFloat", "(FZ)V");
                methodVisitor.visitVarInsn(16, n2);
                methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
                continue;
            }
            if (object5 == Double.TYPE) {
                methodVisitor.visitVarInsn(25, context.var("out"));
                methodVisitor.visitInsn(89);
                this._get(methodVisitor, context, fieldInfo);
                methodVisitor.visitInsn(4);
                methodVisitor.visitMethodInsn(182, SerializeWriter, "writeDouble", "(DZ)V");
                methodVisitor.visitVarInsn(16, n2);
                methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
                continue;
            }
            if (object5 == Boolean.TYPE) {
                methodVisitor.visitVarInsn(25, context.var("out"));
                methodVisitor.visitInsn(89);
                this._get(methodVisitor, context, fieldInfo);
                methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(Z)V");
                methodVisitor.visitVarInsn(16, n2);
                methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
                continue;
            }
            if (object5 == Character.TYPE) {
                methodVisitor.visitVarInsn(25, context.var("out"));
                this._get(methodVisitor, context, fieldInfo);
                methodVisitor.visitMethodInsn(184, "java/lang/Character", "toString", "(C)Ljava/lang/String;");
                methodVisitor.visitVarInsn(16, n2);
                methodVisitor.visitMethodInsn(182, SerializeWriter, "writeString", "(Ljava/lang/String;C)V");
                continue;
            }
            if (object5 == String.class) {
                methodVisitor.visitVarInsn(25, context.var("out"));
                this._get(methodVisitor, context, fieldInfo);
                methodVisitor.visitVarInsn(16, n2);
                methodVisitor.visitMethodInsn(182, SerializeWriter, "writeString", "(Ljava/lang/String;C)V");
                continue;
            }
            if (((Class)object5).isEnum()) {
                methodVisitor.visitVarInsn(25, context.var("out"));
                methodVisitor.visitInsn(89);
                this._get(methodVisitor, context, fieldInfo);
                methodVisitor.visitMethodInsn(182, SerializeWriter, "writeEnum", "(Ljava/lang/Enum;)V");
                methodVisitor.visitVarInsn(16, n2);
                methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
                continue;
            }
            if (List.class.isAssignableFrom((Class<?>)object5)) {
                object4 = fieldInfo.fieldType;
                object3 = object4 instanceof Class ? Object.class : ((ParameterizedType)object4).getActualTypeArguments()[0];
                object2 = null;
                if (object3 instanceof Class && (object2 = (Class)object3) == Object.class) {
                    object2 = null;
                }
                this._get(methodVisitor, context, fieldInfo);
                methodVisitor.visitTypeInsn(192, "java/util/List");
                methodVisitor.visitVarInsn(58, context.var("list"));
                if (object2 == String.class && context.writeDirect) {
                    methodVisitor.visitVarInsn(25, context.var("out"));
                    methodVisitor.visitVarInsn(25, context.var("list"));
                    methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(Ljava/util/List;)V");
                } else {
                    label3 = new Label();
                    label2 = new Label();
                    methodVisitor.visitVarInsn(25, context.var("list"));
                    methodVisitor.visitJumpInsn(199, label2);
                    methodVisitor.visitVarInsn(25, context.var("out"));
                    methodVisitor.visitMethodInsn(182, SerializeWriter, "writeNull", "()V");
                    methodVisitor.visitJumpInsn(167, label3);
                    methodVisitor.visitLabel(label2);
                    methodVisitor.visitVarInsn(25, context.var("list"));
                    methodVisitor.visitMethodInsn(185, "java/util/List", "size", "()I");
                    methodVisitor.visitVarInsn(54, context.var("size"));
                    methodVisitor.visitVarInsn(25, context.var("out"));
                    methodVisitor.visitVarInsn(16, 91);
                    methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
                    label = new Label();
                    object5 = new Label();
                    object4 = new Label();
                    methodVisitor.visitInsn(3);
                    methodVisitor.visitVarInsn(54, context.var("i"));
                    methodVisitor.visitLabel(label);
                    methodVisitor.visitVarInsn(21, context.var("i"));
                    methodVisitor.visitVarInsn(21, context.var("size"));
                    methodVisitor.visitJumpInsn(162, (Label)object4);
                    methodVisitor.visitVarInsn(21, context.var("i"));
                    methodVisitor.visitJumpInsn(153, (Label)object5);
                    methodVisitor.visitVarInsn(25, context.var("out"));
                    methodVisitor.visitVarInsn(16, 44);
                    methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
                    methodVisitor.visitLabel((Label)object5);
                    methodVisitor.visitVarInsn(25, context.var("list"));
                    methodVisitor.visitVarInsn(21, context.var("i"));
                    methodVisitor.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;");
                    methodVisitor.visitVarInsn(58, context.var("list_item"));
                    object5 = new Label();
                    label2 = new Label();
                    methodVisitor.visitVarInsn(25, context.var("list_item"));
                    methodVisitor.visitJumpInsn(199, label2);
                    methodVisitor.visitVarInsn(25, context.var("out"));
                    methodVisitor.visitMethodInsn(182, SerializeWriter, "writeNull", "()V");
                    methodVisitor.visitJumpInsn(167, (Label)object5);
                    methodVisitor.visitLabel(label2);
                    label2 = new Label();
                    Label label4 = new Label();
                    if (object2 != null && Modifier.isPublic(((Class)object2).getModifiers())) {
                        methodVisitor.visitVarInsn(25, context.var("list_item"));
                        methodVisitor.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
                        methodVisitor.visitLdcInsn(com.tradplus.ads.common.serialization.asm.Type.getType(ASMUtils.desc(object2)));
                        methodVisitor.visitJumpInsn(166, label4);
                        this._getListFieldItemSer(context, methodVisitor, fieldInfo, (Class<?>)object2);
                        methodVisitor.visitVarInsn(58, context.var("list_item_desc"));
                        Label label5 = new Label();
                        Label label6 = new Label();
                        if (context.writeDirect) {
                            methodVisitor.visitVarInsn(25, context.var("list_item_desc"));
                            methodVisitor.visitTypeInsn(193, JavaBeanSerializer);
                            methodVisitor.visitJumpInsn(153, label5);
                            methodVisitor.visitVarInsn(25, context.var("list_item_desc"));
                            methodVisitor.visitTypeInsn(192, JavaBeanSerializer);
                            methodVisitor.visitVarInsn(25, 1);
                            methodVisitor.visitVarInsn(25, context.var("list_item"));
                            if (context.nonContext) {
                                methodVisitor.visitInsn(1);
                            } else {
                                methodVisitor.visitVarInsn(21, context.var("i"));
                                methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                            }
                            methodVisitor.visitLdcInsn(com.tradplus.ads.common.serialization.asm.Type.getType(ASMUtils.desc(object2)));
                            methodVisitor.visitLdcInsn(fieldInfo.serialzeFeatures);
                            methodVisitor.visitMethodInsn(182, JavaBeanSerializer, "writeAsArrayNonContext", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
                            methodVisitor.visitJumpInsn(167, label6);
                            methodVisitor.visitLabel(label5);
                        }
                        methodVisitor.visitVarInsn(25, context.var("list_item_desc"));
                        methodVisitor.visitVarInsn(25, 1);
                        methodVisitor.visitVarInsn(25, context.var("list_item"));
                        if (context.nonContext) {
                            methodVisitor.visitInsn(1);
                        } else {
                            methodVisitor.visitVarInsn(21, context.var("i"));
                            methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                        }
                        methodVisitor.visitLdcInsn(com.tradplus.ads.common.serialization.asm.Type.getType(ASMUtils.desc(object2)));
                        methodVisitor.visitLdcInsn(fieldInfo.serialzeFeatures);
                        methodVisitor.visitMethodInsn(185, ObjectSerializer, "write", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
                        methodVisitor.visitLabel(label6);
                        methodVisitor.visitJumpInsn(167, label2);
                    }
                    methodVisitor.visitLabel(label4);
                    methodVisitor.visitVarInsn(25, 1);
                    methodVisitor.visitVarInsn(25, context.var("list_item"));
                    if (context.nonContext) {
                        methodVisitor.visitInsn(1);
                    } else {
                        methodVisitor.visitVarInsn(21, context.var("i"));
                        methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                    }
                    if (object2 != null && Modifier.isPublic(((Class)object2).getModifiers())) {
                        methodVisitor.visitLdcInsn(com.tradplus.ads.common.serialization.asm.Type.getType(ASMUtils.desc((Class)object3)));
                        methodVisitor.visitLdcInsn(fieldInfo.serialzeFeatures);
                        methodVisitor.visitMethodInsn(182, JSONSerializer, "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
                    } else {
                        methodVisitor.visitMethodInsn(182, JSONSerializer, "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;)V");
                    }
                    methodVisitor.visitLabel(label2);
                    methodVisitor.visitLabel((Label)object5);
                    methodVisitor.visitIincInsn(context.var("i"), 1);
                    methodVisitor.visitJumpInsn(167, label);
                    methodVisitor.visitLabel((Label)object4);
                    methodVisitor.visitVarInsn(25, context.var("out"));
                    methodVisitor.visitVarInsn(16, 93);
                    methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
                    methodVisitor.visitLabel(label3);
                }
                methodVisitor.visitVarInsn(25, context.var("out"));
                methodVisitor.visitVarInsn(16, n2);
                methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
                continue;
            }
            object4 = new Label();
            object3 = new Label();
            this._get(methodVisitor, context, fieldInfo);
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(58, context.var("field_" + fieldInfo.fieldClass.getName()));
            methodVisitor.visitJumpInsn(199, (Label)object3);
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitMethodInsn(182, SerializeWriter, "writeNull", "()V");
            methodVisitor.visitJumpInsn(167, (Label)object4);
            methodVisitor.visitLabel((Label)object3);
            object2 = new Label();
            label3 = new Label();
            methodVisitor.visitVarInsn(25, context.var("field_" + fieldInfo.fieldClass.getName()));
            methodVisitor.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
            methodVisitor.visitLdcInsn(com.tradplus.ads.common.serialization.asm.Type.getType(ASMUtils.desc(object5)));
            methodVisitor.visitJumpInsn(166, label3);
            this._getFieldSer(context, methodVisitor, fieldInfo);
            methodVisitor.visitVarInsn(58, context.var("fied_ser"));
            label2 = new Label();
            label = new Label();
            if (context.writeDirect && Modifier.isPublic(((Class)object5).getModifiers())) {
                methodVisitor.visitVarInsn(25, context.var("fied_ser"));
                methodVisitor.visitTypeInsn(193, JavaBeanSerializer);
                methodVisitor.visitJumpInsn(153, label2);
                methodVisitor.visitVarInsn(25, context.var("fied_ser"));
                methodVisitor.visitTypeInsn(192, JavaBeanSerializer);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitVarInsn(25, context.var("field_" + fieldInfo.fieldClass.getName()));
                methodVisitor.visitVarInsn(25, Context.fieldName);
                methodVisitor.visitLdcInsn(com.tradplus.ads.common.serialization.asm.Type.getType(ASMUtils.desc(object5)));
                methodVisitor.visitLdcInsn(fieldInfo.serialzeFeatures);
                methodVisitor.visitMethodInsn(182, JavaBeanSerializer, "writeAsArrayNonContext", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
                methodVisitor.visitJumpInsn(167, label);
                methodVisitor.visitLabel(label2);
            }
            methodVisitor.visitVarInsn(25, context.var("fied_ser"));
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, context.var("field_" + fieldInfo.fieldClass.getName()));
            methodVisitor.visitVarInsn(25, Context.fieldName);
            methodVisitor.visitLdcInsn(com.tradplus.ads.common.serialization.asm.Type.getType(ASMUtils.desc(object5)));
            methodVisitor.visitLdcInsn(fieldInfo.serialzeFeatures);
            methodVisitor.visitMethodInsn(185, ObjectSerializer, "write", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
            methodVisitor.visitLabel(label);
            methodVisitor.visitJumpInsn(167, (Label)object2);
            methodVisitor.visitLabel(label3);
            object5 = fieldInfo.getFormat();
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, context.var("field_" + fieldInfo.fieldClass.getName()));
            if (object5 != null) {
                methodVisitor.visitLdcInsn(object5);
                methodVisitor.visitMethodInsn(182, JSONSerializer, "writeWithFormat", "(Ljava/lang/Object;Ljava/lang/String;)V");
            } else {
                methodVisitor.visitVarInsn(25, Context.fieldName);
                if (fieldInfo.fieldType instanceof Class && ((Class)fieldInfo.fieldType).isPrimitive()) {
                    methodVisitor.visitMethodInsn(182, JSONSerializer, "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;)V");
                } else {
                    methodVisitor.visitVarInsn(25, 0);
                    methodVisitor.visitFieldInsn(180, context.className, fieldInfo.name + "_asm_fieldType", "Ljava/lang/reflect/Type;");
                    methodVisitor.visitLdcInsn(fieldInfo.serialzeFeatures);
                    methodVisitor.visitMethodInsn(182, JSONSerializer, "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
                }
            }
            methodVisitor.visitLabel((Label)object2);
            methodVisitor.visitLabel((Label)object4);
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitVarInsn(16, n2);
            methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
        }
    }

    private void generateWriteMethod(Class<?> clazz, MethodVisitor methodVisitor, FieldInfo[] fieldInfoArray, Context context) {
        boolean bl;
        Object object;
        Label label;
        Object object2;
        Label label2 = new Label();
        int n = fieldInfoArray.length;
        if (!context.writeDirect) {
            object2 = new Label();
            label = new Label();
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitLdcInsn(SerializerFeature.PrettyFormat.mask);
            methodVisitor.visitMethodInsn(182, SerializeWriter, "isEnabled", "(I)Z");
            methodVisitor.visitJumpInsn(154, label);
            boolean bl2 = false;
            object = fieldInfoArray;
            int n2 = fieldInfoArray.length;
            for (int i = 0; i < n2; ++i) {
                if (object[i].method == null) continue;
                bl2 = true;
            }
            if (bl2) {
                methodVisitor.visitVarInsn(25, context.var("out"));
                methodVisitor.visitLdcInsn(SerializerFeature.IgnoreErrorGetter.mask);
                methodVisitor.visitMethodInsn(182, SerializeWriter, "isEnabled", "(I)Z");
                methodVisitor.visitJumpInsn(153, (Label)object2);
            } else {
                methodVisitor.visitJumpInsn(167, (Label)object2);
            }
            methodVisitor.visitLabel(label);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitVarInsn(25, 3);
            methodVisitor.visitVarInsn(25, 4);
            methodVisitor.visitVarInsn(21, 5);
            methodVisitor.visitMethodInsn(183, JavaBeanSerializer, "write", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
            methodVisitor.visitInsn(177);
            methodVisitor.visitLabel((Label)object2);
        }
        if (!context.nonContext) {
            object2 = new Label();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitVarInsn(21, 5);
            methodVisitor.visitMethodInsn(182, JavaBeanSerializer, "writeReference", "(L" + JSONSerializer + ";Ljava/lang/Object;I)Z");
            methodVisitor.visitJumpInsn(153, (Label)object2);
            methodVisitor.visitInsn(177);
            methodVisitor.visitLabel((Label)object2);
        }
        object2 = context.writeDirect ? (context.nonContext ? "writeAsArrayNonContext" : "writeAsArray") : "writeAsArrayNormal";
        if ((((Context)context).beanInfo.features & SerializerFeature.BeanToArray.mask) == 0) {
            label = new Label();
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitLdcInsn(SerializerFeature.BeanToArray.mask);
            methodVisitor.visitMethodInsn(182, SerializeWriter, "isEnabled", "(I)Z");
            methodVisitor.visitJumpInsn(153, label);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitVarInsn(25, 3);
            methodVisitor.visitVarInsn(25, 4);
            methodVisitor.visitVarInsn(21, 5);
            methodVisitor.visitMethodInsn(182, context.className, (String)object2, "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
            methodVisitor.visitInsn(177);
            methodVisitor.visitLabel(label);
        } else {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitVarInsn(25, 3);
            methodVisitor.visitVarInsn(25, 4);
            methodVisitor.visitVarInsn(21, 5);
            methodVisitor.visitMethodInsn(182, context.className, (String)object2, "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
            methodVisitor.visitInsn(177);
        }
        if (!context.nonContext) {
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitMethodInsn(182, JSONSerializer, "getContext", "()" + SerialContext_desc);
            methodVisitor.visitVarInsn(58, context.var("parent"));
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, context.var("parent"));
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitVarInsn(25, 3);
            methodVisitor.visitLdcInsn(((Context)context).beanInfo.features);
            methodVisitor.visitMethodInsn(182, JSONSerializer, "setContext", "(" + SerialContext_desc + "Ljava/lang/Object;Ljava/lang/Object;I)V");
        }
        if ((bl = (((Context)context).beanInfo.features & SerializerFeature.WriteClassName.mask) != 0) || !context.writeDirect) {
            Label label3 = new Label();
            object = new Label();
            Label label4 = new Label();
            if (!bl) {
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitVarInsn(25, 4);
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitMethodInsn(182, JSONSerializer, "isWriteClassName", "(Ljava/lang/reflect/Type;Ljava/lang/Object;)Z");
                methodVisitor.visitJumpInsn(153, (Label)object);
            }
            methodVisitor.visitVarInsn(25, 4);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
            methodVisitor.visitJumpInsn(165, (Label)object);
            methodVisitor.visitLabel(label4);
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitVarInsn(16, 123);
            methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            if (((Context)context).beanInfo.typeKey != null) {
                methodVisitor.visitLdcInsn(((Context)context).beanInfo.typeKey);
            } else {
                methodVisitor.visitInsn(1);
            }
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(182, JavaBeanSerializer, "writeClassName", "(L" + JSONSerializer + ";Ljava/lang/String;Ljava/lang/Object;)V");
            methodVisitor.visitVarInsn(16, 44);
            methodVisitor.visitJumpInsn(167, label3);
            methodVisitor.visitLabel((Label)object);
            methodVisitor.visitVarInsn(16, 123);
            methodVisitor.visitLabel(label3);
        } else {
            methodVisitor.visitVarInsn(16, 123);
        }
        methodVisitor.visitVarInsn(54, context.var("seperator"));
        if (!context.writeDirect) {
            this._before(methodVisitor, context);
        }
        if (!context.writeDirect) {
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitMethodInsn(182, SerializeWriter, "isNotWriteDefaultValue", "()Z");
            methodVisitor.visitVarInsn(54, context.var("notWriteDefaultValue"));
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, JSONSerializer, "checkValue", "(" + SerializeFilterable_desc + ")Z");
            methodVisitor.visitVarInsn(54, context.var("checkValue"));
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, JSONSerializer, "hasNameFilters", "(" + SerializeFilterable_desc + ")Z");
            methodVisitor.visitVarInsn(54, context.var("hasNameFilters"));
        }
        for (int i = 0; i < n; ++i) {
            object = fieldInfoArray[i];
            Class<?> clazz2 = object.fieldClass;
            methodVisitor.visitLdcInsn(object.name);
            methodVisitor.visitVarInsn(58, Context.fieldName);
            if (clazz2 == Byte.TYPE || clazz2 == Short.TYPE || clazz2 == Integer.TYPE) {
                Context context2 = context;
                this._int(clazz, methodVisitor, (FieldInfo)object, context2, context2.var(clazz2.getName()), 'I');
                continue;
            }
            if (clazz2 == Long.TYPE) {
                this._long(clazz, methodVisitor, (FieldInfo)object, context);
                continue;
            }
            if (clazz2 == Float.TYPE) {
                this._float(clazz, methodVisitor, (FieldInfo)object, context);
                continue;
            }
            if (clazz2 == Double.TYPE) {
                this._double(clazz, methodVisitor, (FieldInfo)object, context);
                continue;
            }
            if (clazz2 == Boolean.TYPE) {
                Context context3 = context;
                this._int(clazz, methodVisitor, (FieldInfo)object, context3, context3.var("boolean"), 'Z');
                continue;
            }
            if (clazz2 == Character.TYPE) {
                Context context4 = context;
                this._int(clazz, methodVisitor, (FieldInfo)object, context4, context4.var("char"), 'C');
                continue;
            }
            if (clazz2 == String.class) {
                this._string(clazz, methodVisitor, (FieldInfo)object, context);
                continue;
            }
            if (clazz2 == BigDecimal.class) {
                this._decimal(clazz, methodVisitor, (FieldInfo)object, context);
                continue;
            }
            if (List.class.isAssignableFrom(clazz2)) {
                this._list(clazz, methodVisitor, (FieldInfo)object, context);
                continue;
            }
            if (clazz2.isEnum()) {
                this._enum(clazz, methodVisitor, (FieldInfo)object, context);
                continue;
            }
            this._object(clazz, methodVisitor, (FieldInfo)object, context);
        }
        if (!context.writeDirect) {
            this._after(methodVisitor, context);
        }
        Label label5 = new Label();
        object = new Label();
        methodVisitor.visitVarInsn(21, context.var("seperator"));
        methodVisitor.visitIntInsn(16, 123);
        methodVisitor.visitJumpInsn(160, label5);
        methodVisitor.visitVarInsn(25, context.var("out"));
        methodVisitor.visitVarInsn(16, 123);
        methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
        methodVisitor.visitLabel(label5);
        methodVisitor.visitVarInsn(25, context.var("out"));
        methodVisitor.visitVarInsn(16, 125);
        methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
        methodVisitor.visitLabel((Label)object);
        methodVisitor.visitLabel(label2);
        if (!context.nonContext) {
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, context.var("parent"));
            methodVisitor.visitMethodInsn(182, JSONSerializer, "setContext", "(" + SerialContext_desc + ")V");
        }
    }

    private void _object(Class<?> object, MethodVisitor methodVisitor, FieldInfo fieldInfo, Context context) {
        object = new Label();
        this._nameApply(methodVisitor, fieldInfo, context, (Label)object);
        this._get(methodVisitor, context, fieldInfo);
        methodVisitor.visitVarInsn(58, context.var("object"));
        this._filters(methodVisitor, fieldInfo, context, (Label)object);
        this._writeObject(methodVisitor, fieldInfo, context, (Label)object);
        methodVisitor.visitLabel((Label)object);
    }

    private void _enum(Class<?> object, MethodVisitor methodVisitor, FieldInfo fieldInfo, Context context) {
        object = new Label();
        Label label = new Label();
        Label label2 = new Label();
        this._nameApply(methodVisitor, fieldInfo, context, label2);
        this._get(methodVisitor, context, fieldInfo);
        methodVisitor.visitTypeInsn(192, "java/lang/Enum");
        methodVisitor.visitVarInsn(58, context.var("enum"));
        this._filters(methodVisitor, fieldInfo, context, label2);
        methodVisitor.visitVarInsn(25, context.var("enum"));
        methodVisitor.visitJumpInsn(199, (Label)object);
        this._if_write_null(methodVisitor, fieldInfo, context);
        methodVisitor.visitJumpInsn(167, label);
        methodVisitor.visitLabel((Label)object);
        if (context.writeDirect) {
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitVarInsn(21, context.var("seperator"));
            methodVisitor.visitVarInsn(25, Context.fieldName);
            methodVisitor.visitVarInsn(25, context.var("enum"));
            methodVisitor.visitMethodInsn(182, "java/lang/Enum", "name", "()Ljava/lang/String;");
            methodVisitor.visitMethodInsn(182, SerializeWriter, "writeFieldValueStringWithDoubleQuote", "(CLjava/lang/String;Ljava/lang/String;)V");
        } else {
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitVarInsn(21, context.var("seperator"));
            methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitVarInsn(25, Context.fieldName);
            methodVisitor.visitInsn(3);
            methodVisitor.visitMethodInsn(182, SerializeWriter, "writeFieldName", "(Ljava/lang/String;Z)V");
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, context.var("enum"));
            methodVisitor.visitVarInsn(25, Context.fieldName);
            methodVisitor.visitLdcInsn(com.tradplus.ads.common.serialization.asm.Type.getType(ASMUtils.desc(fieldInfo.fieldClass)));
            methodVisitor.visitLdcInsn(fieldInfo.serialzeFeatures);
            methodVisitor.visitMethodInsn(182, JSONSerializer, "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
        }
        this._seperator(methodVisitor, context);
        methodVisitor.visitLabel(label);
        methodVisitor.visitLabel(label2);
    }

    private void _int(Class<?> object, MethodVisitor methodVisitor, FieldInfo fieldInfo, Context context, int n, char c) {
        object = new Label();
        this._nameApply(methodVisitor, fieldInfo, context, (Label)object);
        this._get(methodVisitor, context, fieldInfo);
        methodVisitor.visitVarInsn(54, n);
        this._filters(methodVisitor, fieldInfo, context, (Label)object);
        methodVisitor.visitVarInsn(25, context.var("out"));
        methodVisitor.visitVarInsn(21, context.var("seperator"));
        methodVisitor.visitVarInsn(25, Context.fieldName);
        methodVisitor.visitVarInsn(21, n);
        methodVisitor.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;" + c + ")V");
        this._seperator(methodVisitor, context);
        methodVisitor.visitLabel((Label)object);
    }

    private void _long(Class<?> object, MethodVisitor methodVisitor, FieldInfo fieldInfo, Context context) {
        object = new Label();
        this._nameApply(methodVisitor, fieldInfo, context, (Label)object);
        this._get(methodVisitor, context, fieldInfo);
        methodVisitor.visitVarInsn(55, context.var("long", 2));
        this._filters(methodVisitor, fieldInfo, context, (Label)object);
        methodVisitor.visitVarInsn(25, context.var("out"));
        methodVisitor.visitVarInsn(21, context.var("seperator"));
        methodVisitor.visitVarInsn(25, Context.fieldName);
        methodVisitor.visitVarInsn(22, context.var("long", 2));
        methodVisitor.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;J)V");
        this._seperator(methodVisitor, context);
        methodVisitor.visitLabel((Label)object);
    }

    private void _float(Class<?> object, MethodVisitor methodVisitor, FieldInfo fieldInfo, Context context) {
        object = new Label();
        this._nameApply(methodVisitor, fieldInfo, context, (Label)object);
        this._get(methodVisitor, context, fieldInfo);
        methodVisitor.visitVarInsn(56, context.var("float"));
        this._filters(methodVisitor, fieldInfo, context, (Label)object);
        methodVisitor.visitVarInsn(25, context.var("out"));
        methodVisitor.visitVarInsn(21, context.var("seperator"));
        methodVisitor.visitVarInsn(25, Context.fieldName);
        methodVisitor.visitVarInsn(23, context.var("float"));
        methodVisitor.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;F)V");
        this._seperator(methodVisitor, context);
        methodVisitor.visitLabel((Label)object);
    }

    private void _double(Class<?> object, MethodVisitor methodVisitor, FieldInfo fieldInfo, Context context) {
        object = new Label();
        this._nameApply(methodVisitor, fieldInfo, context, (Label)object);
        this._get(methodVisitor, context, fieldInfo);
        methodVisitor.visitVarInsn(57, context.var("double", 2));
        this._filters(methodVisitor, fieldInfo, context, (Label)object);
        methodVisitor.visitVarInsn(25, context.var("out"));
        methodVisitor.visitVarInsn(21, context.var("seperator"));
        methodVisitor.visitVarInsn(25, Context.fieldName);
        methodVisitor.visitVarInsn(24, context.var("double", 2));
        methodVisitor.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;D)V");
        this._seperator(methodVisitor, context);
        methodVisitor.visitLabel((Label)object);
    }

    private void _get(MethodVisitor methodVisitor, Context object, FieldInfo fieldInfo) {
        Method method = fieldInfo.method;
        if (method != null) {
            methodVisitor.visitVarInsn(25, ((Context)object).var("entity"));
            object = method.getDeclaringClass();
            methodVisitor.visitMethodInsn(((Class)object).isInterface() ? 185 : 182, ASMUtils.type(object), method.getName(), ASMUtils.desc(method));
            if (!method.getReturnType().equals(fieldInfo.fieldClass)) {
                methodVisitor.visitTypeInsn(192, ASMUtils.type(fieldInfo.fieldClass));
            }
            return;
        }
        methodVisitor.visitVarInsn(25, ((Context)object).var("entity"));
        object = fieldInfo.field;
        methodVisitor.visitFieldInsn(180, ASMUtils.type(fieldInfo.declaringClass), ((Field)object).getName(), ASMUtils.desc(((Field)object).getType()));
        if (!((Field)object).getType().equals(fieldInfo.fieldClass)) {
            methodVisitor.visitTypeInsn(192, ASMUtils.type(fieldInfo.fieldClass));
        }
    }

    private void _decimal(Class<?> object, MethodVisitor methodVisitor, FieldInfo fieldInfo, Context context) {
        object = new Label();
        this._nameApply(methodVisitor, fieldInfo, context, (Label)object);
        this._get(methodVisitor, context, fieldInfo);
        methodVisitor.visitVarInsn(58, context.var("decimal"));
        this._filters(methodVisitor, fieldInfo, context, (Label)object);
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        methodVisitor.visitLabel(label);
        methodVisitor.visitVarInsn(25, context.var("decimal"));
        methodVisitor.visitJumpInsn(199, label2);
        this._if_write_null(methodVisitor, fieldInfo, context);
        methodVisitor.visitJumpInsn(167, label3);
        methodVisitor.visitLabel(label2);
        methodVisitor.visitVarInsn(25, context.var("out"));
        methodVisitor.visitVarInsn(21, context.var("seperator"));
        methodVisitor.visitVarInsn(25, Context.fieldName);
        methodVisitor.visitVarInsn(25, context.var("decimal"));
        methodVisitor.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;Ljava/math/BigDecimal;)V");
        this._seperator(methodVisitor, context);
        methodVisitor.visitJumpInsn(167, label3);
        methodVisitor.visitLabel(label3);
        methodVisitor.visitLabel((Label)object);
    }

    private void _string(Class<?> object, MethodVisitor methodVisitor, FieldInfo fieldInfo, Context context) {
        object = new Label();
        if (fieldInfo.name.equals(((Context)context).beanInfo.typeKey)) {
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 4);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitMethodInsn(182, JSONSerializer, "isWriteClassName", "(Ljava/lang/reflect/Type;Ljava/lang/Object;)Z");
            methodVisitor.visitJumpInsn(154, (Label)object);
        }
        this._nameApply(methodVisitor, fieldInfo, context, (Label)object);
        this._get(methodVisitor, context, fieldInfo);
        methodVisitor.visitVarInsn(58, context.var("string"));
        this._filters(methodVisitor, fieldInfo, context, (Label)object);
        Label label = new Label();
        Label label2 = new Label();
        methodVisitor.visitVarInsn(25, context.var("string"));
        methodVisitor.visitJumpInsn(199, label);
        this._if_write_null(methodVisitor, fieldInfo, context);
        methodVisitor.visitJumpInsn(167, label2);
        methodVisitor.visitLabel(label);
        if ("trim".equals(fieldInfo.format)) {
            methodVisitor.visitVarInsn(25, context.var("string"));
            methodVisitor.visitMethodInsn(182, "java/lang/String", "trim", "()Ljava/lang/String;");
            methodVisitor.visitVarInsn(58, context.var("string"));
        }
        if (context.writeDirect) {
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitVarInsn(21, context.var("seperator"));
            methodVisitor.visitVarInsn(25, Context.fieldName);
            methodVisitor.visitVarInsn(25, context.var("string"));
            methodVisitor.visitMethodInsn(182, SerializeWriter, "writeFieldValueStringWithDoubleQuoteCheck", "(CLjava/lang/String;Ljava/lang/String;)V");
        } else {
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitVarInsn(21, context.var("seperator"));
            methodVisitor.visitVarInsn(25, Context.fieldName);
            methodVisitor.visitVarInsn(25, context.var("string"));
            methodVisitor.visitMethodInsn(182, SerializeWriter, "writeFieldValue", "(CLjava/lang/String;Ljava/lang/String;)V");
        }
        this._seperator(methodVisitor, context);
        methodVisitor.visitLabel(label2);
        methodVisitor.visitLabel((Label)object);
    }

    private void _list(Class<?> type, MethodVisitor methodVisitor, FieldInfo fieldInfo, Context context) {
        type = TypeUtils.getCollectionItemType(fieldInfo.fieldType);
        Type type2 = null;
        if (type instanceof Class) {
            type2 = type;
        }
        if (type2 == Object.class || type2 == Serializable.class) {
            type2 = null;
        }
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        this._nameApply(methodVisitor, fieldInfo, context, label);
        this._get(methodVisitor, context, fieldInfo);
        methodVisitor.visitTypeInsn(192, "java/util/List");
        methodVisitor.visitVarInsn(58, context.var("list"));
        this._filters(methodVisitor, fieldInfo, context, label);
        methodVisitor.visitVarInsn(25, context.var("list"));
        methodVisitor.visitJumpInsn(199, label2);
        this._if_write_null(methodVisitor, fieldInfo, context);
        methodVisitor.visitJumpInsn(167, label3);
        methodVisitor.visitLabel(label2);
        methodVisitor.visitVarInsn(25, context.var("out"));
        methodVisitor.visitVarInsn(21, context.var("seperator"));
        methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
        this._writeFieldName(methodVisitor, context);
        methodVisitor.visitVarInsn(25, context.var("list"));
        methodVisitor.visitMethodInsn(185, "java/util/List", "size", "()I");
        methodVisitor.visitVarInsn(54, context.var("size"));
        label2 = new Label();
        Label label4 = new Label();
        methodVisitor.visitVarInsn(21, context.var("size"));
        methodVisitor.visitInsn(3);
        methodVisitor.visitJumpInsn(160, label2);
        methodVisitor.visitVarInsn(25, context.var("out"));
        methodVisitor.visitLdcInsn("[]");
        methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(Ljava/lang/String;)V");
        methodVisitor.visitJumpInsn(167, label4);
        methodVisitor.visitLabel(label2);
        if (!context.nonContext) {
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, context.var("list"));
            methodVisitor.visitVarInsn(25, Context.fieldName);
            methodVisitor.visitMethodInsn(182, JSONSerializer, "setContext", "(Ljava/lang/Object;Ljava/lang/Object;)V");
        }
        if (type == String.class && context.writeDirect) {
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitVarInsn(25, context.var("list"));
            methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(Ljava/util/List;)V");
        } else {
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitVarInsn(16, 91);
            methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
            label2 = new Label();
            Label label5 = new Label();
            Label label6 = new Label();
            methodVisitor.visitInsn(3);
            methodVisitor.visitVarInsn(54, context.var("i"));
            methodVisitor.visitLabel(label2);
            methodVisitor.visitVarInsn(21, context.var("i"));
            methodVisitor.visitVarInsn(21, context.var("size"));
            methodVisitor.visitJumpInsn(162, label6);
            methodVisitor.visitVarInsn(21, context.var("i"));
            methodVisitor.visitJumpInsn(153, label5);
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitVarInsn(16, 44);
            methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
            methodVisitor.visitLabel(label5);
            methodVisitor.visitVarInsn(25, context.var("list"));
            methodVisitor.visitVarInsn(21, context.var("i"));
            methodVisitor.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;");
            methodVisitor.visitVarInsn(58, context.var("list_item"));
            label5 = new Label();
            Label label7 = new Label();
            methodVisitor.visitVarInsn(25, context.var("list_item"));
            methodVisitor.visitJumpInsn(199, label7);
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitMethodInsn(182, SerializeWriter, "writeNull", "()V");
            methodVisitor.visitJumpInsn(167, label5);
            methodVisitor.visitLabel(label7);
            label7 = new Label();
            Label label8 = new Label();
            if (type2 != null && Modifier.isPublic(((Class)type2).getModifiers())) {
                methodVisitor.visitVarInsn(25, context.var("list_item"));
                methodVisitor.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
                methodVisitor.visitLdcInsn(com.tradplus.ads.common.serialization.asm.Type.getType(ASMUtils.desc(type2)));
                methodVisitor.visitJumpInsn(166, label8);
                this._getListFieldItemSer(context, methodVisitor, fieldInfo, (Class<?>)type2);
                methodVisitor.visitVarInsn(58, context.var("list_item_desc"));
                Label label9 = new Label();
                Label label10 = new Label();
                if (context.writeDirect) {
                    String string = context.nonContext && context.writeDirect ? "writeDirectNonContext" : "write";
                    methodVisitor.visitVarInsn(25, context.var("list_item_desc"));
                    methodVisitor.visitTypeInsn(193, JavaBeanSerializer);
                    methodVisitor.visitJumpInsn(153, label9);
                    methodVisitor.visitVarInsn(25, context.var("list_item_desc"));
                    methodVisitor.visitTypeInsn(192, JavaBeanSerializer);
                    methodVisitor.visitVarInsn(25, 1);
                    methodVisitor.visitVarInsn(25, context.var("list_item"));
                    if (context.nonContext) {
                        methodVisitor.visitInsn(1);
                    } else {
                        methodVisitor.visitVarInsn(21, context.var("i"));
                        methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                    }
                    methodVisitor.visitLdcInsn(com.tradplus.ads.common.serialization.asm.Type.getType(ASMUtils.desc(type2)));
                    methodVisitor.visitLdcInsn(fieldInfo.serialzeFeatures);
                    methodVisitor.visitMethodInsn(182, JavaBeanSerializer, string, "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
                    methodVisitor.visitJumpInsn(167, label10);
                    methodVisitor.visitLabel(label9);
                }
                methodVisitor.visitVarInsn(25, context.var("list_item_desc"));
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitVarInsn(25, context.var("list_item"));
                if (context.nonContext) {
                    methodVisitor.visitInsn(1);
                } else {
                    methodVisitor.visitVarInsn(21, context.var("i"));
                    methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                }
                methodVisitor.visitLdcInsn(com.tradplus.ads.common.serialization.asm.Type.getType(ASMUtils.desc(type2)));
                methodVisitor.visitLdcInsn(fieldInfo.serialzeFeatures);
                methodVisitor.visitMethodInsn(185, ObjectSerializer, "write", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
                methodVisitor.visitLabel(label10);
                methodVisitor.visitJumpInsn(167, label7);
            }
            methodVisitor.visitLabel(label8);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, context.var("list_item"));
            if (context.nonContext) {
                methodVisitor.visitInsn(1);
            } else {
                methodVisitor.visitVarInsn(21, context.var("i"));
                methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            }
            if (type2 != null && Modifier.isPublic(((Class)type2).getModifiers())) {
                methodVisitor.visitLdcInsn(com.tradplus.ads.common.serialization.asm.Type.getType(ASMUtils.desc((Class)type)));
                methodVisitor.visitLdcInsn(fieldInfo.serialzeFeatures);
                methodVisitor.visitMethodInsn(182, JSONSerializer, "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
            } else {
                methodVisitor.visitMethodInsn(182, JSONSerializer, "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            }
            methodVisitor.visitLabel(label7);
            methodVisitor.visitLabel(label5);
            methodVisitor.visitIincInsn(context.var("i"), 1);
            methodVisitor.visitJumpInsn(167, label2);
            methodVisitor.visitLabel(label6);
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitVarInsn(16, 93);
            methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
        }
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitMethodInsn(182, JSONSerializer, "popContext", "()V");
        methodVisitor.visitLabel(label4);
        this._seperator(methodVisitor, context);
        methodVisitor.visitLabel(label3);
        methodVisitor.visitLabel(label);
    }

    private void _filters(MethodVisitor methodVisitor, FieldInfo fieldInfo, Context context, Label label) {
        if (fieldInfo.fieldTransient) {
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitLdcInsn(SerializerFeature.SkipTransientField.mask);
            methodVisitor.visitMethodInsn(182, SerializeWriter, "isEnabled", "(I)Z");
            methodVisitor.visitJumpInsn(154, label);
        }
        this._notWriteDefault(methodVisitor, fieldInfo, context, label);
        if (context.writeDirect) {
            return;
        }
        this._apply(methodVisitor, fieldInfo, context);
        methodVisitor.visitJumpInsn(153, label);
        this._processKey(methodVisitor, fieldInfo, context);
        this._processValue(methodVisitor, fieldInfo, context, label);
    }

    private void _nameApply(MethodVisitor methodVisitor, FieldInfo fieldInfo, Context context, Label label) {
        if (!context.writeDirect) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, 2);
            methodVisitor.visitVarInsn(25, Context.fieldName);
            methodVisitor.visitMethodInsn(182, JavaBeanSerializer, "applyName", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/String;)Z");
            methodVisitor.visitJumpInsn(153, label);
            this._labelApply(methodVisitor, fieldInfo, context, label);
        }
        if (fieldInfo.field == null) {
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitLdcInsn(SerializerFeature.IgnoreNonFieldGetter.mask);
            methodVisitor.visitMethodInsn(182, SerializeWriter, "isEnabled", "(I)Z");
            methodVisitor.visitJumpInsn(154, label);
        }
    }

    private void _labelApply(MethodVisitor methodVisitor, FieldInfo fieldInfo, Context context, Label label) {
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitLdcInsn(fieldInfo.label);
        methodVisitor.visitMethodInsn(182, JavaBeanSerializer, "applyLabel", "(L" + JSONSerializer + ";Ljava/lang/String;)Z");
        methodVisitor.visitJumpInsn(153, label);
    }

    private void _writeObject(MethodVisitor methodVisitor, FieldInfo fieldInfo, Context context, Label label) {
        String string = fieldInfo.getFormat();
        Object object = fieldInfo.fieldClass;
        Label label2 = new Label();
        if (context.writeDirect) {
            methodVisitor.visitVarInsn(25, context.var("object"));
        } else {
            methodVisitor.visitVarInsn(25, Context.processValue);
        }
        methodVisitor.visitInsn(89);
        methodVisitor.visitVarInsn(58, context.var("object"));
        methodVisitor.visitJumpInsn(199, label2);
        this._if_write_null(methodVisitor, fieldInfo, context);
        methodVisitor.visitJumpInsn(167, label);
        methodVisitor.visitLabel(label2);
        methodVisitor.visitVarInsn(25, context.var("out"));
        methodVisitor.visitVarInsn(21, context.var("seperator"));
        methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
        this._writeFieldName(methodVisitor, context);
        label = new Label();
        label2 = new Label();
        if (Modifier.isPublic(((Class)object).getModifiers()) && !ParserConfig.isPrimitive2(object)) {
            boolean bl;
            methodVisitor.visitVarInsn(25, context.var("object"));
            methodVisitor.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
            methodVisitor.visitLdcInsn(com.tradplus.ads.common.serialization.asm.Type.getType(ASMUtils.desc(object)));
            methodVisitor.visitJumpInsn(166, label2);
            this._getFieldSer(context, methodVisitor, fieldInfo);
            methodVisitor.visitVarInsn(58, context.var("fied_ser"));
            object = new Label();
            Label label3 = new Label();
            methodVisitor.visitVarInsn(25, context.var("fied_ser"));
            methodVisitor.visitTypeInsn(193, JavaBeanSerializer);
            methodVisitor.visitJumpInsn(153, (Label)object);
            boolean bl2 = (fieldInfo.serialzeFeatures & SerializerFeature.DisableCircularReferenceDetect.mask) != 0;
            boolean bl3 = bl = (fieldInfo.serialzeFeatures & SerializerFeature.BeanToArray.mask) != 0;
            String string2 = bl2 || context.nonContext && context.writeDirect ? (bl ? "writeAsArrayNonContext" : "writeDirectNonContext") : (bl ? "writeAsArray" : "write");
            methodVisitor.visitVarInsn(25, context.var("fied_ser"));
            methodVisitor.visitTypeInsn(192, JavaBeanSerializer);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, context.var("object"));
            methodVisitor.visitVarInsn(25, Context.fieldName);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, context.className, fieldInfo.name + "_asm_fieldType", "Ljava/lang/reflect/Type;");
            methodVisitor.visitLdcInsn(fieldInfo.serialzeFeatures);
            methodVisitor.visitMethodInsn(182, JavaBeanSerializer, string2, "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
            methodVisitor.visitJumpInsn(167, label3);
            methodVisitor.visitLabel((Label)object);
            methodVisitor.visitVarInsn(25, context.var("fied_ser"));
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(25, context.var("object"));
            methodVisitor.visitVarInsn(25, Context.fieldName);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, context.className, fieldInfo.name + "_asm_fieldType", "Ljava/lang/reflect/Type;");
            methodVisitor.visitLdcInsn(fieldInfo.serialzeFeatures);
            methodVisitor.visitMethodInsn(185, ObjectSerializer, "write", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
            methodVisitor.visitLabel(label3);
            methodVisitor.visitJumpInsn(167, label);
        }
        methodVisitor.visitLabel(label2);
        methodVisitor.visitVarInsn(25, 1);
        if (context.writeDirect) {
            methodVisitor.visitVarInsn(25, context.var("object"));
        } else {
            methodVisitor.visitVarInsn(25, Context.processValue);
        }
        if (string != null) {
            methodVisitor.visitLdcInsn(string);
            methodVisitor.visitMethodInsn(182, JSONSerializer, "writeWithFormat", "(Ljava/lang/Object;Ljava/lang/String;)V");
        } else {
            methodVisitor.visitVarInsn(25, Context.fieldName);
            if (fieldInfo.fieldType instanceof Class && ((Class)fieldInfo.fieldType).isPrimitive()) {
                methodVisitor.visitMethodInsn(182, JSONSerializer, "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;)V");
            } else {
                if (fieldInfo.fieldClass == String.class) {
                    methodVisitor.visitLdcInsn(com.tradplus.ads.common.serialization.asm.Type.getType(ASMUtils.desc(String.class)));
                } else {
                    methodVisitor.visitVarInsn(25, 0);
                    methodVisitor.visitFieldInsn(180, context.className, fieldInfo.name + "_asm_fieldType", "Ljava/lang/reflect/Type;");
                }
                methodVisitor.visitLdcInsn(fieldInfo.serialzeFeatures);
                methodVisitor.visitMethodInsn(182, JSONSerializer, "writeWithFieldName", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;I)V");
            }
        }
        methodVisitor.visitLabel(label);
        this._seperator(methodVisitor, context);
    }

    private void _before(MethodVisitor methodVisitor, Context context) {
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(21, context.var("seperator"));
        methodVisitor.visitMethodInsn(182, JavaBeanSerializer, "writeBefore", "(L" + JSONSerializer + ";Ljava/lang/Object;C)C");
        methodVisitor.visitVarInsn(54, context.var("seperator"));
    }

    private void _after(MethodVisitor methodVisitor, Context context) {
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(21, context.var("seperator"));
        methodVisitor.visitMethodInsn(182, JavaBeanSerializer, "writeAfter", "(L" + JSONSerializer + ";Ljava/lang/Object;C)C");
        methodVisitor.visitVarInsn(54, context.var("seperator"));
    }

    private void _notWriteDefault(MethodVisitor methodVisitor, FieldInfo object, Context context, Label label) {
        if (context.writeDirect) {
            return;
        }
        Label label2 = new Label();
        methodVisitor.visitVarInsn(21, context.var("notWriteDefaultValue"));
        methodVisitor.visitJumpInsn(153, label2);
        object = ((FieldInfo)object).fieldClass;
        if (object == Boolean.TYPE) {
            methodVisitor.visitVarInsn(21, context.var("boolean"));
            methodVisitor.visitJumpInsn(153, label);
        } else if (object == Byte.TYPE) {
            methodVisitor.visitVarInsn(21, context.var("byte"));
            methodVisitor.visitJumpInsn(153, label);
        } else if (object == Short.TYPE) {
            methodVisitor.visitVarInsn(21, context.var("short"));
            methodVisitor.visitJumpInsn(153, label);
        } else if (object == Integer.TYPE) {
            methodVisitor.visitVarInsn(21, context.var("int"));
            methodVisitor.visitJumpInsn(153, label);
        } else if (object == Long.TYPE) {
            methodVisitor.visitVarInsn(22, context.var("long"));
            methodVisitor.visitInsn(9);
            methodVisitor.visitInsn(148);
            methodVisitor.visitJumpInsn(153, label);
        } else if (object == Float.TYPE) {
            methodVisitor.visitVarInsn(23, context.var("float"));
            methodVisitor.visitInsn(11);
            methodVisitor.visitInsn(149);
            methodVisitor.visitJumpInsn(153, label);
        } else if (object == Double.TYPE) {
            methodVisitor.visitVarInsn(24, context.var("double"));
            methodVisitor.visitInsn(14);
            methodVisitor.visitInsn(151);
            methodVisitor.visitJumpInsn(153, label);
        }
        methodVisitor.visitLabel(label2);
    }

    private void _apply(MethodVisitor methodVisitor, FieldInfo object, Context context) {
        object = ((FieldInfo)object).fieldClass;
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(25, Context.fieldName);
        if (object == Byte.TYPE) {
            methodVisitor.visitVarInsn(21, context.var("byte"));
            methodVisitor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
        } else if (object == Short.TYPE) {
            methodVisitor.visitVarInsn(21, context.var("short"));
            methodVisitor.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
        } else if (object == Integer.TYPE) {
            methodVisitor.visitVarInsn(21, context.var("int"));
            methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        } else if (object == Character.TYPE) {
            methodVisitor.visitVarInsn(21, context.var("char"));
            methodVisitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
        } else if (object == Long.TYPE) {
            methodVisitor.visitVarInsn(22, context.var("long", 2));
            methodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        } else if (object == Float.TYPE) {
            methodVisitor.visitVarInsn(23, context.var("float"));
            methodVisitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
        } else if (object == Double.TYPE) {
            methodVisitor.visitVarInsn(24, context.var("double", 2));
            methodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        } else if (object == Boolean.TYPE) {
            methodVisitor.visitVarInsn(21, context.var("boolean"));
            methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
        } else if (object == BigDecimal.class) {
            methodVisitor.visitVarInsn(25, context.var("decimal"));
        } else if (object == String.class) {
            methodVisitor.visitVarInsn(25, context.var("string"));
        } else if (((Class)object).isEnum()) {
            methodVisitor.visitVarInsn(25, context.var("enum"));
        } else if (List.class.isAssignableFrom((Class<?>)object)) {
            methodVisitor.visitVarInsn(25, context.var("list"));
        } else {
            methodVisitor.visitVarInsn(25, context.var("object"));
        }
        methodVisitor.visitMethodInsn(182, JavaBeanSerializer, "apply", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Z");
    }

    private void _processValue(MethodVisitor methodVisitor, FieldInfo fieldInfo, Context context, Label label) {
        Object object;
        Label label2 = new Label();
        Class<?> clazz = fieldInfo.fieldClass;
        if (clazz.isPrimitive()) {
            object = new Label();
            methodVisitor.visitVarInsn(21, context.var("checkValue"));
            methodVisitor.visitJumpInsn(154, (Label)object);
            methodVisitor.visitInsn(1);
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(58, Context.original);
            methodVisitor.visitVarInsn(58, Context.processValue);
            methodVisitor.visitJumpInsn(167, label2);
            methodVisitor.visitLabel((Label)object);
        }
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitLdcInsn(context.getFieldOrinal(fieldInfo.name));
        methodVisitor.visitMethodInsn(182, JavaBeanSerializer, "getBeanContext", "(I)" + ASMUtils.desc(BeanContext.class));
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(25, Context.fieldName);
        object = "Ljava/lang/Object;";
        if (clazz == Byte.TYPE) {
            methodVisitor.visitVarInsn(21, context.var("byte"));
            methodVisitor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(58, Context.original);
        } else if (clazz == Short.TYPE) {
            methodVisitor.visitVarInsn(21, context.var("short"));
            methodVisitor.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(58, Context.original);
        } else if (clazz == Integer.TYPE) {
            methodVisitor.visitVarInsn(21, context.var("int"));
            methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(58, Context.original);
        } else if (clazz == Character.TYPE) {
            methodVisitor.visitVarInsn(21, context.var("char"));
            methodVisitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(58, Context.original);
        } else if (clazz == Long.TYPE) {
            methodVisitor.visitVarInsn(22, context.var("long", 2));
            methodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(58, Context.original);
        } else if (clazz == Float.TYPE) {
            methodVisitor.visitVarInsn(23, context.var("float"));
            methodVisitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(58, Context.original);
        } else if (clazz == Double.TYPE) {
            methodVisitor.visitVarInsn(24, context.var("double", 2));
            methodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(58, Context.original);
        } else if (clazz == Boolean.TYPE) {
            methodVisitor.visitVarInsn(21, context.var("boolean"));
            methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
            methodVisitor.visitInsn(89);
            methodVisitor.visitVarInsn(58, Context.original);
        } else if (clazz == BigDecimal.class) {
            methodVisitor.visitVarInsn(25, context.var("decimal"));
            methodVisitor.visitVarInsn(58, Context.original);
            methodVisitor.visitVarInsn(25, Context.original);
        } else if (clazz == String.class) {
            methodVisitor.visitVarInsn(25, context.var("string"));
            methodVisitor.visitVarInsn(58, Context.original);
            methodVisitor.visitVarInsn(25, Context.original);
        } else if (clazz.isEnum()) {
            methodVisitor.visitVarInsn(25, context.var("enum"));
            methodVisitor.visitVarInsn(58, Context.original);
            methodVisitor.visitVarInsn(25, Context.original);
        } else if (List.class.isAssignableFrom(clazz)) {
            methodVisitor.visitVarInsn(25, context.var("list"));
            methodVisitor.visitVarInsn(58, Context.original);
            methodVisitor.visitVarInsn(25, Context.original);
        } else {
            methodVisitor.visitVarInsn(25, context.var("object"));
            methodVisitor.visitVarInsn(58, Context.original);
            methodVisitor.visitVarInsn(25, Context.original);
        }
        methodVisitor.visitMethodInsn(182, JavaBeanSerializer, "processValue", "(L" + JSONSerializer + ";" + ASMUtils.desc(BeanContext.class) + "Ljava/lang/Object;Ljava/lang/String;" + (String)object + ")Ljava/lang/Object;");
        methodVisitor.visitVarInsn(58, Context.processValue);
        methodVisitor.visitVarInsn(25, Context.original);
        methodVisitor.visitVarInsn(25, Context.processValue);
        methodVisitor.visitJumpInsn(165, label2);
        this._writeObject(methodVisitor, fieldInfo, context, label);
        methodVisitor.visitJumpInsn(167, label);
        methodVisitor.visitLabel(label2);
    }

    private void _processKey(MethodVisitor methodVisitor, FieldInfo object, Context context) {
        Label label = new Label();
        methodVisitor.visitVarInsn(21, context.var("hasNameFilters"));
        methodVisitor.visitJumpInsn(153, label);
        object = ((FieldInfo)object).fieldClass;
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 2);
        methodVisitor.visitVarInsn(25, Context.fieldName);
        if (object == Byte.TYPE) {
            methodVisitor.visitVarInsn(21, context.var("byte"));
            methodVisitor.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
        } else if (object == Short.TYPE) {
            methodVisitor.visitVarInsn(21, context.var("short"));
            methodVisitor.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
        } else if (object == Integer.TYPE) {
            methodVisitor.visitVarInsn(21, context.var("int"));
            methodVisitor.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        } else if (object == Character.TYPE) {
            methodVisitor.visitVarInsn(21, context.var("char"));
            methodVisitor.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
        } else if (object == Long.TYPE) {
            methodVisitor.visitVarInsn(22, context.var("long", 2));
            methodVisitor.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        } else if (object == Float.TYPE) {
            methodVisitor.visitVarInsn(23, context.var("float"));
            methodVisitor.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
        } else if (object == Double.TYPE) {
            methodVisitor.visitVarInsn(24, context.var("double", 2));
            methodVisitor.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
        } else if (object == Boolean.TYPE) {
            methodVisitor.visitVarInsn(21, context.var("boolean"));
            methodVisitor.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
        } else if (object == BigDecimal.class) {
            methodVisitor.visitVarInsn(25, context.var("decimal"));
        } else if (object == String.class) {
            methodVisitor.visitVarInsn(25, context.var("string"));
        } else if (((Class)object).isEnum()) {
            methodVisitor.visitVarInsn(25, context.var("enum"));
        } else if (List.class.isAssignableFrom((Class<?>)object)) {
            methodVisitor.visitVarInsn(25, context.var("list"));
        } else {
            methodVisitor.visitVarInsn(25, context.var("object"));
        }
        methodVisitor.visitMethodInsn(182, JavaBeanSerializer, "processKey", "(L" + JSONSerializer + ";Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;");
        methodVisitor.visitVarInsn(58, Context.fieldName);
        methodVisitor.visitLabel(label);
    }

    private void _if_write_null(MethodVisitor methodVisitor, FieldInfo object, Context context) {
        int n;
        Class<?> clazz = ((FieldInfo)object).fieldClass;
        Label label = new Label();
        Label label2 = new Label();
        Label label3 = new Label();
        Label label4 = new Label();
        methodVisitor.visitLabel(label);
        object = ((FieldInfo)object).getAnnotation();
        int n2 = 0;
        if (object != null) {
            n2 = SerializerFeature.of(object.serialzeFeatures());
        }
        if ((object = ((Context)context).beanInfo.jsonType) != null) {
            n2 |= SerializerFeature.of(object.serialzeFeatures());
        }
        if ((n2 & (n = clazz == String.class ? SerializerFeature.WriteMapNullValue.getMask() | SerializerFeature.WriteNullStringAsEmpty.getMask() : (Number.class.isAssignableFrom(clazz) ? SerializerFeature.WriteMapNullValue.getMask() | SerializerFeature.WriteNullNumberAsZero.getMask() : (Collection.class.isAssignableFrom(clazz) ? SerializerFeature.WriteMapNullValue.getMask() | SerializerFeature.WriteNullListAsEmpty.getMask() : (Boolean.class == clazz ? SerializerFeature.WriteMapNullValue.getMask() | SerializerFeature.WriteNullBooleanAsFalse.getMask() : SerializerFeature.WRITE_MAP_NULL_FEATURES))))) == 0) {
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitLdcInsn(n);
            methodVisitor.visitMethodInsn(182, SerializeWriter, "isEnabled", "(I)Z");
            methodVisitor.visitJumpInsn(153, label2);
        }
        methodVisitor.visitLabel(label3);
        methodVisitor.visitVarInsn(25, context.var("out"));
        methodVisitor.visitVarInsn(21, context.var("seperator"));
        methodVisitor.visitMethodInsn(182, SerializeWriter, "write", "(I)V");
        this._writeFieldName(methodVisitor, context);
        methodVisitor.visitVarInsn(25, context.var("out"));
        methodVisitor.visitLdcInsn(n2);
        if (clazz == String.class || clazz == Character.class) {
            methodVisitor.visitLdcInsn(SerializerFeature.WriteNullStringAsEmpty.mask);
        } else if (Number.class.isAssignableFrom(clazz)) {
            methodVisitor.visitLdcInsn(SerializerFeature.WriteNullNumberAsZero.mask);
        } else if (clazz == Boolean.class) {
            methodVisitor.visitLdcInsn(SerializerFeature.WriteNullBooleanAsFalse.mask);
        } else if (Collection.class.isAssignableFrom(clazz) || clazz.isArray()) {
            methodVisitor.visitLdcInsn(SerializerFeature.WriteNullListAsEmpty.mask);
        } else {
            methodVisitor.visitLdcInsn(0);
        }
        methodVisitor.visitMethodInsn(182, SerializeWriter, "writeNull", "(II)V");
        this._seperator(methodVisitor, context);
        methodVisitor.visitJumpInsn(167, label4);
        methodVisitor.visitLabel(label2);
        methodVisitor.visitLabel(label4);
    }

    private void _writeFieldName(MethodVisitor methodVisitor, Context context) {
        if (context.writeDirect) {
            methodVisitor.visitVarInsn(25, context.var("out"));
            methodVisitor.visitVarInsn(25, Context.fieldName);
            methodVisitor.visitMethodInsn(182, SerializeWriter, "writeFieldNameDirect", "(Ljava/lang/String;)V");
            return;
        }
        methodVisitor.visitVarInsn(25, context.var("out"));
        methodVisitor.visitVarInsn(25, Context.fieldName);
        methodVisitor.visitInsn(3);
        methodVisitor.visitMethodInsn(182, SerializeWriter, "writeFieldName", "(Ljava/lang/String;Z)V");
    }

    private void _seperator(MethodVisitor methodVisitor, Context context) {
        methodVisitor.visitVarInsn(16, 44);
        methodVisitor.visitVarInsn(54, context.var("seperator"));
    }

    private void _getListFieldItemSer(Context context, MethodVisitor methodVisitor, FieldInfo fieldInfo, Class<?> clazz) {
        Label label = new Label();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, context.className, fieldInfo.name + "_asm_list_item_ser_", ObjectSerializer_desc);
        methodVisitor.visitJumpInsn(199, label);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitLdcInsn(com.tradplus.ads.common.serialization.asm.Type.getType(ASMUtils.desc(clazz)));
        methodVisitor.visitMethodInsn(182, JSONSerializer, "getObjectWriter", "(Ljava/lang/Class;)" + ObjectSerializer_desc);
        methodVisitor.visitFieldInsn(181, context.className, fieldInfo.name + "_asm_list_item_ser_", ObjectSerializer_desc);
        methodVisitor.visitLabel(label);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, context.className, fieldInfo.name + "_asm_list_item_ser_", ObjectSerializer_desc);
    }

    private void _getFieldSer(Context context, MethodVisitor methodVisitor, FieldInfo fieldInfo) {
        Label label = new Label();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, context.className, fieldInfo.name + "_asm_ser_", ObjectSerializer_desc);
        methodVisitor.visitJumpInsn(199, label);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitLdcInsn(com.tradplus.ads.common.serialization.asm.Type.getType(ASMUtils.desc(fieldInfo.fieldClass)));
        methodVisitor.visitMethodInsn(182, JSONSerializer, "getObjectWriter", "(Ljava/lang/Class;)" + ObjectSerializer_desc);
        methodVisitor.visitFieldInsn(181, context.className, fieldInfo.name + "_asm_ser_", ObjectSerializer_desc);
        methodVisitor.visitLabel(label);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, context.className, fieldInfo.name + "_asm_ser_", ObjectSerializer_desc);
    }

    static class Context {
        static final int serializer = 1;
        static final int obj = 2;
        static final int paramFieldName = 3;
        static final int paramFieldType = 4;
        static final int features = 5;
        static int fieldName = 6;
        static int original = 7;
        static int processValue = 8;
        private final FieldInfo[] getters;
        private final String className;
        private final SerializeBeanInfo beanInfo;
        private final boolean writeDirect;
        private Map<String, Integer> variants = new HashMap<String, Integer>();
        private int variantIndex = 9;
        private final boolean nonContext;

        public Context(FieldInfo[] fieldInfoArray, SerializeBeanInfo serializeBeanInfo, String string, boolean bl, boolean bl2) {
            this.getters = fieldInfoArray;
            this.className = string;
            this.beanInfo = serializeBeanInfo;
            this.writeDirect = bl;
            this.nonContext = bl2 || serializeBeanInfo.beanType.isEnum();
        }

        public int var(String string) {
            if (this.variants.get(string) == null) {
                this.variants.put(string, this.variantIndex++);
            }
            return this.variants.get(string);
        }

        public int var(String string, int n) {
            if (this.variants.get(string) == null) {
                this.variants.put(string, this.variantIndex);
                this.variantIndex += n;
            }
            return this.variants.get(string);
        }

        public int getFieldOrinal(String string) {
            int n = -1;
            int n2 = this.getters.length;
            for (int i = 0; i < n2; ++i) {
                if (!this.getters[i].name.equals(string)) continue;
                n = i;
                break;
            }
            return n;
        }
    }
}

