/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;

public class BigDecimalCodec
implements ObjectDeserializer,
ObjectSerializer {
    static final BigDecimal LOW = BigDecimal.valueOf(-9007199254740991L);
    static final BigDecimal HIGH = BigDecimal.valueOf(0x1FFFFFFFFFFFFFL);
    public static final BigDecimalCodec instance = new BigDecimalCodec();

    @Override
    public void write(JSONSerializer object, Object object2, Object object3, Type type, int n) {
        object = ((JSONSerializer)object).out;
        if (object2 == null) {
            ((SerializeWriter)object).writeNull(SerializerFeature.WriteNullNumberAsZero);
            return;
        }
        object2 = (BigDecimal)object2;
        int n2 = ((BigDecimal)object2).scale();
        String string = SerializerFeature.isEnabled(n, ((SerializeWriter)object).features, SerializerFeature.WriteBigDecimalAsPlain) && n2 >= -100 && n2 < 100 ? ((BigDecimal)object2).toPlainString() : ((BigDecimal)object2).toString();
        if (n2 == 0 && string.length() >= 16 && SerializerFeature.isEnabled(n, ((SerializeWriter)object).features, SerializerFeature.BrowserCompatible) && (((BigDecimal)object2).compareTo(LOW) < 0 || ((BigDecimal)object2).compareTo(HIGH) > 0)) {
            ((SerializeWriter)object).writeString(string);
            return;
        }
        ((SerializeWriter)object).write(string);
        if (((SerializeWriter)object).isEnabled(SerializerFeature.WriteClassName) && type != BigDecimal.class && ((BigDecimal)object2).scale() == 0) {
            ((SerializeWriter)object).write(46);
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        try {
            return BigDecimalCodec.deserialze(defaultJSONParser);
        }
        catch (Exception exception) {
            throw new JSONException("parseDecimal error, field : ".concat(String.valueOf(object)), exception);
        }
    }

    public static <T> T deserialze(DefaultJSONParser object) {
        JSONLexer jSONLexer = ((DefaultJSONParser)object).lexer;
        if (jSONLexer.token() == 2) {
            object = jSONLexer.decimalValue();
            jSONLexer.nextToken(16);
            return (T)object;
        }
        if (jSONLexer.token() == 3) {
            object = jSONLexer.decimalValue();
            jSONLexer.nextToken(16);
            return (T)object;
        }
        if ((object = ((DefaultJSONParser)object).parse()) == null) {
            return null;
        }
        return (T)TypeUtils.castToBigDecimal(object);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

