/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicBoolean;

public class BooleanCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static final BooleanCodec instance = new BooleanCodec();

    @Override
    public void write(JSONSerializer object, Object object2, Object object3, Type type, int n) {
        object = ((JSONSerializer)object).out;
        if ((object2 = (Boolean)object2) == null) {
            ((SerializeWriter)object).writeNull(SerializerFeature.WriteNullBooleanAsFalse);
            return;
        }
        if (((Boolean)object2).booleanValue()) {
            ((SerializeWriter)object).write("true");
            return;
        }
        ((SerializeWriter)object).write("false");
    }

    @Override
    public <T> T deserialze(DefaultJSONParser object, Type type, Object object2) {
        JSONLexer jSONLexer = ((DefaultJSONParser)object).lexer;
        try {
            if (jSONLexer.token() == 6) {
                jSONLexer.nextToken(16);
                object = Boolean.TRUE;
            } else if (jSONLexer.token() == 7) {
                jSONLexer.nextToken(16);
                object = Boolean.FALSE;
            } else if (jSONLexer.token() == 2) {
                int n = jSONLexer.intValue();
                jSONLexer.nextToken(16);
                object = n == 1 ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if ((object = ((DefaultJSONParser)object).parse()) == null) {
                    return null;
                }
                object = TypeUtils.castToBoolean(object);
            }
        }
        catch (Exception exception) {
            throw new JSONException("parseBoolean error, field : ".concat(String.valueOf(object2)), exception);
        }
        if (type == AtomicBoolean.class) {
            return (T)new AtomicBoolean((Boolean)object);
        }
        return (T)object;
    }

    @Override
    public int getFastMatchToken() {
        return 6;
    }
}

