/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.JSONLexerBase;
import com.tradplus.ads.common.serialization.parser.JSONScanner;
import com.tradplus.ads.common.serialization.parser.deserializer.AbstractDateDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.IOUtils;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.io.Writer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class DateCodec
extends AbstractDateDeserializer
implements ObjectDeserializer,
ObjectSerializer {
    public static final DateCodec instance = new DateCodec();

    @Override
    public void write(JSONSerializer object, Object object2, Object object3, Type type, int n) {
        int n2;
        long l;
        object3 = ((JSONSerializer)object).out;
        if (object2 == null) {
            ((SerializeWriter)object3).writeNull();
            return;
        }
        Class<?> clazz = object2.getClass();
        if (clazz == Date.class && ((l = ((Date)object2).getTime()) + (long)(n2 = ((JSONSerializer)object).timeZone.getOffset(l))) % 86400000L == 0L && !SerializerFeature.isEnabled(((SerializeWriter)object3).features, n, SerializerFeature.WriteClassName)) {
            ((SerializeWriter)object3).writeString(object2.toString());
            return;
        }
        if (clazz == Time.class) {
            l = ((Time)object2).getTime();
            if ("unixtime".equals(((JSONSerializer)object).getDateFormatPattern())) {
                long l2 = l / 1000L;
                ((SerializeWriter)object3).writeLong(l2);
                return;
            }
            if ("millis".equals(((JSONSerializer)object).getDateFormatPattern())) {
                ((SerializeWriter)object3).writeLong(l);
                return;
            }
            if (l < 86400000L) {
                ((SerializeWriter)object3).writeString(object2.toString());
                return;
            }
        }
        int n3 = 0;
        if (clazz == Timestamp.class) {
            n3 = ((Timestamp)object2).getNanos();
        }
        java.util.Date date = object2 instanceof java.util.Date ? (java.util.Date)object2 : TypeUtils.castToDate(object2);
        if ("unixtime".equals(((JSONSerializer)object).getDateFormatPattern())) {
            long l3 = date.getTime() / 1000L;
            ((SerializeWriter)object3).writeLong(l3);
            return;
        }
        if ("millis".equals(((JSONSerializer)object).getDateFormatPattern())) {
            long l4 = date.getTime();
            ((SerializeWriter)object3).writeLong(l4);
            return;
        }
        if (((SerializeWriter)object3).isEnabled(SerializerFeature.WriteDateUseDateFormat)) {
            DateFormat dateFormat = ((JSONSerializer)object).getDateFormat();
            if (dateFormat == null) {
                String string = ((JSONSerializer)object).getFastJsonConfigDateFormatPattern();
                if (string == null) {
                    string = JSON.DEFFAULT_DATE_FORMAT;
                }
                dateFormat = new SimpleDateFormat(string, ((JSONSerializer)object).locale);
                dateFormat.setTimeZone(((JSONSerializer)object).timeZone);
            }
            String string = dateFormat.format(date);
            ((SerializeWriter)object3).writeString(string);
            return;
        }
        if (((SerializeWriter)object3).isEnabled(SerializerFeature.WriteClassName) && clazz != type) {
            if (clazz == java.util.Date.class) {
                ((SerializeWriter)object3).write("new Date(");
                ((SerializeWriter)object3).writeLong(((java.util.Date)object2).getTime());
                ((SerializeWriter)object3).write(41);
                return;
            }
            ((SerializeWriter)object3).write(123);
            ((SerializeWriter)object3).writeFieldName(JSON.DEFAULT_TYPE_KEY);
            ((JSONSerializer)object).write(clazz.getName());
            ((SerializeWriter)object3).writeFieldValue(',', "val", ((java.util.Date)object2).getTime());
            ((SerializeWriter)object3).write(125);
            return;
        }
        long l5 = date.getTime();
        if (((SerializeWriter)object3).isEnabled(SerializerFeature.UseISO8601DateFormat)) {
            char[] cArray;
            int n4 = ((SerializeWriter)object3).isEnabled(SerializerFeature.UseSingleQuotes) ? 39 : 34;
            ((SerializeWriter)object3).write(n4);
            object = Calendar.getInstance(((JSONSerializer)object).timeZone, ((JSONSerializer)object).locale);
            ((Calendar)object).setTimeInMillis(l5);
            int n5 = ((Calendar)object).get(1);
            n = ((Calendar)object).get(2) + 1;
            int n6 = ((Calendar)object).get(5);
            int n7 = ((Calendar)object).get(11);
            int n8 = ((Calendar)object).get(12);
            int n9 = ((Calendar)object).get(13);
            n2 = ((Calendar)object).get(14);
            if (n3 > 0) {
                cArray = "0000-00-00 00:00:00.000000000".toCharArray();
                IOUtils.getChars(n3, 29, cArray);
                IOUtils.getChars(n9, 19, cArray);
                IOUtils.getChars(n8, 16, cArray);
                IOUtils.getChars(n7, 13, cArray);
                IOUtils.getChars(n6, 10, cArray);
                IOUtils.getChars(n, 7, cArray);
                IOUtils.getChars(n5, 4, cArray);
            } else if (n2 != 0) {
                cArray = "0000-00-00T00:00:00.000".toCharArray();
                IOUtils.getChars(n2, 23, cArray);
                IOUtils.getChars(n9, 19, cArray);
                IOUtils.getChars(n8, 16, cArray);
                IOUtils.getChars(n7, 13, cArray);
                IOUtils.getChars(n6, 10, cArray);
                IOUtils.getChars(n, 7, cArray);
                IOUtils.getChars(n5, 4, cArray);
            } else if (n9 == 0 && n8 == 0 && n7 == 0) {
                cArray = "0000-00-00".toCharArray();
                IOUtils.getChars(n6, 10, cArray);
                IOUtils.getChars(n, 7, cArray);
                IOUtils.getChars(n5, 4, cArray);
            } else {
                cArray = "0000-00-00T00:00:00".toCharArray();
                IOUtils.getChars(n9, 19, cArray);
                IOUtils.getChars(n8, 16, cArray);
                IOUtils.getChars(n7, 13, cArray);
                IOUtils.getChars(n6, 10, cArray);
                IOUtils.getChars(n, 7, cArray);
                IOUtils.getChars(n5, 4, cArray);
            }
            if (n3 > 0) {
                int n10;
                for (n10 = 0; n10 < 9 && cArray[n5 = cArray.length - n10 - 1] == '0'; ++n10) {
                }
                ((SerializeWriter)object3).write(cArray, 0, cArray.length - n10);
                ((SerializeWriter)object3).write(n4);
                return;
            }
            ((Writer)object3).write(cArray);
            float f = (float)((Calendar)object).getTimeZone().getOffset(((Calendar)object).getTimeInMillis()) / 3600000.0f;
            n5 = (int)f;
            if ((double)n5 == 0.0) {
                ((SerializeWriter)object3).write(90);
            } else {
                if (n5 > 9) {
                    ((SerializeWriter)object3).write(43);
                    ((SerializeWriter)object3).writeInt(n5);
                } else if (n5 > 0) {
                    ((SerializeWriter)object3).write(43);
                    ((SerializeWriter)object3).write(48);
                    ((SerializeWriter)object3).writeInt(n5);
                } else if (n5 < -9) {
                    ((SerializeWriter)object3).write(45);
                    ((SerializeWriter)object3).writeInt(-n5);
                } else if (n5 < 0) {
                    ((SerializeWriter)object3).write(45);
                    ((SerializeWriter)object3).write(48);
                    ((SerializeWriter)object3).writeInt(-n5);
                }
                ((SerializeWriter)object3).write(58);
                int n11 = (int)(Math.abs(f - (float)n5) * 60.0f);
                ((SerializeWriter)object3).append(String.format("%02d", n11));
            }
            ((SerializeWriter)object3).write(n4);
            return;
        }
        ((SerializeWriter)object3).writeLong(l5);
    }

    @Override
    public <T> T cast(DefaultJSONParser object, Type object2, Object object3, Object object4) {
        if (object4 == null) {
            return null;
        }
        if (object4 instanceof java.util.Date) {
            return (T)object4;
        }
        if (object4 instanceof BigDecimal) {
            return (T)new java.util.Date(TypeUtils.longValue((BigDecimal)object4));
        }
        if (object4 instanceof Number) {
            return (T)new java.util.Date(((Number)object4).longValue());
        }
        if (object4 instanceof String) {
            TimeZone timeZone;
            object3 = (String)object4;
            if (((String)object3).length() == 0) {
                return null;
            }
            if (((String)object3).length() == 23 && ((String)object3).endsWith(" 000")) {
                object3 = ((String)object3).substring(0, 19);
            }
            object4 = new JSONScanner((String)object3);
            try {
                if (((JSONScanner)object4).scanISO8601DateIfMatch(false)) {
                    object = ((JSONLexerBase)object4).getCalendar();
                    if (object2 == Calendar.class) {
                        return (T)object;
                    }
                    object = ((Calendar)object).getTime();
                    return (T)object;
                }
            }
            finally {
                ((JSONLexerBase)object4).close();
            }
            object4 = ((DefaultJSONParser)object).getDateFomartPattern();
            if (((String)object3).length() == ((String)object4).length() || ((String)object3).length() == 22 && ((String)object4).equals("yyyyMMddHHmmssSSSZ") || ((String)object3).indexOf(84) != -1 && ((String)object4).contains("'T'") && ((String)object3).length() + 2 == ((String)object4).length()) {
                object = ((DefaultJSONParser)object).getDateFormat();
                try {
                    return (T)((DateFormat)object).parse((String)object3);
                }
                catch (ParseException parseException) {}
            }
            if (((String)object3).startsWith("/Date(") && ((String)object3).endsWith(")/")) {
                object3 = ((String)object3).substring(6, ((String)object3).length() - 2);
            }
            if ("0000-00-00".equals(object3) || "0000-00-00T00:00:00".equalsIgnoreCase((String)object3) || "0001-01-01T00:00:00+08:00".equalsIgnoreCase((String)object3)) {
                return null;
            }
            int n = ((String)object3).lastIndexOf(124);
            if (n > 20 && !"GMT".equals((timeZone = TimeZone.getTimeZone(((String)object3).substring(n + 1))).getID())) {
                Object object5 = ((String)object3).substring(0, n);
                object5 = new JSONScanner((String)object5);
                try {
                    if (((JSONScanner)object5).scanISO8601DateIfMatch(false)) {
                        object3 = ((JSONLexerBase)object5).getCalendar();
                        ((Calendar)object3).setTimeZone(timeZone);
                        if (object2 == Calendar.class) {
                            object2 = object3;
                            return (T)object2;
                        }
                        object2 = ((Calendar)object3).getTime();
                        return (T)object2;
                    }
                }
                finally {
                    ((JSONLexerBase)object5).close();
                }
            }
            long l = Long.parseLong((String)object3);
            return (T)new java.util.Date(l);
        }
        throw new JSONException("parse error");
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

