/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import java.lang.reflect.Type;
import java.text.DecimalFormat;

public class DoubleSerializer
implements ObjectSerializer {
    public static final DoubleSerializer instance = new DoubleSerializer();
    private DecimalFormat decimalFormat = null;

    public DoubleSerializer() {
    }

    public DoubleSerializer(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public DoubleSerializer(String string) {
        this(new DecimalFormat(string));
    }

    @Override
    public void write(JSONSerializer object, Object object2, Object object3, Type type, int n) {
        object = ((JSONSerializer)object).out;
        if (object2 == null) {
            ((SerializeWriter)object).writeNull(SerializerFeature.WriteNullNumberAsZero);
            return;
        }
        double d = (Double)object2;
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            ((SerializeWriter)object).writeNull();
            return;
        }
        if (this.decimalFormat == null) {
            ((SerializeWriter)object).writeDouble(d, true);
            return;
        }
        object2 = this.decimalFormat.format(d);
        ((SerializeWriter)object).write((String)object2);
    }
}

