/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class FloatCodec
implements ObjectDeserializer,
ObjectSerializer {
    private NumberFormat decimalFormat;
    public static FloatCodec instance = new FloatCodec();

    public FloatCodec() {
    }

    public FloatCodec(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public FloatCodec(String string) {
        this(new DecimalFormat(string));
    }

    @Override
    public void write(JSONSerializer object, Object object2, Object object3, Type type, int n) {
        object = ((JSONSerializer)object).out;
        if (object2 == null) {
            ((SerializeWriter)object).writeNull(SerializerFeature.WriteNullNumberAsZero);
            return;
        }
        float f = ((Float)object2).floatValue();
        if (this.decimalFormat != null) {
            String string = this.decimalFormat.format(f);
            ((SerializeWriter)object).write(string);
            return;
        }
        ((SerializeWriter)object).writeFloat(f, true);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        try {
            return FloatCodec.deserialze(defaultJSONParser);
        }
        catch (Exception exception) {
            throw new JSONException("parseLong error, field : ".concat(String.valueOf(object)), exception);
        }
    }

    public static <T> T deserialze(DefaultJSONParser object) {
        JSONLexer jSONLexer = ((DefaultJSONParser)object).lexer;
        if (jSONLexer.token() == 2) {
            object = jSONLexer.numberString();
            jSONLexer.nextToken(16);
            return (T)Float.valueOf(Float.parseFloat((String)object));
        }
        if (jSONLexer.token() == 3) {
            float f = jSONLexer.floatValue();
            jSONLexer.nextToken(16);
            return (T)Float.valueOf(f);
        }
        if ((object = ((DefaultJSONParser)object).parse()) == null) {
            return null;
        }
        return (T)TypeUtils.castToFloat(object);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

