/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerialContext;
import com.tradplus.ads.common.serialization.serializer.SerializeConfig;
import com.tradplus.ads.common.serialization.serializer.SerializeFilterable;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.serializer.StringCodec;
import com.tradplus.ads.common.serialization.util.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.GZIPOutputStream;

public class JSONSerializer
extends SerializeFilterable {
    protected final SerializeConfig config;
    public final SerializeWriter out;
    private int indentCount = 0;
    private String indent = "\t";
    private String dateFormatPattern;
    private DateFormat dateFormat;
    private String fastJsonConfigDateFormatPattern;
    protected IdentityHashMap<Object, SerialContext> references = null;
    protected SerialContext context;
    protected TimeZone timeZone = JSON.defaultTimeZone;
    protected Locale locale = JSON.defaultLocale;

    public JSONSerializer() {
        this(new SerializeWriter(), SerializeConfig.getGlobalInstance());
    }

    public JSONSerializer(SerializeWriter serializeWriter) {
        this(serializeWriter, SerializeConfig.getGlobalInstance());
    }

    public JSONSerializer(SerializeConfig serializeConfig) {
        this(new SerializeWriter(), serializeConfig);
    }

    public JSONSerializer(SerializeWriter serializeWriter, SerializeConfig serializeConfig) {
        this.out = serializeWriter;
        this.config = serializeConfig;
    }

    public String getDateFormatPattern() {
        if (this.dateFormat instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)this.dateFormat).toPattern();
        }
        return this.dateFormatPattern;
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null && this.dateFormatPattern != null) {
            this.dateFormat = this.generateDateFormat(this.dateFormatPattern);
        }
        return this.dateFormat;
    }

    private DateFormat generateDateFormat(String object) {
        object = new SimpleDateFormat((String)object, this.locale);
        ((DateFormat)object).setTimeZone(this.timeZone);
        return object;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        if (this.dateFormatPattern != null) {
            this.dateFormatPattern = null;
        }
    }

    public void setDateFormat(String string) {
        this.dateFormatPattern = string;
        if (this.dateFormat != null) {
            this.dateFormat = null;
        }
    }

    public void setFastJsonConfigDateFormatPattern(String string) {
        this.fastJsonConfigDateFormatPattern = string;
    }

    public String getFastJsonConfigDateFormatPattern() {
        return this.fastJsonConfigDateFormatPattern;
    }

    public SerialContext getContext() {
        return this.context;
    }

    public void setContext(SerialContext serialContext) {
        this.context = serialContext;
    }

    public void setContext(SerialContext serialContext, Object object, Object object2, int n) {
        this.setContext(serialContext, object, object2, n, 0);
    }

    public void setContext(SerialContext serialContext, Object object, Object object2, int n, int n2) {
        if (this.out.disableCircularReferenceDetect) {
            return;
        }
        this.context = new SerialContext(serialContext, object, object2, n, n2);
        if (this.references == null) {
            this.references = new IdentityHashMap();
        }
        this.references.put(object, this.context);
    }

    public void setContext(Object object, Object object2) {
        JSONSerializer jSONSerializer = this;
        jSONSerializer.setContext(jSONSerializer.context, object, object2, 0);
    }

    public void popContext() {
        if (this.context != null) {
            this.context = this.context.parent;
        }
    }

    public final boolean isWriteClassName(Type type, Object object) {
        return this.out.isEnabled(SerializerFeature.WriteClassName) && (type != null || !this.out.isEnabled(SerializerFeature.NotWriteRootClassName) || this.context != null && this.context.parent != null);
    }

    public boolean containsReference(Object object) {
        if (this.references == null) {
            return false;
        }
        SerialContext serialContext = this.references.get(object);
        if (serialContext == null) {
            return false;
        }
        if (object == Collections.emptyMap()) {
            return false;
        }
        object = serialContext.fieldName;
        return object == null || object instanceof Integer || object instanceof String;
    }

    public void writeReference(Object object) {
        SerialContext serialContext = this.context;
        Object object2 = serialContext.object;
        if (object == object2) {
            this.out.write("{\"$ref\":\"@\"}");
            return;
        }
        object2 = serialContext.parent;
        if (object2 != null && object == ((SerialContext)object2).object) {
            this.out.write("{\"$ref\":\"..\"}");
            return;
        }
        while (serialContext.parent != null) {
            serialContext = serialContext.parent;
        }
        if (object == serialContext.object) {
            this.out.write("{\"$ref\":\"$\"}");
            return;
        }
        this.out.write("{\"$ref\":\"");
        object = this.references.get(object).toString();
        this.out.write((String)object);
        this.out.write("\"}");
    }

    public boolean checkValue(SerializeFilterable serializeFilterable) {
        return this.valueFilters != null && this.valueFilters.size() > 0 || this.contextValueFilters != null && this.contextValueFilters.size() > 0 || serializeFilterable.valueFilters != null && serializeFilterable.valueFilters.size() > 0 || serializeFilterable.contextValueFilters != null && serializeFilterable.contextValueFilters.size() > 0 || this.out.writeNonStringValueAsString;
    }

    public boolean hasNameFilters(SerializeFilterable serializeFilterable) {
        return this.nameFilters != null && this.nameFilters.size() > 0 || serializeFilterable.nameFilters != null && serializeFilterable.nameFilters.size() > 0;
    }

    public boolean hasPropertyFilters(SerializeFilterable serializeFilterable) {
        return this.propertyFilters != null && this.propertyFilters.size() > 0 || serializeFilterable.propertyFilters != null && serializeFilterable.propertyFilters.size() > 0;
    }

    public int getIndentCount() {
        return this.indentCount;
    }

    public void incrementIndent() {
        ++this.indentCount;
    }

    public void decrementIdent() {
        --this.indentCount;
    }

    public void println() {
        this.out.write(10);
        for (int i = 0; i < this.indentCount; ++i) {
            this.out.write(this.indent);
        }
    }

    public SerializeWriter getWriter() {
        return this.out;
    }

    public String toString() {
        return this.out.toString();
    }

    public void jsonCfg(SerializerFeature serializerFeature, boolean bl) {
        this.out.jsonCfg(serializerFeature, bl);
    }

    public boolean isEnabled(SerializerFeature serializerFeature) {
        return this.out.isEnabled(serializerFeature);
    }

    public void writeNull() {
        this.out.writeNull();
    }

    public SerializeConfig getMapping() {
        return this.config;
    }

    public static void write(Writer writer, Object object) {
        try (SerializeWriter serializeWriter = new SerializeWriter();){
            new JSONSerializer(serializeWriter).write(object);
            serializeWriter.writeTo(writer);
            return;
        }
    }

    public static void write(SerializeWriter serializeWriter, Object object) {
        new JSONSerializer(serializeWriter).write(object);
    }

    public final void write(Object object) {
        if (object == null) {
            this.out.writeNull();
            return;
        }
        Object object2 = object.getClass();
        object2 = this.getObjectWriter((Class<?>)object2);
        try {
            object2.write(this, object, null, null, 0);
            return;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
    }

    public final void writeAs(Object object, Class object2) {
        if (object == null) {
            this.out.writeNull();
            return;
        }
        object2 = this.getObjectWriter((Class<?>)object2);
        try {
            object2.write(this, object, null, null, 0);
            return;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
    }

    public final void writeWithFieldName(Object object, Object object2) {
        this.writeWithFieldName(object, object2, null, 0);
    }

    protected final void writeKeyValue(char c, String string, Object object) {
        if (c != '\u0000') {
            this.out.write(c);
        }
        this.out.writeFieldName(string);
        this.write(object);
    }

    public final void writeWithFieldName(Object object, Object object2, Type type, int n) {
        try {
            if (object == null) {
                this.out.writeNull();
                return;
            }
            Class<?> clazz = object.getClass();
            this.getObjectWriter(clazz).write(this, object, object2, type, n);
            return;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
    }

    public final void writeWithFormat(Object object, String string) {
        if (object instanceof Date) {
            if ("unixtime".equals(string)) {
                long l = ((Date)object).getTime() / 1000L;
                this.out.writeInt((int)l);
                return;
            }
            if ("millis".equals(string)) {
                this.out.writeLong(((Date)object).getTime());
                return;
            }
            DateFormat dateFormat = this.getDateFormat();
            if (dateFormat == null) {
                if (string != null) {
                    try {
                        dateFormat = this.generateDateFormat(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        String string2 = string.replaceAll("T", "'T'");
                        dateFormat = this.generateDateFormat(string2);
                    }
                } else if (this.fastJsonConfigDateFormatPattern != null) {
                    JSONSerializer jSONSerializer = this;
                    dateFormat = jSONSerializer.generateDateFormat(jSONSerializer.fastJsonConfigDateFormatPattern);
                } else {
                    dateFormat = this.generateDateFormat(JSON.DEFFAULT_DATE_FORMAT);
                }
            }
            String string3 = dateFormat.format((Date)object);
            this.out.writeString(string3);
            return;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if ("gzip".equals(string) || "gzip,base64".equals(string)) {
                GZIPOutputStream gZIPOutputStream = null;
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    gZIPOutputStream = byArray.length < 512 ? new GZIPOutputStream((OutputStream)byteArrayOutputStream, byArray.length) : new GZIPOutputStream(byteArrayOutputStream);
                    gZIPOutputStream.write(byArray);
                    gZIPOutputStream.finish();
                    this.out.writeByteArray(byteArrayOutputStream.toByteArray());
                }
                catch (IOException iOException) {
                    try {
                        throw new JSONException("write gzipBytes error", iOException);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(gZIPOutputStream);
                        throw throwable;
                    }
                }
                IOUtils.close(gZIPOutputStream);
                return;
            }
            if ("hex".equals(string)) {
                this.out.writeHex(byArray);
                return;
            }
            this.out.writeByteArray(byArray);
            return;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            Iterator iterator = collection.iterator();
            this.out.write(91);
            for (int i = 0; i < collection.size(); ++i) {
                object = iterator.next();
                if (i != 0) {
                    this.out.write(44);
                }
                this.writeWithFormat(object, string);
            }
            this.out.write(93);
            return;
        }
        this.write(object);
    }

    public final void write(String string) {
        StringCodec.instance.write(this, string);
    }

    public ObjectSerializer getObjectWriter(Class<?> clazz) {
        return this.config.getObjectWriter(clazz);
    }

    public void close() {
        this.out.close();
    }
}

