/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.PropertyNamingStrategy;
import com.tradplus.ads.common.serialization.annotation.JSONField;
import com.tradplus.ads.common.serialization.serializer.AfterFilter;
import com.tradplus.ads.common.serialization.serializer.BeanContext;
import com.tradplus.ads.common.serialization.serializer.BeforeFilter;
import com.tradplus.ads.common.serialization.serializer.FieldSerializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.LabelFilter;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerialContext;
import com.tradplus.ads.common.serialization.serializer.SerializeBeanInfo;
import com.tradplus.ads.common.serialization.serializer.SerializeFilter;
import com.tradplus.ads.common.serialization.serializer.SerializeFilterable;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.FieldInfo;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaBeanSerializer
extends SerializeFilterable
implements ObjectSerializer {
    protected final FieldSerializer[] getters;
    protected final FieldSerializer[] sortedGetters;
    protected SerializeBeanInfo beanInfo;
    private volatile transient long[] hashArray;
    private volatile transient short[] hashArrayMapping;

    public JavaBeanSerializer(Class<?> clazz) {
        this(clazz, (Map<String, String>)null);
    }

    public JavaBeanSerializer(Class<?> clazz, String ... stringArray) {
        this(clazz, JavaBeanSerializer.createAliasMap(stringArray));
    }

    static Map<String, String> createAliasMap(String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            String string2 = string = stringArray[i];
            hashMap.put(string2, string2);
        }
        return hashMap;
    }

    public Class<?> getType() {
        return this.beanInfo.beanType;
    }

    public JavaBeanSerializer(Class<?> clazz, Map<String, String> map) {
        this(TypeUtils.buildBeanInfo(clazz, map, null));
    }

    public JavaBeanSerializer(SerializeBeanInfo object2) {
        int n;
        this.beanInfo = object2;
        this.sortedGetters = new FieldSerializer[((SerializeBeanInfo)object2).sortedFields.length];
        for (n = 0; n < this.sortedGetters.length; ++n) {
            this.sortedGetters[n] = new FieldSerializer(((SerializeBeanInfo)object2).beanType, ((SerializeBeanInfo)object2).sortedFields[n]);
        }
        if (((SerializeBeanInfo)object2).fields == ((SerializeBeanInfo)object2).sortedFields) {
            this.getters = this.sortedGetters;
        } else {
            this.getters = new FieldSerializer[((SerializeBeanInfo)object2).fields.length];
            n = 0;
            for (int i = 0; i < this.getters.length; ++i) {
                FieldSerializer fieldSerializer = this.getFieldSerializer(((SerializeBeanInfo)object2).fields[i].name);
                if (fieldSerializer == null) {
                    n = 1;
                    break;
                }
                this.getters[i] = fieldSerializer;
            }
            if (n != 0) {
                System.arraycopy(this.sortedGetters, 0, this.getters, 0, this.sortedGetters.length);
            }
        }
        if (((SerializeBeanInfo)object2).jsonType != null) {
            for (Class<? extends SerializeFilter> clazz : ((SerializeBeanInfo)object2).jsonType.serialzeFilters()) {
                try {
                    SerializeFilter serializeFilter = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.addFilter(serializeFilter);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void writeDirectNonContext(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n) {
        this.write(jSONSerializer, object, object2, type, n);
    }

    public void writeAsArray(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n) {
        this.write(jSONSerializer, object, object2, type, n);
    }

    public void writeAsArrayNonContext(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n) {
        this.write(jSONSerializer, object, object2, type, n);
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n) {
        this.write(jSONSerializer, object, object2, type, n, false);
    }

    public void writeNoneASM(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n) {
        this.write(jSONSerializer, object, object2, type, n, false);
    }

    protected void write(JSONSerializer jSONSerializer, Object object, Object object2, Type clazz, int n, boolean bl) {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull();
            return;
        }
        if (this.writeReference(jSONSerializer, object, n)) {
            return;
        }
        FieldSerializer[] fieldSerializerArray = serializeWriter.sortField ? this.sortedGetters : this.getters;
        SerialContext serialContext = jSONSerializer.context;
        if (!this.beanInfo.beanType.isEnum()) {
            jSONSerializer.setContext(serialContext, object, object2, this.beanInfo.features, n);
        }
        boolean bl2 = this.isWriteAsArray(jSONSerializer, n);
        FieldSerializer fieldSerializer = null;
        try {
            Class<?> clazz2;
            Class<?> clazz3;
            char c;
            char c2 = bl2 ? (char)'[' : '{';
            char c3 = c = bl2 ? (char)']' : '}';
            if (!bl) {
                serializeWriter.append(c2);
            }
            if (fieldSerializerArray.length > 0 && serializeWriter.isEnabled(SerializerFeature.PrettyFormat)) {
                jSONSerializer.incrementIndent();
                jSONSerializer.println();
            }
            boolean bl3 = false;
            if (((this.beanInfo.features & SerializerFeature.WriteClassName.mask) != 0 || (n & SerializerFeature.WriteClassName.mask) != 0 || jSONSerializer.isWriteClassName(clazz, object)) && clazz3 != (clazz2 = (clazz3 = object.getClass()) != clazz && clazz instanceof WildcardType ? TypeUtils.getClass(clazz) : clazz)) {
                this.writeClassName(jSONSerializer, this.beanInfo.typeKey, object);
                bl3 = true;
            }
            c2 = bl3 ? (char)',' : '\u0000';
            boolean bl4 = serializeWriter.isEnabled(SerializerFeature.WriteClassName);
            bl3 = this.writeBefore(jSONSerializer, object, c2) == ',';
            c2 = (char)(serializeWriter.isEnabled(SerializerFeature.SkipTransientField) ? 1 : 0);
            boolean bl5 = serializeWriter.isEnabled(SerializerFeature.IgnoreNonFieldGetter);
            for (int i = 0; i < fieldSerializerArray.length; ++i) {
                Class<?> clazz4;
                int n2;
                Object object3;
                List list;
                boolean bl6;
                FieldSerializer fieldSerializer2 = fieldSerializerArray[i];
                Field field = fieldSerializer2.fieldInfo.field;
                FieldInfo fieldInfo = fieldSerializer2.fieldInfo;
                String string = fieldInfo.name;
                Class<?> clazz5 = fieldInfo.fieldClass;
                boolean bl7 = SerializerFeature.isEnabled(serializeWriter.features, fieldInfo.serialzeFeatures, SerializerFeature.UseSingleQuotes);
                boolean bl8 = bl6 = serializeWriter.quoteFieldNames && !bl7;
                if (c2 != '\u0000' && fieldInfo != null && fieldInfo.fieldTransient || bl5 && field == null) continue;
                boolean bl9 = false;
                if (!this.applyName(jSONSerializer, object, string) || !this.applyLabel(jSONSerializer, fieldInfo.label)) {
                    if (!bl2) continue;
                    bl9 = true;
                }
                if (this.beanInfo.typeKey != null && string.equals(this.beanInfo.typeKey) && jSONSerializer.isWriteClassName(clazz, object)) continue;
                if (bl9) {
                    list = null;
                } else {
                    try {
                        list = fieldSerializer2.getPropertyValueDirect(object);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        fieldSerializer = fieldSerializer2;
                        if (serializeWriter.isEnabled(SerializerFeature.IgnoreErrorGetter)) {
                            list = null;
                        }
                        throw invocationTargetException;
                    }
                }
                if (!this.apply(jSONSerializer, object, string, list)) continue;
                if (clazz5 == String.class && "trim".equals(fieldInfo.format) && list != null) {
                    list = ((String)((Object)list)).trim();
                }
                String string2 = string;
                string2 = this.processKey(jSONSerializer, object, string2, list);
                List list2 = list;
                if ((list = this.processValue(jSONSerializer, fieldSerializer2.fieldContext, object, string, list, n)) == null) {
                    int n3 = fieldInfo.serialzeFeatures;
                    object3 = fieldInfo.getAnnotation();
                    if (this.beanInfo.jsonType != null) {
                        n3 |= SerializerFeature.of(this.beanInfo.jsonType.serialzeFeatures());
                    }
                    if (object3 != null && !"".equals(object3.defaultValue())) {
                        list = object3.defaultValue();
                    } else if (clazz5 == Boolean.class) {
                        n2 = SerializerFeature.WriteNullBooleanAsFalse.mask;
                        int n4 = n2 | SerializerFeature.WriteMapNullValue.mask;
                        if (!bl2 && (n3 & n4) == 0 && (serializeWriter.features & n4) == 0) continue;
                        if ((n3 & n2) != 0) {
                            list = Boolean.FALSE;
                        } else if ((serializeWriter.features & n2) != 0 && (n3 & SerializerFeature.WriteMapNullValue.mask) == 0) {
                            list = Boolean.FALSE;
                        }
                    } else if (clazz5 == String.class) {
                        n2 = SerializerFeature.WriteNullStringAsEmpty.mask;
                        int n5 = n2 | SerializerFeature.WriteMapNullValue.mask;
                        if (!bl2 && (n3 & n5) == 0 && (serializeWriter.features & n5) == 0) continue;
                        if ((n3 & n2) != 0) {
                            list = "";
                        } else if ((serializeWriter.features & n2) != 0 && (n3 & SerializerFeature.WriteMapNullValue.mask) == 0) {
                            list = "";
                        }
                    } else if (Number.class.isAssignableFrom(clazz5)) {
                        n2 = SerializerFeature.WriteNullNumberAsZero.mask;
                        int n6 = n2 | SerializerFeature.WriteMapNullValue.mask;
                        if (!bl2 && (n3 & n6) == 0 && (serializeWriter.features & n6) == 0) continue;
                        if ((n3 & n2) != 0) {
                            list = 0;
                        } else if ((serializeWriter.features & n2) != 0 && (n3 & SerializerFeature.WriteMapNullValue.mask) == 0) {
                            list = 0;
                        }
                    } else if (Collection.class.isAssignableFrom(clazz5)) {
                        n2 = SerializerFeature.WriteNullListAsEmpty.mask;
                        int n7 = n2 | SerializerFeature.WriteMapNullValue.mask;
                        if (!bl2 && (n3 & n7) == 0 && (serializeWriter.features & n7) == 0) continue;
                        if ((n3 & n2) != 0) {
                            list = Collections.emptyList();
                        } else if ((serializeWriter.features & n2) != 0 && (n3 & SerializerFeature.WriteMapNullValue.mask) == 0) {
                            list = Collections.emptyList();
                        }
                    } else if (!bl2 && !fieldSerializer2.writeNull && !serializeWriter.isEnabled(SerializerFeature.WriteMapNullValue.mask) && (n3 & SerializerFeature.WriteMapNullValue.mask) == 0) continue;
                }
                if (list != null && (serializeWriter.notWriteDefaultValue || (fieldInfo.serialzeFeatures & SerializerFeature.NotWriteDefaultValue.mask) != 0 || (this.beanInfo.features & SerializerFeature.NotWriteDefaultValue.mask) != 0) && ((clazz4 = fieldInfo.fieldClass) == Byte.TYPE && list instanceof Byte && (Byte)((Object)list) == 0 || clazz4 == Short.TYPE && list instanceof Short && (Short)((Object)list) == 0 || clazz4 == Integer.TYPE && list instanceof Integer && (Integer)((Object)list) == 0 || clazz4 == Long.TYPE && list instanceof Long && (Long)((Object)list) == 0L || clazz4 == Float.TYPE && list instanceof Float && ((Float)((Object)list)).floatValue() == 0.0f || clazz4 == Double.TYPE && list instanceof Double && (Double)((Object)list) == 0.0 || clazz4 == Boolean.TYPE && list instanceof Boolean && !((Boolean)((Object)list)).booleanValue())) continue;
                if (bl3) {
                    if (fieldInfo.unwrapped && list instanceof Map && ((Map)((Object)list)).size() == 0) continue;
                    serializeWriter.write(44);
                    if (serializeWriter.isEnabled(SerializerFeature.PrettyFormat)) {
                        jSONSerializer.println();
                    }
                }
                if (string2 != string) {
                    if (!bl2) {
                        serializeWriter.writeFieldName(string2, true);
                    }
                    jSONSerializer.write(list);
                } else if (list2 != list) {
                    if (!bl2) {
                        fieldSerializer2.writePrefix(jSONSerializer);
                    }
                    jSONSerializer.write(list);
                } else {
                    if (!bl2) {
                        boolean bl10;
                        boolean bl11 = Map.class.isAssignableFrom(clazz5);
                        boolean bl12 = bl10 = !clazz5.isPrimitive() && !clazz5.getName().startsWith("java.") || clazz5 == Object.class;
                        if (bl4 || !fieldInfo.unwrapped || !bl11 && !bl10) {
                            if (bl6) {
                                serializeWriter.write(fieldInfo.name_chars, 0, fieldInfo.name_chars.length);
                            } else {
                                fieldSerializer2.writePrefix(jSONSerializer);
                            }
                        }
                    }
                    if (!bl2) {
                        JSONField jSONField = fieldInfo.getAnnotation();
                        if (clazz5 == String.class && (jSONField == null || jSONField.serializeUsing() == Void.class)) {
                            if (list == null) {
                                int n8 = fieldSerializer2.features;
                                if (this.beanInfo.jsonType != null) {
                                    n8 |= SerializerFeature.of(this.beanInfo.jsonType.serialzeFeatures());
                                }
                                if ((serializeWriter.features & SerializerFeature.WriteNullStringAsEmpty.mask) != 0 && (n8 & SerializerFeature.WriteMapNullValue.mask) == 0) {
                                    serializeWriter.writeString("");
                                } else if ((n8 & SerializerFeature.WriteNullStringAsEmpty.mask) != 0) {
                                    serializeWriter.writeString("");
                                } else {
                                    serializeWriter.writeNull();
                                }
                            } else {
                                object3 = (String)((Object)list);
                                if (bl7) {
                                    serializeWriter.writeStringWithSingleQuote((String)object3);
                                } else {
                                    serializeWriter.writeStringWithDoubleQuote((String)object3, '\u0000');
                                }
                            }
                        } else {
                            if (fieldInfo.unwrapped && list instanceof Map && ((Map)((Object)list)).size() == 0) {
                                bl3 = false;
                                continue;
                            }
                            fieldSerializer2.writeValue(jSONSerializer, list);
                        }
                    } else {
                        fieldSerializer2.writeValue(jSONSerializer, list);
                    }
                }
                boolean bl13 = false;
                if (fieldInfo.unwrapped && list instanceof Map) {
                    object3 = (Map)((Object)list);
                    if (object3.size() == 0) {
                        bl13 = true;
                    } else if (!jSONSerializer.isEnabled(SerializerFeature.WriteMapNullValue)) {
                        n2 = 0;
                        object3 = object3.values().iterator();
                        while (object3.hasNext()) {
                            if (object3.next() == null) continue;
                            n2 = 1;
                            break;
                        }
                        if (n2 == 0) {
                            bl13 = true;
                        }
                    }
                }
                if (bl13) continue;
                bl3 = true;
            }
            this.writeAfter(jSONSerializer, object, bl3 ? (char)',' : '\u0000');
            if (fieldSerializerArray.length > 0 && serializeWriter.isEnabled(SerializerFeature.PrettyFormat)) {
                jSONSerializer.decrementIdent();
                jSONSerializer.println();
            }
            if (!bl) {
                serializeWriter.append(c);
            }
            return;
        }
        catch (Exception exception) {
            Object object4;
            String string = "write javaBean error, fastjson version 1.2.74";
            if (object != null) {
                string = string + ", class " + object.getClass().getName();
            }
            if (object2 != null) {
                string = string + ", fieldName : " + object2;
            } else if (fieldSerializer != null && fieldSerializer.fieldInfo != null) {
                object4 = fieldSerializer.fieldInfo;
                string = ((FieldInfo)object4).method != null ? string + ", method : " + ((FieldInfo)object4).method.getName() : string + ", fieldName : " + fieldSerializer.fieldInfo.name;
            }
            if (exception.getMessage() != null) {
                string = string + ", " + exception.getMessage();
            }
            object4 = null;
            if (exception instanceof InvocationTargetException) {
                object4 = exception.getCause();
            }
            if (object4 == null) {
                object4 = exception;
            }
            throw new JSONException(string, (Throwable)object4);
        }
        finally {
            jSONSerializer.context = serialContext;
        }
    }

    protected void writeClassName(JSONSerializer jSONSerializer, String clazz, Object object) {
        if (clazz == null) {
            clazz = jSONSerializer.config.typeKey;
        }
        jSONSerializer.out.writeFieldName((String)((Object)clazz), false);
        clazz = this.beanInfo.typeName;
        if (clazz == null) {
            clazz = object.getClass();
            if (TypeUtils.isProxy(clazz)) {
                clazz = clazz.getSuperclass();
            }
            clazz = clazz.getName();
        }
        jSONSerializer.write((String)((Object)clazz));
    }

    public boolean writeReference(JSONSerializer jSONSerializer, Object object, int n) {
        SerialContext serialContext = jSONSerializer.context;
        int n2 = SerializerFeature.DisableCircularReferenceDetect.mask;
        if (serialContext == null || (serialContext.features & n2) != 0 || (n & n2) != 0) {
            return false;
        }
        if (jSONSerializer.references != null && jSONSerializer.references.containsKey(object)) {
            jSONSerializer.writeReference(object);
            return true;
        }
        return false;
    }

    protected boolean isWriteAsArray(JSONSerializer jSONSerializer) {
        return this.isWriteAsArray(jSONSerializer, 0);
    }

    protected boolean isWriteAsArray(JSONSerializer jSONSerializer, int n) {
        int n2 = SerializerFeature.BeanToArray.mask;
        return (this.beanInfo.features & n2) != 0 || jSONSerializer.out.beanToArray || (n & n2) != 0;
    }

    public Object getFieldValue(Object object, String string) {
        FieldSerializer fieldSerializer = this.getFieldSerializer(string);
        if (fieldSerializer == null) {
            throw new JSONException("field not found. ".concat(String.valueOf(string)));
        }
        try {
            return fieldSerializer.getPropertyValue(object);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new JSONException("getFieldValue error.".concat(String.valueOf(string)), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JSONException("getFieldValue error.".concat(String.valueOf(string)), illegalAccessException);
        }
    }

    public Object getFieldValue(Object object, String string, long l, boolean bl) {
        FieldSerializer fieldSerializer = this.getFieldSerializer(l);
        if (fieldSerializer == null) {
            if (bl) {
                throw new JSONException("field not found. ".concat(String.valueOf(string)));
            }
            return null;
        }
        try {
            return fieldSerializer.getPropertyValue(object);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new JSONException("getFieldValue error.".concat(String.valueOf(string)), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JSONException("getFieldValue error.".concat(String.valueOf(string)), illegalAccessException);
        }
    }

    public FieldSerializer getFieldSerializer(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        int n2 = this.sortedGetters.length - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            int n4 = this.sortedGetters[n3].fieldInfo.name.compareTo(string);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return this.sortedGetters[n3];
        }
        return null;
    }

    public FieldSerializer getFieldSerializer(long l) {
        int n;
        int n2;
        String string;
        int n3;
        int n4;
        PropertyNamingStrategy[] propertyNamingStrategyArray = null;
        if (this.hashArray == null) {
            propertyNamingStrategyArray = PropertyNamingStrategy.values();
            long[] lArray = new long[this.sortedGetters.length * propertyNamingStrategyArray.length];
            n4 = 0;
            for (n3 = 0; n3 < this.sortedGetters.length; ++n3) {
                string = this.sortedGetters[n3].fieldInfo.name;
                lArray[n4++] = TypeUtils.fnv1a_64(string);
                for (n2 = 0; n2 < propertyNamingStrategyArray.length; ++n2) {
                    String string2 = propertyNamingStrategyArray[n2].translate(string);
                    if (string.equals(string2)) continue;
                    lArray[n4++] = TypeUtils.fnv1a_64(string2);
                }
            }
            Arrays.sort(lArray, 0, n4);
            this.hashArray = new long[n4];
            System.arraycopy(lArray, 0, this.hashArray, 0, n4);
        }
        if ((n = Arrays.binarySearch(this.hashArray, l)) < 0) {
            return null;
        }
        if (this.hashArrayMapping == null) {
            if (propertyNamingStrategyArray == null) {
                propertyNamingStrategyArray = PropertyNamingStrategy.values();
            }
            short[] sArray = new short[this.hashArray.length];
            Arrays.fill(sArray, (short)-1);
            for (n3 = 0; n3 < this.sortedGetters.length; ++n3) {
                string = this.sortedGetters[n3].fieldInfo.name;
                n2 = Arrays.binarySearch(this.hashArray, TypeUtils.fnv1a_64(string));
                if (n2 >= 0) {
                    sArray[n2] = (short)n3;
                }
                for (int i = 0; i < propertyNamingStrategyArray.length; ++i) {
                    int n5;
                    String string3 = propertyNamingStrategyArray[i].translate(string);
                    if (string.equals(string3) || (n5 = Arrays.binarySearch(this.hashArray, TypeUtils.fnv1a_64(string3))) < 0) continue;
                    sArray[n5] = (short)n3;
                }
            }
            this.hashArrayMapping = sArray;
        }
        if ((n4 = this.hashArrayMapping[n]) != -1) {
            return this.sortedGetters[n4];
        }
        return null;
    }

    public List<Object> getFieldValues(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.sortedGetters.length);
        FieldSerializer[] fieldSerializerArray = this.sortedGetters;
        int n = this.sortedGetters.length;
        for (int i = 0; i < n; ++i) {
            FieldSerializer fieldSerializer = fieldSerializerArray[i];
            arrayList.add(fieldSerializer.getPropertyValue(object));
        }
        return arrayList;
    }

    public List<Object> getObjectFieldValues(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.sortedGetters.length);
        FieldSerializer[] fieldSerializerArray = this.sortedGetters;
        int n = this.sortedGetters.length;
        for (int i = 0; i < n; ++i) {
            FieldSerializer fieldSerializer = fieldSerializerArray[i];
            Class<?> clazz = fieldSerializer.fieldInfo.fieldClass;
            if (clazz.isPrimitive() || clazz.getName().startsWith("java.lang.")) continue;
            arrayList.add(fieldSerializer.getPropertyValue(object));
        }
        return arrayList;
    }

    public int getSize(Object object) {
        int n = 0;
        FieldSerializer[] fieldSerializerArray = this.sortedGetters;
        int n2 = this.sortedGetters.length;
        for (int i = 0; i < n2; ++i) {
            if (fieldSerializerArray[i].getPropertyValueDirect(object) == null) continue;
            ++n;
        }
        return n;
    }

    public Set<String> getFieldNames(Object object) {
        HashSet<String> hashSet = new HashSet<String>();
        FieldSerializer[] fieldSerializerArray = this.sortedGetters;
        int n = this.sortedGetters.length;
        for (int i = 0; i < n; ++i) {
            FieldSerializer fieldSerializer = fieldSerializerArray[i];
            if (fieldSerializer.getPropertyValueDirect(object) == null) continue;
            hashSet.add(fieldSerializer.fieldInfo.name);
        }
        return hashSet;
    }

    public Map<String, Object> getFieldValuesMap(Object object) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(this.sortedGetters.length);
        FieldSerializer[] fieldSerializerArray = this.sortedGetters;
        int n = this.sortedGetters.length;
        for (int i = 0; i < n; ++i) {
            FieldSerializer fieldSerializer = fieldSerializerArray[i];
            boolean bl = SerializerFeature.isEnabled(fieldSerializer.features, SerializerFeature.SkipTransientField);
            FieldInfo fieldInfo = fieldSerializer.fieldInfo;
            if (bl && fieldInfo != null && fieldInfo.fieldTransient) continue;
            if (fieldSerializer.fieldInfo.unwrapped) {
                Object object2 = JSON.toJSON(fieldSerializer.getPropertyValue(object));
                if (object2 instanceof Map) {
                    linkedHashMap.putAll((Map)object2);
                    continue;
                }
                linkedHashMap.put(fieldSerializer.fieldInfo.name, fieldSerializer.getPropertyValue(object));
                continue;
            }
            linkedHashMap.put(fieldSerializer.fieldInfo.name, fieldSerializer.getPropertyValue(object));
        }
        return linkedHashMap;
    }

    protected BeanContext getBeanContext(int n) {
        return this.sortedGetters[n].fieldContext;
    }

    protected Type getFieldType(int n) {
        return this.sortedGetters[n].fieldInfo.fieldType;
    }

    protected char writeBefore(JSONSerializer jSONSerializer, Object object, char c) {
        Iterator iterator;
        if (jSONSerializer.beforeFilters != null) {
            iterator = jSONSerializer.beforeFilters.iterator();
            while (iterator.hasNext()) {
                c = ((BeforeFilter)iterator.next()).writeBefore(jSONSerializer, object, c);
            }
        }
        if (this.beforeFilters != null) {
            iterator = this.beforeFilters.iterator();
            while (iterator.hasNext()) {
                c = ((BeforeFilter)iterator.next()).writeBefore(jSONSerializer, object, c);
            }
        }
        return c;
    }

    protected char writeAfter(JSONSerializer jSONSerializer, Object object, char c) {
        Iterator iterator;
        if (jSONSerializer.afterFilters != null) {
            iterator = jSONSerializer.afterFilters.iterator();
            while (iterator.hasNext()) {
                c = ((AfterFilter)iterator.next()).writeAfter(jSONSerializer, object, c);
            }
        }
        if (this.afterFilters != null) {
            iterator = this.afterFilters.iterator();
            while (iterator.hasNext()) {
                c = ((AfterFilter)iterator.next()).writeAfter(jSONSerializer, object, c);
            }
        }
        return c;
    }

    protected boolean applyLabel(JSONSerializer iterator, String string) {
        if (((JSONSerializer)((Object)iterator)).labelFilters != null) {
            iterator = ((JSONSerializer)((Object)iterator)).labelFilters.iterator();
            while (iterator.hasNext()) {
                if (((LabelFilter)iterator.next()).apply(string)) continue;
                return false;
            }
        }
        if (this.labelFilters != null) {
            iterator = this.labelFilters.iterator();
            while (iterator.hasNext()) {
                if (((LabelFilter)iterator.next()).apply(string)) continue;
                return false;
            }
        }
        return true;
    }
}

